////////////////////////////////////////////////////////////////////////////////
//
//	Class : akPromptDbleRange
//
//	Author : Andy Jefferson
//
//	Description :
//		The akPromptDbleRange class provides a data
//		prompt for a double value within a range.
//		It creates a widget consisting of an optional
//		variable name label, together with the
//		actual data entry field.
//		The user can retrieve the value from the class
//		via the function "value", or use a callback
//		hook to receive updates when changes are made.
//
//	Public Methods :
//		(Constructor) requires :-
//			parent		Parent widget of component
//			name		Name used in resources
//			prompt		Prompt label
//			callback	Callback called when enter pressed
//			clientData	Data passed to callback
//			lower_limit	Lower limit of range
//			upper_limit	Upper limit of range
//		setRange()		Set lower and upper limits
//		setValue()		Set value in text field
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
//
// Version 1
// ---------
//	Last Author 		: Andy Jefferson
//	Date Last Changed	: November 1996
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptDbleRange_h
#define _akPromptDbleRange_h
#ifdef __cplusplus

#include <string>
#include <Xm/Xm.h>
#include "akPromptDble.h"

class akPromptDbleRange : public akPromptDble
{
	public:

		// Constructor

		akPromptDbleRange(Widget parent,
				   char *name,
				   string variable_name,
				   akPromptDbleCB callback=0,
				   XtPointer clientData=0,
				   double lower=-9.9E99,
				   double upper=9.9E99);

		// Class name

		virtual const char *const className(void)
			{return ("akPromptDbleRange");}

		// Access functions

		virtual void	setValue(double new_value);
		virtual void	setRange(double lower,double upper);

	protected:

		virtual void	changeCB(string field_string);

	private:

		double		lower_range;
		double		upper_range;
};

#endif
#endif
