////////////////////////////////////////////////////////////////////////////////
//
//	Object Name 		: akPromptDialog
//	File Name		: akPromptDialog.h
//
// DESCRIPTION:
// ------------
//	The akPromptDialog is an object to provide simple prompt dialogs.
//
////////////////////////////////////////////////////////////////////////////////
//
// Version 1
// ---------
//	Last Author 		: Andy Jefferson
//	Date Last Changed	: November 1996
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _akPromptDialog_h
#define _akPromptDialog_h
#ifdef __cplusplus

#include <string>
#include "akComponent.h"
#include "akLabel.h"
#include "akPromptString.h"
#include "akDialogCallbackData.h"

class akPromptDialog : public akComponent
{

	public:

		// Constructor/Destructor

		akPromptDialog(Widget parent,
				char *name,
				Boolean modal,
				string prompt,
				void *clientData=0,
				akDialogCallback ok=0,
				akDialogCallback cancel=0,
				akDialogCallback help=0);
		~akPromptDialog(void);

		void		post(void *clientData=0,
				     akDialogCallback ok=0,
				     akDialogCallback cancel=0,
				     akDialogCallback help=0);

		// Update functions

		void		setValue(string value);
		void		setPrompt(string prompt);
		void		setTitle(string new_title);
		void		setMessageLabel(string message);
		void		setOKLabel(string label);
		void		setCancelLabel(string label);
		void		setHelpLabel(string label);
		void		setEditable(bool value);

	private:

		akPromptString		*_prompt;
		akLabel			*_messageLabel;

		// Button pressed callback

		static void	actionCB(Widget,XtPointer,XtPointer);

		// Users callback data

		akDialogCallbackData	*_CBdata;
};

#endif
#endif
