#include <iostream>
#include <fstream>
#include <strstream>
#include <cstdio>
#include <ctype.h>

#include "mxBase64String.h"

static	bool		textMode;
static	int		saved_linefeed;
static	istrstream	*inputstr;
static	char		AlphabetIndex[256];

////////////////////////////////////////////////////////////////////////////////
//
//	encode
//
////////////////////////////////////////////////////////////////////////////////
string	mxBase64String::encode(string the_input,bool text_mode)
{
	string	output;
	int	linelength = 0;
	int	c;
	long	word;
	char	*Alphabet=
	  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

	saved_linefeed = 0;
	textMode = text_mode;
	inputstr = new istrstream((char *)the_input.c_str(),the_input.size());

	while (1)
	  {
	   c = nextCharForEncode();
	   if (c == EOF)
	     break;
	   word = (c & 0xff) << 16;

	   c = nextCharForEncode();
	   if (c == EOF)
	     {
	      output += (char)Alphabet[word >> 18];
	      output += (char)Alphabet[(word >> 12) & 077];
	      output += "==";
	      linelength += 4;
	      break;
	     }
	   word |= (c & 0xff) << 8;

	   c = nextCharForEncode();
	   if (c == EOF)
	     {
	      if (!(linelength + 4 <= 72))
		{
		 output += "\n";
		 linelength = 0;
	        }
	      output += (char)Alphabet[word >> 18];
	      output += (char)Alphabet[(word >> 12) & 077];
	      output += (char)Alphabet[(word >> 6) & 077];
	      output += "=";
	      linelength += 4;
	      break;
	     }
	   word |= (c & 0xff);

	   if (!(linelength + 4 <= 72))
	     {
	      output += "\n";
	      linelength = 0;
	     }
	   output += (char)Alphabet[word >> 18];
	   output += (char)Alphabet[(word >> 12) & 077];
	   output += (char)Alphabet[(word >> 6) & 077];
	   output += (char)Alphabet[word & 077];
	   linelength += 4;
          }
	if (linelength != 0)
	  output += "\n";

	delete inputstr;

	return output;
}
////////////////////////////////////////////////////////////////////////////////
//
//	Return next character of input string (allowing for end-of-lines)
//
////////////////////////////////////////////////////////////////////////////////
int	mxBase64String::nextCharForEncode()
{
	int c;

	if (saved_linefeed)
	  {
	   saved_linefeed = 0;
	   return '\n';
	  }
	if ((c = inputstr->get()) == EOF)
	  return EOF;
	if (textMode && c == '\n')
	  {
	   saved_linefeed = 1;
	   return '\r';
	  }
	return c;
}
////////////////////////////////////////////////////////////////////////////////
//
//	decode
//
////////////////////////////////////////////////////////////////////////////////
string	mxBase64String::decode(string the_input)
{
	string		output;
	int		c1,c2,c3,c4;
	unsigned long	word;
	struct decoding
	  {
	   char c;
	   unsigned char bits;
	  } b64chars[] = {
    {'A', '\000'}, {'B', '\001'}, {'C', '\002'}, {'D', '\003'}, {'E', '\004'},
    {'F', '\005'}, {'G', '\006'}, {'H', '\007'}, {'I', '\010'}, {'J', '\011'},
    {'K', '\012'}, {'L', '\013'}, {'M', '\014'}, {'N', '\015'}, {'O', '\016'},
    {'P', '\017'}, {'Q', '\020'}, {'R', '\021'}, {'S', '\022'}, {'T', '\023'},
    {'U', '\024'}, {'V', '\025'}, {'W', '\026'}, {'X', '\027'}, {'Y', '\030'},
    {'Z', '\031'}, {'a', '\032'}, {'b', '\033'}, {'c', '\034'}, {'d', '\035'},
    {'e', '\036'}, {'f', '\037'}, {'g', '\040'}, {'h', '\041'}, {'i', '\042'},
    {'j', '\043'}, {'k', '\044'}, {'l', '\045'}, {'m', '\046'}, {'n', '\047'},
    {'o', '\050'}, {'p', '\051'}, {'q', '\052'}, {'r', '\053'}, {'s', '\054'},
    {'t', '\055'}, {'u', '\056'}, {'v', '\057'}, {'w', '\060'}, {'x', '\061'},
    {'y', '\062'}, {'z', '\063'}, {'0', '\064'}, {'1', '\065'}, {'2', '\066'},
    {'3', '\067'}, {'4', '\070'}, {'5', '\071'}, {'6', '\072'}, {'7', '\073'},
    {'8', '\074'}, {'9', '\075'}, {'+', '\076'}, {'/', '\077'},
			};
	for (int i=0;i<sizeof(b64chars)/sizeof(*b64chars);++i)
	  AlphabetIndex[b64chars[i].c] = b64chars[i].bits;

	inputstr = new istrstream((char *)the_input.c_str(),the_input.size());

	while (1)
	  {
	   c1 = nextCharForDecode();
	   c2 = nextCharForDecode();
	   c3 = nextCharForDecode();
	   c4 = nextCharForDecode();

	   if (c1 == EOF || c2 == EOF || c3 == EOF || c4 == EOF)
	     break;
	   word = (int)AlphabetIndex[c1] << 18;

	   if (c2 == EOF)
	     break;
	   word |= (int)AlphabetIndex[c2] << 12;

	   if (c3 == '=')
	     {
	      output += (char)((word>>16) & 0xff);
	      continue;
	     }
	   if (c3 == EOF)
	     break;
	   word |= (int)AlphabetIndex[c3] << 6;

	   if (c4 == '=')
	     {
	      output += (char)((word>>16) & 0xff);
	      output += (char)((word>>8) & 0xff);
	      continue;
	     }
	   if (c4 == EOF)
	     break;
	   word |= AlphabetIndex[c4];
	   output += (char)((word>>16) & 0xff);
	   output += (char)((word>>8) & 0xff);
	   output += (char)(word & 0xff);
	  }

	delete inputstr;

	return output;
}
////////////////////////////////////////////////////////////////////////////////
//
// Find the next 'legal' base-64 character - allowing for skipping end-of-lines
// and other chars such as the '>' that some mailers insert
//
////////////////////////////////////////////////////////////////////////////////
int	mxBase64String::nextCharForDecode()
{
	int	c;
	do
	  {
	   c = inputstr->get();
	   if (c == EOF || c == 'A' || c == '=')
	     return c;
	  } while (AlphabetIndex[c] == 0);

	return c;
}
