////////////////////////////////////////////////////////////////////////////////
//
//	Class :	mxDirView
//
//	Author : Andy Jefferson
//
//	Description :
//		mxDirView provides a directory/file listing of a directory.
//		It operates from an 'ls -alF' output, and a directory path.
//
//	Methods :
//		(Constructor) requires :
//			parent		Widget used as a parent to the icon
//			name		Name used for resource specification
//			directory	The current directory path.
//			ls_output	The ls output listing.
//			callback	Callback called when directory change 
//					requested.
//			clientData	Callback data passed to callback.
//
//		update()		Updates the current display.
//		update()		Updates the output display using a
//					provided ls output listing and directory.
//
//	Limitations :
//		Requires 'ls -alF' to work correctly.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxDirView_h
#define mxDirView_h
#ifdef __cplusplus

#include <string>
#include "akComponent.h"
#include "akList.h"
#include "akPromptString.h"

typedef	void	(*mxDirViewCB) (XtPointer clientData,string selection);

class mxDirView : public akComponent
{
	public:

		// Constructor and destructor

		mxDirView(Widget parent,
			  char *name,
			  string directory,
			  string ls_output,
			  mxDirViewCB callback=0,
			  XtPointer clientData=0);
		~mxDirView();

		// Update facility

		void		update(string directory,string ls_output);
		void		update();
		string		*selectedFiles() const;
		int		noSelectedFiles() const;
		string		selectedDirectory() const;
		string		currentDirectory() const;

	private:

		// Data used within the class

		string			_lsOutput;
		string			_directory;
		akList			*_dirList;
		akList			*_fileList;
		akPromptString		*_currentDirLabel;

		// List callbacks

		static	void		fileSelectedCB(Widget,XtPointer,XtPointer);
		static	void		dirSelectedCB(Widget,XtPointer,XtPointer);
		static	void		dirActionedCB(Widget,XtPointer,XtPointer);

		// Users 'directory-change' Callback

		mxDirViewCB		_userCB;
		XtPointer		_userData;
};

inline
string	mxDirView::currentDirectory() const
	{return _directory;}
inline
int	mxDirView::noSelectedFiles() const
	{return _fileList->noSelectedItems();}

#endif
#endif
