////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxMailBoxDisplay
//
//	Author : Andy Jefferson
//
//	Description :
//		mxMailBoxDisplay displays the contents of an mxMailBox object.
//		The mxMailBox object (ptr) is passed at construction.
//		The display takes the form of a list displaying each message
//		in the mailbox as a single line 'title', together with a
//		'notebook' showing the text of the selected message in the list.
//		The user can reply to the message, forward it, move it to a
//		different mailbox, copy it to a different mailbox,
//		as well as being able to sort the messages in a variety of ways.
//
//	Public Methods :
//		(Constructor) requires :
//			name	The name used for resource specifications
//			mailbox	A ptr to an mxMailBox object.
//
//		update()	Updates the display.
//		newMail()	Informs this object that there is new mail
//				in the mailbox that hasn't been read yet.
//		noNewMail()	Informs this object that there isn't any mail
//				in the mailbox that hasn't been read yet.
//
//	Notes :
//		Messages are read in update(), and are written back in closeCB()
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxMailBoxDisplay_h
#define mxMailBoxDisplay_h
#ifdef __cplusplus

#include "akWindow.h"
#include "akButton.h"
#include "akList.h"
#include "akPromptDialog.h"
#include "mxMailBox.h"
#include "mxMailBoxSelector.h"
#include "mxMailAddressBook.h"
#include "mxMailSpamBook.h"
#include "mxMailMsgDisplay.h"

class mxMailBoxDisplay : public akWindow
{
	public:

		// Constructor and destructor

		mxMailBoxDisplay(char *name,
				 mxMailBox *the_mailbox,
				 mxMailAddressBook *book,
				 mxMailSpamBook *spam,
				 XtCallbackProc callback=0,
				 XtPointer clientData=0);
		~mxMailBoxDisplay();

		// Update facility

		void		update();
		void		manage();

	private:

		// The mailbox that this display represents

		mxMailBox		*_mailbox;
		vector<string>		_deletionIds; // Msg ids to be deleted
		vector<string>		_readIds;     // Msg ids that are read
		string			_selectedId;  // Msg that is selected
		bool			_readStatusUpdated;

		mxMailAddressBook	*_addressbook;
		mxMailSpamBook		*_spambook;

		// Panel creation function/data

		Widget			createWorkArea(Widget);
		mxMailMsgDisplay	*_messageView;
		akList			*_messageList;
		akButton		*_closeButton;
		akButton		*_deleteButton;
		akButton		*_undeleteButton;
		akButton		*_replyButton;
		akButton		*_forwardButton;
		akButton		*_copyButton;
		akButton		*_moveButton;
		akButton		*_newmailButton;
		akButton		*_spamButton;
		akButton		*_findButton;
		akButton		*_sortByDateButton;
		akButton		*_sortByAuthorButton;
		akButton		*_sortBySubjectButton;
		akButton		*_sortBySizeButton;

		mxMailBoxSelector	*_mailboxSelector;
		akPromptDialog		*_findDialog;
		int			_findLocation;

		int		_currentMessageNo;

		void		addMessagePage(int);
		void		removeMessagePage(int);
		void		selectMessage(int msg_no);
		string		titleForMessage(int msg_no);

		// Callbacks for view panel options

		static void	listPageChanged(Widget,XtPointer,XtPointer);
		static void	closeCB(Widget,XtPointer,XtPointer);
		static void	deleteCB(Widget,XtPointer,XtPointer);
		static void	undeleteCB(Widget,XtPointer,XtPointer);
		static void	replyCB(Widget,XtPointer,XtPointer);
		static void	forwardCB(Widget,XtPointer,XtPointer);
		static void	composeClosedCB(Widget,XtPointer,XtPointer);
		static void	copyCB(Widget,XtPointer,XtPointer);
		static void	copyOK(XtPointer,string);
		static void	moveCB(Widget,XtPointer,XtPointer);
		static void	moveOK(XtPointer,string);
		static void	spamCB(Widget,XtPointer,XtPointer);
		static void	sortByDateCB(Widget,XtPointer,XtPointer);
		static void	sortByAuthorCB(Widget,XtPointer,XtPointer);
		static void	sortBySubjectCB(Widget,XtPointer,XtPointer);
		static void	sortBySizeCB(Widget,XtPointer,XtPointer);
		static void	findCB(Widget,XtPointer,XtPointer);
		static void	findNextCB(XtPointer,XtPointer);
		static void	findPrevCB(XtPointer,XtPointer);
		static void	findCloseCB(XtPointer,XtPointer);

		XtCallbackProc	_userCB;
		XtPointer	_userData;
};

#endif
#endif
