////////////////////////////////////////////////////////////////////////////////
//
//	Class : mxSetup
//
//	Author : Andy Jefferson
//
//	Description :
//		mxSetup represents the setup data for the mx applications.
//
//	Public Methods :
//		Access and set methods exist for ALL setup parameters.
//		Can read setup details from a file, and write to a file.
//
//	Limitations :
//
////////////////////////////////////////////////////////////////////////////////
#ifndef mxSetup_h
#define mxSetup_h
#ifdef __cplusplus

#include <string>
#include <vector>

class mxSetup
{
	public:

		// Constructor, assignment operator, etc

		mxSetup(string filename);
		mxSetup();
		mxSetup(const mxSetup& setup);
		~mxSetup();
		mxSetup&	operator=(const mxSetup& setup);

		// Access functions

		void		read();
		void		write();

		const string&	filename() const;

		// a). General

		void		setOrganisation(string);
		void		setTempDirectory(string);
		void		setHelpDirectory(string);
		void		setAudioDirectory(string);
		void		setIntroSound(bool);
		void		setCheckMailSound(bool);
		void		setNewMailSound(bool);
		void		setFtpTransferSound(bool);
		const string&	organisation() const;
		const string&	tempDirectory() const;
		const string&	helpDirectory() const;
		const string&	audioDirectory() const;
		bool		introSound() const;
		bool		checkMailSound() const;
		bool		newMailSound() const;
		bool		ftpTransferSound() const;

		void		setMailServer(string);
		void		setNewsServer(string);
		void		setTimeServer(string);
		const string&	mailServer() const;
		const string&	newsServer() const;
		const string&	timeServer() const;

		// b). mxFTP

		void		setFtpShowPermissions(bool);
		void		setFtpShowNumberLinks(bool);
		void		setFtpShowOwner(bool);
		void		setFtpShowGroup(bool);
		void		setFtpShowSize(bool);
		void		setFtpShowDate(bool);
		void		setFtpDefaultLocalDir(string);
		void		setFtpDefaultRemoteDir(string);
		void		setFtpProcessFilename(string);
		void		addFtpSite(string);
		void		removeFtpSite(string);
		bool		ftpShowPermissions() const;
		bool		ftpShowNumberLinks() const;
		bool		ftpShowOwner() const;
		bool		ftpShowGroup() const;
		bool		ftpShowSize() const;
		bool		ftpShowDate() const;
		const string&	ftpDefaultLocalDir() const;
		const string&	ftpDefaultRemoteDir() const;
		const string&	ftpProcessFilename() const;
		int		ftpNoOfSites() const;
		const string&	ftpSite(int) const;

		// c). mxMail

		void		setMailSenderName(string);
		void		setMailInboxName(string);
		void		setMailOutboxName(string);
		void		setMailAddressbookName(string);
		void		setMailSpambookName(string);
		void		setMailSignatureName(string);
		void		setMailFolderDirectory(string);
		void		setMailInboxReadFolder(string);
		void		setMailIndentString(string);
		void		setMailProcessFilename(string);
		void		setMailUpdateInterval(int);
		void		setMailStartupFolders(int,string*);
		void		setMailMimeFormat(bool);
		const string&	mailSenderName() const;
		const string&	mailInboxName() const;
		const string&	mailOutboxName() const;
		const string&	mailAddressbookName() const;
		const string&	mailSpambookName() const;
		const string&	mailSignatureName() const;
		const string&	mailFolderDirectory() const;
		const string&	mailInboxReadFolder() const;
		const string&	mailIndentString() const;
		const string&	mailProcessFilename() const;
		int		mailUpdateInterval() const;
		int		mailNoStartupFolders() const;
		const string&	mailStartupFolder(int) const;
		bool		mailMimeFormat() const;

		// d). mxNews

		void		setNewsBaseDirectory(string);
		const string&	newsBaseDirectory() const;

		// e). mxNet

		void		setModemSpeed(int);
		void		setModemPort(int);
		void		setModemInit(string);
		void		setModemIdle(int);
		void		setModemNoRetries(int);
		void		setSupplierName(string);
		void		setSupplierLocation(string);
		void		setSupplierPhoneNo(string);
		void		setSupplierLogin(string);
		void		setSupplierPassword(string);
		void		setWWWCommand(string);
		void		setNewsCommand(string);
		int		modemSpeed() const;
		int		modemPort() const;
		const string&	modemInit() const;
		int		modemIdle() const;
		int		modemNoRetries() const;
		const string&	supplierName() const;
		const string&	supplierLocation() const;
		const string&	supplierPhoneNo() const;
		const string&	supplierLogin() const;
		const string&	supplierPassword() const;
		const string&	wwwCommand() const;
		const string&	newsCommand() const;

	private:

		// the setup filename

		string		_filename;

		// General items

		string		_organisation;
		string		_tempDirectory;
		string		_helpDirectory;
		string		_audioDirectory;
		bool		_introSound;
		bool		_checkMailSound;
		bool		_newMailSound;
		bool		_ftpTransferSound;

		string		_mailServer;
		string		_newsServer;
		string		_timeServer;

		// mxFTP items

		bool		_ftpShowPermissions;
		bool		_ftpShowNumberLinks;
		bool		_ftpShowGroup;
		bool		_ftpShowOwner;
		bool		_ftpShowSize;
		bool		_ftpShowDate;
		string		_ftpDefaultLocalDir;
		string		_ftpDefaultRemoteDir;
		string		_ftpProcessFilename;
		vector<string>	_ftpSites;

		// mxMail items

		string 		_mailSenderName;
		string		_mailInboxName;
		string 		_mailOutboxName;
		string 		_mailAddressbookName;
		string 		_mailSpambookName;
		string 		_mailSignatureName;
		string		_mailFolderDirectory;
		string		_mailIndentString;
		string 		_mailInboxReadFolder;
		string 		_mailProcessFilename;
		int		_mailUpdateInterval;	
		vector<string>	_mailStartupFolders;
		bool		_mailMimeFormat;

		// mxNews items

		string 		_newsBaseDirectory;

		// mxNet items

		int		_modemSpeed;
		int		_modemPort;
		string		_modemInit;
		int		_modemIdle;
		int		_modemNoRetries;
		string		_supplierName;
		string		_supplierLocation;
		string		_supplierPhoneNo;
		string		_supplierLogin;
		string		_supplierPassword;
		string		_wwwCommand;
		string		_newsCommand;
};
//	Single global instance
extern mxSetup	*theMxSetup;

inline
const string&	mxSetup::filename() const
	{return _filename;}

////////////////////////////////////////////////////////////////////////////////
//	Inline functions - General
////////////////////////////////////////////////////////////////////////////////
inline
void	mxSetup::setOrganisation(string org)
	{_organisation = org;}
inline
void	mxSetup::setTempDirectory(string name)
	{_tempDirectory = name;}
inline
void	mxSetup::setHelpDirectory(string name)
	{_helpDirectory = name;}
inline
void	mxSetup::setAudioDirectory(string name)
	{_audioDirectory = name;}
inline
void	mxSetup::setMailServer(string name)
	{_mailServer = name;}
inline
void	mxSetup::setNewsServer(string name)
	{_newsServer = name;}
inline
void	mxSetup::setTimeServer(string name)
	{_timeServer = name;}
inline
void	mxSetup::setIntroSound(bool value)
	{_introSound = value;}
inline
void	mxSetup::setCheckMailSound(bool value)
	{_checkMailSound = value;}
inline
void	mxSetup::setNewMailSound(bool value)
	{_newMailSound = value;}
inline
void	mxSetup::setFtpTransferSound(bool value)
	{_ftpTransferSound = value;}
inline
const string&	mxSetup::organisation() const
	{return _organisation;}
inline
const string&	mxSetup::tempDirectory() const
	{return _tempDirectory;}
inline
const string&	mxSetup::helpDirectory() const
	{return _helpDirectory;}
inline
const string&	mxSetup::audioDirectory() const
	{return _audioDirectory;}
inline
const string&	mxSetup::mailServer() const
	{return _mailServer;}
inline
const string&	mxSetup::newsServer() const
	{return _newsServer;}
inline
const string&	mxSetup::timeServer() const
	{return _timeServer;}
inline
bool	mxSetup::introSound() const
	{return _introSound;}
inline
bool	mxSetup::checkMailSound() const
	{return _checkMailSound;}
inline
bool	mxSetup::newMailSound() const
	{return _newMailSound;}
inline
bool	mxSetup::ftpTransferSound() const
	{return _ftpTransferSound;}

////////////////////////////////////////////////////////////////////////////////
//	Inline functions - mxFTP
////////////////////////////////////////////////////////////////////////////////
inline
void	mxSetup::setFtpShowPermissions(bool value)
	{_ftpShowPermissions = value;}
inline
void	mxSetup::setFtpShowNumberLinks(bool value)
	{_ftpShowNumberLinks = value;}
inline
void	mxSetup::setFtpShowOwner(bool value)
	{_ftpShowOwner = value;}
inline
void	mxSetup::setFtpShowGroup(bool value)
	{_ftpShowGroup = value;}
inline
void	mxSetup::setFtpShowSize(bool value)
	{_ftpShowSize = value;}
inline
void	mxSetup::setFtpShowDate(bool value)
	{_ftpShowDate = value;}
inline
void	mxSetup::setFtpDefaultLocalDir(string value)
	{_ftpDefaultLocalDir = value;}
inline
void	mxSetup::setFtpDefaultRemoteDir(string value)
	{_ftpDefaultRemoteDir = value;}
inline
void	mxSetup::setFtpProcessFilename(string value)
	{_ftpProcessFilename = value;}
inline
void	mxSetup::addFtpSite(string name)
{
	for (int i=0;i<_ftpSites.size();i++)
	   {
	    if (_ftpSites[i] == name)
	      return;
	   }
	_ftpSites.push_back(name);
}
inline
void	mxSetup::removeFtpSite(string name)
{
	for (int i=0;i<_ftpSites.size();i++)
	   {
	    if (_ftpSites[i] == name)
	       {
		_ftpSites.erase(_ftpSites.begin()+i);
		return;
	       }
	   }
}
inline
bool	mxSetup::ftpShowPermissions() const
	{return _ftpShowPermissions;}
inline
bool	mxSetup::ftpShowNumberLinks() const
	{return _ftpShowNumberLinks;}
inline
bool	mxSetup::ftpShowOwner() const
	{return _ftpShowOwner;}
inline
bool	mxSetup::ftpShowGroup() const
	{return _ftpShowGroup;}
inline
bool	mxSetup::ftpShowSize() const
	{return _ftpShowSize;}
inline
bool	mxSetup::ftpShowDate() const
	{return _ftpShowDate;}
inline
const string&	mxSetup::ftpDefaultLocalDir() const
	{return _ftpDefaultLocalDir;}
inline
const string&	mxSetup::ftpDefaultRemoteDir() const
	{return _ftpDefaultRemoteDir;}
inline
const string&	mxSetup::ftpProcessFilename() const
	{return _ftpProcessFilename;}
inline
int		mxSetup::ftpNoOfSites() const
	{return _ftpSites.size();}
inline
const string&	mxSetup::ftpSite(int no) const
{
	if (no < 0 || no >= _ftpSites.size())
	  return _ftpSites[0];
	return _ftpSites[no];
}

////////////////////////////////////////////////////////////////////////////////
//	Inline functions - mxMail
////////////////////////////////////////////////////////////////////////////////
inline
void	mxSetup::setMailSenderName(string name)
	{_mailSenderName = name;}
inline
void	mxSetup::setMailInboxName(string name)
	{_mailInboxName = name;}
inline
void	mxSetup::setMailOutboxName(string name)
	{_mailOutboxName = name;}
inline
void	mxSetup::setMailAddressbookName(string name)
	{_mailAddressbookName = name;}
inline
void	mxSetup::setMailSpambookName(string name)
	{_mailSpambookName = name;}
inline
void	mxSetup::setMailSignatureName(string name)
	{_mailSignatureName = name;}
inline
void	mxSetup::setMailFolderDirectory(string name)
	{_mailFolderDirectory = name;}
inline
void	mxSetup::setMailInboxReadFolder(string name)
	{_mailInboxReadFolder = name;}
inline
void	mxSetup::setMailIndentString(string name)
	{_mailIndentString = name;}
inline
void	mxSetup::setMailProcessFilename(string name)
	{_mailProcessFilename = name;}
inline
void	mxSetup::setMailUpdateInterval(int interval)
	{_mailUpdateInterval = interval;}
inline
void	mxSetup::setMailStartupFolders(int no,string *folders)
{
	_mailStartupFolders.erase(_mailStartupFolders.begin(),
				  _mailStartupFolders.end());
	for (int i=0;i<no;i++)
	  _mailStartupFolders.push_back(folders[i]);
}
inline
const string&	mxSetup::mailSenderName() const
	{return _mailSenderName;}
inline
void	mxSetup::setMailMimeFormat(bool on_off)
	{_mailMimeFormat = on_off;}
inline
const string&	mxSetup::mailInboxName() const
	{return _mailInboxName;}
inline
const string&	mxSetup::mailOutboxName() const
	{return _mailOutboxName;}
inline
const string&	mxSetup::mailAddressbookName() const
	{return _mailAddressbookName;}
inline
const string&	mxSetup::mailSpambookName() const
	{return _mailSpambookName;}
inline
const string&	mxSetup::mailSignatureName() const
	{return _mailSignatureName;}
inline
const string&	mxSetup::mailFolderDirectory() const
	{return _mailFolderDirectory;}
inline
const string&	mxSetup::mailInboxReadFolder() const
	{return _mailInboxReadFolder;}
inline
const string&	mxSetup::mailIndentString() const
	{return _mailIndentString;}
inline
const string&	mxSetup::mailProcessFilename() const
	{return _mailProcessFilename;}
inline
int		mxSetup::mailUpdateInterval() const
	{return _mailUpdateInterval;}
inline
int		mxSetup::mailNoStartupFolders() const
	{return _mailStartupFolders.size();}
inline
const string&	mxSetup::mailStartupFolder(int no) const
{
	if (no < 0 || no >= _mailStartupFolders.size())
	  return _mailStartupFolders[0];
	return _mailStartupFolders[no];
}
inline
bool		mxSetup::mailMimeFormat() const
	{return _mailMimeFormat;}

////////////////////////////////////////////////////////////////////////////////
//	Inline functions - mxNews
////////////////////////////////////////////////////////////////////////////////
inline
void	mxSetup::setNewsBaseDirectory(string dir)
	{_newsBaseDirectory = dir;}
inline
const string&	mxSetup::newsBaseDirectory() const
	{return _newsBaseDirectory;}

////////////////////////////////////////////////////////////////////////////////
//	Inline functions - mxNet
////////////////////////////////////////////////////////////////////////////////
inline
void	mxSetup::setModemSpeed(int value)
	{_modemSpeed = value;}
inline
void	mxSetup::setModemPort(int value)
	{_modemPort = value;}
inline
void	mxSetup::setModemInit(string value)
	{_modemInit = value;}
inline
void	mxSetup::setModemIdle(int value)
	{_modemIdle = value;}
inline
void	mxSetup::setModemNoRetries(int value)
	{_modemNoRetries = value;}
inline
void	mxSetup::setSupplierName(string value)
	{_supplierName = value;}
inline
void	mxSetup::setSupplierLocation(string value)
	{_supplierLocation = value;}
inline
void	mxSetup::setSupplierPhoneNo(string value)
	{_supplierPhoneNo = value;}
inline
void	mxSetup::setSupplierLogin(string value)
	{_supplierLogin = value;}
inline
void	mxSetup::setSupplierPassword(string value)
	{_supplierPassword = value;}
inline
void	mxSetup::setWWWCommand(string value)
	{_wwwCommand = value;}
inline
void	mxSetup::setNewsCommand(string value)
	{_newsCommand = value;}
inline
int		mxSetup::modemSpeed() const
	{return _modemSpeed;}
inline
int		mxSetup::modemPort() const
	{return _modemPort;}
inline
const string&	mxSetup::modemInit() const
	{return _modemInit;}
inline
int		mxSetup::modemIdle() const
	{return _modemIdle;}
inline
int		mxSetup::modemNoRetries() const
	{return _modemNoRetries;}
inline
const string&	mxSetup::supplierName() const
	{return _supplierName;}
inline
const string&	mxSetup::supplierLocation() const
	{return _supplierLocation;}
inline
const string&	mxSetup::supplierPhoneNo() const
	{return _supplierPhoneNo;}
inline
const string&	mxSetup::supplierLogin() const
	{return _supplierLogin;}
inline
const string&	mxSetup::supplierPassword() const
	{return _supplierPassword;}
inline
const string&	mxSetup::wwwCommand() const
	{return _wwwCommand;}
inline
const string&	mxSetup::newsCommand() const
	{return _newsCommand;}

#endif
#endif
