/*
 * Create and destroy the advance-warning popup. It is installed when the
 * Advance icon (looks like a clock with two hands) is pressed. early_warn
 * and/or late_warn in edit.entry are set to zero (off) or nonzero (on)
 * when buttons in the Advance popup are pressed.
 *
 *	destroy_advance_popup()
 *	create_advance_popup()
 */

#include <stdio.h>
#include <time.h>
#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/LabelP.h>
#include <Xm/LabelG.h>
#include <Xm/PushBP.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/Text.h>
#include <Xm/Protocols.h>
#include "cal.h"

static void		done_callback(), early_callback(),
			early_text_callback(), late_callback(),
			late_text_callback(), noalarm_callback();

extern Display		*display;	/* everybody uses the same server */
extern struct edit	edit;		/* info about entry being edited */
extern struct config	config;		/* global configuration data */
extern Pixel		color[NCOLS];	/* colors: COL_* */
extern struct plist	*mainlist;	/* list of all schedule entries */

static BOOL		have_shell;	/* message popup exists if TRUE */
static Widget		shell;		/* popup menu shell */
static Widget		early;		/* early-warning text */
static Widget		early_toggle;	/* early-warning toggle button */
static Widget		late;		/* late-warning text */
static Widget		late_toggle;	/* late-warning toggle button */
static Widget		noalarm_toggle;	/* no final alarm toggle button */


/*
 * destroy a popup. Remove it from the screen, and destroy its widgets.
 * It's too much trouble to keep them for next time.
 */

void destroy_advance_popup()
{
	char			*string;	/* contents of text widget */

	if (have_shell && edit.editing) {
		if (edit.entry.early_warn) {
			string = XmTextGetString(early);
			edit.entry.early_warn = parse_timestring(string, TRUE);
			XtFree(string);
		}
		if (edit.entry.late_warn) {
			string = XmTextGetString(late);
			edit.entry.late_warn = parse_timestring(string, TRUE);
			XtFree(string);
		}
		edit.changed = TRUE;
		edit.entry.suspended = FALSE;
		print_pixmap(edit.menu->entry[edit.y][SC_ADVANCE],
				edit.entry.early_warn || edit.entry.late_warn ?
							PIC_ADVANCE : -1);
	}
	if (have_shell) {
		XtPopdown(shell);
		XTDESTROYWIDGET(shell);
		have_shell = FALSE;
		confirm_new_entry();
	}
}


/*
 * create an advance-warning popup as a separate application shell. The
 * popup is initialized with data from edit.entry.
 */

void create_advance_popup()
{
	Widget			form, rowcol, w, help;
	register struct entry	*ep = &edit.entry;
	Arg			args[20];
	int			n;
	Atom			closewindow;

	destroy_advance_popup();

	n = 0;
	XtSetArg(args[n], XmNdeleteResponse,	XmDO_NOTHING);		n++;
	XtSetArg(args[n], XmNiconic,		False);			n++;
	shell = XtAppCreateShell("Advance Warnings", "plan",
			applicationShellWidgetClass, display, args, n);
#	ifdef EDITRES
	XtAddEventHandler(shell, (EventMask)0, TRUE, 
 			_XEditResCheckMessages, NULL);
#	endif
	set_icon(shell, 1);
	form = XtCreateManagedWidget("advform1", xmFormWidgetClass,
			shell, NULL, 0);
	XtAddCallback(form, XmNhelpCallback, help_callback, (XtPointer)"adv");

							/*-- buttons --*/
	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	w = XtCreateManagedWidget("Done", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(w, XmNactivateCallback, done_callback, (XtPointer)0);
	XtAddCallback(w, XmNhelpCallback,     help_callback, (XtPointer)
								"adv_done");

	n = 0;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNrightWidget,	w);			n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNwidth,		80);			n++;
	help = XtCreateManagedWidget("Help", xmPushButtonWidgetClass,
			form, args, n);
	XtAddCallback(help, XmNactivateCallback, help_callback,
							(XtPointer)"adv");
	XtAddCallback(help, XmNhelpCallback,     help_callback,
							(XtPointer)"adv");

							/*-- frame --*/
	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset,		8);			n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_WIDGET);	n++;
	XtSetArg(args[n], XmNbottomWidget,	w);			n++;
	XtSetArg(args[n], XmNbottomOffset,	16);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	8);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	8);			n++;
	XtSetArg(args[n], XmNshadowType,	XmSHADOW_ETCHED_IN);	n++;
	w = XtCreateManagedWidget("", xmFrameWidgetClass,
			form, args, n);
	w = XtCreateManagedWidget("advform2", xmFormWidgetClass,
			w, NULL, 0);
	n = 0;
	XtSetArg(args[n], XmNtopAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNtopOffset,		10);			n++;
	XtSetArg(args[n], XmNbottomAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNbottomOffset,	10);			n++;
	XtSetArg(args[n], XmNrightAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNrightOffset,	10);			n++;
	XtSetArg(args[n], XmNleftAttachment,	XmATTACH_FORM);		n++;
	XtSetArg(args[n], XmNleftOffset,	10);			n++;
	XtSetArg(args[n], XmNspacing,		20);			n++;
	XtSetArg(args[n], XmNpacking,		XmPACK_COLUMN);		n++;
	XtSetArg(args[n], XmNnumColumns,	3);			n++;
	rowcol = XtCreateManagedWidget("", xmRowColumnWidgetClass,
			w, args, n);
							/*-- early, late --*/
	n = 0;
	XtSetArg(args[n], XmNselectColor,	color[COL_TOGGLE]);	n++;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	XtSetArg(args[n], XmNset,		ep->early_warn != 0);	n++;
	early_toggle = XtCreateManagedWidget("Early warning",
			xmToggleButtonWidgetClass,
			rowcol, args, n);
	XtAddCallback(early_toggle, XmNvalueChangedCallback,
					early_callback, (XtPointer)0);
	XtAddCallback(early_toggle, XmNhelpCallback,
					help_callback, (XtPointer)"adv_early");

	n = 0;
	XtSetArg(args[n], XmNselectColor,	color[COL_TOGGLE]);	n++;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	XtSetArg(args[n], XmNset,		ep->late_warn != 0);	n++;
	late_toggle = XtCreateManagedWidget("Late warning",
			xmToggleButtonWidgetClass,
			rowcol, args, n);
	XtAddCallback(late_toggle, XmNvalueChangedCallback,
					late_callback, (XtPointer)0);
	XtAddCallback(late_toggle, XmNhelpCallback,
					help_callback, (XtPointer)"adv_late");

	n = 0;
	XtSetArg(args[n], XmNselectColor,	color[COL_TOGGLE]);	n++;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	XtSetArg(args[n], XmNset,		ep->noalarm == 0);	n++;
	noalarm_toggle = XtCreateManagedWidget("Normal alarm",
			xmToggleButtonWidgetClass,
			rowcol, args, n);
	XtAddCallback(noalarm_toggle, XmNvalueChangedCallback,
				noalarm_callback, (XtPointer)0);
	XtAddCallback(noalarm_toggle, XmNhelpCallback,
				help_callback, (XtPointer)"adv_noalarm");

	n = 0;
	XtSetArg(args[n], XmNwidth,		100);			n++;
	XtSetArg(args[n], XmNrecomputeSize,	False);			n++;
	XtSetArg(args[n], XmNpendingDelete,	True);			n++;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	XtSetArg(args[n], XmNbackground,	color[COL_TEXTBACK]);	n++;
	early = XtCreateManagedWidget("", xmTextWidgetClass,
			rowcol, args, n);
	XtAddCallback(early, XmNactivateCallback,
					early_text_callback, (XtPointer)NULL);
	XtAddCallback(early, XmNhelpCallback,
					help_callback, (XtPointer)"adv_early");

	n = 0;
	XtSetArg(args[n], XmNwidth,		100);			n++;
	XtSetArg(args[n], XmNrecomputeSize,	False);			n++;
	XtSetArg(args[n], XmNpendingDelete,	True);			n++;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	XtSetArg(args[n], XmNbackground,	color[COL_TEXTBACK]);	n++;
	late = XtCreateManagedWidget("", xmTextWidgetClass,
			rowcol, args, n);
	XtAddCallback(late, XmNactivateCallback,
					late_text_callback, (XtPointer)NULL);
	XtAddCallback(late, XmNhelpCallback,
					help_callback, (XtPointer)"adv_late");

	n = 0;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	XtCreateManagedWidget("", xmLabelWidgetClass,
			rowcol, args, n);

	n = 0;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	w = XtCreateManagedWidget("in advance", xmLabelWidgetClass,
			rowcol, args, n);

	n = 0;
	XtSetArg(args[n], XmNhighlightThickness,0);			n++;
	w = XtCreateManagedWidget("in advance", xmLabelWidgetClass,
			rowcol, args, n);

	XtPopup(shell, XtGrabNone);
	closewindow = XmInternAtom(display, "WM_DELETE_WINDOW", False);
	XmAddWMProtocolCallback(shell, closewindow,
					done_callback, (XtPointer)shell);

	if (ep->early_warn)
		print_text_button(early, mktimestring(ep->early_warn, TRUE));
	if (ep->late_warn)
		print_text_button(late, mktimestring(ep->late_warn, TRUE));

	have_shell = TRUE;
}


/*-------------------------------------------------- callbacks --------------*/
/*
 * All of these routines are direct X callbacks.
 */

/*ARGSUSED*/
static void done_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	destroy_advance_popup();
}


/*ARGSUSED*/
static void early_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	if (data->set) {
		XmProcessTraversal(early, XmTRAVERSE_CURRENT);
		print_text_button(early,
			mktimestring(edit.entry.early_warn = config.early_time,
									TRUE));
	} else {
		edit.entry.early_warn = 0;
		print_text_button(early, "");
	}
	edit.changed = TRUE;
	sensitize_edit_buttons();
}


/*ARGSUSED*/
static void early_text_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	char				*text = XmTextGetString(widget);
	Arg				args;
	int				warn;

	if ((warn = parse_timestring(text, TRUE)) > 60)
		config.early_time = edit.entry.early_warn = warn;
	XtSetArg(args, XmNset, edit.entry.early_warn != 0);
	XtSetValues(early_toggle, &args, 1);
	print_text_button(widget, mktimestring(edit.entry.early_warn, TRUE));
	XtFree(text);
}


/*ARGSUSED*/
static void late_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	if (data->set) {
		XmProcessTraversal(late, XmTRAVERSE_CURRENT);
		print_text_button(late,
			mktimestring(edit.entry.late_warn = config.late_time,
									TRUE));
	} else {
		edit.entry.late_warn = 0;
		print_text_button(late, "");
	}
	edit.changed = TRUE;
	sensitize_edit_buttons();
}


/*ARGSUSED*/
static void late_text_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	char				*text = XmTextGetString(widget);
	Arg				args;

	config.late_time     =
	edit.entry.late_warn = parse_timestring(text, TRUE);
	XtSetArg(args, XmNset, edit.entry.late_warn != 0);
	XtSetValues(late_toggle, &args, 1);
	print_text_button(widget, mktimestring(edit.entry.late_warn, TRUE));
	XtFree(text);
}


/*ARGSUSED*/
static void noalarm_callback(widget, item, data)
	Widget				widget;
	int				item;
	XmToggleButtonCallbackStruct	*data;
{
	edit.entry.noalarm = !data->set;
	edit.changed = TRUE;
	sensitize_edit_buttons();
}
