/*  Public Header file for the FileSelector

    Copyright (c) Richard M. Offer 1994,1995

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

$Id: File.h,v 1.5 1995/07/03 09:24:52 richardo Exp $

*/


#ifndef _RWS_File_H
#define _RWS_File_H


/* include this to get XmVERSION stuff */

#include <Xm/Xm.h>
#if XmVERSION == 1
#	if XmREVISION == 1
#		define HAVE_MOTIF_1_1
#	else /* ! revision 1 */
#		define HAVE_MOTIF_1_2
#	endif /* revision 1 */
#else /* ! version 1 */ 
#	define HAVE_MOTIF_2
#endif /* version 1 */

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_MOTIF_2
externalref WidgetClass rwsFileSelectorWidgetClass;
#else 
extern WidgetClass rwsFileSelectorWidgetClass;
#endif


typedef struct _RwsFileSelectorClassRec *RwsFileSelectorWidgetClass;
typedef struct _RwsFileSelectorRec 	*RwsFileSelectorWidget;

typedef struct _RwsFileSelectorCallbackStruct {

      int	reason;
      
      char	*file;
      char	*dir;
      
      
} RwsFileSelectorCallbackStruct;



/* resource names (spacific to the FileSelector) */

#define RwsNfileEntryFont	"fileEntryFont"
#define RwsNdirEntryFont	"dirEntryFont"
#define RwsNfileSelectedCallback "fileSelectedCallback"
#define RwsNcurrentDirectory	"currentDirectory"
#define RwsNnumDirEntriesVisible "numEntries"
#define RwsNautoOpenDirectories	"autoOpenDirs"

#define RwsCCurrentDirectory	"currentDirectory"
#define RwsCNumDirEntriesVisible "NumEntries"
#define RwsCAutoOpenDirectories	"AutoOpenDirs"


/* reason codes for the callbacks

RwsCR_TYPED_FILENAME user pressed return inside text field (only if
   XmNeditable = True )

RwsCR_SELECTED_FILENAME user selected an entry from the list
   (usefull if RwsNautoOpenDirestories = False ) 

*/
enum { RwsCR_TYPED_FILENAME=0, RwsCR_SELECTED_FILENAME=1 };

/* defines for Rws...GetChild() */

#define RwsFileSelectorCurrentDir	"current-dir"
#define RwsFileSelectorFileList		"file-list"
#define RwsFileSelectorFileName		"file-name"

extern Widget RwsCreateFileSelector(
#if NeedFunctionPrototypes
				    Widget	parent,
				    String	name,
				    Arg		*args,
				    Cardinal	nargs
#endif
				    );


#ifdef __cplusplus
}
#endif

#endif /* _RWS_File_H */
