/*  Private Header file for the FileSelector

    Copyright (c) Richard M. Offer 1994,1995

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

$Id: FileP.h,v 1.4 1995/07/03 09:24:54 richardo Exp $

*/


#ifndef _RWS_FileP_H
#define _RWS_FileP_H


/* File Widget superclass */

#include <Rws/File.h>

#include <X11/Xos.h>
#include <X11/Xfuncs.h>

#if XmVERSION == 1
#	if XmREVISION == 1
#		define HAVE_MOTIF_1_1
#	else /* ! revision 1 */
#		define HAVE_MOTIF_1_2
#	endif /* revision 1 */
#else /* ! version 1 */ 
#	define HAVE_MOTIF_2
#endif /* version 1 */

#ifndef HAVE_MOTIF_1_1
#include <Xm/ManagerP.h>
#else
#include <Xm/XmP.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


typedef struct _RwsFileSelectorClassPart {

      XtPointer	extension;
      
} RwsFileSelectorClassPart;

typedef struct _RwsFileSelectorClassRec {
      
      CoreClassPart		core_class;
      CompositeClassPart	composite_class;
      ConstraintClassPart	constraint_class;
      XmManagerClassPart	manager_class;
      RwsFileSelectorClassPart	file_class;

} RwsFileSelectorClassRec;

typedef struct _RwsFileSelectorPart {

/* resources */
      XFontStruct	*file_font;
      XFontStruct	*dir_font;
      
      XtCallbackList	file_selected_cb;

      Boolean		editable;
      
      char		*current_dir;

      int		num_dir_entries;
      
      Boolean		auto_open_dirs;

      unsigned char	shadow_type;
      

/* internal use */

      Widget	dir_label;
      Widget	file_list;
      Widget	file_name;
      
} RwsFileSelectorPart;


typedef struct _RwsFileSelectorRec { 
      
      CorePart		core;
      CompositePart	composite;
      ConstraintPart	constraint;
      XmManagerPart	manager;
      RwsFileSelectorPart file;
      
} RwsFileSelectorRec;


/* constraint struct's (not ued at present) */

typedef struct _RwsFileSelectorConstraintPart {
      
      int	unused;
      
} RwsFileSelectorConstraintPart, *RwsFileSelectorConstraint;

typedef struct _RwsFileSelectorConstraintRec {
      
      XmManagerConstraintPart	manager;
      RwsFileSelectorConstraintPart	file;
      
} RwsFileSelectorConstraintRec, *RwsFileSelectorConstraintPtr;

 

      



#ifdef __cplusplus
}
#endif

#endif /* _RWS_FileP_H */
