static char rcsid[] = "$Id: clock.c,v 1.10 1995/05/10 09:11:21 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* clock.c for rtc --- makes a simple digital clock

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/


#include <Rtc.h>
 
#ifdef WANT_CLOCK

static void rtcUpdateTime( 
#if NeedFunctionPrototypes
			  RTCObject *object
#endif
			  );

static void rtcPopupReminder( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XtPointer	call
#endif
			  );

static void rtcReadReminderFile( 
#if NeedFunctionPrototypes
			  RTCObject *object
#endif
			  );

static void rtcUpdateTimeString( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XmScaleCallbackStruct	*call
#endif
			  );

static void rtcUpdateDateString( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XmScaleCallbackStruct	*call
#endif
			  );

static void rtcUpdateMonthString( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XmScaleCallbackStruct	*call
#endif
			  );

static void rtcUpdateYearString( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XmScaleCallbackStruct	*call
#endif
			  );

static void rtcAddReminderToList( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XtPointer	call
#endif
			  );

static void rtcEditReminder( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XtPointer	call
#endif
			  );

static void rtcDelReminderFromList( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XtPointer	call
#endif
			  );

static void rtcDoneWithReminder( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XtPointer	call
#endif
			  );

static void rtcCancelReminder( 
#if NeedFunctionPrototypes
			     Widget	widget,
			     RTCObject *object,
			     XtPointer	call
#endif
			  );

static void rtcAddLegacyReminders( 
#if NeedFunctionPrototypes
			  RTCObject *object
#endif
			  );

static void rtcAlarm( 
#if NeedFunctionPrototypes
			  RTCReminderEntry *reminder
#endif
			  );

static char	*month[] = { 
      "Jan", "Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec",
};



#if NeedFunctionPrototypes
ObjectReturnType RtcParseClock(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseClock(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel >= (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			fprintf(stderr,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      fprintf(stderr,"%d ",
				      object->options[i]->type);

			      i++;
			}

			fprintf(stderr,"\n");
			
		  }
		  
	    }
 
	    ptr += num_chars;

      }

      object->parent = parent;
 
      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc(	sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

       object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;

      return ( Child );
      
}


#if NeedFunctionprototypes
void RtcCreateClock(RTCObject *object)
#else
void RtcCreateClock(object)
RTCObject	*object;
#endif
{

      XmString	xmstr = NULL;
      Widget	button;
      Arg	args[5];
      int	n;
      char	time_str[64];
      time_t	time_val;
      int	i=0;
      struct tm *time_struct;
      
      extern XtAppContext	AppContext;

      
      time_val = time( NULL );

      time_struct = localtime(&time_val);

      strftime(time_str,
	       sizeof(time_str),
	       object->name,
	       time_struct);
      
      
      n=0;
      xmstr = XmStringCreateLtoR(time_str,"menu-buttons");

      XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
      XtSetArg( args[n], XmNlabelString, xmstr);n++;


      button = XmCreateCascadeButtonGadget(object->parent->widget,
					   "clock",
					   args,
					   n);

      if ( ! (object->option_mask & TimeMask ) ) {

	    if ( object->options == NULL )
		  object->options = (RTCOption ** ) XtMalloc( sizeof(RTCOption *) );
	    else {

		  while ( object->options && object->options[i] != NULL )
			i++;


		  object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (i+1));

	    }	    
	    object->options[i] = (RTCOption *) XtMalloc( sizeof(RTCOption) );
	    
	    object->options[i]->type = TimeMask;
	    
	    object->options[i]->value = XtNewString("60");

	    object->options[i]->data = NULL;
	    
	    i++; 

	    object->options = (RTCOption ** ) XtRealloc( (char * ) object->options, sizeof(RTCOption *) * (i+1));
	    
	    object->options[i] = NULL;
	    
	    
	    object->option_mask  =  object->option_mask | TimeMask ;
	    
	    XtAppAddTimeOut(AppContext,
			    60000L,
			    (XtTimerCallbackProc) rtcUpdateTime,
			    (XtPointer) object);
      }
      else {
	    int pause;

	    while ( object->options && object->options[i] != NULL ) {

		  if ( object->options[i]->type & TimeMask ) {
		  
			pause = atoi ( object->options[i]->value );
			break;
			
		  }
		  
		  i++;
	    }

	    XtAppAddTimeOut(AppContext,
			    pause*1000,
			    (XtTimerCallbackProc) rtcUpdateTime,
			    (XtPointer) object);
      }

      XtAddCallback(button, 
		    XmNactivateCallback, 
		    (XtCallbackProc) rtcPopupReminder,
		    (XtPointer) object);


#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(button, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      
	    
      XtManageChild( button );

      object->widget = button;
      
      if ( xmstr ) 
	    XmStringFree(xmstr);
      
/* open reminder file */

      rtcReadReminderFile(object);
      
}

#if NeedFunctionPrototypes
static void rtcReadReminderFile(RTCObject *object)
#else
static void rtcReadReminderFile(object)
RTCObject	*object;
#endif
{
      FILE	*fp;
      char	line[MAX_LINE_LEN];
      RTCReminder	*reminder;
      int	i,num;
      time_t	time_val,alarm;
      extern XtAppContext	AppContext;

 
      if ( (fp=fopen(object->master->resources.reminderFile,"r")) != NULL ) {

	    time_val = time( NULL );
	    
	    reminder = (RTCReminder *) object->data;

	    if ( reminder == NULL ) {
		  reminder = (RTCReminder *) XtMalloc( sizeof( RTCReminder ));
		  
		  reminder->entries = (RTCReminderEntry **) NULL;
		  reminder->dialog = NULL;
		  reminder->num_entries = 0;
	    
		  object->data = ( char* ) reminder;
	    }
	    else {

		  for (i=0; i< reminder->num_entries;i++ ) {
			XtFree(reminder->entries[i]->text);
			XtRemoveTimeOut(reminder->entries[i]->id);
			XtFree( (char *) reminder->entries[i]);
		  }
		  reminder->num_entries = 0;
		  XtFree( ( char *) reminder->entries);
		  
		  reminder->entries = (RTCReminderEntry **) NULL;
		  
	    }
	    
	    while ( fgets(line,MAX_LINE_LEN,fp) ) {

		  if ( sscanf(line,"%ld %n",&alarm,&num) ) { 
		  
			if ( alarm < time_val )
			      RtcMsg(object->master,Info,"Alarm %s has expired\n",&line[num]);
			else { 

			      if ( reminder->entries == NULL )
				    reminder->entries = ( RTCReminderEntry ** ) XtMalloc( sizeof (RTCReminderEntry *) );
			      else
				    reminder->entries = ( RTCReminderEntry ** ) XtRealloc( ( char *)reminder->entries,
											  sizeof (RTCReminderEntry *)*(reminder->num_entries+1));
			
			/* strip off trailing newline */
			      line[strlen(line)-1] = '\0';
			
			      reminder->entries[reminder->num_entries] = ( RTCReminderEntry * ) XtMalloc( sizeof (RTCReminderEntry) );
			
			      reminder->entries[reminder->num_entries]->time = alarm;
			      reminder->entries[reminder->num_entries]->text = XtNewString(&line[num]);
			
			      reminder->entries[reminder->num_entries]->id = XtAppAddTimeOut(AppContext,
											     (alarm-time_val)*1000,
											     (XtTimerCallbackProc) rtcAlarm,
											     (XtPointer ) reminder->entries[reminder->num_entries]);
			      reminder->num_entries++;
			
			}
		  }
		  
	    }

	    object->data = (char *) reminder; 

	    fclose(fp);
	    
      }
}


#if NeedFunctionPrototypes
static void rtcUpdateTime(RTCObject *object)
#else
static void rtcUpdateTime(object)
RTCObject	*object;
#endif
{

      XmString	xmstr;
      char	time_str[64];
      time_t	time_val;
      int i,pause;
      struct tm *time_struct;
     
      extern XtAppContext	AppContext;

      
      time_val = time( NULL );

      time_struct = localtime(&time_val);

      strftime(time_str,
	       sizeof(time_str),
	       object->name,
	       time_struct);
         
      xmstr = XmStringCreateLtoR(time_str,"menu-buttons");

      XtVaSetValues(object->widget,
		    XmNlabelString, xmstr,
		    NULL);
      

      i=0;
      while ( object->options && object->options[i] != NULL ) {

	    if ( object->options[i]->type & TimeMask ) {
		  
		  pause = atoi( object->options[i]->value );
		  
		  break;
		  
	    }
	    
	    i++;
      }

      XmStringFree(xmstr);

      XtAppAddTimeOut(AppContext,
		      pause*1000L,
		      (XtTimerCallbackProc) rtcUpdateTime,
		      (XtPointer) object);
      

}


#if NeedFunctionPrototypes
static void rtcPopupReminder(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcPopupReminder(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{
      Widget	form,date_form,entry_form,frame,label,rowcol,action_form,separator,ok,cancel;
      Arg	args[10];
      int	n=0;
      time_t	time_val;
      struct tm *time_struct;
      char	hour[6];
      RTCReminder *reminder;
      XmString	xmstr;
      extern	Widget	TopLevel;
      
      if ( object->data  == NULL ) {
	    object->data = (char *) XtMalloc( sizeof( RTCReminder ));

	    ((RTCReminder *) object->data)->dialog = NULL;
	    ((RTCReminder *) object->data)->num_entries = 0;
	    ((RTCReminder *) object->data)->entries = NULL;
	    
      }

      reminder = (RTCReminder *) object->data;

      if ( reminder->dialog == NULL ) {
	    
     
	    time_val = time( NULL );

	    time_struct = localtime(&time_val);

	    sprintf(hour,"%02d:%02d", time_struct->tm_hour, time_struct->tm_min);

#ifndef WANT_BROKEN_FORM_WORKAROUND
	    n=0;
	    XtSetArg(args[n], XmNtitle,"RTC Reminder" );n++;
	    reminder->dialog = XmCreateInformationDialog(TopLevel,
							 "reminder",
							 args,
							 n);
#else      
	    n=0;
	    XtSetArg(args[n], XmNtitle,"RTC Reminder" );n++;
	    reminder->dialog = XmCreateDialogShell(TopLevel,
						   "reminder-shell",
						   args,
						   n);
#endif
	    form = XtVaCreateWidget(
#ifdef WANT_BROKEN_FORM_WORKAROUND
		                    "reminder",
#else
				    "form",
#endif
				    xmFormWidgetClass,
				    reminder->dialog,
#ifdef WANT_BROKEN_FORM_WORKAROUND
				    XmNverticalSpacing, 4,
				    XmNhorizontalSpacing, 4,
#endif
				    NULL);

	    entry_form = XtVaCreateWidget("entry-form",
					  xmFormWidgetClass,
					  form,
					  XmNtopAttachment,XmATTACH_FORM,
					  XmNleftAttachment,XmATTACH_FORM,
					  XmNrightAttachment,XmATTACH_FORM,
					/*  XmNheight, 100, */
					  NULL);

	    frame = XtVaCreateWidget("date-frame",
				     xmFrameWidgetClass,
				     entry_form,
				     XmNtopAttachment,XmATTACH_FORM,
				     XmNleftAttachment,XmATTACH_FORM,
				     XmNbottomAttachment,XmATTACH_FORM,
				     NULL);

	    date_form = XtVaCreateWidget("date-form",
					 xmFormWidgetClass,
					 frame,
					 NULL);

	    xmstr = XmStringCreateLtoR("At : ","panel-prompt");

	    label = XtVaCreateManagedWidget("time-label",
					    xmLabelGadgetClass,
					    date_form,
					    XmNlabelString, xmstr,
					    XmNtopAttachment,XmATTACH_FORM,
					    XmNleftAttachment,XmATTACH_FORM,
					    NULL);

	    XmStringFree(xmstr);

	    xmstr = XmStringCreateSimple(hour);

	    reminder->time  = XtVaCreateManagedWidget("time-scale",
						      xmScaleWidgetClass,
						      date_form,
						      XmNtitleString, xmstr,
						      XmNorientation,XmHORIZONTAL,
						      XmNtopAttachment,XmATTACH_FORM,
						      XmNleftAttachment,XmATTACH_WIDGET,
						      XmNleftWidget,label,
						      XmNrightAttachment,XmATTACH_FORM,
						      XmNmaximum, 288,
						      XmNminimum,0,
						      XmNvalue, ((time_struct->tm_hour*12)+(time_struct->tm_min/5)),
						      NULL);

	    XmStringFree(xmstr);

	    XtAddCallback( reminder->time,
			  XmNvalueChangedCallback,
			  (XtCallbackProc) rtcUpdateTimeString,
			  (XtPointer) object);

	    XtAddCallback( reminder->time,
			  XmNdragCallback,
			  (XtCallbackProc) rtcUpdateTimeString,
			  (XtPointer) object);

	    xmstr = XmStringCreateLtoR("On : ","panel-prompt");
      
	    label = XtVaCreateManagedWidget("date-label",
					    xmLabelGadgetClass,
					    date_form,
					    XmNlabelString, xmstr,
					    XmNtopAttachment,XmATTACH_WIDGET,
					    XmNtopWidget,reminder->time,
					    XmNleftAttachment,XmATTACH_FORM,
					    NULL);
	    XmStringFree(xmstr);

	    sprintf(hour,"%d",time_struct->tm_mday);

	    xmstr = XmStringCreateSimple(hour);

	    reminder->date = XtVaCreateManagedWidget("date-scale",
						     xmScaleWidgetClass,
						     date_form,
						     XmNtitleString, xmstr,
						     XmNorientation,XmHORIZONTAL,
						     XmNtopAttachment,XmATTACH_WIDGET,
						     XmNtopWidget,reminder->time,
						     XmNleftAttachment,XmATTACH_WIDGET,
						     XmNleftWidget,label,
						     XmNmaximum, 31,
						     XmNminimum,1,
						     XmNvalue,time_struct->tm_mday,
						     XmNscaleWidth,50,
						     NULL);

	    XmStringFree(xmstr);

	    XtAddCallback( reminder->date,
			  XmNvalueChangedCallback,
			  (XtCallbackProc) rtcUpdateDateString,
			  (XtPointer) object);

	    XtAddCallback( reminder->date,
			  XmNdragCallback,
			  (XtCallbackProc) rtcUpdateDateString,
			  (XtPointer) object);

	    xmstr = XmStringCreateLtoR("/","panel-prompt");

	    label = XtVaCreateManagedWidget("date-label",
					    xmLabelGadgetClass,
					    date_form,
					    XmNlabelString, xmstr,
					    XmNtopAttachment,XmATTACH_WIDGET,
					    XmNtopWidget,reminder->time,
					    XmNleftAttachment,XmATTACH_WIDGET,
					    XmNleftWidget,reminder->date,
					    NULL);

	    XmStringFree(xmstr);

	    xmstr = XmStringCreateSimple(month[time_struct->tm_mon]);
	
	    reminder->month = XtVaCreateManagedWidget("month-scale",
						      xmScaleWidgetClass,
						      date_form,
						      XmNtitleString, xmstr,
						      XmNorientation,XmHORIZONTAL,
						      XmNtopAttachment,XmATTACH_WIDGET,
						      XmNtopWidget,reminder->time,
						      XmNleftAttachment,XmATTACH_WIDGET,
						      XmNleftWidget,label,
						      XmNmaximum, 11,
						      XmNminimum,0,
						      XmNvalue,time_struct->tm_mon,
						      XmNscaleWidth,50,
						      NULL);
	    XmStringFree(xmstr);

	    XtAddCallback(reminder->month,
			  XmNvalueChangedCallback,
			  (XtCallbackProc) rtcUpdateMonthString,
			  (XtPointer) object);
	    
	    XtAddCallback(reminder->month,
			  XmNdragCallback,
			  (XtCallbackProc) rtcUpdateMonthString,
			  (XtPointer) object);
	    
	    xmstr = XmStringCreateLtoR("/","panel-prompt");

	    label = XtVaCreateManagedWidget("date-label",
					    xmLabelGadgetClass,
					    date_form,
					    XmNlabelString, xmstr,
					    XmNtopAttachment,XmATTACH_WIDGET,
					    XmNtopWidget,reminder->time,
					    XmNleftAttachment,XmATTACH_WIDGET,
					    XmNleftWidget,reminder->month,
					    NULL);

	    XmStringFree(xmstr);
	    
	    
	    sprintf(hour,"%d",time_struct->tm_year);
      
	    xmstr = XmStringCreateSimple(hour);

	    reminder->year = XtVaCreateManagedWidget("year-scale",
						     xmScaleWidgetClass,
						     date_form,
						     XmNtitleString, xmstr,
						     XmNorientation,XmHORIZONTAL,
						     XmNtopAttachment,XmATTACH_WIDGET,
						     XmNtopWidget,reminder->time,
						     XmNleftAttachment,XmATTACH_WIDGET,
						     XmNleftWidget,label,
						     XmNrightAttachment, XmATTACH_FORM,
						     XmNmaximum, 2000,
						     XmNminimum,1994,
						     XmNvalue,time_struct->tm_year+1900,
						     XmNscaleWidth,50,
						     NULL);

	    XmStringFree(xmstr);

	    
	    XtAddCallback( reminder->year,
			  XmNvalueChangedCallback,
			  (XtCallbackProc) rtcUpdateYearString,
			  (XtPointer) object);
	    XtAddCallback( reminder->year,
			  XmNdragCallback,
			  (XtCallbackProc) rtcUpdateYearString,
			  (XtPointer) object);
	    
	    
	    XtManageChild( date_form );

	    rowcol= XtVaCreateWidget("rowcol",
				     xmRowColumnWidgetClass,
				     entry_form,
				     XmNtopAttachment, XmATTACH_FORM,
				     XmNleftAttachment,  XmATTACH_WIDGET,
				     XmNleftWidget,  frame,
				     XmNbottomAttachment, XmATTACH_FORM,
				     NULL);
	    
	    reminder->add = XtVaCreateManagedWidget("save",
						    xmPushButtonGadgetClass,
						    rowcol,
						    NULL);


	    XtAddCallback( reminder->add,
			  XmNactivateCallback,
			  (XtCallbackProc) rtcAddReminderToList,
			  (XtPointer) object);

	    reminder->edit = XtVaCreateManagedWidget("edit",
						    xmPushButtonGadgetClass,
						    rowcol,
						    NULL);

	    
	    XtAddCallback( reminder->edit,
			  XmNactivateCallback,
			  (XtCallbackProc) rtcEditReminder,
			  (XtPointer) object);

	    reminder->delete = XtVaCreateManagedWidget("delete",
						    xmPushButtonGadgetClass,
						    rowcol,
						    NULL);

	    XtAddCallback( reminder->delete,
			  XmNactivateCallback,
			  (XtCallbackProc) rtcDelReminderFromList,
			  (XtPointer) object);
	    n=0;


	    XtSetArg(args[n], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);n++;
	    XtSetArg(args[n], XmNselectionPolicy, XmSINGLE_SELECT);n++;

	    reminder->list = XmCreateScrolledList(entry_form,
						  "reminder-list",
						  args,
						  n);

	    XtVaSetValues( XtParent(reminder->list),
			  XmNtopAttachment, XmATTACH_FORM,
			  XmNleftAttachment, XmATTACH_WIDGET,
			  XmNleftWidget, rowcol,
			  XmNrightAttachment, XmATTACH_FORM,
			  XmNbottomAttachment, XmATTACH_FORM,
			  XmNresizable,	False,
			  NULL);

	    xmstr = XmStringCreateLtoR("Msg :","panel-prompt");
	    
	    label = XtVaCreateManagedWidget("date-label",
					    xmLabelGadgetClass,
					    form,
					    XmNlabelString, xmstr,
					    XmNtopAttachment,XmATTACH_WIDGET,
					    XmNtopWidget,entry_form,
					    XmNtopOffset, 2, 
					    XmNleftAttachment,XmATTACH_FORM,
					    NULL);

	    XmStringFree(xmstr);
	    
	    reminder->text = XtVaCreateWidget("reminder-text",
					      xmTextFieldWidgetClass,
					      form,
					      XmNresizable,	False,
					      XmNtopAttachment,  XmATTACH_WIDGET,
					      XmNtopWidget,  entry_form,
					      XmNtopOffset, 2,
					      XmNleftAttachment,  XmATTACH_WIDGET,
					      XmNleftWidget, label,
					      XmNrightAttachment,  XmATTACH_FORM,
					      NULL);
	
	    XtManageChild( rowcol );
	    
	    XtManageChild( entry_form );
	    XtManageChild( frame );
	    
	    XtManageChild(reminder->text);
	    XtManageChild(reminder->list);

#ifndef WANT_BROKEN_FORM_WORKAROUND
	    XtAddCallback(reminder->dialog, XmNokCallback, 
			  (XtCallbackProc) rtcDoneWithReminder,
			  (XtPointer) object);
	       

	    XtAddCallback(reminder->dialog, XmNcancelCallback, 
			  (XtCallbackProc) rtcCancelReminder,
			  (XtPointer) object);

	    XtUnmanageChild( XmMessageBoxGetChild(reminder->dialog, XmDIALOG_HELP_BUTTON));
	    XtUnmanageChild( XmMessageBoxGetChild(reminder->dialog, XmDIALOG_SYMBOL_LABEL));
	    XtUnmanageChild( XmMessageBoxGetChild(reminder->dialog, XmDIALOG_MESSAGE_LABEL));
#else      
       
	    separator = XtVaCreateManagedWidget("sep",
						xmSeparatorGadgetClass,
						form,
						XmNtopAttachment,XmATTACH_WIDGET,
						XmNtopWidget,reminder->text,
						XmNleftAttachment,XmATTACH_FORM,
						XmNrightAttachment,XmATTACH_FORM,
						NULL);
      
	    action_form = XtVaCreateWidget("action-form",
					   xmFormWidgetClass,
					   form,
					   XmNtopAttachment,XmATTACH_WIDGET,
					   XmNtopWidget, separator,
					   XmNleftAttachment,XmATTACH_FORM,
					   XmNrightAttachment,XmATTACH_FORM,
					   XmNfractionBase,5,
					   NULL);
      
	    ok = XtVaCreateManagedWidget("Ok",
					 xmPushButtonGadgetClass,
					 action_form,
					 XmNtopAttachment,XmATTACH_FORM,
					 XmNleftAttachment,XmATTACH_POSITION,
					 XmNleftPosition,1,
					 XmNrightAttachment,XmATTACH_POSITION,
					 XmNrightPosition,2,
					 XmNbottomAttachment, XmATTACH_FORM,
					 XmNshowAsDefault, True,
					 NULL);

      
	    cancel = XtVaCreateManagedWidget("Cancel",
					 xmPushButtonGadgetClass,
					 action_form,
					 XmNtopAttachment,XmATTACH_FORM,
					 XmNleftAttachment,XmATTACH_POSITION,
					 XmNleftPosition,3,
					 XmNrightAttachment,XmATTACH_POSITION,
					 XmNrightPosition,4,
					 XmNbottomAttachment, XmATTACH_FORM,
					 NULL);
	    
	    XtAddCallback(cancel,XmNactivateCallback, (XtCallbackProc) rtcCancelReminder, (XtPointer) object);
	    XtAddCallback(ok,XmNactivateCallback, (XtCallbackProc) rtcDoneWithReminder, (XtPointer) object);
      
     
	    XtManageChild( action_form );
#endif
      
	    XtManageChild( form );

      }
      else
/* re-read the reminders file, just incase the panel was 'caneled out' previously */
	    rtcReadReminderFile(object);

/* if we read some reminders from the reminders file then install these into the list */
      if ( reminder->num_entries > 0 ) 
	    rtcAddLegacyReminders(object);
      
#ifndef WANT_BROKEN_FORM_WORKAROUND
      XtManageChild(((RTCReminder *) object->data)->dialog);
#else
      XtPopup(((RTCReminder *) object->data)->dialog, XtGrabNone);
#endif
}

#if NeedFunctionPrototypes
static void rtcUpdateTimeString(Widget widget, RTCObject *object, XmScaleCallbackStruct *call)
#else
static void rtcUpdateTimeString(widget,object,call)
Widget	widget;
RTCObject	*object;
XmScaleCallbackStruct 	*call;
#endif
{

      XmString	xmstr;
      char	hour[6];
      int	value;
      
      if ( call != NULL )
	    sprintf(hour,"%02d:%02d",call->value / 12, ( call->value % 12 ) * 5);
      else {
	    XtVaGetValues(widget,      
			  XmNvalue,&value,
			  NULL);

	    sprintf(hour,"%02d:%02d",value / 12, ( value % 12 ) * 5);
      }	    
	    
      xmstr = XmStringCreateSimple(hour);
     
      XtVaSetValues(widget,
		    XmNtitleString, xmstr,
		    NULL);
      

      XmStringFree(xmstr );
      
}


#if NeedFunctionPrototypes
static void rtcUpdateMonthString(Widget widget, RTCObject *object, XmScaleCallbackStruct *call)
#else
static void rtcUpdateMonthString(widget,object,call)
Widget	widget;
RTCObject	*object;
XmScaleCallbackStruct *call;
#endif
{

      static XmString	xmstr[12] ;
      int	i,value;
      static	setup = False;
      
      if ( ! setup ) { 
	    for ( i=0;i<12; i++ ) 
		  xmstr[i] = XmStringCreateSimple(month[i]);
	    setup= True;
      }
      
      
      if ( call != NULL )

	    XtVaSetValues(widget,
			  XmNtitleString, xmstr[call->value],
			  NULL);
      else {
	    XtVaGetValues(widget,      
			  XmNvalue,&value,
			  NULL);

	    XtVaSetValues(widget,
			  XmNtitleString, xmstr[value],
			  NULL);
      }
      

}


#if NeedFunctionPrototypes
static void rtcUpdateDateString(Widget widget, RTCObject *object, XmScaleCallbackStruct *call)
#else
static void rtcUpdateDateString(widget,object,call)
Widget	widget;
RTCObject	*object;
XmScaleCallbackStruct *call;
#endif
{

      XmString	xmstr;
      char	date[3];
      int	value;
      
      if ( call != NULL )
	    sprintf(date,"%2d",call->value );
      else {
	    XtVaGetValues(widget,      
			  XmNvalue,&value,
			  NULL);

	    sprintf(date,"%2d",value );
      }
      
      xmstr = XmStringCreateSimple(date);
     
      XtVaSetValues(widget,
		    XmNtitleString, xmstr,
		    NULL);
      

      XmStringFree(xmstr );
      
}

#if NeedFunctionPrototypes
static void rtcUpdateYearString(Widget widget, RTCObject *object, XmScaleCallbackStruct *call)
#else
static void rtcUpdateYearString(widget,object,call)
Widget	widget;
RTCObject	*object;
XmScaleCallbackStruct *call;
#endif
{

      XmString	xmstr;
      char	year[3];
      int	value;
      
      if ( call != NULL )
	    sprintf(year,"%2d",call->value-1900 );
      else {
	    XtVaGetValues(widget,      
			  XmNvalue,&value,
			  NULL);

	    sprintf(year,"%2d",value-1900 );
      }

      xmstr = XmStringCreateSimple(year);
     
      XtVaSetValues(widget,
		    XmNtitleString, xmstr,
		    NULL);
      

      XmStringFree(xmstr );
      
}


#if NeedFunctionPrototypes
static void rtcAddReminderToList(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcAddReminderToList(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer 	call;
#endif
{

      char	entry[256];
      char	*text;
      int	date,imonth,year,hour;
      XmString	xmstr;
      RTCReminder *reminder = (RTCReminder *) object->data;
      time_t	current,alarm;
      struct tm	tm;
      int	*items,nitems,n;
      extern	XtAppContext	AppContext;
      
      
      XtVaGetValues(reminder->time,
		    XmNvalue,&hour,
		    NULL);

      XtVaGetValues(reminder->date,
		    XmNvalue,&date,
		    NULL);
      
      XtVaGetValues(reminder->month,
		    XmNvalue,&imonth,
		    NULL);
      
      XtVaGetValues(reminder->year,
		    XmNvalue,&year,
		    NULL);

      XtVaGetValues(reminder->text,
		    XmNvalue,&text,
		    NULL);
      

      sprintf(entry,
	      "%2d/%s/%d %2d:%02d %s",
	      date,
	      month[imonth],
	      year-1900,
	      hour/12,
	      (hour%12)*5,
	      text);
      
      xmstr = XmStringCreateLtoR(entry,"list-entry");
      
      
      current = time( NULL );

      tm.tm_sec = 0;
      tm.tm_min = (hour%12)*5;
      tm.tm_hour = hour/12;
      tm.tm_mday = date;
      tm.tm_mon = imonth;
      tm.tm_year = year-1900;
      tm.tm_isdst = -1;
      
      
      alarm = mktime( &tm );

      if ( alarm != (time_t) -1 ) {

/* if an item from the list is selected then this is a replacement *NOT* a new reminder */
	    if ( XmListGetSelectedPos(reminder->list, &items,&nitems) ) {
		  
		  n=items[0]-1;
		  
		  reminder->entries[n]->time = alarm;
		  reminder->entries[n]->text = XtNewString(text);
		  
		  XtRemoveTimeOut(reminder->entries[n]->id);

		  reminder->entries[n]->id = XtAppAddTimeOut(AppContext,
							     ( alarm - current) * 1000,
							     (XtTimerCallbackProc) rtcAlarm,
							     (XtPointer) reminder->entries[n]);

		  XmListReplaceItemsPos(reminder->list,
					&xmstr,
					1,
					n+1);

	    }
	    else {

		  if ( reminder->entries == NULL )
			reminder->entries = ( RTCReminderEntry ** ) XtMalloc( sizeof (RTCReminderEntry *) );
		  else
			reminder->entries = ( RTCReminderEntry ** ) XtRealloc(( char * ) reminder->entries,
									      sizeof (RTCReminderEntry *) * (reminder->num_entries+1));
	    
		  reminder->entries[reminder->num_entries] = ( RTCReminderEntry * ) XtMalloc( sizeof (RTCReminderEntry) );
	    
		  reminder->entries[reminder->num_entries]->time = alarm;
		  reminder->entries[reminder->num_entries]->text = XtNewString(text);
	    
		  reminder->entries[reminder->num_entries]->id = XtAppAddTimeOut(AppContext,
										 ( alarm - current) * 1000,
										 (XtTimerCallbackProc) rtcAlarm,
										 (XtPointer) reminder->entries[reminder->num_entries]);
		  reminder->num_entries++;
		  
		  XmListAddItemUnselected(reminder->list,
				    xmstr,
				    0);
		  
	    }
	         
      }	

      XmStringFree(xmstr);
      
}


#if NeedFunctionPrototypes
static void rtcEditReminder(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcEditReminder(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer 	call;
#endif
{
      int	*items,nitems;
      struct tm	*tm;
      RTCReminder *reminder = (RTCReminder *) object->data;
      

      if ( XmListGetSelectedPos(reminder->list, &items,&nitems) ) {

	    if ( reminder->entries == NULL )
		return;

	    tm = localtime(&reminder->entries[items[0]-1]->time);
	    
	    XtVaSetValues(reminder->time,
			  XmNvalue,((tm->tm_hour*12)+(tm->tm_min/5)),
			  NULL);

	    XtVaSetValues(reminder->date,
			  XmNvalue,tm->tm_mday,
			  NULL);
      
	    XtVaSetValues(reminder->month,
			  XmNvalue,tm->tm_mon,
			  NULL);
      
	    XtVaSetValues(reminder->year,
			  XmNvalue,tm->tm_year+1900,
			  NULL);

	    XtVaSetValues(reminder->text,
			  XmNvalue,reminder->entries[items[0]-1]->text,
			  NULL);

/* 
   update the labels to reflect the changes, passing NULL as the
   call_data, requests the function to get the resource from the widget
   rather than the call_data structure.
*/
	    rtcUpdateTimeString(reminder->time,
				object,
				(XmScaleCallbackStruct *) NULL);

	    rtcUpdateDateString(reminder->date,
				object,
				(XmScaleCallbackStruct *) NULL);

	    rtcUpdateMonthString(reminder->month,
				 object,
				 (XmScaleCallbackStruct *) NULL);

	    rtcUpdateYearString(reminder->year,
				object,
				(XmScaleCallbackStruct *) NULL);

      }

}


#if NeedFunctionPrototypes
static void rtcDelReminderFromList(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcDelReminderFromList(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer 	call;
#endif
{
      int	*items,nitems;
      int	i,n;
      RTCReminder *reminder = (RTCReminder *) object->data;
      

      if ( XmListGetSelectedPos(reminder->list, &items,&nitems) ) {

	    if ( reminder->entries == NULL ) {
	    	XmListDeletePos(reminder->list,items[0]);
		return;
	    }

	    n=items[0]-1;

	    XtRemoveTimeOut(reminder->entries[n]->id);
	    
	    if ( reminder->num_entries == 1 ) {
		  XtFree(reminder->entries[n]->text);
		  XtFree( (char *) reminder->entries[n] );
		  
		  reminder->num_entries = 0;
		  
	    }
	    else {
		  
		  for (i=n;i< reminder->num_entries-1; i++ )
			reminder[n]=reminder[n+1];
		  
		  XtFree(reminder->entries[reminder->num_entries-1]->text);
		  XtFree( (char *) reminder->entries[reminder->num_entries-1] );
		  
		  reminder->num_entries--;
		  
		  
	    }
	    
	    XmListDeletePos(reminder->list,items[0]);
	    
      }

}

#if NeedFunctionPrototypes
static void rtcDoneWithReminder(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcDoneWithReminder(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer 	call;
#endif
{

      FILE	*fp;
      RTCReminder *reminder = (RTCReminder *) object->data;
      int	i;
      

      if ( (fp=fopen(object->master->resources.reminderFile,"w")) == NULL ) {

	    RtcMsg(object->master,Error,"Cannot open reminder file (%s) for writing\n",object->master->resources.reminderFile);
	    return;
      }
      
      for ( i =0; i< reminder->num_entries; i++ ) { 
		fprintf(fp,"%Ld %s\n",
		    reminder->entries[i]->time,
		    reminder->entries[i]->text);
      }
      
      fclose(fp);

#ifndef  WANT_BROKEN_FORM_WORKAROUND     
      XtUnmanageChild( reminder->dialog );
#else
      XtPopdown(reminder->dialog );
#endif

}

#if NeedFunctionPrototypes
static void rtcCancelReminder(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcCancelReminder(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer 	call;
#endif
{

      RTCReminder *reminder = (RTCReminder *) object->data;
      
#ifndef  WANT_BROKEN_FORM_WORKAROUND     
      XtUnmanageChild( reminder->dialog );
#else
      XtPopdown(reminder->dialog );
#endif

}

#if NeedFunctionPrototypes
static void rtcAddLegacyReminders(RTCObject *object)
#else
static void rtcAddLegacyReminders(object)
RTCObject	*object;
#endif
{

      struct tm *tm;
      RTCReminder	*reminder = (RTCReminder *) object->data;
      int	i;
      char	entry[256];
      XmString	xmstr;
      
      XmListDeleteAllItems(reminder->list);
      
      for ( i =0; i < reminder->num_entries; i++ ) {

	    tm= localtime(&reminder->entries[i]->time);
	    
	    sprintf(entry,
		    "%2d/%s/%d %2d:%02d %s",
		    tm->tm_mday,
		    month[tm->tm_mon],
		    tm->tm_year,
		    tm->tm_hour,
		    tm->tm_min,
		    reminder->entries[i]->text);
      
	    xmstr = XmStringCreateLtoR(entry,"list-entry");

	    XmListAddItemUnselected(reminder->list,
				    xmstr,
				    0);
	    XmStringFree(xmstr);
      }
      

}

#if NeedFunctionPrototypes
static void rtcAlarm(RTCReminderEntry *reminder)
#else
static void rtcAlarm(reminder)
RTCReminderEntry	*reminder;
#endif
{


  XmString	xmstr,tmp;
  Widget	dialog;
  Arg		args[5];
  int		n;
  extern Widget	TopLevel;

  xmstr = XmStringCreateLtoR("The Following Alarm has expired\n\n","message");

  tmp = XmStringConcat(xmstr,
		       XmStringCreateLtoR(reminder->text,"message"));

  n=0;

  XtSetArg(args[n], XmNmessageString, tmp);n++;
  XtSetArg(args[n], XmNtitle, "Rtc Alarm Notifier");n++;

  dialog = XmCreateMessageDialog(TopLevel,
				 "alarm-expired",
				 args,
				 n);


  XtAddCallback(dialog, XmNokCallback,
		(XtCallbackProc) RtcDestroyDialog,
		(XtPointer) dialog);

  XmStringFree(xmstr);
  XmStringFree(tmp);

  XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_CANCEL_BUTTON));
  XtUnmanageChild(XmMessageBoxGetChild(dialog,XmDIALOG_HELP_BUTTON));


  XtManageChild(dialog);
}


#endif /* WANT_CLOCK */
