static char rcsid[] = "$Id: disk-space.c,v 1.5 1995/03/27 12:48:57 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* disk.c --- displays disk partition usage

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_DISK_WATCHER

static void rtcUpdateDiskUsage(
#if NeedFunctionPrototypes
			RTCObject	*object
#endif
			    );

static void rtcParseDiskBreakPoints(
#if NeedFunctionPrototypes
				    RTCObject	*object,
				    char	*line
#endif
				    );

static void rtcDiskUsageTimeOut(
#if NeedFunctionPrototypes
			RTCObject	*object
#endif
			    );

static void rtcDiskUsageCB(
#if NeedFunctionPrototypes
			   Widget	widget,
			   RTCObject	*object,
			   XtPointer	call
#endif
			    );


#if NeedFunctionPrototypes
ObjectReturnType RtcParseDiskUsage(RTCMaster *master, RTCObject *parent, RTCObject *object,char *line)
#else
ObjectReturnType RtcParseDiskUsage(master, parent,object,line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{
      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*options;
      RTCDiskSpace	*disk_space;
      
      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(master,Diagnostics,"\n");
			
		  }
		  
	    }
 
	    ptr += num_chars;

      }

      sscanf(ptr,"%s%n",keyword,&num_chars);
      ptr += num_chars;

      disk_space = (RTCDiskSpace *) XtMalloc( sizeof(RTCDiskSpace));
      
      disk_space->partition = RtcExpandShellVariable( keyword, strlen(keyword) );
      disk_space->update_period = 1800;
      disk_space->entries = (RTCDiskSpaceEntry **) NULL;
      disk_space->num_entries = 0;
      
/* because the update period is accessed often, make it directly
   available, rather than having to walk through the option list every
   time */

      if ( object->option_mask | TimeMask ) {
	    i=0;
	    while ( object->options && object->options[i] != NULL ) {
		  
		  if ( object->options[i]->type & TimeMask ) {
			
			disk_space->update_period = atoi( object->options[i]->value );
			
			break;
		  
		  }
		  
		  i++;
	    }
      }
      
      
      object->data = (char *) disk_space;

      rtcParseDiskBreakPoints(object, ptr );

      object->parent = parent;
 
      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc(	sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

       object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;

      return ( Child );
      
}


#if NeedFunctionPrototypes
void	RtcCreateDiskUsage(RTCObject *object)
#else
void RtcCreateDiskUsage(object)
RTCObject	*object;
#endif
{

      int	n;
      Widget	button;
      Arg	args[5];
      char	label[64];
      XmString	xmstr;
      float	space;
#if HAVE_STATVFS
      struct statvfs buf;
#else
      struct statfs buf;
#endif
      
      extern XtAppContext	AppContext;

      if ( statfs(((RTCDiskSpace *)object->data)->partition,&buf, sizeof(buf), 0) ) {

	    RtcMsg(object->master,Error,"Internal Error performing statfs(%s) value %d\n",
		   ((RTCDiskSpace *)object->data)->partition,
		   errno);

	    xmstr = XmStringCreateLtoR("broken statfs()","menu-buttons");
      }
      else {
/* this is a prob, Ideally I would like to use b_bavail, as this is the
space availble to the non-superuser, but not all systems (IRIX 4.0)
have this, so we have to make to with the total free space, blahhh */
#ifdef HAVE_STATVFS
	    space =((float) buf.f_frsize * (buf).f_bavail /1048576.0);
#else
	    space = ( ((float) (buf.f_bsize * buf.f_bfree))  / 1048576.0 );
#endif

	    sprintf(label,object->name, space);
	    xmstr = XmStringCreateLtoR(label,"menu-buttons");
      }
      n=0;	
      XtSetArg( args[n], XmNlabelType, XmSTRING);n++;
      XtSetArg( args[n], XmNlabelString, xmstr);n++;
/* have to use widget since, we will be setting the colour later, which we can't do with gadgets (no window) */
      button = XmCreateCascadeButton(object->parent->widget,
				     "disk-usage",
				     args,
				     n);

      XmStringFree(xmstr);
      
#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	      XtAddCallback(button, 
			    XmNhelpCallback, 
			    (XtCallbackProc) RtcDisplayContextHelp,
			    (XtPointer) object);
      }
#endif      
      
      XtAppAddTimeOut(AppContext,
		      0L,
		      (XtTimerCallbackProc) rtcDiskUsageTimeOut,
		      (XtPointer) object);
      
      XtAddCallback(button,
		    XmNactivateCallback,
		    (XtCallbackProc) rtcDiskUsageCB,
		    (XtPointer) object);
      

      object->widget = button;
      
      XtManageChild( button );
      
}

#if NeedFunctionPrototypes
static void rtcDiskUsageTimeOut(RTCObject *object)
#else
static void rtcDiskUsageTimeOut(object)
RTCObject	*object;
#endif
{
      extern XtAppContext	AppContext;

      rtcUpdateDiskUsage(object);
      

      XtAppAddTimeOut(AppContext,
		      ((RTCDiskSpace *) object->data)->update_period * 1000L,
		      (XtTimerCallbackProc) rtcDiskUsageTimeOut,
		      (XtPointer) object);
 
}

#if NeedFunctionPrototypes
static void rtcDiskUsageCB(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcDiskUsageCB(widget,object,call)
Widget	widget;
RTCObject	*object;
XtPointer	call;
#endif
{

      rtcUpdateDiskUsage(object);
      

}


#if NeedFunctionPrototypes
static void rtcUpdateDiskUsage(RTCObject *object)
#else
static void rtcUpdateDiskUsage(object)
RTCObject	*object;
#endif
{

      char	label[64];
      XmString	xmstr;
#if HAVE_STATVFS
      struct statvfs buf;
#else
      struct statfs buf;
#endif
      int	i=0;
      RTCDiskSpace	*disk = (RTCDiskSpace *) object->data ;
      float	space;
      
      
      if ( statfs(((RTCDiskSpace *)object->data)->partition,&buf, sizeof(buf), 0) )

	    RtcMsg(object->master,Diagnostics,"Internal Error performing statfs(%s) value %d\n",
		   ((RTCDiskSpace *)object->data)->partition,
		   errno);

      else { 
#ifdef HAVE_STATVFS
	    space =((float) buf.f_frsize * (buf).f_bavail /1048576.0);
#else
	    space = ( ((float) (buf.f_bsize * buf.f_bfree))  / 1048576.0 );
#endif

	    sprintf(label,object->name, space);
	    
	    xmstr = XmStringCreateLtoR(label,"menu-buttons");

	    if ( disk != NULL ) { 
		  for ( i=0; i <disk->num_entries; i++ ) { 
			if ( space < (float) disk->entries[i]->max && space > (float) disk->entries[i]->min ) {
			      XtVaSetValues(object->widget,
					    XtVaTypedArg, XmNforeground,XmRString, disk->entries[i]->colour,strlen(disk->entries[i]->colour)+1,
					    NULL);	
			      break;
			}
		  }
		  
	    }
	    

	    XtVaSetValues(object->widget,
			  XmNlabelString, xmstr,
			  NULL);
	    
	    XmStringFree( xmstr );
	    
      }
      
     
}

#if NeedFunctionPrototypes
static void rtcParseDiskBreakPoints(RTCObject *object, char *line)
#else
static void rtcParseDiskBreakPoints(object,line)
RTCObject	*object;
char		*line;
#endif
{

      char	word[32],colour[32],*tmp;
      int	n=0,num_chars,i;
      RTCDiskSpace	*disk = (RTCDiskSpace *) object->data ;
      
      while ( sscanf(&line[n],"%s%n",word,&num_chars) > 0 ) { 
      
	    n+=num_chars;
	    i=0;
	    colour[0] = '\0';
	    
	    while ( word[i] && word[i] != '=' )
		  i++;
	    
	    if ( disk->entries == NULL ) 
		  disk->entries = ( RTCDiskSpaceEntry **) XtMalloc( sizeof( RTCDiskSpace *) );
	    else
		  disk->entries = ( RTCDiskSpaceEntry **) XtRealloc( (char *) disk->entries,
								    sizeof( RTCDiskSpace *) * (disk->num_entries+1));
		  
	    disk->entries[disk->num_entries] = ( RTCDiskSpaceEntry *) XtMalloc( sizeof( RTCDiskSpace ) );
	    disk->entries[disk->num_entries]->colour = (char * ) XtMalloc( sizeof(char) * (i + 1));
	    disk->entries[disk->num_entries]->colour[0] = '\0';

	    disk->entries[disk->num_entries]->max = MAXINT ;
	    disk->entries[disk->num_entries]->min = 1 - MAXINT ;

	    num_chars = RtcExtractString(&tmp,word,"=:");
	    if ( strlen( tmp )  > 0 )
		  disk->entries[disk->num_entries]->max = atoi( tmp );
	    disk->entries[disk->num_entries]->min = atoi( &word[num_chars]);

	    strncat(disk->entries[disk->num_entries]->colour,word,i);

	    XtFree( tmp );

	    disk->num_entries++;	  
      }
      
}



#endif
