static char rcsid[] = "$Id: gui.c,v 1.10 1995/07/05 15:01:34 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* gui.c for rtc

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>


static void rtcCreateMenu(
#if NeedFunctionProtoTypes
			 RTCObject	*object
#endif
			 );


#if NeedFunctionPrototypes
int RtcMakeGUI(RTCMaster *master)
#else
int RtcMakeGUI(master)
RTCMaster	*master;
#endif
{

      Widget	menu_bar,form;
      extern Widget TopLevel,MsgArea;
      Arg	args[15];
      int	n;
      RTCObject	*top;
      
      form = XtVaCreateWidget("top-form",
			      xmFormWidgetClass,
			      TopLevel,
			      NULL);
      

      n=0;

      if ( master->resources.vertical ) { 
	    XtSetArg( args[n], XmNorientation, XmVERTICAL);n++;
      }

      XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM);n++;
      XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
      XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
      
      menu_bar = XmCreateMenuBar(form,
				 "menu-bar",
				 args,
				 n);
      
      if ( master->resources.msgStyle == (unsigned char) StatusArea ) { 
	    n=0;
      
	    XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET);n++;
	    XtSetArg(args[n], XmNtopWidget, menu_bar);n++;
	    XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM);n++;
	    XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM);n++;
	    XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM);n++;
	    XtSetArg(args[n], XmNautoShowCursorPosition, False);n++;
	    XtSetArg(args[n], XmNcursorPositionVisible, False);n++;
	    XtSetArg(args[n], XmNscrollHorizontal, False);n++;
	    XtSetArg(args[n], XmNscrollVertical, True);n++;
	    XtSetArg(args[n], XmNeditable, False);n++;
	    XtSetArg(args[n], XmNeditMode, XmMULTI_LINE_EDIT);n++;
	    XtSetArg(args[n], XmNhighlightThickness, 0);n++;
	    XtSetArg(args[n], XmNrows, 1);n++;
	    XtSetArg(args[n], XmNshowArrows, False);n++;
	    
	    MsgArea = XmCreateScrolledText(form,
					"msg-area",
					args,
					n);

	    XtManageChild( MsgArea );

#ifdef SITE_INIT_MSG
	    RtcMsg(master,StartUp,SITE_INIT_MSG);
#endif

      }
      
      
      top = RtcGetObjectByName(master, "Top", MenuDefType);
      
      
      top->widget = menu_bar;
 
      rtcCreateMenu(top);
      
      XtManageChild( menu_bar);
      XtManageChild( form );
      
      
      return ( True );
      
}

#if NeedFunctionPrototypes
static void rtcCreateMenu(RTCObject *object)
#else
static void rtcCreateMenu(object)
RTCObject	*object;
#endif
{

      int	i;

      for ( i=0; i< object->num_children; i++ )  {

		  if ( object->children[i]->create_asap )
			object->children[i]->create( object->children[i]  );

		  switch ( object->children[i]->type ) { 
		     case MenuType:
#ifdef WANT_HELP		     
		     case HelpMenuType:
#endif		     
			rtcCreateMenu(  object->children[i]->children[0] );
			break;
			
		     default:
			break;
		  }
      
      }
      
}


#if NeedFunctionProtoTypes
Boolean RtcGetPixmap(RTCObject *object, Pixmap *pixmap)
#else
Boolean RtcGetPixmap(object, pixmap)
RTCObject	*object;
Pixmap	*pixmap;
#endif
{
      
      int	i;
      Pixel	fg,bg;
      Screen	*screen;
      char	*pathname;
#ifdef WANT_COLOUR_ICONS
      Pixmap	mask;
      Display	*disp;
      Window	drawable;
      XpmAttributes	attrib;
      XpmColorSymbol	remap[8];
      int	error_code;
#endif      
      
      i=0;
      
      while ( object->options && object->options[i] != NULL ) {

	    if ( object->options[i]->type & IconFileMask ) {
		  
		  pathname = RtcFindFileInPath(object->master->resources.iconFilePath,object->options[i]->value);

		  if ( pathname == NULL ) {
			RtcMsg(object->master,
			       Error,
			       "Cannot find Iconfile %s in %s\n",
			       object->options[i]->value,
			       object->master->resources.iconFilePath);

			return (False);
		  }
		  
		  XtVaGetValues(object->parent->widget,
				XmNforeground, &fg,
				XmNbackground, &bg,
#ifdef WANT_COLOUR_ICONS
				XmNdepth, &attrib.depth,
				XmNcolormap,&attrib.colormap,
#endif
				NULL);

		  screen = XtScreen( object->parent->widget);
/* 
   there was a problem here, with many newer versions of motif
   (ie. metrolink 2.0), support for Xpm files are built into the Motif
   library, hense if you pass a xpm file to XmgetPixmap() you get a
   valid pixmap returned.

   So far so good.

   However this stops us remapping the symbolic colors "mask", "none",
   and "background" (just to be safe) to the backgound (bg) color. One
   alternative would be to use the shape extension, the alternative
   (used here) is to read xpm files first (withXpmReadFileToPixmap()),
   then if that fails use XmgetPixmap() to read a bitmap file.
*/
#ifdef WANT_COLOUR_ICONS

/* some versions of libXpm are case sensitive (ie. the one shipped with metrolink Motif 2.0) */
/* these are for symbolic names */			
		  remap[0].name = "mask";
		  remap[0].value = NULL;
		  remap[0].pixel = bg;

		  remap[1].name = "Mask";
		  remap[1].value = NULL;
		  remap[1].pixel = bg;
		  
		  
		  remap[2].name = "None";
		  remap[2].value = NULL;
		  remap[2].pixel = bg;
		  
		  remap[3].name = "none";
		  remap[3].value = NULL;
		  remap[3].pixel = bg;
		  
		  
		  remap[4].name ="Background";
		  remap[4].value = NULL;
		  remap[4].pixel = bg;
		  
		  remap[5].name = "background";
		  remap[5].value = NULL;
		  remap[5].pixel = bg;

/* these are for colour names */
		  remap[6].name = NULL;
		  remap[6].value = "None";
		  remap[6].pixel = bg;
		  
		  remap[7].name = NULL;
		  remap[7].value = "none";
		  remap[7].pixel = bg;
		  
		  disp = XtDisplay( object->parent->widget);
		  
		  drawable = RootWindowOfScreen( screen );
			
		  attrib.colorsymbols = remap;
		  attrib.numsymbols = 8;
		  attrib.visual = DefaultVisual( disp, DefaultScreen(disp));
		  attrib.valuemask = XpmDepth | XpmColorSymbols | XpmVisual ;
		  
		  error_code = XpmReadFileToPixmap(disp,
						   drawable,
						   pathname,
						   pixmap,
						   &mask,
						   &attrib);
		  
		  switch ( error_code ) { 

		     case XpmFileInvalid:
/* not a xpm file, try reading as a bitmap */			
#endif */ WANT_COLOR_ICONS */
			*pixmap = XmGetPixmap( screen,
					      pathname,
					      fg,
					      bg);

			if ( *pixmap == XmUNSPECIFIED_PIXMAP ) { 

			      RtcMsg(object->master,Error,
#ifdef WANT_COLOUR_ICONS
				     "Rtc: icon %s is not a valid Xpm or Xbm format icon\n",
#else
				     "Rtc: icon %s is not Xbm (and no support for Xpm files)\n",
#endif
				     pathname);
			      
			      XtFree(pathname);
			      return ( False );
			}
			else 
			      return ( True );
#ifdef WANT_COLOUR_ICONS
			break;
			
		     case XpmSuccess:
			XtFree(pathname);
			return (True );
			break;
			

		     default:
			RtcMsg(object->master,Error,
			       "Rtc: error %d reading Xpm file %s\n",error_code, pathname);
			XtFree(pathname);
			return ( False );

		  }
#endif /* WANT_COLOUR_ICONS */			
	    }

	    i++;
	    
      }

/* if we get here then something is wrong */

      RtcMsg(object->master,Error,"Internal Error Reading  %s\n",object->options[i]->value);

      return ( False );
      

}



#if NeedFunctionPrototypes
void RtcDestroyDialog(Widget button, Widget dialog, XtPointer ignore)
#else
void RtcDestroyDialog(button, dialog, ignore)
Widget	button;
Widget	dialog;
XtPointer	ignore;
#endif
{

  if ( XmIsDialogShell(button) || XmIsDialogShell(XtParent(button)) )
    XtDestroyWidget(button);
  else 
      XtDestroyWidget(dialog);
      
}

#if NeedFunctionPrototypes
void RtcUnmanageDialog(Widget button, Widget dialog, XtPointer ignore)
#else
void RtcUnmanageDialog(button, dialog, ignore)
Widget	button;
Widget	dialog;
XtPointer	ignore;
#endif
{

#ifdef WANT_BROKEN_FORM_WORKAROUND
      XtPopdown(dialog);
      
#else
      XtUnmanageChild(dialog);
#endif      
}
