static char rcsid[] = "$Id: panel-scale.c,v 1.4 1995/03/17 13:43:01 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* panel-scale.c

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_PANEL

static void rtcScaleCallback(
#if NeedFunctionPrototypes
			    Widget	widget,
			    RTCObject	*object,
			    XtPointer	call
#endif
			    );



#if NeedFunctionPrototypes
ObjectReturnType RtcParseScale(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParseScale(master, parent, object, line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{

      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars;
      char	*ptr,*result,*options;
      int	i;
      
      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;
      
      result = strchr(ptr,'=');
      
      if ( result ) {
	    result++;
	    sscanf(result,"%s",keyword);
	    object->command = XtNewString(keyword);

	    result += strlen(keyword);

	    (void) RtcExtractString(&object->data,ptr,"{}");

      }
      else { 
	    RtcMsg(object->master,Error,"No result indicator (=) in line %s\n",line);
	    return ( Child );
	    
      }
      
      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return( Child );
      
}


#if NeedFunctionPrototypes
void RtcCreateScale(RTCObject *object)
#else
void RtcCreateScale(object)
RTCObject	*object;
#endif
{
      Widget	frame,form,label,scale;
      XmString	xmstr;
      int	i=0;
      int	min=1,max=100,step=1,def;
      

      frame = XtVaCreateWidget("panel-entry-frame",
			       xmFrameWidgetClass,
			       object->parent->widget,
			       NULL);
      
#ifdef HAVE_MOTIF_1_1
      form = XtVaCreateWidget("panel-entry-form",
			      xmFormWidgetClass,
			      frame,
			      NULL);
#else
      form = frame;
#endif

      xmstr = XmStringCreateLtoR(object->name,"panel-prompt");
	    
      label = XtVaCreateManagedWidget("panel-entry-label",
				      xmLabelGadgetClass,
				      form,
				      XmNtopAttachment, XmATTACH_FORM,
				      XmNleftAttachment, XmATTACH_FORM,
				      XmNbottomAttachment, XmATTACH_FORM,
#ifndef HAVE_MOTIF_1_1
				      XmNchildType, XmFRAME_TITLE_CHILD,
#endif
				      XmNlabelString, xmstr,
				      NULL);
      


      sscanf(object->data,"%d %d %d",&min,&max,&step);
      

      scale = XtVaCreateWidget("panel-entry-scale",
			       xmScaleWidgetClass,
			       form,
			       XmNtopAttachment, XmATTACH_FORM,
#ifdef HAVE_MOTIF_1_1	
			       XmNleftAttachment, XmATTACH_WIDGET,
			       XmNleftWidget, label,
#else	
			       XmNleftAttachment, XmATTACH_FORM,
#endif		
			       XmNrightAttachment, XmATTACH_FORM,
			       XmNbottomAttachment, XmATTACH_FORM,
			       XmNminimum,min,
			       XmNmaximum,max,
			       XmNscaleMultiple,step,
			       XmNorientation,XmHORIZONTAL,
			       XmNshowValue,True,
			       NULL);


      XtAddCallback(scale,XmNdragCallback,(XtCallbackProc) rtcScaleCallback, (XtPointer) object);
      XtAddCallback(scale,XmNvalueChangedCallback,(XtCallbackProc) rtcScaleCallback, (XtPointer) object);
      
#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(scale, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      

      if ( object->option_mask & DefaultMask ) { 
	    while( object->options[i] ) { 
		  if ( object->options[i]->type == DefaultMask ) {
			sscanf(object->options[i]->value,"%d",&def);
			XtVaSetValues(scale,XmNvalue,def,NULL);
			break;
		  }
	    }
      }      


      XmStringFree(xmstr);

      object->widget = scale;

      XtManageChild(scale);

#ifdef HAVE_MOTIF_1_1
      XtManageChild(form);
#endif

      XtManageChild(frame);
      
}

#if NeedFunctionPrototypes
char *RtcScaleConfig(RTCObject *object, ConfigMaskType what)
#else
char *RtcScaleConfig(object,what)
RTCObject	*object;
ConfigMaskType	what;
#endif
{
      static char 	value[16];
      int	i=0,val;

      switch ( what ) {

	 case GetResultValue:
	    
	    XtVaGetValues(object->widget,XmNvalue,&val,NULL);
	    
	    sprintf(value,"%d",val);
	    
	    return ( value );
	    break;
	    
	 case GetResultName:

	    return( object->command );
	    break;
	
	 case ResetToDefault:

	    if ( object->option_mask & DefaultMask ) {
		  while( object->options[i] ) { 
			if ( object->options[i]->type == DefaultMask ) {
			      sscanf(object->options[i]->value,"%d",&val);

			      XtVaSetValues(object->widget,XmNvalue,val,NULL);

			      return ( NULL );
			      
			      break;
			}
		  }
	    }      
	    else 
		  XtVaSetValues(object->widget,
				XmNvalue, "",
				NULL);
	    
	    return (NULL );
	    break;
    
	 default:
	    break;
      }
      

      return NULL;

}


#if NeedFunctionPrototypes
static void rtcScaleCallback(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcScaleCallback(widget,object,call)
Widget		widget;
RTCObject	*object;
XtPointer	call;
#endif
{

      
      RtcUpdatePanelStatus(object->parent);
      
}


#endif /* WANT_PANEL */
