static char rcsid[] = "$Id: panel-text.c,v 1.4 1995/03/17 13:43:03 richardo Exp $ (c) Richard M. Offer 1993, 1994,1995";
/* panel-text.c

Copyright (c) 1993,1994 Richard M. Offer.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


Although the GPL allows you to modify the code to your hearts content,
could you be polite and send me a copy of any changes (but not patches, my
code may have changed). If you are considering adding additional
features, you might me better contacting me to make sure I'm not one
step ahead of you :-)

richard.

*/

#include <Rtc.h>

#ifdef WANT_PANEL

static void rtcTextCallback(
#if NeedFunctionPrototypes
			    Widget	widget,
			    RTCObject	*object,
			    XtPointer	call
#endif
			    );


#if NeedFunctionPrototypes
ObjectReturnType RtcParseText(RTCMaster *master, RTCObject *parent, RTCObject *object, char * line)
#else
ObjectReturnType RtcParseText(master, parent, object, line)
RTCMaster	*master;
RTCObject	*parent;
RTCObject	*object;
char		*line;
#endif
{

      char	keyword[32]; 		/* all keywords *will* fit into this */
      int	num_chars,i;
      char	*ptr,*result,*options;

      sscanf(line,"%s%n",keyword,&num_chars);
      
      while ( isspace(line[num_chars++] ))
	    ;
      
      
      num_chars--;
      
      ptr = &line[num_chars];

/* removes trailing new-line */

      line[strlen(line)-1] = '\0';

/* parse the name of the cascade button */
      num_chars = RtcExtractString(&object->name,ptr,"\"\"");

      ptr += num_chars;

/* get any options */
      num_chars = RtcExtractString(&options,ptr,"[]");

      if ( num_chars ) { 
	    RtcParseOptionsList(object,options);

	    if ( master->resources.msgLevel == (unsigned char) Diagnostics ) {
		  if ( object->option_mask) {
			RtcMsg(object->master,Diagnostics,"Options set on %s -> ",object->name);
			
			i=0;
		     
			while ( object->options && object->options[i] != NULL ) {
			      RtcMsg(object->master,Diagnostics,"%d ",
				      object->options[i]->type);

			      i++;
			}

			RtcMsg(object->master,Diagnostics,"\n");
			
		  }
		  
	    }

	    ptr += num_chars;

      }

      while ( isspace(*ptr))
	    ptr++;
      
      result = strchr(ptr,'=');
      
      if ( result ) {
	    result++;
	    sscanf(result,"%s",keyword);
	    object->command = XtNewString(keyword);
	    
      }
      else { 
	    RtcMsg(object->master,Error,"No result indicator (=) in line %s\n",line);
	    return ( Child );
	    
      }

/* give an initial value to the result */
      if ( object->option_mask & DefaultMask ) {
	    i=0;
	    while ( object->options && object->options[i] != NULL ) {
		  if ( object->options[i]->type == DefaultMask) {
			object->data = XtNewString(object->options[i]->value);
			break;
		  }
		  i++;
	    }
      }

      if ( ! object->data )
	    object->data = XtNewString("");
	    


      object->parent = parent;

      if ( object->parent->children == NULL )
	    object->parent->children = (RTCObject **) XtMalloc( sizeof(RTCObject *) * (object->parent->num_children+1));
      else
	    object->parent->children = (RTCObject **) XtRealloc(( char *)object->parent->children,
								sizeof(RTCObject *) * (object->parent->num_children+1));

      object->parent->children[object->parent->num_children] = object;
      
      object->parent->num_children++;


      return( Child );
       
}


#if NeedFunctionPrototypes
void RtcCreateText(RTCObject *object)
#else
void RtcCreateText(object)
RTCObject	*object;
#endif
{

      Widget	frame,form,label,text;
      XmString	xmstr;
      char	*def=NULL,*def_text=NULL;
      int	i=0;
      

      frame = XtVaCreateWidget("panel-entry-frame",
			       xmFrameWidgetClass,
			       object->parent->widget,
			       NULL);
      
#ifdef HAVE_MOTIF_1_1
      form = XtVaCreateWidget("panel-entry-form",
			      xmFormWidgetClass,
			      frame,
			      NULL);
#else
      form = frame;
#endif

      xmstr = XmStringCreateLtoR(object->name,"panel-prompt");
	    
      label = XtVaCreateManagedWidget("panel-entry-label",
				      xmLabelGadgetClass,
				      form,
				      XmNtopAttachment, XmATTACH_FORM,
				      XmNleftAttachment, XmATTACH_FORM,
				      XmNbottomAttachment, XmATTACH_FORM,
#ifndef HAVE_MOTIF_1_1
				      XmNchildType, XmFRAME_TITLE_CHILD,
#endif
				      XmNlabelString, xmstr,
				      NULL);
      
      XmStringFree(xmstr);

      if ( object->option_mask & DefaultMask ) { 
	    while( object->options[i] ) { 
		  if ( object->options[i]->type == DefaultMask ) {
			def = object->options[i]->value;
			break;
		  }
	    }

	    def_text = RtcExpandShellVariable(def, strlen(def));
      }      

      text = XtVaCreateManagedWidget("panel-entry-label",
				     xmTextFieldWidgetClass,
				     form,
				     XmNtopAttachment, XmATTACH_FORM,
#ifdef HAVE_MOTIF_1_1
				     XmNleftAttachment, XmATTACH_WIDGET,
				     XmNleftWidget, label,
#else
				     XmNleftAttachment, XmATTACH_FORM,
#endif
				     XmNrightAttachment, XmATTACH_FORM,
				     XmNbottomAttachment, XmATTACH_FORM,
				     NULL);

      if ( def_text ) 
	    XtVaSetValues(text, XmNvalue,def_text,NULL);
      
      object->widget = text;
      
      XtAddCallback(text,
		    XmNvalueChangedCallback,
		    (XtCallbackProc) rtcTextCallback ,
		    (XtPointer) object);
      
#ifdef WANT_HELP      
      if ( object->option_mask & ( HelpMask | HelpFileMask ) ) {
	    XtAddCallback(text, 
			  XmNhelpCallback, 
			  (XtCallbackProc) RtcDisplayContextHelp,
			  (XtPointer) object);
      }
#endif      

#ifdef HAVE_MOTIF_1_1
      XtManageChild(form);
#endif

      XtManageChild(frame);
      

}

#if NeedFunctionPrototypes
char *RtcTextConfig(RTCObject *object, ConfigMaskType what)
#else
char *RtcTextConfig(object,what)
RTCObject	*object;
ConfigMaskType	what;
#endif
{
      char 	*def,*def_text;
      int	i=0;

      switch ( what ) {

	 case GetResultValue:

	   if ( ! object->data ) 
	     object->data = XtNewString("");

	    return ( object->data );
	    break;
	    
	 case GetResultName:

	    return( object->command );
	    break;
	
	 case ResetToDefault:

	    if ( object->option_mask & DefaultMask ) {
		  while( object->options[i] ) { 
			if ( object->options[i]->type == DefaultMask ) {
			      def = object->options[i]->value;
			      def_text = RtcExpandShellVariable(def, strlen(def));

			      XtVaSetValues(object->widget,
					    XmNvalue, def_text,
					    NULL);
			      

			      XtFree( def_text );
			      return ( NULL );
			      
			      break;
			}
		  }
	    }      
	    else 
		  XtVaSetValues(object->widget,
				XmNvalue, "",
				NULL);
	    
	    return (NULL );
	    break;
    
	 default:
	    break;
      }
      

      return NULL;

}


#if NeedFunctionPrototypes
static void rtcTextCallback(Widget widget, RTCObject *object, XtPointer call)
#else
static void rtcTextCallback(widget,object,call)
Widget		widget;
RTCObject	*object;
XtPointer	call;
#endif
{

      char	*tmp;
      

      if ( object->data )
	    XtFree( object->data );
      
      XtVaGetValues(widget,
		    XmNvalue, &tmp,
		    NULL);
      

      object->data = XtNewString(tmp);
      

      
      RtcUpdatePanelStatus(object->parent);
      
}



#endif /* WANT_PANEL */
