/* worldmap - a world map display program
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * menubar.c - create functions and callbacks
 */

#include <stdio.h>
#include <assert.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/FileSB.h>
#include "Map.h"

#include "help.h"
#include "message.h"
#include "xtutil.h"

#define FILE_OPEN 0

static Widget open_dialog = NULL; /* make it static for reuse */
static void OpenCancel(Widget w, XtPointer client_data, XtPointer call_data);
static void OpenOK(Widget w, XtPointer client_data, XtPointer call_data);

void
File(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int item_no = (int) client_data;
  Widget map = (Widget) XtNameToWidget(TopLevel(widget), "*map");

  switch (item_no)
    {
    case FILE_OPEN:
      if (!open_dialog)
	{
	  open_dialog = \
	    XmCreateFileSelectionDialog(TopLevel(widget),
					"openDialog", NULL, 0);
	  assert(XmIsFileSelectionBox(open_dialog));
	  XtAddCallback(open_dialog, XmNcancelCallback,
			(XtCallbackProc) OpenCancel, (XtPointer) open_dialog);
	  XtAddCallback(open_dialog, XmNokCallback,
			(XtCallbackProc) OpenOK, (XtPointer) map);
	}

      XtManageChild(open_dialog);
      XtPopup(XtParent(open_dialog), XtGrabNone);
      break;

    default:
      exit(0);
      break;
    }
}

static void
OpenOK(Widget pushb, XtPointer client_data, XtPointer call_data)
{
  Widget map = (Widget) client_data;
  XmString xms;
  char *fname;
  char s[80];

  assert(XmIsFileSelectionBox(open_dialog));
  XtVaGetValues(open_dialog, XmNtextString, &xms, NULL);
  assert(XmStringGetLtoR(xms, XmSTRING_DEFAULT_CHARSET, &fname));
  XmStringFree(xms);

  sprintf(s, "Scheme interpreting...");
  SetMessageArea(s);	

  /* evaluate the scheme file.  Report errors in a dialog window */
  XmMapEvalGuileFile(map, fname);

  sprintf(s, "done");
  SetMessageArea(s);	
  XtPopdown(XtParent(open_dialog));
}

static void
OpenCancel(Widget pushb, XtPointer client_data, XtPointer call_data)
{
  Widget open_dialog = (Widget) client_data;

  XtPopdown(XtParent(open_dialog));
}
