/* worldmap - a world map display program
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * help.c - help dialog support
 */

#include <assert.h>

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/MessageB.h>
#include "xtutil.h"

#define MSG "This is where help text should go"

void
PopupHelp(Widget widget, XtPointer client_data, XtPointer call_data)
{
    static Widget dialog;
	XmString xms =  XmStringCreateSimple((String) client_data);

    if (!dialog)
	{
        Arg args[1];
        int n = 0;

        XtSetArg (args[n], XmNmessageString, xms); n++;
        dialog = \
			XmCreateInformationDialog(TopLevel(widget),
									  "help_dialog", args, n);
    }
	else
	{
		XtVaSetValues(dialog, XmNmessageString, xms, NULL);
	}

    XtManageChild (dialog);
    XtPopup (XtParent (dialog), XtGrabNone);
}

