/* worldmap - a world map display program
   Copyright (C) 1998 Andrew Skypeck
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

/* x toolkit */
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/Xmu/Converters.h>

/* widgets used in this file */
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/MainW.h>
#include <Xm/MessageB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>

#include "Map.h"

/* custom toolkit resources and options */
#include "resources.h"
#include "actions.h"

/* error and warning handling */
#include "error.h"

/* message area functions */
#include "message.h"

/* local rpc server initialization */
#include "rmapsvc.h"

/* optionally start the scheme interpreter.  The rest of the
   application is started within it */
#ifdef USE_GUILE

#include <guile/gh.h>

int main_func(int argc, char *argv[]);

int
main(int argc, char *argv[])
{
  /* yes, this is funky.  guile needs to take over the main function
     for the purposes of garbage collection */
  gh_enter(argc, argv, (void (*)(int, char *[])) main_func);
}

int
main_func(int argc, char *argv[])
#else
int
main(int argc, char *argv[])
#endif /* USE_GUILE */
{
  XtAppContext app_context;
  Widget top_level, main_window, menubar, scrolled_window, map, message_form;

  Widget CreateMenubar(Widget main_window);
  Widget CreateMessageArea(Widget main_window);
  static char map_trans[] = "#augment <Btn3Down>: ShowLocation()";

  /* Establish the RPC server daemon */
  RPCRegisterServer();

  top_level = \
    XtVaAppInitialize(&app_context, "gmap",
		      custom_options, XtNumber(custom_options),
		      &argc, argv,
		      fallback_resources,
		      NULL);
  assert(XtIsTopLevelShell(top_level));

  if (argc != 1)
    {
      fprintf(stderr, "usage: gmap [-toolkit option..]\n"
                      "            [-scrolledMap] [-logo xpm-file]\n");
      exit(1);
    }

  /* initialize the appication error and warning handlers in error.c */
  InitError(app_context);

  /* put custom command line args or their defaults into the
     instance record */
  XtGetApplicationResources(top_level, &instance_record,
			    custom_resources, XtNumber(custom_resources),
			    NULL, 0);

  /* identify the event action functions to the app */
  XtAppAddActions(app_context, actions, XtNumber(actions));

  /* main window contains a menubar, list widget, and message label */
  main_window = \
    XtVaCreateManagedWidget("mainWindow",
			    xmMainWindowWidgetClass,   top_level,
			    NULL);
  assert(XmIsMainWindow(main_window));

  menubar = CreateMenubar(main_window);
  assert(XmIsRowColumn(menubar));

  /* this widget is were info will be stuck */
  message_form = CreateMessageArea(main_window);
  assert(XmIsForm(message_form));

  /* create the work area (map).  It may be scrolled */
  if (instance_record.scrolled_map)
    {
      scrolled_window = \
	XtVaCreateManagedWidget("scrolledWindow",
				xmScrolledWindowWidgetClass, main_window,
				XmNscrollingPolicy,        XmAUTOMATIC,
				XmNscrollBarDisplayPolicy, XmAS_NEEDED,
				NULL);
      assert(XmIsScrolledWindow(scrolled_window));

      map = \
	XtVaCreateManagedWidget("map",
				xmMapWidgetClass, scrolled_window,
				XmNtranslations,
				XtParseTranslationTable(map_trans),
				NULL);
      assert(XmIsMap(map));

      XtVaSetValues(main_window,
		    XmNmenuBar,       menubar,
		    XmNmessageWindow, message_form,
		    XmNworkWindow,    scrolled_window,
		    NULL);
    }
  else
    {
      map = \
	XtVaCreateManagedWidget("map",
				xmMapWidgetClass, main_window,
				XmNuseShm,        instance_record.use_shm,
				XmNtranslations,
				XtParseTranslationTable(map_trans),
				NULL);
      assert(XmIsMap(map));

      XtVaSetValues(main_window,
		    XmNmenuBar,       menubar,
		    XmNmessageWindow, message_form,
		    XmNworkWindow,    map,
		    NULL);    
    }


  XtRealizeWidget(top_level);

  /* install the socket input handler */
  RPCAddSocketInput(app_context, map);

  XtAppMainLoop(app_context);
}

