/*
 * MapP.h
 */

#ifndef _MapP_h
#define _MapP_h

#include "Map.h"

#include <Xm/PrimitiveP.h>
#include <X11/extensions/XShm.h>

typedef float Matrix33[3][3];

/* New fields for the Map widget class record */
typedef struct {
  int make_compiler_happy;	/* can have an empty structure,
                                   even though it is */
} MapClassPart;

/* Full class record declaration */
typedef struct _MapClassRec {
  CoreClassPart	core_class;
  XmPrimitiveClassPart primitive_class;
  MapClassPart	map_class;
} MapClassRec;

extern MapClassRec mapClassRec;

/* New fields for the Map widget record */
typedef struct {
  /* resources */
  XmProjection projection;	/* which map projection to use */
  float center_lon;             /* central meridian of projection */

  float major_grid_size;        /* delta lat and lon for grid */
  float minor_grid_size;

  Boolean draw_coastline;	/* draw coastlines? */
  Boolean draw_lakes;		/* draw lakes? */
  Boolean draw_rivers;		/* draw rivers? */
  Boolean draw_boundaries;	/* draw political boundries? */
  Boolean draw_grid;		/* draw the grid? */

  Pixel ocean_color;		/* ocean color */
  Pixel land_color;		/* land color */
  Pixel coastline_color;	/* coastline color */
  Pixel lake_color;		/* lake color */
  Pixel river_color;		/* river color */
  Pixel boundary_color;         /* political boundary color */
  Pixel grid_color;		/* geographic grid color */
  Pixel zoom_box_color;         /* zoom box outline color */

  String map_dir;		/* directory containing all the map files */
  String coastlines_file;	/* file containing coastline polygon data */
  String lakes_file;		/* file containing lake polygon data */
  String rivers_file;		/* file containing river line data */
  String boundaries_file;       /* File with political border data */

  XmFontList font_list;		/* font XmMapDrawString uses */
  Boolean use_shm;		/* use shared memory for the map image? */

  XtCallbackList before_reset_callbacks;
  XtCallbackList after_reset_callbacks;

  /* private variables */
  Boolean refresh;		/* refresh the window */
  GC copy_gc;			/* copy drawing graphics context */
  GC xor_gc;			/* XOR drawing graphics context */
  GC ext_gc;                    /* for external drawing */
  float zoom_center_x;		/* X coordinate zoom center [-PI PI] */
  float zoom_center_y;		/* Y coordinate zoom center [-PI/2 PI/2] */
  float zoom_factor;		/* magnification zoom factor >= 1.0 */
  Pixmap map_pixmap;		/* current map pixmap */
  XFontStruct *font;		/* fontStruct from fontList */
  XImage *basemap_image;	/* an image of the base map */
  XSegment zoom_region;		/* zoom region in window coordinates */
#ifdef USE_SHM
  XShmSegmentInfo shm_info;	/* shared memory segment info */
#endif
} MapPart;

/*
 * Full instance record declaration
 */
typedef struct _MapRec {
  CorePart core;
  XmPrimitivePart primitive;
  MapPart map;
} MapRec;

#endif /* _MapP_h */
