'\" t
.TH X3270 1 "9 December 1999"
.SH NAME
x3270 \-
.SM IBM
host access tool
.SH SYNOPSIS
.B x3270      
.RI [ options ]       
.RI [[ prefix :]...[ LUname [, LUname ...]@] hostname [: port ]] 
.SH DESCRIPTION
.B x3270
opens a telnet connection to an
.SM IBM
host in an X window.
It implements RFCs 2355 (TN3270E), 1576 (TN3270) and 1646 (LU name selection).
The window created by
.B x3270
can use its own font for displaying characters, so it is a fairly accurate
representation of an
.SM IBM
3278 or 3279.
It is similar to
.IR tn3270 (1)
except that it is X-based, not curses-based.
.LP
Prepending a
.B p:
onto
.I hostname
causes the connection to go through the
.I telnet-passthru
service rather than directly to the host.
See PASSTHRU below.
.LP
Prepending an
.B s:
onto
.I hostname
removes the "extended data stream" option reported to the host.
See
.B \-tn
below for further information.
.LP
A specific LU name to use may be specified by prepending it to the
.I hostname
with an
.RB `` @ ''.
Multiple LU names to try can be separated by commas.
An empty LU can be placed in the list with an extra comma.
.LP
On systems that support the
.I forkpty
library call, the
.I hostname
may be replaced with
.B \-e
and a command string.
This will cause x3270 to connect to a local child process, such as a shell.
.LP
The port to connect to defaults to
.BR telnet .
This can be overridden with the
.RI \- port
option, or by appending a
.I port
to the
.I hostname
with a colon
.RB `` : ''.
(For compatability with previous versions of
.I x3270
and with
.IR tn3270 ,
the
.I port
may also be specified as a second, separate argument.)
.SH OPTIONS
.B x3270 
is a toolkit based program, so it understands standard options and resources.
It also understands the following options:
.TP
.B \-activeicon
Specifies that the icon should be a miniature version of the screen image.
See
.SM ICONS
below.
.TP
.B \-apl
Sets up
.SM APL
mode.
This is actually an abbreviation for several options.
See
.SM "APL SUPPORT"
below.
.TP
.BI \-cc " range" : "value" "[,...]
Sets character classes.
See CHARACTER CLASSES, below.
.TP
.BI \-charset " name"
Specifies an
.SM EBCDIC
national character set.
See
.SM CHARACTER SETS
below.
.TP
.BI \-clear " toggle"
Sets the initial value of
.I toggle
to
.B false.
The list of toggle names is under
.SM MENUS
below.
.TP
.BI \-efont " name"
Specifies a font for the emulator window.
See
.SM FONTS
below.
.TP
.BI \-iconname " name"
Specifies an alternate title for the program icon.
.TP
.BI \-iconx " x"
Specifies the initial x coordinate for the program icon.
.TP
.BI \-icony " y"
Specifies the initial y coordinate for the program icon.
.TP
.BI \-keymap " name"
Specifies a keymap name and optional modifiers.
See
.SM KEYMAPS
below.
.TP
.B \-keypad
Turns on the keypad as soon as
.B x3270
starts.
.TP
.BI \-model " name"
The model of 3270 display to be emulated.
The model name is in three parts, any of which may be omitted:
.IP
The first part is the
.BR "base model" ,
which is either
.B 3278
or
.BR 3279 .
.B 3278
specifies a monochrome 3270 display;
.B 3279
specifies a color 3270 display.
When 3278 emulation is specified for a color X display, fields are displayed
using pseudo-colors; see
.SM PSEUDO-COLOR
below.
.IP
The second part is the
.BR "model number" ,
which specifies the number of rows and columns.
Model 4 is the default.
.PP
.RS
.TS
center;
c c c .
Model Number	Columns	Rows
_
2	80	24
3	80	30
4	80	43
5	132	27
.TE
.RE
.IP
Note: Technically, there is no such 3270 display as a 3279-4 or 3279-5, but
most hosts seem to work with them anyway.
.IP
The third part specifies the Extended 3270 Data Stream, and is given as
.B \-E.
It signals the host that the 3270 display is capable of displaying
extended field attributes, and supports structured fields and query replies.
A 3279 always uses the Extended Data Stream (whether or not
.B \-E
is specified); for a 3278 it is optional.
.IP
The default model for a color X display is
.B 3279\-4\-E.
For a monochrome X display, it is
.BR 3278\-4\-E .
(The behavior of previous versions of
.B x3270
on color X displays can be specified as
.BR 3278\-4 ).
.TP
.B \-mono
Forces
.B x3270
to believe it is running on a monochrome X display.
.TP
.B \-once
Causes
.B x3270
to exit after a host disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
.BI \-oversize " cols" x rows
Makes the screen larger than the default for the chosen model number.
This option has effect only in combination with extended data stream support
(the
.B \-E
suffix on the model), and only if the host supports the Query Reply structured
field.
The number of columns multiplied by the number of rows must not exceed
16383 (3fff hex), the limit of 14-bit 3270 buffer addressing.
.TP
.BI \-port " n"
Specifies a different
.SM TCP
port to connect to.
.I n
can be a name from
.B /etc/services
like
.BR telnet ,
or a number.
This option changes the default port number used for all connections.
(The positional parameter affects only the initial connection.)
.TP
.B \-reconnect
Causes
.B x3270
to automatically reconnect to the host if it ever disconnects.
This option has effect only if a hostname is specified on the command line.
.TP
.B \-sb
Turns on the scrollbar.
.B +sb turns the scrollbar off.
.TP
.BI \-scheme " name"
Specifes a color scheme to use in 3279 mode.
This option has effect only in combination with 3279 emulation.
See
.SM "COLOR SCHEMES"
below.
.TP
.B \-script
Causes
.B x3270
to read commands from standard input, with the results written to standard
output.
The protocol for these commands is documented in
.IR x3270-script (1).
.TP
.BI \-sl " n"
Specifies that
.I n
lines should be saved for scrolling back.
The default is 64.
.TP
.BI \-set " toggle"
Sets the initial value of
.I toggle
to
.B true.
The list of toggle names is under
.SM MENUS
below.
.TP
.BI \-tn " name"
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
.BI IBM\- model_name,
for example,
.B IBM\-3279\-4\-E
for a color X display, or
.B IBM\-3278\-4\-E
for a monochrome X display.
.IP
Some hosts are confused by the
.B \-E
suffix on the terminal name, and will ignore the extra screen area on
models 3, 4 and 5.
Prepending an
.B :s
on the hostname removes the
.B \-E
from the terminal name when connecting to such hosts.
.IP
The name can also be specified with the "x3270.termName" resource.
.TP
.B \-trace
Turns on data stream tracing at startup.
Unlike turning it on from a menu option, there is no pop-up to confirm the
file name, which defaults to
.BI /tmp/x3trc. process_id.
.SH FONTS
By default,
.B x3270
does not use the "*font" resource for its main window.
Instead, it uses a custom 14-point font called
.BR 3270 ,
which is a close
approximation of a real 3270 display and allows
.B x3270
to display a complete
.SM EBCDIC
character set and special status-line symbols.
A more compact font,
.BR 3270\-12 ,
is also supported, as are the various sized fonts
.BR 3270gt8 ,
.BR 3270gt12 ,
.BR 3270gt16 ,
.BR 3270-20 ,
.BR 3270gt24 ,
and
.BR 3270gt32 .
The font
.B 3270h
is also included to allow display of Hebrew text.
.LP
The font may be specified with the
.B \-efont
option or the "x3270.emulatorFont" resource.
.LP
.B x3270
can also use any constant-spaced X font, but unless the font implements the
entire
.SM ISO
8859\-1 (Latin-\1) character set,
.B x3270
may not properly display several
.SM EBCDIC
graphics that do not have
.SM ASCII
equivalents.
.PP
One additional font,
.BR 3270d ,
is supplied.
This font is identical to the default
.B 3270
font, except that it has bitmaps defined for field attribute characters.
This means that field attributes, which are normally displayed as blanks,
are now visible on the screen.
The characters displayed are hexadecimal codes, which can be translated
using a document provided with the
.B x3270
sources.
.LP
The font can be changed at any time through a menu option.
It can also be implicitly changed by changing the size of the
.B x3270
window with the mouse: if the window is made larger, x3270 will try to
change to a larger font, and vice-versa.
.SH "CHARACTER SETS"
The
.B \-charset
option or the "x3270.charset" resource controls the
.SM EBCDIC
national character set used by
.B x3270.
Available sets include:
.PP
.TS
center;
l c
lfB c.
Charset Name	Q121 Code
_
bracket	\-
us-intl	01
german	03
finnish	09
uk	22
norwegian	23
french	30
hebrew*	\-
icelandic	\-
belgian	\-
.TE
.IP
(*) requires a special font,
.B 3270h
.PP
The default character set is
.BR bracket ,
which is useful for common
.SM IBM
hosts which use
.SM EBCDIC
codes 0xAD and 0xBD for the `[' and `]' characters, respectively.
.PP
You can also specify national-language translations for your keyboard; see
.SM KEYMAPS
below.
.SH "CHARACTER CLASSES"
.B x3270
supports character classes (groupings of characters chosen with a double
mouse click) in the same manner as
.IR xterm (1).
The "x3270.charClass" resource or the
.B \-cc
option can be used to alter the character class table.
The default table is the same as
.IR xterm "'s;"
It groups letters together, and puts most punctuation characters in individual
classes.
To put all non-whitespace characters together in the same class (and
duplicate the behavior of some early versions of
.BR x3270 ),
use the following value:
.PP
.nf
    33-127:48,161-255:48
.fi
.PP
See
.IR xterm (1)
for further syntax details.
.SH KEYPAD
A keypad may optionally be displayed, with a mouse-clickable button for each
3270 function key (these functions are also available from the keyboard).
The keypad can be turned on and off by clicking on the "keypad" button in the
upper-right-hand corner of the window.
The "x3270.keypad" resource controls where it is displayed.
Options are:
.PP
.TS
center;
l l.
left	in a separate window, to the left of the screen
right	in a separate window, to the right of the screen
bottom	in a separate window, below the screen
integral	in the same window as the screen, below it
.TE
.PP
The default is
.B right.
.PP
If the "x3270.keypadOn" resource is set to
.BR true ,
the keypad will be displayed at startup.
.SH "HOSTS DATABASE"
.B x3270
uses the
.I ibm_hosts
database to construct a pull-down menu of hosts to connect to.
It supports the
.B loginstring
function, which allows you to specify a macro to be sent to the host when the
connection is first made.
See
.IR ibm_hosts (5)
for details.
.LP
You may specify a different
.I ibm_hosts
database with the "x3270.hostsFile" resource.
.SH "COLOR SCHEMES"
When emulating a 3279 display, the X colors used to draw the display
are selected by two resources: the "x3270.colorScheme" resource, which gives
the name of the color scheme to use, and the
individual "x3270.colorScheme.\fIxxx\fP" resources, which
give the actual definitions.
The color scheme resources are documented in the
.B Docs/Resources
file with the
.B x3270
source.
.LP
The color scheme may also be changed while
.B x3270
is running with a selection from the
.B Options
menu.
.SH PSEUDO-COLOR
When emulating a 3278 display on a color X display,
.B x3270 
does not understand
.SM IBM
3270 color protocols.
Instead, it draws text in one of three colors depending on the field attributes.
Those colors may be customized using the following resources (shown with their
default values):
.nf
	x3270.normalColor:	green
	x3270.boldColor:	cyan
	x3270.inputColor:	orange
	x3270.colorBackground:	black
	x3270.selectBackground:	dim gray
.fi
.SH "ANSI MODE"
Some hosts use an
.SM ASCII
front-end to do initial login negotiation, then later switch to 3270 mode.
.B x3270
will emulate an
.SM ANSI
X.64 terminal until the host places it in 3270 mode (telnet
.SM BINARY
and
.SM "SEND EOR"
modes).
The emulation is fairly complete; however, it is not intended to make
.B x3270
a replacement for
.IR xterm (1).
.PP
If the host later negotiates to stop functioning in 3270 mode,
.B x3270
will return to
.SM ANSI
emulation.
.PP
When emulating an
.SM ANSI
terminal,
.B x3270
supports both character-at-a-time mode and line mode operation.
You may select the mode with a menu option.
When in line mode, the special characters and operational characteristics are
defined by resources:
.PP
.TS
center;
l c c.
Mode/Character	Resource	Default
_
Translate CR to NL	x3270.icrnl	true
Translate NL to CR	x3270.inlcr	false
Erase previous character	x3270.erase	^?
Erase entire line	x3270.kill	^U
Erase previous word	x3270.werase	^W
Redisplay line	x3270.rprnt	^R
Ignore special meaning of next character	x3270.lnext	^V
Interrupt	x3270.intr	^C
Quit	x3270.quit	^\\\\ 
End of file	x3270.eof	^D
.TE
.SH MENUS
.B x3270
has a menu bar with three pull-down menus (File, Options, and
Connect) and a button to turn the keypad on and off.
The pull-down menus are also available as pop-up menus by using the "Ctrl"
key and the left, middle and right mouse buttons, respectively.
.PP
The menu bar can be turned off by setting the "x3270.menuBar" resource to
.B false.
.PP
Many sections of the File and Options menus are toggles,
options that may be either on or off.
The entries under the File menu are as follows:
.TP
.B File Transfer
Initiates transferring a file between the IBM host and the local workstation,
using the
.B IND$FILE
protocol.
A pop-up menu allows specifying the file names and other attributes of the
transfer.
.br
The IND$FILE program must be installed on the IBM host, and the 3270 cursor
must be located in a field that will accept a TSO or VM/CMS command.
.TP
.B Trace Data Stream
If set, network traffic (both a hexadecimal representation and its
interpretation) are logged to the file
.BI /tmp/x3trc. process_id,
and a window is popped up to monitor the data.
The file name is confirmed with a pop-up; the default directory name for the
trace file can be changed with the "x3270.traceDir" resource.
.TP
.B Trace X Events
If set, information about X events and the actions that
.B x3270
takes in response are logged to a file.
This is the same file as used for tracing the data stream, above.
X event tracing is useful for creating and debugging custom keymaps, macros
and scripts.
For example, it will tell you precisely what action was taken in response to
pressing a particular key.
If the key is not mapped, it will tell you the keysym name and keycode so you
can add it to a custom keymap.
.TP
.B Save Screen(s) in File
If set, saves an
.SM ASCII
representation of the current screen image in the file
.BI /tmp/x3scr. process_id.
A pop-up allows the file name to be changed; the default directory name can be
changed with the "x3270.traceDir" resource.
The pop-up also has buttons to choose between saving just the current image,
or continuously saving it as it is redrawn.
.TP
.B Save Changed Options in File
Saves into a file the values of all options that have been changed since
.B x3270
was started.
A pop-up allows the file name to be changed; the default file is
.B .x3270pro
in the user's home directory.
If the file already exists, it is appended to.
.B x3270
will read the contents of this file the next time it starts up.
The options settings in the file override any resources defined
with
.B xrdb
or in the user's
.B .Xdefaults
file; command-line switches override the file.
A different options file can be specified by the
.B X3270PRO
environment variable.
If the environment variable
.B NOX3270PRO
is set, no options file will be read.
.TP
.B Execute an Action
Allows an action name and parameters to be entered from the keyboard.
This allows experimentation with actions without having to edit keymaps
and repeatedly restart
.B x3270.
.LP
The toggles under the Options menu are as follows:
.TP
.B Monocase
If set,
.B x3270
operates in uppercase-only mode.
.TP
.B Blinking Cursor
If set, the cursor blinks once per second.
.TP
.B Blank Fill
If set,
.B x3270
behaves in some un-3270-like ways.
First, when a character is typed into a field, all nulls in the field to the
left of that character are changed to blanks.
This eliminates a common 3270 data-entry surprise.
Second, in insert mode, trailing blanks in a field are treated like nulls,
eliminating the annoying ``lock-up'' that often occurs when inserting into an
field with (apparent) space at the end.
.TP
.B Show Timing
If set, the time taken by the host to process an
.SM AID
is displayed on the status line.
.TP
.B Track Cursor
If set, the cursor position is displayed on the status line.
.TP
.B Scrollbar
If set, the scrollbar appears.
.TP
.B Wraparound
If set, the
.SM ANSI
terminal emulator automatically assumes a
.SM NEWLINE
character when it reaches the end of a line.
.TP
.B "Paste with Left Margin"
If set, puts restrictions on how pasted text is placed on the screen.
The position of the cursor at the time the paste operation is begun is
used as a left margin.
No pasted text will fill any area of the screen to the left of that
position.
This option is useful for pasting into certain
.SM IBM
editors that use the left side of the screen for control information.
.TP
.B "Select by Rectangles"
If set,
.B x3270
will always select rectangular areas of the screen.
Otherwise,
.B x3270
selects by rectangles when in 3270 mode, but in
.SM ANSI
mode it selects continuous regions of the screen like
.IR xterm (1).
.PP
The names of the toggles for use with the
.B -set
and
.B -clear
options are as follows:
.LP
.TS
center;
l l .
Menu Option	Name
_
Monocase	monoCase
Blinking Cursor	cursorBlink
Blank Fill	blankFill
Show Timing	showTiming
Track Cursor	cursorPos
Trace Data Stream	dsTrace
Trace X Events	eventTrace
Save Screen(s) in File	screenTrace
Scrollbar	scrollBar
Wraparound	lineWrap
Paste with Left Margin	marginedPaste
Select by Rectangles	rectangleSelect
.TE
.LP
In addition, the toggle
.B altCursor
can be used to select the cursor type.
If set, an underline cursor will be used.
If clear, the normal block cursor will be used.
.LP
These names also represent resources that can be set in your .Xdefaults
file.
For example, if you always want to have the scrollbar on, you can add
the following to your .Xdefaults:
.br
    x3270.scrollBar:	true
.br
.SH "STATUS LINE"
The
.B x3270
status line contains a variety of information.
From left to right, the fields are:
.TP
.B "comm status"
Three symbols indicate the state of the connection to the host.
If connected, the right-hand symbol is a solid box; if not, it is a
question mark.
.TP
.B "keyboard lock"
If the keyboard is locked, an "X" symbol and a message field indicate the
reason for the keyboard lock.
.TP
.B "shift"
Three characters indicate the keyboard modifier status.
"M" indicates the Meta key, "A" the Alt key, and an up-arrow or "^"
indicates the Shift key.
.TP
.B "compose"
The letter "C" indicates that a composite character is in progress.
If another symbol follows the "C", it is the first character of the
composite.
.TP
.B "typeahead"
The letter "T" indicates that one or more keystrokes are in the typeahead
buffer.
.TP
.B "temporary keymap"
The letter "K" indicates that a temporary keymap is in effect.
.TP
.B "reverse"
The letter "R" indicates that the keyboard is in reverse field entry mode.
.TP
.B "insert mode"
A thick caret "^" or the letter "I" indicates that the keyboard is in insert
mode.
.TP
.B "timing"
A clock symbol and a time in seconds indicate the time it took to process
the last
.SM AID
or the time to connect to a host.
This display is optional.
.TP
.B "cursor position"
The cursor row and column are optionally displayed, separated by a "/".
.SH ICONS
If the
.B \-activeicon
option is given (or the "x3270.activeIcon" resource is set to
.BR true ),
.B x3270
will attempt to make its icon a miniature version of the current screen image.
This function is highly dependent on your window manager:
.TP
.B mwm
The size of the icon is limited by the "Mwm.iconImageMaximum" resource, which
defaults to
.B 50x50.
The image will be clipped at the bottom and right.
The icon cannot accept keyboard input.
.TP
.B olwm
The full screen image of all 3270 models can be displayed on the icon.
However, the icon cannot be resized, so if the model is later changed with an
.B x3270
menu option, the icon image will be corrupted.
The icon cannot accept keyboard input.
.TP
.BR twm " and " tvtwm
The full screen image of all 3270 models can be displayed on the icon, and the
icon can be resized.
The icon can accept keyboard input.
.IP
However,
.B twm
does not put labels on application-supplied icon windows.
You can have
.B x3270
add its own label to the icon by setting the "x3270.labelIcon" resource to
.B true.
The default font for icon labels is
.BR 8x13 ;
you may change it with the "x3270.iconLabelFont" resource.
.SH KEYMAPS
.PP
The type of keyboard may be specified with the
.B \-keymap
switch or using either the 
.SM KEYMAP
or
.SM KEYBD
environment variables.
The types of supported keyboards include
.BR sun_k3 ,
.BR sun_k4 ,
.BR sun_k5 ,
.BR hp\-k1 ,
.B hp\-pc
and
.BR ncd .
.PP
The keymap may also be specified as a comma-separated list of names.
Later definitions override earlier ones.
This is used to specify both a primary keyboard type and a set of modifiers.
The modifiers defined include:
.TP
.B ow
(OpenWindows) Swaps the middle and right mouse button definitions, so the
middle button performs the "Extend" function and the right-hand button
performs the "Paste" function.
Also changes the cut and paste actions to use the OpenWindows
.SM CLIPBOARD.
.TP
.B alt
Replaces the default "Meta" key definitions with "Alt" definitions,
for keyboards which do not have a "Meta" key.
.TP
.B apl
Allows entry of
.SM APL
characters (see
.SM "APL SUPPORT"
below).
.TP
.B finnish7
Replaces the bracket, brace and bar keys with common Finnish characters.
.TP
.B norwegian7
Replaces the bracket, brace and bar keys with common Norwegian characters.
.PP
A temporary keymap can also be specified while
.B x3270
is running with the Keymap() action.
When the action Keymap(\fIn\fP) is executed, temporary keymap
.I n
is added to or deleted from the current keymap.
Multiple temporary keymaps can be active simultaneously.
The action Keymap(None) restores the original keymap.
.B Note:
When Keymap() is specified as part of a list of multiple actions in a keymap,
it must be the last action in the list.
.PP
The temporary keymap
.B hebrew
is provided to allow entry of Hebrew characters.
.PP
The X Toolkit translation mechanism is used to provide keyboard emulation.
It maps 
.B events
into 
.B actions.
The best documentation can be found with X toolkit documents, but the
following should suffice for simple customization.
.PP
An Xt event consists of (at least) four fields.  The first is called a
.B modifier.
It may be any combination of meta, shift and ctrl.  If it is prefaced by !,
it means those modifiers only.  The second field is the specific event,
in 
.B x3270
usually just <Key>.  The third field is the detail field, which gives the
actual key.  The name of the key may be determined using the
.I xev
program or with the "Trace X Events" menu option.
The last field is the action, which is the internal emulator function.
A complete list of actions may be found later in the manual.
.PP
There are three levels of translation tables in
.B x3270.
The first is a default, compiled in table. It defines alphabetic, numeric,
function keys, and such basic functions as Enter and Delete.  It allows a
minimal useful functionality.
.PP
The second level is a keyboard specific table, which is found in the
application default file, which defines actions for such things as keypad
keys, and keys unique to certain keyboards.
.PP
The third level is a user customizable table which may be used to augment or
override key definitions.  This will typically be found in the users 
.B .Xdefaults
file.
The naming for a sun4 keyboard would be:
.RS
x3270.keymap.default:
.br
x3270.keymap.sun_k4:
.br
x3270.keymap.sun_k4.user:
.RE
.PP
The basic default translation table is:
.RS
.TS
l l .
<Key>Multi_key	Compose()
Shift<Key>Return	Newline()
<Key>Return	Enter()
<Key>Linefeed	Newline()
Shift<Key>Tab	BackTab()
<Key>Tab	Tab()
<Key>Home	Home()
Meta<Key>Left	PreviousWord()
<Key>Left	Left()
Meta<Key>Right	NextWord()
<Key>Right	Right()
<Key>Up	Up()
<Key>Down	Down()
<Key>Insert	Insert()
<Key>Delete	Delete()
<Key>BackSpace	BackSpace()
Ctrl<Btn1Down>	HandleMenu(quitMenu)
Ctrl<Btn2Down>	HandleMenu(optionsMenu)
Ctrl<Btn3Down>	HandleMenu(hostMenu)
Shift<Btn1Down>	MoveCursor()
<Btn1Down>	select\-start()
<Btn1Motion>	select\-extend()
<Btn2Down>	ignore()
<Btn2Motion>	ignore()
<Btn2Up>	insert\-selection(PRIMARY)
<Btn3Down>	start\-extend()
<Btn3Motion>	select\-extend()
<BtnUp>	select\-end(PRIMARY)
Meta<Key>F1	PF(13)
Meta<Key>F2	PF(14)
Meta<Key>F3	PF(15)
Meta<Key>F4	PF(16)
Meta<Key>F5	PF(17)
Meta<Key>F6	PF(18)
Meta<Key>F7	PF(19)
Meta<Key>F8	PF(20)
Meta<Key>F9	PF(21)
Meta<Key>F10	PF(22)
Meta<Key>F11	PF(23)
Meta<Key>F12	PF(24)
<Key>F1	PF(1)
<Key>F2	PF(2)
<Key>F3	PF(3)
<Key>F4	PF(4)
<Key>F5	PF(5)
<Key>F6	PF(6)
<Key>F7	PF(7)
<Key>F8	PF(8)
<Key>F9	PF(9)
<Key>F10	PF(10)
<Key>F11	PF(11)
<Key>F12	PF(12)
Meta<Key>1	PA(1)
Meta<Key>2	PA(2)
Meta<Key>3	PA(3)
Meta<Key>a	Attn()
Meta<Key>b	PrintWindow()
Meta<Key>c	Clear()
Meta<Key>d	Delete()
Meta<Key>h	Home()
Meta<Key>i	Insert()
Meta<Key>l	Redraw()
Meta<Key>p	PrintText()
Meta<Key>q	Quit()
Meta<Key>r	Reset()
Ctrl<Key>u	DeleteField()
Ctrl<Key>w	DeleteWord()
:<Key>asciicircum	CircumNot()
:<Key>	Default()
.TE
.RE
.PP
Meta is the diamond shaped key on a sun_k4, "Alt" on an
.SM NCD,
"Extend Char" on an
.SM HP.
The following
.I xmodmap
command must be used on the
.SM NCD
to allow use the the "Alt"
key:
.PP
.RS
xmodmap \-e "keysym Alt_L = Meta_L"
.RE
.PP
The left mouse button may be used to make a selection.
Clicking once unselects the current selection.
Clicking twice selects the word under the mouse cursor.
Clicking three times selects the line under the mouse cursor.
Clicking and dragging selects a rectangular area of the display.
.PP
The middle mouse button may be used to paste a selection.
.PP
The right mouse button may also be used for selections, selecting the
rectangular area between the current position and where the left button was
last pressed.
.PP
.PP
On color X displays, the "x3270.selectBackground" resource is used to
distinguish the selected text from the rest of the screen.
On monochrome X displays, selected text is in reverse video.
(It can be distinguished from a block cursor because the block cursor covers
slightly less than an entire character position on the screen.)
.PP
The left mouse button, when pressed with the "Shift" key held down, moves the
3270 cursor to the where the mouse cursor is pointing.
.PP
This is the complete list of keymap-callable actions.
Other actions are defined for use by scripts and are documented in
.IR x3270-script (1);
still others actions are defined for internal use by
.B x3270
and are not documented here.
.PP
.RS
.TS
l l
.
Attn	attention key
AltCursor	switch between block and underscore cursor
BackSpace	move cursor left (or send ASCII BS)
BackTab	tab to start of previous input field
CircumNot	input "^" in ANSI mode, or "notsign" in 3270 mode
Clear	clear screen
Compose	next two keys form a special symbol
CursorSelect	Cursor Select AID
Cut	erase selected text
Default	enter key literally
Delete	delete character under cursor (or send ASCII DEL)
DeleteField	delete the entire field
DeleteWord	delete the current or previous word
Down	move cursor down
Dup	duplicate field
Enter	Enter AID (or send ASCII CR)
Erase	erase previous character (or send ASCII BS)
EraseEOF	erase to end of current field
EraseInput	erase all input fields
Execute(\fIcmd\fP)	execute a command in a shell
FieldEnd	move cursor to end of field
FieldExit	clear to end of field and skip to next (5250 emulation)
FieldMark	mark field
HandleMenu(\fIname\fP)	pop up a menu
HexString(\fIhex_digits\fP)	insert control-character string
Home	move cursor to first input field
Insert	set insert mode
Interrupt	send TELNET IP to host
Key(\fIkeysym\fP)	insert key \fIkeysym\fP
Keymap(\fIkeymap\fP)	toggle alternate \fIkeymap\fP (or remove with \fBNone\fP)
Left	move cursor left
Left2	move cursor left 2 positions
Macro(\fImacrofP)	run a macro
MoveCursor	move cursor to mouse position
MonoCase	toggle uppercase-only mode
Newline	move cursor to first field on next line (or send ASCII LF)
NextWord	move cursor to next word
PA(\fIn\fP)	Program Attention AID (\fIn\fP from 1 to 3)
PF(\fIn\fP)	Program Function AID (\fIn\fP from 1 to 24)
PreviousWord	move cursor to previous word
PrintText(\fIcommand\fP)	print screen text on printer
PrintWindow(\fIcommand\fP)	print screen image (bitmap) on printer
Quit	exit \fBx3270\fP
Reconnect	reconnect to previous host
Redraw	redraw window
Reset	reset locked keyboard
Right	move cursor right
Right2	move cursor right 2 positions
SetFont(\fIfont\fP)	change emulator font
Script(\fIcommand\fP[,\fIarg\fP...])	run a script
String(\fIstring\fP)	insert string (simple macro facility)
SysReq	System Request AID
Tab	move cursor to next input field
ToggleInsert	toggle insert mode
Up	move cursor up
_
(the following are similar to xterm)
_
ignore	do nothing
insert\-selection([\fIatom\fP[\fI,atom...\fP]])	paste selection
move\-select	a combination of \fBMoveCursor\fP and \fBselect\-start\fP
select\-end(\fIatom\fP[\fI,atom...\fP]])	complete selection and assign to atom(s)
select\-extend	move the end of a selection
select\-start	mark the beginning of a selection
set\-select(\fIatom\fP[\fI,atom...\fP]])	assign exsting selection to atom(s)
start\-extend	begin marking the end of a selection
.TE
.RE
.SH "MACROS AND SCRIPTS"
There are several types of macros and script functions available.
.TP
.B The String() Action
The simplest method for macros is provided via the String action, which can
be bound to any key in a keymap.
The arguments to String() are one or more double-quoted strings which are
inserted directly as if typed.
The C backslash conventions are honored as follows.
(Entries marked * mean that after sending the
.SM AID
code to the host,
.B x3270
will wait for the host to unlock the keyboard before further processing the
string.)
.RS 1i
.TS
l l.
\eb	Left
\ef	Clear*
\en	Enter*
\e\epa\fIn\fP	PA key \fIn\fP*
\e\epf\fInn\fP	PF key \fInn\fP*
\er	Newline
\et	Tab
.TE
.RE
.IP
An example action would be:
.RS 1i
Meta<Key>p: String("probs clearrdr\en")
.RE
.IP
.B Note:
The strings are in
.SM ASCII
and converted to
.SM EBCDIC,
so beware of inserting
control codes.
Also, a backslash before a
.B p
must be doubled so it will not be removed when resource files are read.
.IP
There is also an alternate form of the String action, HexString, which is
used to enter non-printing data.
The argument to HexString is a string of hexadecimal digits, two per
character.  A leading 0x or 0X is optional.
In 3270 mode, the hexadecimal data represent EBCDIC characters, which are
entered into the current field.
In ANSI mode, the hexadecimal data represent ASCII characters, which are sent
directly to the host.
.TP
The Script() Action
This facility causes
.B x3270
to start a child process which can execute
.B x3270
actions.
The child process' standard input and output are piped back to
.BR x3270 .
The
.B Script()
action is fully documented in
.IR x3270-script (1).
.TP
.B The macros Resource
An alternate method of defining macros is the "x3270.macros" resource.
This resource is similar to a keymap, but instead of defining keyboard
mappings, it associates a list of X actions with a name.
These names are displayed on a Macros menu that appears when
.B x3270
is connected to a host.
Selecting one of the names on the menu executes the X actions associated with
it.
Typically the actions are String() calls, but any action may be specified.
Here is a sample macros resource definition, which would result in a four-entry
Macros menu:
.RS 1i
x3270.macros: \\
.br
	log off: String("logout\\n")\\n\\
.br
	vtam: String("dial vtam\\n")\\n\\
.br
	pa1: PA(1)\\n\\
.br
	alt printer: PrintText("lpr -Plw2")
.RE
.IP
You can also define a different set of macros for each host.
If there is a resource named
.RI ``x3270.macros. somehost '',
it defines the macros menu for when
.B x3270
is connected to
.I somehost.
.TP
.B The \-script Switch
This facility allows
.B x3270
to operate under the complete control of a script.
.B x3270
accepts actions from standard input, and prints results on standard output.
The \-script switch is fully documented in
.IR x3270-script (1).
.B
.SH "COMPOSITE CHARACTERS"
If your keyboard has a "Compose" key,
.B x3270
allows the direct entry of accented letters and special symbols.
Pressing and releasing the "Compose" key, followed by two other keys, causes
entry of the symbol combining those two keys.
For example, "Compose" followed by the "C" key and the "," (comma) key, enters
the "C-cedilla" symbol.
A `C' on the status line indicates a pending composite character.
.PP
The mappings between these pairs of ordinary keys and the symbols they
represent is controlled by the "x3270.composeMap" resource; it gives the
name of the map to use.
The maps themselves are named "x3270.composeMap.\fIname\fR".
The default is "latin1", which gives mappings for most of the symbols in the
.SM ISO
8859\-1 Latin\-1 character set that are not in the 7-bit
.SM ASCII
character set.
.PP
.B Note:
The default keymap defines the "Multi_key" keysym as the "Compose" key.
If your keyboard lacks such a key, you may set up your own "Compose" key with
a keymap that maps some other keysym onto the "Compose" action.
.SH "APL SUPPORT"
.B x3270
supports the full
.SM APL2
character set and the entry of
.SM APL
characters from the keyboard.
.PP
.SM APL
characters are supported only in the special
.B 3270 font.
.PP
Keyboard entry of
.SM APL
characters is supported through the
.B apl
keymap modifier.
This modifier defines the "Alt" key as an
.SM APL
shift key, with a typical
.SM APL
keyboard layout,
.IR e . g .,
"Alt" pressed with the
.B A
key results in the \s-1APL\s+1 `alpha' symbol.
Overstruck characters such as `quad-quote' are not defined as single
keystrokes; instead they are entered as composites (see
.SM "COMPOSITE CHARACTERS"
above).
A special composite map,
.BR apl ,
is provided for this purpose.
.PP
.B Note:
Some keyboards do not define the "Alt" key as a modifier, so keymaps that use
the "Alt" key will not function.
On a Sun for example, this can be remedied with the command:
.IP
xmodmap \-e "add mod2 = Alt_L"
.PP
For convenience, an
.B \-apl
option is defined, which is an abbreviation for the following resource
definitions:
.RS
.RI x3270.keymap: " your_keymap_name" ,apl
.br
x3270.charset: apl
.br
x3270.composeMap: apl
.RE
.PP
There are a number of
.SM APL
characters that are similar in appearance to non-\s-1APL\s+1 characters.
In particular, the \s-1APL\s+1 `stile', `slope,' `tilde' and `quotedot'
characters are similar to the \s-1EBCDIC\s+1 `bar', `backslash,' `tilde'
and `exclaim' characters.
The
.SM APL
characters are entered with the "Alt" key, and have slightly different
appearances.
.PP
The complete list of special
.SM APL
keysyms is as follows.  Entries marked with an asterisk (*) represent
simple aliases for standard \s-1EBCDIC\s+1 characters.
.PP
.RS
.TS
l c l l l.
\s-1APL\s+1 Symbol	Hex	x3270 Keysym	x3270 Key	x3270 Composed Keys
_
A underbar	41	apl_Aunderbar	Alt-A	A + underbar
alpha	B0	apl_alpha	Alt-a
B underbar	42	apl_Bunderbar	Alt-B	B + underbar
bar	60*	apl_bar	-
C underbar	43	apl_Cunderbar	Alt-C	C + underbar
circle	9D	apl_circle	Alt-o
circle bar	ED	apl_circlebar		circle + bar
circle slope	CF	apl_circleslope		circle + slope
circle star	FD	apl_circlestar		circle + star
circle stile	CD	apl_circlestile		circle + stile
colon	7A*	apl_colon	:
comma	6B*	apl_comma	,
D underbar	44	apl_Dunderbar	Alt-D	D + underbar
del	BA	apl_del	Alt-g
del stile	DC	apl_delstile		del + stile
del tilde	FB	apl_deltilde		del + tilde
delta	BB	apl_delta	Alt-h
delta stile	DD	apl_deltastile		delta + stile
delta underbar	FC	apl_deltaunderbar		delta + underbar
diamond	70	apl_diamond		up caret + down caret
dieresis	72	apl_dieresis	Alt-1
dieresis dot	EC	apl_dieresisdot		dieresis + dot
divide	B8	apl_divide	Alt-+
dot	4B*	apl_dot	.
down arrow	8B	apl_downarrow	Alt-u
down caret	78	apl_downcaret	Alt-9
down caret tilde	CB	apl_downcarettilde		down caret + tilde
down shoe	AB	apl_downshoe	Alt-v
down stile	8E	apl_downstile	Alt-d
down tack	AC	apl_downtack	Alt-b
down tack jot	FE	apl_downtackjot		down tack + jot
down tack up tack	DA	apl_downtackuptack		down tack + up tack
E underbar	45	apl_Eunderbar	Alt-E	E + underbar
epsilon	B1	apl_epsilon	Alt-e
epsilon underbar	75	apl_epsilonunderbar		epsilon + underbar
equal	7E*	apl_equal	'='
equal underbar	E1	apl_equalunderbar		equal + underbar
F underbar	46	apl_Funderbar	Alt-F	F + underbar
G underbar	47	apl_Gunderbar	Alt-G	G + underbar
greater	6E*	apl_greater	>
H underbar	48	apl_Hunderbar	Alt-H	H + underbar
I underbar	49	apl_Iunderbar	Alt-I	I + underbar
iota	B2	apl_iota	Alt-i
iota underbar	74	apl_iotaunderbar		iota + underbar
J underbar	51	apl_Junderbar	Alt-J	J + underbar
jot	AF	apl_jot	alt-j
K underbar	52	apl_Kunderbar	Alt-K	K + underbar
L underbar	53	apl_Lunderbar	Alt-L	L + underbar
left arrow	9F	apl_leftarrow	Alt-[
left bracket	AD	apl_leftbracket	[
left paren	4D*	apl_leftparen	(
left shoe	9B	apl_leftshoe	Alt-z
less	4C*	apl_less	<
M underbar	54	apl_Munderbar	Alt-M	M + underbar
N underbar	55	apl_Nunderbar	Alt-N	N + underbar
not equal	BE	apl_notequal	Alt-8	equal + slash
not greater	8C	apl_notgreater	Alt-4	less + equal
not less	AE	apl_notless	Alt-6	greater + equal
O underbar	56	apl_Ounderbar	Alt-O	O + underbar
omega	B4	apl_omega	Alt-w
overbar	A0	apl_overbar	Alt-2
P underbar	57	apl_Punderbar	Alt-P	P + underbar
plus	4E*	apl_plus	+
Q underbar	58	apl_Qunderbar	Alt-Q	Q + underbar
quad	90	apl_quad	Alt-l
quad divide	EE	apl_quaddivide		quad + divide
quad jot	73	apl_quadjot		quad + jot
quad quote	DE	apl_quadquote		quad + quote
quad slope	CE	apl_quadslope		quad + slope
query	6F*	apl_query	?
quote	7D*	apl_quote	'
quote dot	DB	apl_quotedot		quote + dot
R underbar	59	apl_Runderbar	Alt-R	R + underbar
rho	B3	apl_rho	Alt-r
right arrow	8F	apl_rightarrow	Alt-]
right bracket	BD	apl_rightbracket	]
right paren	5D*	apl_rightparen	)
right shoe	9A	apl_rightshoe	Alt-x
S underbar	62	apl_Sunderbar	Alt-S	S + underbar
semicolon	5E*	apl_semicolon	;
slash	61*	apl_slash	/
slash bar	EA	apl_slashbar		slash + bar
slope	B7	apl_slope	Alt-\\\\ 
slope bar	EB	apl_slopebar		slope + bar
squad	CC	apl_squad		quad + quad
star	5C*	apl_star	*
stile	BF	apl_stile	Alt-|
T underbar	63	apl_Tunderbar	Alt-T	T + underbar
tilde	80	apl_tilde	Alt-~
times	B6	apl_times	Alt-=
U underbar	64	apl_Uunderbar	Alt-U	U + underbar
underbar	6D*	apl_underbar	'_'
up arrow	8A	apl_uparrow	Alt-y
up caret	71	apl_upcaret	Alt-0
up caret tilde	CA	apl_upcarettilde		up caret + tilde
up shoe	AA	apl_upshoe	Alt-c
up shoe jot	DF	apl_upshoejot		up shoe + jot
up stile	8D	apl_upstile	Alt-s
up tack	BC	apl_uptack	Alt-n
up tack jot	EF	apl_uptackjot		up tack + jot
V underbar	65	apl_Vunderbar	Alt-V	V + underbar
W underbar	66	apl_Wunderbar	Alt-W	W + underbar
X underbar	67	apl_Xunderbar	Alt-X	X + underbar
Y underbar	68	apl_Yunderbar	Alt-Y	Y + underbar
Z underbar	69	apl_Zunderbar	Alt-Z	Z + underbar
.SH "5250 (AS/400) SUPPORT"
.B x3270
provides limited support for 5250 (AS/400) emulation.
This is not native 5250 terminal emulation, but rather for use with hosts
which allow a 3270 terminal to emulate a 5250.
A 
.B 5250
keymap is defined, which maps the keyboard function keys to the 5250 emulator'
PA/PF key sequences, as well as redefining the Return key to use the special
FieldExit action.
The command line for 5250 support is:
.RS 1i
.br
x3270 -model 2 -keymap 5250
.br
.RE
.TE
.SH "SCREEN PRINTING"
Screen printing is handled through options on the File menu or by the
PrintText and PrintWindow keyboard actions.
Each results in a pop-up to confirm the print command.
.PP
The PrintText action (usually assigned to the key <Meta>p) sends the current
screen image to the printer as 
.SM ASCII
characters.
The default command used to print the data is controlled by
the "x3270.printTextCommand" resource; the default is
.BR lpr .
You may also use a keymap definition to pass a print command the PrintText
action itself.
The command receives the screen text as its standard input.
For example, the following keymap will save the screen text in a file:
.IP
Meta<Key>f: PrintText("cat >screen.image")
.PP
Note: HardPrint is an alias for PrintText.
.PP
The PrintWindow action (usually assigned to the key <Meta>b) sends the current
screen image to the printer as a bitmap.
The default command used to print the data is controlled by
the "x3270.printWindowCommand" resource; the default is
.IP
.BR "xwd \-id %d | xpr | lpr" .
.PP
You may also use a keymap definition to pass a print command to the
PrintWindow action itself.
If the command contains the text "%d", the window ID of
.B x3270
will be substituted before it is run.
For example, the following keymap will pop up a duplicate of the current
screen image:
.IP
Meta<Key>g: PrintWindow("xwd \-id %d | xwud &")
.LP
If the command for PrintWindow or PrintText begins with an "@" character,
the initial pop-up menu to confirm the print command is not displayed and
the command cannot be edited.
.SH BUGS
Cursor highlighting will not work with if you use the
.B NoTitleFocus
option in your .twmrc file.
.LP
Pull-down menus may not work properly if the Caps Lock, Num Lock, Shift, Alt
or Meta keys are pressed.
This is a bug in the Athena menu widget and affects several other X
applications as well.
.SH PASSTHRU
.B x3270
supports the Sun
.I telnet-passthru
service provided by the
.I in.telnet-gw
server.
This allows outbound telnet connections through a firewall machine.
When a
.B p:
is prepended to a hostname,
.B x3270
acts much like the
.IR itelnet(1)
command.
It contacts the machine named
.B internet-gateway
at the port defined in
.B /etc/services
as
.B telnet-passthru
(which defaults to 3514).
It then passes the requested hostname and port to the
.B in.telnet-gw
server.
.SH FILES
.nf
/usr/lib/X11/x3270/ibm_hosts
.SH "SEE ALSO"
telnet(1), tn3270(1), ibm_hosts(5), x3270-script(1)
.br
X Toolkit Intrinsics
.br
Data Stream Programmer's Reference, IBM GA23\-0059
.br
Character Set Reference, IBM GA27\-3831
.br
RFC 1576, TN3270 Current Practices
.br
RFC 1646, TN3270 Extensions for LUname and Printer Selection
.br
RFC 2355, TN3270 Enhancements
.SH COPYRIGHTS
.LP
Modifications Copyright 1993, 1994, 1995, 1996, 1997, 1999 by Paul Mattes.
.br
Original X11 Port Copyright 1990 by Jeff Sparkes.
.RS
Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
.RE
Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA 30332.
.RS
All Rights Reserved.  GTRC hereby grants public use of this software.
Derivative works based on this software must incorporate this copyright
notice.
.RE
5250 Emulation Code copyright Minolta (Schweiz) AG, Beat Rubischon.
.SH VERSION
x3270 3.2A1
