/* baseframe.c -- routines associated with xa's base frame */

/* $Id: baseframe.c,v 1.6 1996/03/16 16:55:20 richards Exp $ */

/*
 * $Log: baseframe.c,v $
 * Revision 1.6  1996/03/16 16:55:20  richards
 * renamed xrastool to xa
 * fixed indenting
 *
 * Revision 1.5  1996/03/14 21:55:31  richards
 * trivial change
 *
 * Revision 1.4  1996/02/08 01:24:01  richards
 * removed #include <xview/notify.h>
 *
 * Revision 1.3  1996/01/27 22:29:06  richards
 * changed some comment formats
 *
 * Revision 1.2  1996/01/21 21:29:47  richards
 * prototyping
 *
 * Revision 1.1  1996/01/18 16:56:55  richards
 * Initial revision
 *
 */

#include "xa.h"

/* Global variables */

Frame BaseFrame;

int NukeCanvas = FALSE; /* To allow clean exits from program */

/* Base frame icon */

#include "bitmaps/base_icon.xbm"

/* Local functions */

static Notify_value base_frame_quit(Notify_client client,
				    Destroy_status status);

/*** END OF PREAMBLE ***/

void MakeBaseFrame(void)
{
  /* Modifies BaseFrame (created in main()) and makes icon */

  Server_image icon_image; Icon icon;

  icon_image = (Server_image)
    xv_create(XV_NULL, SERVER_IMAGE,
	      SERVER_IMAGE_X_BITS,
	      base_icon_bits, XV_WIDTH,
	      base_icon_width, XV_HEIGHT,
	      base_icon_height, NULL);

  icon = (Icon) xv_create(XV_NULL, ICON, ICON_IMAGE, icon_image, NULL);

  (void) xv_set(BaseFrame, XV_X, DFLT_BASE_FRAME_XV_X, XV_Y,
		DFLT_BASE_FRAME_XV_Y, FRAME_LABEL, "xa: Main Panel",
		FRAME_SHOW_FOOTER, TRUE, FRAME_LEFT_FOOTER, "No images loaded",
		FRAME_RIGHT_FOOTER, VERSION, FRAME_ICON, icon, NULL);

  /* Interpose a destroy function */

  notify_interpose_destroy_func(BaseFrame, base_frame_quit);
}

static Notify_value base_frame_quit(Notify_client client,
				    Destroy_status status)
{
  /* Intercepts BaseFrame quit request so that the canvas can be killed too */

  NukeCanvas = TRUE;

  (void) xv_destroy_safe(CanvasFrame);

  return notify_next_destroy_func(client, status);
}

/*** Baseframe.c ***/
