/* $XConsortium: Mailbox.c,v 1.64 94/04/17 20:43:26 rws Exp $ */
/*

Copyright (c) 1988  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.

*/

/*
 * Author:  Jim Fulton, MIT X Consortium
 *
 * I recommend that you use the new mailfull and mailempty bitmaps instead of
 * the ugly mailboxes:
 *
 *         XBiff*fullPixmap:  mailfull
 *         XBiff*emptyPixmap:  mailempty
 */

#include <X11/IntrinsicP.h>		/* for toolkit stuff */
#include <X11/StringDefs.h>		/* for useful atom names */
#include <X11/cursorfont.h>		/* for cursor constants */
#include <X11/Xosdefs.h>		/* for X_NOT_POSIX def */
#include <sys/stat.h>			/* for stat() ** needs types.h ***/
#include <stdio.h>			/* for printing error messages */
#include <stdlib.h>
#include <ctype.h>			/* for tolower() */
#ifdef WIN32
#include <X11/Xw32defs.h>
#else
#include <pwd.h>			/* for getting username */
#include <unistd.h>
#endif

#if defined(sparc) && !defined(USE_AUDIOFILE)
# include <netdb.h>			/* for hostent struct */
#endif

#ifndef X_NOT_POSIX
#ifdef _POSIX_SOURCE
# include <sys/wait.h>
#else
#define _POSIX_SOURCE
# include <sys/wait.h>
#undef _POSIX_SOURCE
#endif
# define waitCode(w)	WEXITSTATUS(w)
# define waitSig(w)	WIFSIGNALED(w)
typedef int		waitType;
# define INTWAITTYPE
#else /* ! X_NOT_POSIX */
#ifdef SYSV
# define waitCode(w)	(((w) >> 8) & 0x7f)
# define waitSig(w)	((w) & 0xff)
typedef int		waitType;
# define INTWAITTYPE
#else
#ifdef WIN32
#include <process.h>
# define INTWAITTYPE
typedef int		waitType;
# define waitCode(w)	(w)
# define waitSig(w)	(0)
#else
# include	<sys/wait.h>
# define waitCode(w)	((w).w_T.w_Retcode)
# define waitSig(w)	((w).w_T.w_Termsig)
typedef union wait	waitType;
#endif /* WIN32 else */
#endif /* SYSV else */
#endif /* ! X_NOT_POSIX else */

#include <X11/bitmaps/mailfull>		/* for flag up (mail present) bits */
#include <X11/bitmaps/mailempty>	/* for flag down (mail not here) */

#include <X11/Xaw/XawInit.h>
#include "SSMailboxP.h"			/* for implementation mailbox stuff */
#include <X11/Xmu/Drawing.h>
#include <X11/extensions/shape.h>

#include "strtok.h"

#include "xbiff-proto.h"

char *sound_path = NULL;

/*
 * The default user interface is to have the mailbox turn itself off whenever
 * the user presses a button in it.  Expert users might want to make this
 * happen on EnterWindow.  It might be nice to provide support for some sort of
 * exit callback so that you can do things like press q to quit.
 */

static char defaultTranslations[] =
  "<Btn1Down>:  unset()\n\
   <Btn3Down>:  review()";

static void Check(), Set(), Unset(), Review(), Quit();

static XtActionsRec actionsList[] = {
    { "check",	Check },
    { "unset",	Unset },
    { "set",	Set },
    { "review", Review },
    { "quit",	Quit },
};

static int not_on_console_p XBIFFPROTO((Display *display));

/* Initialization of defaults */

#define offset(field) XtOffsetOf(SSMailboxRec, ssmailbox.field)
#define goffset(field) XtOffsetOf(WidgetRec, core.field)

static Dimension defDim = 48;
static Pixmap nopix = None;

static XtResource resources[] = {
    { XtNwidth, XtCWidth, XtRDimension, sizeof (Dimension),
	goffset (width), XtRDimension, (XtPointer)&defDim },
    { XtNheight, XtCHeight, XtRDimension, sizeof (Dimension),
	goffset (height), XtRDimension, (XtPointer)&defDim },
    { XtNupdate, XtCInterval, XtRInt, sizeof (int),
	offset (update), XtRString, "30" },
    { XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
	offset (foreground_pixel), XtRString, XtDefaultForeground },
    { XtNbackground, XtCBackground, XtRPixel, sizeof (Pixel),
	goffset (background_pixel), XtRString, "white" },
    { XtNfile, XtCFile, XtRString, sizeof (String),
	offset (filename), XtRString, NULL },
    { XtNcheckCommand, XtCCheckCommand, XtRString, sizeof(char*),
	offset (check_command), XtRString, NULL},
    { XtNvolume, XtCVolume, XtRInt, sizeof(int),
	offset (volume), XtRString, "50"},
    { XtNonceOnly, XtCBoolean, XtRBoolean, sizeof(Boolean),
	offset (once_only), XtRImmediate, (XtPointer)False },
    { XtNfullPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
	offset (full.bitmap), XtRString, "flagup" },
    { XtNfullPixmapMask, XtCPixmapMask, XtRBitmap, sizeof(Pixmap),
	offset (full.mask), XtRBitmap, (XtPointer) &nopix },
    { XtNemptyPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
	offset (empty.bitmap), XtRString, "flagdown" },
    { XtNemptyPixmapMask, XtCPixmapMask, XtRBitmap, sizeof(Pixmap),
	offset (empty.mask), XtRBitmap, (XtPointer) &nopix },
    { XtNflip, XtCFlip, XtRBoolean, sizeof(Boolean),
	offset (flipit), XtRString, "true" },
    { XtNshapeWindow, XtCShapeWindow, XtRBoolean, sizeof(Boolean),
	offset (shapeit), XtRString, "false" },
    { XtNsound, XtCSound, XtRString, sizeof (String),
	offset (sound), XtRString, NULL },
    { XtNnoMailSound, XtCNoMailSound, XtRString, sizeof (String),
	offset (no_mail_sound), XtRString, NULL },
    { XtNsoundBindings, XtCSoundBindings, XtRString, sizeof (String),
	offset (sound_bindings), XtRString, NULL },
    { XtNfaceBindings, XtCFaceBindings, XtRString, sizeof (String),
	offset (face_bindings), XtRString, NULL },
    { XtNcaseSensitive, XtCCaseSensitive, XtRBoolean, sizeof(Boolean),
      offset (case_sensitive), XtRString, "false" },
    { XtNautoResize, XtCAutoResize, XtRBoolean, sizeof(Boolean),
      offset (auto_resize), XtRString, "false" },
    { XtNuseLED, XtCUseLED, XtRBoolean, sizeof(Boolean),
      offset (use_LED), XtRString, "true" },
    { XtNwhichLED, XtCWhichLED, XtRInt, sizeof(int),
      offset (which_LED), XtRString, "1" },
    { XtNdebug, XtCDebug, XtRBoolean, sizeof(Boolean),
      offset (debug), XtRString, "false" },
    { XtNsoundPath, XtCSoundPath, XtRString, sizeof(String),
      offset (sound_path), XtRString, NULL }
};

#undef offset
#undef goffset

static void GetMailFile(), CloseDown();
static void check_ssmailbox(), redraw_ssmailbox(), reshape_ssmailbox();
static void Initialize(), Realize(), Destroy(), Redisplay();
static void beep(), frob_leds();
static Boolean SetValues();
Boolean show_face ();

SSMailboxClassRec ssmailboxClassRec = {
    { /* core fields */
    /* superclass		*/	(WidgetClass) &simpleClassRec,
    /* class_name		*/	"SSMailbox",
    /* widget_size		*/	sizeof(SSMailboxRec),
    /* class_initialize		*/	XawInitializeWidgetSet,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actionsList,
    /* num_actions		*/	XtNumber(actionsList),
    /* resources		*/	resources,
    /* resource_count		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL
    },
    { /* simple fields */
    /* change_sensitive         */	XtInheritChangeSensitive
    },
    { /* mailbox fields */
    /* ignore                   */	0
    }
};

WidgetClass ssmailboxWidgetClass = (WidgetClass) &ssmailboxClassRec;

/*
 * widget initialization
 */

static GC get_ssmailbox_gc (w)
    SSMailboxWidget w;
{
    XtGCMask valuemask;
    XGCValues xgcv;

    valuemask = GCForeground | GCBackground | GCFunction | GCGraphicsExposures;
    xgcv.foreground = w->ssmailbox.foreground_pixel;
    xgcv.background = w->core.background_pixel;
    xgcv.function = GXcopy;
    xgcv.graphics_exposures = False;	/* this is Bool, not Boolean */
    return (XtGetGC ((Widget) w, valuemask, &xgcv));
}


/* ARGSUSED */
static void Initialize (request, new, args, num_args)
    Widget request, new;
     ArgList args;
     Cardinal *num_args;
{
    SSMailboxWidget w = (SSMailboxWidget) new;
    int shape_event_base, shape_error_base;

    if (w->core.width <= 0) w->core.width = 1;
    if (w->core.height <= 0) w->core.height = 1;

    if (w->ssmailbox.shapeit && !XShapeQueryExtension (XtDisplay (w),
						     &shape_event_base,
						     &shape_error_base))
      w->ssmailbox.shapeit = False;
    w->ssmailbox.shape_cache.mask = None;
    w->ssmailbox.gc = get_ssmailbox_gc (w);
    w->ssmailbox.interval_id = (XtIntervalId) 0;

    w->ssmailbox.full.image = None;
    w->ssmailbox.empty.image = None;
    w->ssmailbox.current_face.image = None;
    w->ssmailbox.full.colors = None;
    w->ssmailbox.empty.colors = None;
    w->ssmailbox.current_face.colors = None;
    w->ssmailbox.full.ncolors = 0;
    w->ssmailbox.empty.ncolors = 0;
    w->ssmailbox.current_face.ncolors = 0;

    w->ssmailbox.flag_up = FALSE;
    w->ssmailbox.last_size = 0;
    w->ssmailbox.last_mtime = 0;
    w->ssmailbox.last_numnew = 0;
    if (!w->ssmailbox.filename) GetMailFile (w);

    w->ssmailbox.bindings = NULL;
    w->ssmailbox.face = 0;
    w->ssmailbox.not_on_console = not_on_console_p (XtDisplay (w));

    return;
}


static int not_on_console_p (display)
     Display *display;
{
#if defined(USE_AUDIOFILE) || defined(AAPI)
  return(0);
#else
# ifdef sparc
  /* When running on a SparcStation, we cannot use digitized sounds as
     beeps unless emacs is running on the same machine that $DISPLAY
     points to, and $DISPLAY points to screen 0 of that machine.
   */
  int not_on_console;
  char *dpy = display->display_name;
  char *tail = (char *) strchr (dpy, ':');
  if (! tail ||
      strncmp (tail, ":0", 2))
    not_on_console = 1;
  else {
    char dpyname[255], localname[255];
    strncpy (dpyname, dpy, tail-dpy);
    dpyname [tail-dpy] = 0;
    if (dpyname[0] == '\0' || !strcmp(dpyname, "unix") ||
      !strcmp(dpyname, "localhost"))
      not_on_console = 0;
    else if (gethostname (localname, 255))
      not_on_console = 1;  /* can't find hostname? */
    else {
      /* gethostbyname() reuses the structure it returns,
	 so we have to copy the string out of it. */
      struct hostent *h = gethostbyname (dpyname);
      not_on_console = !!(strcmp (localname, h->h_name));
    }
  }
  return not_on_console;
# else
  return 1;
# endif
#endif
}

/*
 * action procedures
 */

/*
 * pretend there is new mail; put widget in flagup state
 */

/* ARGSUSED */
static void Set (gw, event, params, nparams)
    Widget gw;
    XEvent *event;
    String *params;
    Cardinal *nparams;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;

    w->ssmailbox.last_size = -1;
    w->ssmailbox.last_numnew = -1;

    check_ssmailbox (w, TRUE, FALSE, FALSE);	/* redraw, no reset, no review*/

    return;
}


/*
 * ack the existing mail; put widget in flagdown state
 */

/* ARGSUSED */
static void Unset (gw, event, params, nparams)
    Widget gw;
    XEvent *event;
    String *params;
    Cardinal *nparams;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;

    check_ssmailbox (w, TRUE, TRUE, FALSE);	/* redraw, reset, no review */

    return;
}

/*
 * pretend all mail is new; review sounds
 */

/* ARGSUSED */
static void Review (gw, event, params, nparams)
    Widget gw;
    XEvent *event;
    String *params;
    Cardinal *nparams;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;

    w->ssmailbox.last_numnew = 0;
    w->ssmailbox.last_size = 0;
    check_ssmailbox (w, TRUE, FALSE, TRUE);	/* redraw, no reset, review */

    return;
}


/*
 * look to see if there is new mail; if so, Set, else Unset
 */

/* ARGSUSED */
static void Check (gw, event, params, nparams)
    Widget gw;
    XEvent *event;
    String *params;
    Cardinal *nparams;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;

    check_ssmailbox (w, TRUE, FALSE, TRUE);	/* redraw, no reset, review */

    return;
}


/*
 * shut down xbiff
 */

/* ARGSUSED */
static void Quit (gw, event, params, nparams)
    Widget gw;
    XEvent *event;
    String *params;
    Cardinal *nparams;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;

    CloseDown (w, 0);

    return;
}


/* ARGSUSED */
static void clock_tic (client_data, id)
    XtPointer client_data;
    XtIntervalId *id;
{
    SSMailboxWidget w = (SSMailboxWidget) client_data;

    check_ssmailbox (w, FALSE, FALSE, FALSE);	/* no redraw, no reset, no review */

    /*
     * and reset the timer
     */

    w->ssmailbox.interval_id =
	XtAppAddTimeOut (XtWidgetToApplicationContext((Widget) w),
			 w->ssmailbox.update * 1000, clock_tic, client_data);

    return;
}

static Pixmap make_pixmap (dpy, w, bitmap, depth, flip, widthp, heightp)
    Display *dpy;
    SSMailboxWidget w;
    Pixmap bitmap;
    Boolean flip;
    int depth;
    int *widthp, *heightp;
{
    Window root;
    int x, y;
    unsigned int width, height, bw, dep;
    unsigned long fore, back;

    if (!XGetGeometry (dpy, bitmap, &root, &x, &y, &width, &height, &bw, &dep))
      return None;

    *widthp = (int) width;
    *heightp = (int) height;
    if (flip) {
	fore = w->core.background_pixel;
	back = w->ssmailbox.foreground_pixel;
    } else {
	fore = w->ssmailbox.foreground_pixel;
	back = w->core.background_pixel;
    }
    return XmuCreatePixmapFromBitmap (dpy, w->core.window, bitmap,
				      width, height, depth, fore, back);
}

static void Realize (gw, valuemaskp, attr)
    Widget gw;
    XtValueMask *valuemaskp;
    XSetWindowAttributes *attr;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;
    register Display *dpy = XtDisplay (w);

    *valuemaskp |= (CWBitGravity | CWCursor);
    attr->bit_gravity = ForgetGravity;
    attr->cursor = XCreateFontCursor (dpy, XC_top_left_arrow);

    (*ssmailboxWidgetClass->core_class.superclass->core_class.realize)
	(gw, valuemaskp, attr);
  
    /*
     * build up the pixmaps that we'll put into the image
     */
    if (w->ssmailbox.full.bitmap == None) {
	w->ssmailbox.full.bitmap =
	  XCreateBitmapFromData (dpy, w->core.window, (char *) mailfull_bits,
				 mailfull_width, mailfull_height);
    }
    if (w->ssmailbox.empty.bitmap == None) {
	w->ssmailbox.empty.bitmap =
	  XCreateBitmapFromData (dpy, w->core.window, (char *) mailempty_bits,
				 mailempty_width, mailempty_height);
    }

    {
	Window root;
	int x, y;
	unsigned int bw, dep;

	XGetGeometry (dpy, w->ssmailbox.full.bitmap, &root, &x, &y,
		      (unsigned *)&w->ssmailbox.full.width,
		      (unsigned *)&w->ssmailbox.full.height,
		      &bw, &dep);
#if 0
	printf ("GG:  %d,%d  %d x %d x %d  /%d\n",
		x, y, w->ssmailbox.full.width,
		w->ssmailbox.full.height, dep, bw);
	fflush(stdout);
#endif
	XGetGeometry (dpy, w->ssmailbox.empty.bitmap, &root, &x, &y,
		      (unsigned *)&w->ssmailbox.empty.width,
		      (unsigned *)&w->ssmailbox.empty.height,
		      &bw, &dep);
    }

    w->ssmailbox.full.image =
      XGetImage (dpy, w->ssmailbox.full.bitmap, 0, 0,
		 w->ssmailbox.full.width,
		 w->ssmailbox.full.height,
		 AllPlanes, ZPixmap);
    w->ssmailbox.empty.image =
      XGetImage (dpy, w->ssmailbox.empty.bitmap, 0, 0,
		 w->ssmailbox.empty.width,
		 w->ssmailbox.empty.height,
		 AllPlanes, ZPixmap);
    {
      unsigned int fg = w->ssmailbox.foreground_pixel;
      unsigned int bg = w->core.background_pixel;
      Boolean flipit  = w->ssmailbox.flipit;
      FrobnicateImage (dpy, DefaultScreen(dpy), &w->ssmailbox.full.image, 0,
		       flipit ? bg : fg, flipit ? fg : bg);
      FrobnicateImage (dpy, DefaultScreen(dpy), &w->ssmailbox.empty.image, 0,
		       fg, bg);
    }

/*
    w->ssmailbox.empty.pixmap = make_pixmap (dpy, w, w->ssmailbox.empty.bitmap,
					   w->core.depth, False,
					   &w->ssmailbox.empty.width,
					   &w->ssmailbox.empty.height);
    w->ssmailbox.full.pixmap = make_pixmap (dpy, w, w->ssmailbox.full.bitmap,
					  w->core.depth, w->ssmailbox.flipit,
					  &w->ssmailbox.full.width,
					  &w->ssmailbox.full.height);
 */
/*
    w->ssmailbox.empty.image =
      XCreateImage(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
		   1, XYBitmap, 0,
		   w->ssmailbox.empty.bitmap,
		   w->ssmailbox.empty.width,
		   w->ssmailbox.empty.height,
		   8, (w->ssmailbox.empty.width + 7) / 8);
    w->ssmailbox.full.image =
      XCreateImage(dpy, DefaultVisual(dpy, DefaultScreen(dpy)),
		   1, XYBitmap, 0,
		   w->ssmailbox.full.bitmap,
		   w->ssmailbox.full.width,
		   w->ssmailbox.full.height,
		   8, (w->ssmailbox.full.width + 7) / 8);
 */
    if (w->ssmailbox.empty.mask == None && w->ssmailbox.full.mask == None)
      w->ssmailbox.shapeit = False;

    w->ssmailbox.interval_id = 
	XtAppAddTimeOut (XtWidgetToApplicationContext((Widget) w),
			 w->ssmailbox.update * 1000, clock_tic, (XtPointer) w);

    w->ssmailbox.shape_cache.mask = None;

    if (w->ssmailbox.sound_bindings)
    {
	regexp *pattern;
	char *pair, *patstr, *sound;
	Bindings *binding, *last_binding = NULL;

	while ((pair=strtoken(&w->ssmailbox.sound_bindings,",",1)))
	{
	    patstr=strtoken(&pair, "|", 1);
	    if (patstr) sound=strtoken(&pair, "|", 1);
	    if (!patstr || !sound)
	    {
		fprintf(stderr, "malformed sound bindings.\n");
		continue;
	    }

	    if ( w->ssmailbox.case_sensitive == FALSE ) {
	       char *c = patstr;
	       for (; *c != '\0'; c++) if (isupper(*c)) *c = tolower(*c);
	    }

	    pattern = regcomp(patstr);
	    if (pattern) {

		binding = (Bindings *)malloc(sizeof(Bindings));
		binding->patstr = patstr;
		binding->pattern = pattern;
		binding->sound = sound;
		binding->face = 0;

		if (last_binding) last_binding->next = binding;
		binding->next = NULL;
		last_binding = binding;

		if (!w->ssmailbox.bindings)
		    w->ssmailbox.bindings = binding;
		if (w->ssmailbox.debug == TRUE)
		   fprintf(stderr, "Sound regexp: \"%s\"\n", binding->patstr);
	    }
	}
    }

    if (w->ssmailbox.face_bindings)
    {
	regexp *pattern;
	char *pair, *patstr, *face;
	Bindings *binding, *last_binding = NULL;

	while ((pair=strtoken(&w->ssmailbox.face_bindings,",",1)))
	{
	    patstr=strtoken(&pair, "|", 1);
	    if (patstr) face=strtoken(&pair, "|", 1);
	    if (!patstr || !face)
	    {
		fprintf(stderr, "malformed face bindings.\n");
		continue;
	    }

	    if ( w->ssmailbox.case_sensitive == FALSE ) {
	       char *c = patstr;
	       for (; *c != '\0'; c++) if (isupper(*c)) *c = tolower(*c);
	    }

	    pattern = regcomp(patstr);
	    if (pattern) {

		binding = (Bindings *)malloc(sizeof(Bindings));
		binding->patstr = patstr;
		binding->pattern = pattern;
		binding->sound = 0;
		binding->face = face;

		if (last_binding) last_binding->next = binding;
		binding->next = NULL;
		last_binding = binding;

		if (!w->ssmailbox.bindings)
		    w->ssmailbox.bindings = binding;
		if (w->ssmailbox.debug == TRUE)
		   fprintf(stderr, "Face  regexp: \"%s\"\n", binding->patstr);
	    }
	}
    }

    /* check it the first time (instead of waiting for the first timeout) */
    check_ssmailbox (w, TRUE, FALSE, FALSE);

    return;
}


static void Destroy (gw)
    Widget gw;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;
    Display *dpy = XtDisplay (gw);

    /* Turn off the LED when we exit.
       This should happen on a signal-function so that it happens when
       the processes is killed as well.
     */
    w->ssmailbox.flag_up = False;
    frob_leds (w);

    XtFree (w->ssmailbox.filename);
    if (w->ssmailbox.interval_id) XtRemoveTimeOut (w->ssmailbox.interval_id);
    XtReleaseGC (gw, w->ssmailbox.gc);
#define freepix(p) if (p) XFreePixmap (dpy, p)
#define freeimg(p) if (p) XDestroyImage (p)
    freepix (w->ssmailbox.full.bitmap);		/* until cvter does ref cnt */
    freepix (w->ssmailbox.full.mask);		/* until cvter does ref cnt */
    freeimg (w->ssmailbox.full.image);
    freepix (w->ssmailbox.empty.bitmap);	/* until cvter does ref cnt */
    freepix (w->ssmailbox.empty.mask);		/* until cvter does ref cnt */
    freeimg (w->ssmailbox.empty.image);
    freepix (w->ssmailbox.current_face.bitmap);	/* until cvter does ref cnt */
    freepix (w->ssmailbox.current_face.mask);	/* until cvter does ref cnt */
    freeimg (w->ssmailbox.current_face.image);
    freepix (w->ssmailbox.shape_cache.mask);
#undef freepix
#undef freeimg
    return;
}


static void Redisplay (gw, event, region)
    Widget gw;
    XEvent *event;
    Region region;
{
    SSMailboxWidget w = (SSMailboxWidget) gw;

    /* Yeah right, like we need to do all those regexp matches at every
       redisplay event. */
    /* check_ssmailbox (w, TRUE, FALSE, FALSE); */
    redraw_ssmailbox (w);
}


static void frob_leds (w)
     SSMailboxWidget w;
{
  if ( w->ssmailbox.use_LED ) {
    XKeyboardControl control;
    control.led = w->ssmailbox.which_LED;
    control.led_mode = (w->ssmailbox.flag_up ? LedModeOn : LedModeOff);
    XChangeKeyboardControl(XtDisplay(w), KBLed | KBLedMode, &control);
  }
}

static int newmsgs(w, sounds)
    SSMailboxWidget w;
    struct MsgStruct **sounds;
{
    struct stat st;
    FILE *fp;
    int rval;

    /* if we can't stat() the mailbox, pretend there aren't any msgs */
    if (stat(w->ssmailbox.filename, &st) != 0)
	return 0;

    if (w->ssmailbox.debug == TRUE)
	fprintf(stderr, "%s:\n\tsize=%ld, mtime=%ld\n\tosiz=%ld, omtim=%ld\n",
	       w->ssmailbox.filename, st.st_size, (long )st.st_mtime,
	       w->ssmailbox.last_size, (long )w->ssmailbox.last_mtime);

    /* if we know nothing's changed... */
    if (st.st_size == w->ssmailbox.last_size &&
	st.st_mtime == w->ssmailbox.last_mtime)
	return w->ssmailbox.last_numnew;

    /* if we can't open the mailbox return 0 */
    if (!(fp= fopen(w->ssmailbox.filename, "r")))
	return 0;

    /* try reading from where we left off */
    if (st.st_size > w->ssmailbox.last_size) {
	fseek(fp, w->ssmailbox.last_size, SEEK_SET);
	rval = scanmbox(w, fp, sounds);
	if (rval != -1)
	   rval += w->ssmailbox.last_numnew;
    } else
	rval = -1;

    /* that didn't work; start from the beginning */
    if (rval == -1) {
      fseek(fp, 0, SEEK_SET);
      rval = scanmbox(w, fp, sounds);
    }

    /* remember these for the next runthrough */
    w->ssmailbox.last_size = st.st_size;
    w->ssmailbox.last_mtime = st.st_mtime;

    return rval;
}

static void check_ssmailbox (w, force_redraw, reset, review)
    SSMailboxWidget w;
    Boolean force_redraw, reset, review;
{
    long numnew = 0;
    Boolean readSinceLastWrite = FALSE;
    int beepit = 0;
    struct MsgStruct *sounds = 0;  /* and faces */

    if (w->ssmailbox.check_command != NULL) {
	waitType wait_status;
	int	check_status;
#ifdef INTWAITTYPE
	wait_status = system(w->ssmailbox.check_command);
#else
	wait_status.w_status = system(w->ssmailbox.check_command);
#endif
	check_status = waitCode(wait_status);

	/* error in sh checkCommand execution */
	if (waitSig(wait_status))
	    check_status = 2;		/* act as if there is no mail */

	switch (check_status) {
	  case 0:
	    numnew = w->ssmailbox.last_numnew + 1;
	    break;
	  case 2:
	    numnew = 0;
	    break;
	  default:	/* treat everything else as no change */
	    	        /* case 1 is no change */
	    numnew = w->ssmailbox.last_numnew;
	}
    }
    else {
	numnew = newmsgs(w, &sounds);
    }
    if (w->ssmailbox.debug == TRUE)
	fprintf(stderr, "Got %ld new msgs\n", numnew);

    /*
     * Now check for changes.  If reset is set then we want to pretent that
     * there is no mail.  If the mailbox is empty then we want to turn off
     * the flag.  Otherwise if the mailbox has changed size then we want to
     * put the flag up, unless the mailbox has been read since the last
     * write.
     *
     * The cases are:
     *    o  forced reset by user                        DOWN
     *    o  no mailbox or empty (zero-sized) mailbox    DOWN
     *    o  if read after most recent write 		 DOWN
     *    o  same size as last time                      no change
     *    o  bigger than last time                       UP
     *    o  smaller than last time but non-zero         UP
     *
     * The last two cases can be expressed as different from last
     * time and non-zero.
     */

    if (reset) {			/* forced reset */
	w->ssmailbox.flag_up = FALSE;
	force_redraw = TRUE;
    } else if (numnew == 0) {
	w->ssmailbox.flag_up = FALSE;
	if (w->ssmailbox.last_numnew > 0) force_redraw = TRUE;  /* if change */
    } else if (readSinceLastWrite) { 	/* only when checkCommand is NULL */
	/* mailbox has been read after most recent write */
	if (w->ssmailbox.flag_up) {
	    w->ssmailbox.flag_up = FALSE;
	    force_redraw = TRUE;
	}

    } else if (numnew <= w->ssmailbox.last_numnew) {	/* less mail than
							   before */
	/* do nothing; don't play sounds and don't change icon since
	   user may have lowered the flag manually. */
    } else if (numnew > w->ssmailbox.last_numnew) {  /* different size */
	if (!w->ssmailbox.once_only || !w->ssmailbox.flag_up)
	    beepit = 1;
	if (!w->ssmailbox.flag_up)
	    force_redraw = w->ssmailbox.flag_up = TRUE;
    }

    frob_leds (w);

    if (beepit || review)
	beep(w, sounds, numnew - w->ssmailbox.last_numnew, review);

    if (force_redraw) {
      reshape_ssmailbox (w);
      redraw_ssmailbox (w);
    }

    w->ssmailbox.last_numnew = numnew;
    while (sounds)
    {
	struct MsgStruct *x;
	x = sounds->next;
	while (sounds->sounds)
	{
	    struct SoundStruct *s;
	    s = sounds->sounds->next;
	    free(sounds->sounds);
	    sounds->sounds = s;
	}
	free(sounds);
	sounds = x;
    }

    return;
}

/*
 * get user name for building mailbox
 */

static void GetMailFile (w)
    SSMailboxWidget w;
{
    char *username, *mailptr;
    struct passwd *pw;

    mailptr = getenv("MAIL");
    if (mailptr) {
	w->ssmailbox.filename = (String) XtMalloc (strlen (mailptr) + 1);
	strcpy (w->ssmailbox.filename, mailptr);
    } else {
#ifdef WIN32
	username = getenv("USERNAME");
#else
	pw = getpwuid(getuid());
	if (pw)
	    username = pw->pw_name;
	else
	    username = getlogin ();
#endif
	if (!username) {
	    fprintf (stderr, "%s:  unable to find a username for you.\n",
		     "Mailbox widget");
	    CloseDown (w, 1);
	}

	w->ssmailbox.filename = (String) XtMalloc(strlen(MAILBOX_DIRECTORY) +
						  1 + strlen (username) + 1);
	strcpy (w->ssmailbox.filename, MAILBOX_DIRECTORY);
	strcat (w->ssmailbox.filename, "/");
	strcat (w->ssmailbox.filename, username);
    }
    return;
}

static void CloseDown (w, status)
    SSMailboxWidget w;
    int status;
{
    Display *dpy = XtDisplay (w);

    XtDestroyWidget ((Widget)w);
    XCloseDisplay (dpy);
    exit (status);
}


/* ARGSUSED */
static Boolean SetValues (gcurrent, grequest, gnew, args, num_args)
    Widget gcurrent, grequest, gnew;
    ArgList args;
    Cardinal *num_args;
{
    SSMailboxWidget current = (SSMailboxWidget) gcurrent;
    SSMailboxWidget new = (SSMailboxWidget) gnew;
    Boolean redisplay = FALSE;

    if (current->ssmailbox.update != new->ssmailbox.update) {
	if (current->ssmailbox.interval_id)
	  XtRemoveTimeOut (current->ssmailbox.interval_id);
	new->ssmailbox.interval_id =
	    XtAppAddTimeOut (XtWidgetToApplicationContext(gnew),
			     new->ssmailbox.update * 1000, clock_tic,
			     (XtPointer) gnew);
    }

    if (current->ssmailbox.foreground_pixel != new->ssmailbox.foreground_pixel
	|| current->core.background_pixel != new->core.background_pixel) {
	XtReleaseGC (gcurrent, current->ssmailbox.gc);
	new->ssmailbox.gc = get_ssmailbox_gc (new);
	redisplay = TRUE;
    }

    return (redisplay);
}


/*
 * drawing code
 */

static void redraw_ssmailbox (w)
    SSMailboxWidget w;
{
    register Display *dpy = XtDisplay (w);
    register Window win = XtWindow (w);
    register int x, y;
    GC gc = w->ssmailbox.gc;
    Pixel back = w->core.background_pixel;
    struct _mbimage *im;

    if (! XtIsRealized((Widget)w)) return;

    if (w->ssmailbox.flag_up) {		/* paint the "up" position */
       if (w->ssmailbox.current_face.image != None)
	  im = &w->ssmailbox.current_face;
       else {
	  im = &w->ssmailbox.full;
	  if (w->ssmailbox.flipit) back = w->ssmailbox.foreground_pixel;
       }
    } else {				/* paint the "down" position */
	im = &w->ssmailbox.empty;
    }

    XSetWindowBackground (dpy, win, back);
#if 0
    XClearWindow (dpy, win);  /* ## is this necessary? -jwz */
#endif

    /* center the picture in the window */
#if 0
    if (im->mask)
      x = y = 0;
    else
    {
      x = (((int)w->core.width) - im->width) / 2;
      y = (((int)w->core.height) - im->height) / 2;
    }
#else
    x = y = 0; /* Oh, screw this! */
#endif

    XPutImage (dpy, win, gc, im->image, 0, 0, x, y, im->width, im->height);
    return;
}

static void reshape_ssmailbox (w)
     SSMailboxWidget w;
{
  register int x, y;
  struct _mbimage *im;

  if (! XtIsRealized((Widget)w)) return;

  if (w->ssmailbox.flag_up) {
    if (w->ssmailbox.current_face.image != None)
      im = &w->ssmailbox.current_face;
    else
      im = &w->ssmailbox.full;
  } else {
    im = &w->ssmailbox.empty;
  }
  if ( w->ssmailbox.auto_resize != False ) {
    Widget parent;
    x=0; y=0;

/*  AAAAAAAAARRHRRHRRRRRRRRRRRRRGGGGGGGGGHGGGHGHHHHHHHGGGHHHHHHHH!!!!!!!!!!
    Fuck me gently with a chainsaw!  Will someone please tell me how the fuck
    you resize a fucking widget??  Why, when I call whatever resize method
    I try with 64x64 does the fucking window end up 64x82?  WHY????????
    WHY????????  WHY????????  WHY????????  WHY????????  WHY????????  (why..?)
 */

    for (parent = (Widget) w; parent != None; parent = XtParent(parent)) {
#ifdef Xt_doesnt_suck_wet_farts_from_dead_pigeons
      XtResizeWidget(parent, im->width, im->height, parent->core.border_width);
#else
/*
      parent->core.width = im->width;
      parent->core.height = im->height;
      XtResizeWindow (w);
 */
      XResizeWindow (XtDisplay (parent), XtWindow (parent),
		     im->width, im->height);

# ifdef eat_my_shorts
      {
	int width, height, res;
	res = XtMakeResizeRequest(w, im->width, im->height, &width, &height);
	if (width != im->width || height != im->height)
	  printf("Fuck!!  %d %d; %d y:%d n:%d d:%d a:%d\n", width, height,
		 res, XtGeometryYes, XtGeometryNo, XtGeometryDone,
		 XtGeometryAlmost
		 );
      }
# endif
#endif
    }
  } else {
    x = (((int)w->core.width) - im->width) / 2;
    y = (((int)w->core.height) - im->height) / 2;
  }

    /*
     * XXX - temporary hack; walk up widget tree to find top most parent (which
     * will be a shell) and mash it to have our shape.  This will be replaced
     * by a special shell widget.
     *
     *  Note: this "temporary hack" has been in here for years.
     *
     */
    if (w->ssmailbox.shapeit) {
       Widget parent;

	for (parent = (Widget) w; XtParent(parent);
	     parent = XtParent(parent)) {
	    x += parent->core.x + parent->core.border_width;
	    y += parent->core.y + parent->core.border_width;
	}

	if (/*(im->mask || w->ssmailbox.shape_cache.mask) && */
	    (im->mask != w->ssmailbox.shape_cache.mask ||
	     x != w->ssmailbox.shape_cache.x ||
	     y != w->ssmailbox.shape_cache.y)) {
#if 0
	   printf ("shaping %d\n", im->mask);
#endif
	    XShapeCombineMask (XtDisplay(parent), XtWindow(parent),
			       ShapeBounding, x, y, im->mask, ShapeSet);
	    w->ssmailbox.shape_cache.mask = im->mask;
	    w->ssmailbox.shape_cache.x = x;
	    w->ssmailbox.shape_cache.y = y;
	}
    }
}


void play_sound (w, sound, volume)
     SSMailboxWidget w;
     char *sound;
     int volume;
{
#ifdef USE_AUDIOFILE
  static int AFattempts = 3;
#endif /* USE_AUDIOFILE */
#ifdef AAPI
  static int AAattempts = 3;
#endif /* AAPI */

  /* fill in sound_path if we've got a default */
  if (w->ssmailbox.sound_path != NULL && sound_path == NULL)
    sound_path = w->ssmailbox.sound_path;

#ifdef USE_AUDIOFILE
  if (AFattempts) {
    if (AFplay(sound) == 0) {
      if (w->ssmailbox.debug == TRUE)
	fprintf(stderr, "Played \"%s\" via AudioFile\n", sound);
      return;
    }
    AFattempts--;
    if (w->ssmailbox.debug == TRUE)
      fprintf(stderr, "AudioFile failed, %d more attempts\n", AFattempts);
  }
#endif /* USE_AUDIOFILE */

#ifdef AAPI
  if (AAattempts) {
    if (AAplay(sound) == 0) {
      if (w->ssmailbox.debug == TRUE)
	fprintf(stderr, "Played \"%s\" via HPAAPI\n", sound);
      return;
    }
    AAattempts--;
    if (w->ssmailbox.debug == TRUE)
      fprintf(stderr, "HPAudio failed, %d more attempts\n", AAattempts);
  }
#endif /* AAPI */

#ifdef USE_HPDEV
  if (HPplay(sound) == 0) {
    if (w->ssmailbox.debug == TRUE)
      fprintf(stderr, "Played \"%s\" via HPAudio\n", sound);
    return;
  }
#endif /* AAPI */

#if defined(sparc) && !(defined(__svr4__) || defined(SVR4))
  if (! w->ssmailbox.not_on_console)
    play_sound_file (sound, volume);
  else
#endif
    XBell (XtDisplay (w), w->ssmailbox.volume);
}

XImage *LocateBitmapFile();

int ReadBitmapFile (dpy, filename, current_face, depth, drawable, gc, fg, bg)
     Display *dpy;
     char *filename;
     struct _mbimage *current_face;
     int depth;
     Drawable drawable;
     GC gc;
     unsigned int fg, bg;
{
    int x_hot, y_hot; /* ignored */

#if 0
    printf("ReadBitmapFile: reading \"%s\"", filename);
    if (current_face->image != None)
       printf(", clearing old face\n");
    else printf(".\n");
#endif

    if (current_face->image != None) {
       XDestroyImage(current_face->image);
       current_face->image = None;
    }
    current_face->bitmap = None;
    current_face->mask = None;
    current_face->image = LocateBitmapFile (dpy, DefaultScreen(dpy),
					     filename, NULL, 0,
					     &current_face->width,
					     &current_face->height,
					     &x_hot, &y_hot,
					     &current_face->colors,
					     &current_face->ncolors);
    if (current_face->image == None) return BitmapOpenFailed;

    /* LocateBitmapFile() always returns an XImage of the same depth as
       the screen we're running on.
     */
    if (current_face->ncolors != 0)  /* yar har, here be colours... */
      {
	  int i, c=0;
	  unsigned int *mappings;
	  mappings = (unsigned int *)
		     malloc(sizeof(unsigned int) * current_face->ncolors+1);
	  for (i = 0; i < current_face->ncolors; i++) {
	    int p = current_face->colors[i].pixel;
#ifdef DEBUG_COLORS
	    unsigned short r = current_face->colors[i].red;
	    unsigned short g = current_face->colors[i].green;
	    unsigned short b = current_face->colors[i].blue;
#endif /* DEBUG_COLORS */

#if 0
	    current_face->colors[i].red = 65535;
	    current_face->colors[i].green = 0;
	    current_face->colors[i].blue = 65535;
	    current_face->colors[i].flags = (DoRed|DoGreen|DoBlue);
#endif
	    if (XAllocColor(dpy, DefaultColormap(dpy, DefaultScreen(dpy)),
			    &current_face->colors[i])) {
	      mappings[p] = current_face->colors[i].pixel;
	      c++;
	    } else {
	      mappings[p] = BlackPixel(dpy, DefaultScreen(dpy));
#ifdef DEBUG_COLORS
	      printf("color %d->%d: got [%d %d %d] instead of [%d %d %d]\n",
		     (int) p, (int) current_face->colors[i].pixel,
		     (int) current_face->colors[i].red,
		     (int) current_face->colors[i].green,
		     (int) current_face->colors[i].blue,
		     (int) r, (int) g, (int) b);
#endif /* DEBUG_COLORS */
	    }
	  }
	  FrobnicateImage(dpy, DefaultScreen(dpy), &current_face->image,
			  mappings, fg, bg);
	  free(mappings);
#if 0
	  printf ("  ..%d of %d colors\n", c, current_face->ncolors);
#endif
      }
    else
      FrobnicateImage(dpy, DefaultScreen(dpy), &current_face->image, 0,
		      fg, bg);

    return BitmapSuccess;
}


/* Returns TRUE if it installed an image, FALSE otherwise.
   If the given face is NULL, uninstalls everything.
 */
Boolean show_face (w, face)
     SSMailboxWidget w;
     char *face;
{
    Display *dpy = XtDisplay(w);
    Colormap colormap = DefaultColormap(dpy, DefaultScreen(dpy));
    int status;
    if (w->ssmailbox.current_face.image != None) {
#if 0
       printf("show_face: clearing current_face\n");
#endif
       XDestroyImage (w->ssmailbox.current_face.image);
       w->ssmailbox.current_face.image = None;
       }
    if (w->ssmailbox.current_face.ncolors != 0) {
       int i;
#if 0
       printf("Freeing %d colors\n", w->ssmailbox.current_face.ncolors);
#endif
       for (i=0; i == w->ssmailbox.current_face.ncolors; i++) {
	  XFreeColors(dpy, colormap,
		      &(w->ssmailbox.current_face.colors[i].pixel),
		      1, 0);
       }
       w->ssmailbox.current_face.ncolors = 0;
    }
    if (! face) return FALSE;
    status = ReadBitmapFile (dpy, face,
			     &w->ssmailbox.current_face,
			     w->core.depth,
			     w->core.window,
			     w->ssmailbox.gc,
			     w->ssmailbox.foreground_pixel,
			     w->core.background_pixel);
    /* ### is this necessary?  I doubt it */
    XSetWindowColormap(dpy, XtWindow(w),
		       DefaultColormap(dpy, DefaultScreen(dpy)));
    if (status == BitmapSuccess) return TRUE;
    /* don't exit on error, just warn. */
    if (status == BitmapFileInvalid)
       fprintf(stderr,
	       "xbiff++: input file \"%s\" is not in bitmap format\n", face);
    else if (status == BitmapOpenFailed)
       fprintf(stderr, "xbiff++: cannot read bitmap file \"%s\"\n", face);
    else
       fprintf(stderr,
	       "xbiff++: error code %d reading bitmap file \"%s\"\n",
	       status, face);
    return FALSE;
}


static void beep (w, sounds, num, review)
    SSMailboxWidget w;
    struct MsgStruct *sounds;
    int num;
    Boolean review;
{
    struct SoundStruct *ss;
    Boolean any_sounds_matched = FALSE, any_faces_matched = FALSE;

    if (w->ssmailbox.debug == TRUE)
	fprintf(stderr, "Beeping %d msgs\n", num);

#if 0
    show_face(w, NULL); /* ditch any old faces */
#endif
    if (num == 0) {
	if (w->ssmailbox.no_mail_sound && review) {
	    play_sound (w, w->ssmailbox.no_mail_sound, w->ssmailbox.volume);
	}
	return;
    }
    else if (sounds)
	while (sounds && num)
	{
	    ss = sounds->sounds;
	    while(ss)
	    {
		if (ss->sound) {
		  if (! any_sounds_matched) {
		    if (w->ssmailbox.debug == TRUE)
		      fprintf(stderr, "Play \"%s\" at %d\n", ss->sound,
			      w->ssmailbox.volume);
		    play_sound (w, ss->sound, w->ssmailbox.volume);
		  }
		  any_sounds_matched = TRUE;
		}
		/* don't put up a new face if one is already there.  This
		   is so that a message that is matched by several regexps
		   gets the face of the first one matched, not the last.
		   As in, someone you have a face for sends mail to a mailing
		   list you are on.  If you want this case to match the mlist
		   face instead of your friend's, put the mlist first in your
		   bindings.

		   Order of fields in the message doesn't matter; we collect
		   the TO, FROM, etc fields first, then iterate through the
		   user-defined regexps comparing them.

		   it is annoying that if several messages show up at once,
		   the face corresponding to the *first* one is shown instead
		   of the *last* one.  This happens when there is mail in the
		   mailbox before XBiff is run, and when the user manually
		   rescans by clicking mouse-right.   - jwz, 10-dec-90.
		 */
		if (any_faces_matched == FALSE)
		   any_faces_matched = show_face(w, ss->face);
		ss = ss->next;
	    }
	    sounds = sounds->next;
	    --num;
	}
    if (any_sounds_matched == FALSE) {
       if (w->ssmailbox.sound) {
	  if (w->ssmailbox.debug == TRUE)
	     fprintf(stderr, "Play \"%s\" at %d\n", w->ssmailbox.sound,
		     w->ssmailbox.volume);
	  play_sound (w, w->ssmailbox.sound, w->ssmailbox.volume);
       } else {
	  if (w->ssmailbox.debug == TRUE)
	     fprintf(stderr, "Bell at %d\n", w->ssmailbox.volume);
	  XBell (XtDisplay (w), w->ssmailbox.volume);
       }
    }
    return;
}

void regerror(s)
    char *s;
{
    fprintf(stderr, "regexp(3): %s\n", s);
}
