#include <stdio.h>
#include <stdlib.h>
#ifndef WIN32
#include <unistd.h>
#endif
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/Xutil.h>
#include <X11/Xmu/CvtCache.h>
#include <X11/Xmu/Drawing.h>

#ifndef X_NOT_POSIX
#ifdef _POSIX_SOURCE
#include <limits.h>
#else
#define _POSIX_SOURCE
#include <limits.h>
#undef _POSIX_SOURCE
#endif
#endif /* X_NOT_POSIX */
#ifndef PATH_MAX
#ifdef WIN32
#define PATH_MAX 512
#else
#include <sys/param.h>
#endif
#ifndef PATH_MAX
#ifdef MAXPATHLEN
#define PATH_MAX MAXPATHLEN
#else
#define PATH_MAX 1024
#endif
#endif
#endif /* PATH_MAX */

#include "xbiff-proto.h"

static char **split_path_string XBIFFPROTO((char *));

/* This function almost completely lifted from XmuLocateBitmapFile();
 */
#if NeedFunctionPrototypes
XImage *LocateBitmapFile (Display *dpy, int screen_no, char *name,
			  char *srcname, int srcnamelen, int *widthp,
			  int *heightp, int *xhotp, int *yhotp,
			  XColor **colorsP, int *ncolorsP)
#else
XImage *LocateBitmapFile (dpy, screen_no, name, srcname, srcnamelen,
			  widthp, heightp, xhotp, yhotp, colorsP, ncolorsP)
    Display *dpy;
    int screen_no;
    char *name;
    char *srcname;			/* RETURN */
    int srcnamelen;
    int *widthp, *heightp, *xhotp, *yhotp;  /* RETURN */
    XColor **colorsP;
    int *ncolorsP;
#endif
{
#ifdef WANT_PIXMAP
    Screen *screen = ScreenOfDisplay(dpy, screen_no);
    Window root = RootWindowOfScreen (screen);
#endif
    Bool try_plain_name = True;
    XmuCvtCache *cache = _XmuCCLookupDisplay (dpy);
    char **file_paths = NULL;
    char filename[PATH_MAX];
    unsigned int width, height;
    int xhot, yhot;
    int i;

    /*
     * look in cache for bitmap path
     */
    if (cache) {
	if (!cache->string_to_bitmap.bitmapFilePath) {
	    XrmName xrm_name[2];
	    XrmClass xrm_class[2];
	    XrmRepresentation rep_type;
	    XrmValue value;

	    xrm_name[0] = XrmPermStringToQuark ("bitmapFilePath");
	    xrm_name[1] = NULLQUARK;
	    xrm_class[0] = XrmPermStringToQuark ("BitmapFilePath");
	    xrm_class[1] = NULLQUARK;
	    /*
	     * XXX - warning, derefing Display * until XDisplayDatabase
	     */
	    if (!XrmGetDatabase(dpy)) {
		/* what a hack; need to initialize it */
		(void) XGetDefault (dpy, "", "");
	    }
	    if (XrmQGetResource (XrmGetDatabase(dpy), xrm_name, xrm_class, 
				 &rep_type, &value) &&
		rep_type == XrmPermStringToQuark("String")) {
		cache->string_to_bitmap.bitmapFilePath = 
		  split_path_string (value.addr);
	    }
	}
	file_paths = cache->string_to_bitmap.bitmapFilePath;
    }


    /*
     * Search order:
     *    1.  name if it begins with / or ./
     *    2.  "each prefix in file_paths"/name
     *    3.  BITMAPDIR/name
     *    4.  name if didn't begin with / or .
     */

#ifndef BITMAPDIR
#define BITMAPDIR "/usr/include/X11/bitmaps"
#endif

    for (i = 1; i <= 4; i++) {
        int status;
	char *fn = filename;
#ifdef WANT_PIXMAP
	Pixmap pixmap;
#endif
	unsigned char *data;

	switch (i) {
	  case 1:
	    if (!(name[0] == '/' || ((name[0] == '.') && name[1] == '/')))
	      continue;
	    fn = (char *) name;
	    try_plain_name = False;
	    break;
	  case 2:
	    if (file_paths && *file_paths) {
		sprintf (filename, "%s/%s", *file_paths, name);
		file_paths++;
		i--;
		break;
	    }
	    continue;
	  case 3:
	    sprintf (filename, "%s/%s", BITMAPDIR, name);
	    break;
	  case 4:
	    if (!try_plain_name) continue;
	    fn = (char *) name;
	    break;
	}

	status = XmuReadBitmapDataFromFile (fn, &width, &height,
					    &data, &xhot, &yhot);

	if (status == BitmapSuccess) {
#ifdef WANT_PIXMAP
	    pixmap = XCreatePixmapFromBitmapData (dpy, root, (char *) data,
						  width, height,
						  fore, back, depth);
	    XFree ((char *)data);
	} else
	    pixmap = NULL;

	if (pixmap) {
#endif

	  if (widthp) *widthp = (int)width;
	  if (heightp) *heightp = (int)height;
	  if (xhotp) *xhotp = xhot;
	  if (yhotp) *yhotp = yhot;
	  if (srcname && srcnamelen > 0) {
	    strncpy (srcname, fn, srcnamelen - 1);
	    srcname[srcnamelen - 1] = '\0';
	  }
#ifdef WANT_PIXMAP
	  return pixmap;
#else
	  {
	    XImage *image = XCreateImage (dpy, DefaultVisual(dpy, screen_no),
					  1, XYBitmap, 0, (char *)data,
					  width, height,
					  8, 0);
	    /* Is this portable?  It seems necessary on my color sparc. */
	    image->bitmap_bit_order= LSBFirst;
	    image->byte_order= LSBFirst;
	    
	    return image;
	  }
#endif
	}
    }
    return None;
}

unsigned long DataSize(bpl, height, depth, format)
     int bpl, height, depth, format;
{
    if (format != ZPixmap)
	return (bpl * height * depth);
    else
	return(bpl * height);
}

void
FrobnicateImage (dpy, scr, image, color_mappings, fg, bg)
     Display *dpy;
     int scr;
     XImage **image;
     unsigned int *color_mappings, fg, bg;
{
  /*
   * Create image that matches default visual.
   */
  char *imgmem;
  XImage *new_image;
  int x, y;
  int width  = (*image)->width;
  int height = (*image)->height;
  int depth  = DefaultDepth(dpy, scr);
  int bytes_per_line = (width+31) / 8;
  int pad    = 32;
  int xoff   = 0;

  imgmem = (char *)malloc((DataSize(bytes_per_line, height, depth, ZPixmap) *
			     100));
  new_image = XCreateImage(dpy, DefaultVisual(dpy, scr), depth, ZPixmap, xoff,
			   imgmem, width, height, pad, 0 /* bytes_per_line */
			   );
  
  for (y = 0; y < height; ++y) {
    for (x = 0; x < width; ++x) {
      if (color_mappings == 0)
	XPutPixel (new_image, x, y, (XGetPixel(*image, x, y) ? fg : bg));
      else
	XPutPixel (new_image, x, y, color_mappings[XGetPixel(*image, x, y)]);
    }
  }
/*
  for (y = 0; y < height; ++y) {
    for (x = 0; x < width; ++x) {
      printf("%c", XGetPixel(new_image, x, y) ? '*' : ' ');
    }
    printf("\n");
  }
 */
  XDestroyImage (*image);
  *image = new_image;
}


/* lifted without modification from lib/Xmu/LocBitmap.c 
 */

/*
 * split_path_string - split a colon-separated list into its constituent
 * parts; to release, free list[0] and list.
 */
static char **split_path_string (src)
    register char *src;
{
    int nelems = 1;
    register char *dst;
    char **elemlist, **elem;

    /* count the number of elements */
    for (dst = src; *dst; dst++) if (*dst == ':') nelems++;

    /* get memory for everything */
    dst = (char *) malloc (dst - src + 1);
    if (!dst) return NULL;
    elemlist = (char **) calloc ((nelems + 1), sizeof (char *));
    if (!elemlist) {
	free (dst);
	return NULL;
    }

    /* copy to new list and walk up nulling colons and setting list pointers */
    strcpy (dst, src);
    for (elem = elemlist, src = dst; *src; src++) {
	if (*src == ':') {
	    *elem++ = dst;
	    *src = '\0';
	    dst = src + 1;
	}
    }
    *elem = dst;

    return elemlist;
}
