/* xscreensaver, Copyright (c) 1992, 1997, 1998
 *  Jamie Zawinski <jwz@jwz.org>
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#ifdef __STDC__
# include <stdlib.h>
# include <string.h>
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>

#undef P
#ifdef __STDC__
# define P(x)x
#else
# define P(x)()
# ifndef const
#  define const /**/
# endif
#endif

#include "resources.h"


/* Resource functions.  Assumes: */

extern char *progname;
extern char *progclass;
extern XrmDatabase db;

#ifdef __STDC__
static unsigned int get_time_resource (char *res_name, char *res_class,
				       Bool sec_p);
#endif

#ifndef isupper
# define isupper(c)  ((c) >= 'A' && (c) <= 'Z')
#endif
#ifndef _tolower
# define _tolower(c)  ((c) - 'A' + 'a')
#endif

char *
#ifdef __STDC__
get_string_resource (char *res_name, char *res_class)
#else /* !__STDC__ */
get_string_resource (res_name, res_class)
     char *res_name, *res_class;
#endif /* !__STDC__ */
{
  XrmValue value;
  char	*type;
  char full_name [1024], full_class [1024];
  strcpy (full_name, progname);
  strcat (full_name, ".");
  strcat (full_name, res_name);
  strcpy (full_class, progclass);
  strcat (full_class, ".");
  strcat (full_class, res_class);
  if (XrmGetResource (db, full_name, full_class, &type, &value))
    {
      char *str = (char *) malloc (value.size + 1);
      strncpy (str, (char *) value.addr, value.size);
      str [value.size] = 0;
      return str;
    }
  return 0;
}

Bool 
#ifdef __STDC__
get_boolean_resource (char *res_name, char *res_class)
#else /* !__STDC__ */
get_boolean_resource (res_name, res_class)
     char *res_name, *res_class;
#endif /* !__STDC__ */
{
  char *tmp, buf [100];
  char *s = get_string_resource (res_name, res_class);
  char *os = s;
  if (! s) return 0;
  for (tmp = buf; *s; s++)
    *tmp++ = isupper (*s) ? _tolower (*s) : *s;
  *tmp = 0;
  free (os);

  while (*buf &&
	 (buf[strlen(buf)-1] == ' ' ||
	  buf[strlen(buf)-1] == '\t'))
    buf[strlen(buf)-1] = 0;

  if (!strcmp (buf, "on") || !strcmp (buf, "true") || !strcmp (buf, "yes"))
    return 1;
  if (!strcmp (buf,"off") || !strcmp (buf, "false") || !strcmp (buf,"no"))
    return 0;
  fprintf (stderr, "%s: %s must be boolean, not %s.\n",
	   progname, res_name, buf);
  return 0;
}

int 
#ifdef __STDC__
get_integer_resource (char *res_name, char *res_class)
#else /* !__STDC__ */
get_integer_resource (res_name, res_class)
     char *res_name, *res_class;
#endif /* !__STDC__ */
{
  int val;
  char c, *s = get_string_resource (res_name, res_class);
  char *ss = s;
  if (!s) return 0;

  while (*ss && *ss <= ' ') ss++;			/* skip whitespace */

  if (ss[0] == '0' && (ss[1] == 'x' || ss[1] == 'X'))	/* 0x: parse as hex */
    {
      if (1 == sscanf (ss+2, "%x %c", &val, &c))
	{
	  free (s);
	  return val;
	}
    }
  else							/* else parse as dec */
    {
      if (1 == sscanf (ss, "%d %c", &val, &c))
	{
	  free (s);
	  return val;
	}
    }

  fprintf (stderr, "%s: %s must be an integer, not %s.\n",
	   progname, res_name, s);
  free (s);
  return 0;
}

double
#ifdef __STDC__
get_float_resource (char *res_name, char *res_class)
#else /* !__STDC__ */
get_float_resource (res_name, res_class)
     char *res_name, *res_class;
#endif /* !__STDC__ */
{
  double val;
  char c, *s = get_string_resource (res_name, res_class);
  if (! s) return 0.0;
  if (1 == sscanf (s, " %lf %c", &val, &c))
    {
      free (s);
      return val;
    }
  fprintf (stderr, "%s: %s must be a float, not %s.\n",
	   progname, res_name, s);
  free (s);
  return 0.0;
}


unsigned int
#ifdef __STDC__
get_pixel_resource (char *res_name, char *res_class,
		    Display *dpy, Colormap cmap)
#else /* !__STDC__ */
get_pixel_resource (res_name, res_class, dpy, cmap)
     char *res_name, *res_class;
     Display *dpy;
     Colormap cmap;
#endif /* !__STDC__ */
{
  XColor color;
  char *s = get_string_resource (res_name, res_class);
  char *s2;
  if (!s) goto DEFAULT;

  for (s2 = s + strlen(s) - 1; s2 > s; s2--)
    if (*s2 == ' ' || *s2 == '\t')
      *s2 = 0;
    else
      break;

  if (! XParseColor (dpy, cmap, s, &color))
    {
      fprintf (stderr, "%s: can't parse color %s\n", progname, s);
      goto DEFAULT;
    }
  if (! XAllocColor (dpy, cmap, &color))
    {
      fprintf (stderr, "%s: couldn't allocate color %s\n", progname, s);
      goto DEFAULT;
    }
  free (s);
  return color.pixel;
 DEFAULT:
  if (s) free (s);
  return ((strlen(res_class) >= 10 &&
	   !strcmp ("Background", res_class + strlen(res_class) - 10))
	  ? BlackPixel (dpy, DefaultScreen (dpy))
	  : WhitePixel (dpy, DefaultScreen (dpy)));
}


int
#ifdef __STDC__
parse_time (const char *string, Bool seconds_default_p, Bool silent_p)
#else /* !__STDC__ */
parse_time (string, seconds_default_p, silent_p)
     const char *string;
     Bool seconds_default_p, silent_p;
#endif /* !__STDC__ */
{
  unsigned int h, m, s;
  char c;
  if (3 == sscanf (string,   " %u : %2u : %2u %c", &h, &m, &s, &c))
    ;
  else if (2 == sscanf (string, " : %2u : %2u %c", &m, &s, &c) ||
	   2 == sscanf (string,    " %u : %2u %c", &m, &s, &c))
    h = 0;
  else if (1 == sscanf (string,       " : %2u %c", &s, &c))
    h = m = 0;
  else if (1 == sscanf (string,          " %u %c",
			(seconds_default_p ? &s : &m), &c))
    {
      h = 0;
      if (seconds_default_p) m = 0;
      else s = 0;
    }
  else
    {
      if (! silent_p)
	fprintf (stderr, "%s: invalid time interval specification \"%s\".\n",
		 progname, string);
      return -1;
    }
  if (s >= 60 && (h != 0 || m != 0))
    {
      if (! silent_p)
	fprintf (stderr, "%s: seconds > 59 in \"%s\".\n", progname, string);
      return -1;
    }
  if (m >= 60 && h > 0)
    {
      if (! silent_p)
	fprintf (stderr, "%s: minutes > 59 in \"%s\".\n", progname, string);
      return -1;
    }
  return ((h * 60 * 60) + (m * 60) + s);
}

static unsigned int 
#ifdef __STDC__
get_time_resource (char *res_name, char *res_class, Bool sec_p)
#else /* !__STDC__ */
get_time_resource (res_name, res_class, sec_p)
     char *res_name, *res_class;
     Bool sec_p;
#endif /* !__STDC__ */
{
  int val;
  char *s = get_string_resource (res_name, res_class);
  if (!s) return 0;
  val = parse_time (s, sec_p, False);
  free (s);
  return (val < 0 ? 0 : val);
}

unsigned int 
#ifdef __STDC__
get_seconds_resource (char *res_name, char *res_class)
#else /* !__STDC__ */
get_seconds_resource (res_name, res_class)
     char *res_name, *res_class;
#endif /* !__STDC__ */
{
  return get_time_resource (res_name, res_class, True);
}

unsigned int 
#ifdef __STDC__
get_minutes_resource (char *res_name, char *res_class)
#else /* !__STDC__ */
get_minutes_resource (res_name, res_class)
     char *res_name, *res_class;
#endif /* !__STDC__ */
{
  return get_time_resource (res_name, res_class, False);
}
