/* template.h -- template defines					*/
/*
 * Copyright (c) 1994  Leon Avery
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Send questions or comments on xdatplot to:
 *
 * Leon Avery
 * Department of Biochemistry
 * University of Texas Southwestern Medical Center
 * 5323 Harry Hines Blvd
 * Dallas, TX  75235-9038
 *
 * leon@eatworms.swmed.edu
 */
#ifndef	TEMPLATE_H
#define	TEMPLATE_H

#include "filter.h"

typedef	enum	TEMPL_TYPE {
    INVALID = 0,
    INTERPOLATED = 1,
}		TEMPL_TYPE;

typedef	struct	POINT {
    double	time;
    double	val;
}		POINT;

/*
 * An interpolated template consists of a sequence of time-value
 * pairs.  The continuous template is derived from this by
 * interpolation.  The points are in order of time, are normalized so
 * that the maximum and minimum values differ by 1, and are shifted so
 * that the sum is 0.  norm is the normalization factor, i.e., to
 * regenerate the original averages, multiply the points[i].val by
 * norm.  weight is the number of points that were averaged to get
 * each point.
 */
typedef	struct	TEMPL_INTER {
    TEMPL_TYPE	type;
    double	weight;
    double	norm;
    int		npoints;
    POINT	*points;
}		TEMPL_INTER;

typedef	union	TEMPL {
    TEMPL_TYPE	type;
    TEMPL_INTER	templ_inter;
}		TEMPL;

#ifdef	XtRWidget			/* Make it safe for non-X	*/
/*
 * Xwindows template functions
 */
#ifdef	__STDC__
Widget	make_template_dialog(void);
Boolean	CvtTemplateTypeToString(Display *, XrmValuePtr, Cardinal *,
				XrmValuePtr, XrmValuePtr);
Boolean	CvtStringToTemplateType(Display *, XrmValuePtr, Cardinal *,
				XrmValuePtr, XrmValuePtr);
Boolean	CvtPointListToString(Display *, XrmValuePtr, Cardinal *,
			     XrmValuePtr, XrmValuePtr);
Boolean	CvtStringToPointList(Display *, XrmValuePtr, Cardinal *,
			     XrmValuePtr, XrmValuePtr);
#else
Widget	make_template_dialog();
Boolean	CvtTemplateTypeToString();
Boolean	CvtStringToTemplateType();
Boolean	CvtPointListToString();
Boolean	CvtStringToPointList();
#endif

#define	XtRTemplateType "TemplateType"
#define	XtRPointList "PointList"

#endif	/* XtRWidget */

/*
 * X-independent template functions
 */
#ifdef	__STDC__
void	destroy_templ(TEMPL *);
char	*read_template(char *, TEMPL *);
char	*cook_template(TEMPL *, double, FILTER_VAL **, int *, int *);
#else
void	destroy_templ();
char	*read_template();
char	*cook_template();
#endif

#endif	/* TEMPLATE_H */
