#ifndef _XawSmeToggleP_h
#define _XawSmeToggleP_h

/***********************************************************************
 *
 * Sme Object Private Data
 *
 ***********************************************************************/

#include <X11/Xaw/SmeBSBP.h>
#include <X11/Xaw/ToggleP.h>
#include "SmeToggle.h"

#define OWNFILES
#define CHECKMARK "CheckMark"

#ifdef CLEANOWNFILES
# ifdef OWNFILES
#  undef OWNFILES
# endif /* OWNFILES */
#endif /* CLEANOWNFILES */

/************************************************************
 *
 * New fields for the Sme Object class record.
 *
 ************************************************************/

typedef struct _SmeToggleClassPart {
# ifdef    OWNFILES
  Pixmap  (*getbitmap)(Widget new);
# endif /* OWNFILES */
  XtPointer extension;
} SmeToggleClassPart;

/* Full class record declaration */
typedef struct _SmeToggleClassRec {
    RectObjClassPart   rect_class;
    SmeClassPart       sme_class;
    SmeBSBClassPart    sme_bsb_class;
    SmeToggleClassPart sme_toggle_class;
} SmeToggleClassRec;

extern SmeToggleClassRec smeToggleClassRec;

/* New fields for the Sme Object record */
typedef struct {
    /* resources */
    Boolean     set;
    Boolean     incomplete_notify;
    Widget      widget;
    XtPointer   radio_data;
    Pixmap      on_bitmap, off_bitmap; /* bitmaps to show left. */

/* private resources. */
    RadioGroup *radio_group;
} SmeTogglePart;

/****************************************************************
 *
 * Full instance record declaration
 *
 ****************************************************************/

typedef struct _SmeToggleRec {
  ObjectPart         object;
  RectObjPart        rectangle;
  SmePart	     sme;
  SmeBSBPart         sme_bsb;
  SmeTogglePart      sme_toggle;
} SmeToggleRec;

/************************************************************
 *
 * Private declarations.
 *
 ************************************************************/

# ifdef    OWNFILES
typedef Pixmap (*_XawEntryWidgetFunc)(Widget w);

#  define XtInheritGetBitmap   ((_XawEntryWidgetFunc) _XtInherit)
# endif /* OWNFILES */

#endif /* _XawSmeToggleP_h */
