#ifndef OBSERVE_H
# define OBSERVE_H

# include <X11/Intrinsic.h>

typedef struct _Observe Observe;
# include "players.h"
# include "games.h"

# ifndef   HAVE_NO_STDARG_H
extern void GameMessage(const Game *game, const char *Prefix, 
                        const char *Format, ...);
# else  /* HAVE_NO_STDARG_H */
void GameMessage();
# endif /* HAVE_NO_STDARG_H */

extern Observe *OpenObserve(Game *game);
extern void     DestroyObservers(Observe **observers);
extern void     InitObserve(Widget toplevel);
extern void     GotoObserve(Observe *observe, int Pos);
extern void     PassToDone(const Game *game, int Pass, int Done);
extern void     Kibitz(const Game *game, const Player *player,
                       const char *kibitz, int length);
extern int      ObserveMove(const Observe *observe);
extern void     SetTitle(const Observe *observers, const char *Text);
extern void     SetKomi(const Observe *observers, const char *Text);
extern void     SetHandicap(const Observe *observers, int handicap);
extern void     SetObserveTime(const Observe *observers, const char *Text);
extern void     SetObserveDescriptions(Observe *observers, const Game *game);
extern void     ShowPosition(const Game *game);
extern void     SetCaptures(const Game *game);
extern void     ReplayTime(unsigned long diff, Observe *observers, int nodes);
#endif /* OBSERVE_H */
