/*
  
Copyright (C) 10/1995 Klaus Hartenstein

Permission to use, copy, modify, and distribute this software and its
documentation for any purpose and without fee is hereby granted, provided
that the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.  This software is provided "as is" without express or
implied warranty.

*/

#define xresources_file
#include "xresources.h"
#include "stdio.h"
#include "stdlib.h"

#define XtNdataFile  "dataFile"
#define XtCDataFile  "DataFile"
#define XtNautoPopup "autoPopup"
#define XtCAutoPopup "AutoPopup"
#define XtNh         "help"
#define XtCH         "Help"
#define XtNshadow    "shadow"
#define XtCShadow    "Shadow"
#define XtNsavekill  "savekill"
#define XtCSavekill  "Savekill"

#define DEFAULT_FILE ".rolo"

static char *SetDefaultDataFile();

// some compilers do not like the following... :-/
//
// static  XtResource resources[]={ 
//   {
//     XtNdataFile,
//     XtCDataFile,
//     XtRString,
//     sizeof(char *),
//     XtOffset(AppDataPtr, dataFile),
//     XtRString,
//     SetDefaultDataFile()
//   },{
//     XtNautoPopup,
//     XtCAutoPopup,
//     XtRBoolean,
//     sizeof(Boolean),
//     XtOffset(AppDataPtr, autoPopup),
//     XtRImmediate,
//     (XtPointer)False
//   },{
//     XtNh,
//     XtCH,
//     XtRBoolean,
//     sizeof(Boolean),
//     XtOffset(AppDataPtr, help),
//     XtRImmediate,
//     (XtPointer)False
//   },{
//     XtNshadow,
//     XtCShadow,
//     XtRBoolean,
//     sizeof(Boolean),
//     XtOffset(AppDataPtr, shadow),
//     XtRImmediate,
//     (XtPointer)False
//   }
// };

static XtResource resources[5];

void LoadApplicationResources(Widget top)
{

  resources[0].resource_name=  XtNdataFile;
  resources[0].resource_class= XtCDataFile;
  resources[0].resource_type=  XtRString;
  resources[0].resource_size=  sizeof(char *);
  resources[0].resource_offset=XtOffset(AppDataPtr, dataFile);
  resources[0].default_type=   XtRString;
  resources[0].default_addr=   SetDefaultDataFile();
    
  resources[1].resource_name=  XtNautoPopup;
  resources[1].resource_class= XtCAutoPopup;
  resources[1].resource_type=  XtRBoolean;
  resources[1].resource_size=  sizeof(Boolean);
  resources[1].resource_offset=XtOffset(AppDataPtr, autoPopup);
  resources[1].default_type=   XtRImmediate;
  resources[1].default_addr=   (XtPointer)False;
    
  resources[2].resource_name=  XtNh;
  resources[2].resource_class= XtCH;
  resources[2].resource_type=  XtRBoolean;
  resources[2].resource_size=  sizeof(Boolean);
  resources[2].resource_offset=XtOffset(AppDataPtr, help);
  resources[2].default_type=   XtRImmediate;
  resources[2].default_addr=   (XtPointer)False;
    
  resources[3].resource_name=  XtNshadow;
  resources[3].resource_class= XtCShadow;
  resources[3].resource_type=  XtRBoolean;
  resources[3].resource_size=  sizeof(Boolean);
  resources[3].resource_offset=XtOffset(AppDataPtr, shadow);
  resources[3].default_type=   XtRImmediate;
  resources[3].default_addr=   (XtPointer)False;
    
  resources[4].resource_name=  XtNsavekill;
  resources[4].resource_class= XtCSavekill;
  resources[4].resource_type=  XtRBoolean;
  resources[4].resource_size=  sizeof(Boolean);
  resources[4].resource_offset=XtOffset(AppDataPtr, savekill);
  resources[4].default_type=   XtRImmediate;
  resources[4].default_addr=   (XtPointer)False;
    
  XtGetApplicationResources(top,
                            (XtPointer)&app_data,
                            resources,
                            XtNumber(resources),
                            NULL, 0);
}

/********************************************************************************
 * set default filename for data file
 ********************************************************************************/
static char *SetDefaultDataFile()
{
  char *filename;
  char *str = getenv("HOME");
  filename = (char *)calloc((strlen(str) + strlen(DEFAULT_FILE) + 3),
			    sizeof(char));
  sprintf(filename, "%s/%s", str, DEFAULT_FILE);
  return(filename);
}
