/*
 *   xmmix - Motif(tm) Audio Mixer
 *
 *   Copyright (C) 1994-1996  Ti Kan
 *   E-mail: ti@amb.org
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __MIXER_H__
#define __MIXER_H__

#ifndef LINT
static char *_mixer_h_ident_ = "@(#)mixer.h	3.2 96/07/14";
#endif


#define FS_LOAD		1		/* File selection mode: Load */
#define FS_SAVE		2		/* File selection mode: Save */


#define MAXDEVS		32		/* Max devices supported */
#define MAXDEVS_V2	12		/* VoxWare 2.x SOUND_MIXER_NRDEVICES */
#define MAXDEVS_V3	17		/* VoxWare 3.x SOUND_MIXER_NRDEVICES */


/* Structure of control state information */
typedef struct {
	int		devmask;	/* Mixer feature mask */
	int		recmask;	/* Recording source capability mask */
	int		recsrc;		/* Recording source selector */
	int		stereodevs;	/* Stereo source capability mask */
	int		caps;		/* Capability flags */
	int		enhance;       	/* Stereo enhance setting */
	bool_t		mute;		/* Mute setting */
	bool_t		loudness;	/* Loudness setting */
	struct {
		int	left;		/* Left slider setting */
		int	right;		/* Right slider setting */
		bool_t	locked;		/* Sliders locked */
	} slinfo[MAXDEVS];
} ctlinfo_t;


/* Public functions */
extern void	mx_init_drv(void);
extern void	mx_init_hw(widgets_t *);
extern void	mx_start(widgets_t *);

/* Callback functions */
extern void	mx_slider_l(Widget, XtPointer, XtPointer);
extern void	mx_slider_r(Widget, XtPointer, XtPointer);
extern void	mx_lock_btn(Widget, XtPointer, XtPointer);
extern void	mx_play_btn(Widget, XtPointer, XtPointer);
extern void	mx_rec_btn(Widget, XtPointer, XtPointer);
extern void	mx_flat_btn(Widget, XtPointer, XtPointer);
extern void	mx_mute_btn(Widget, XtPointer, XtPointer);
extern void	mx_loud_btn(Widget, XtPointer, XtPointer);
extern void	mx_enhance_btn(Widget, XtPointer, XtPointer);
extern void	mx_load(Widget, XtPointer, XtPointer);
extern void	mx_save(Widget, XtPointer, XtPointer);
extern void	mx_exit(Widget, XtPointer, XtPointer);
extern void	mx_reset(Widget, XtPointer, XtPointer);
extern void	mx_manpg(Widget, XtPointer, XtPointer);
extern void	mx_about(Widget, XtPointer, XtPointer);
extern void	mx_fsok_btn(Widget, XtPointer, XtPointer);
extern void	mx_fscancel_btn(Widget, XtPointer, XtPointer);
extern void	mx_focuschg(Widget, XtPointer, XtPointer);

#endif	/* __MIXER_H__ */

