/*
  Xquote Copyright (c) 1997 Mark Buser,
  All Rights Reserved.

  Permission is hereby granted to copy
  and freely distribute copies of this
  program for non-commercial purposes
  without fee, provided that this notice
  appears in all copies.
  
  All redistributions must be in their
  entirety as originally distributed.
  Feel free to modify Xquote, but
  modified versions may not be distributed
  without prior consent of the author.
  
  This software is provided 'as-is'
  without any express or implied warranty.
  In no event will the author be held
  liable for any damages resulting from
  the use of this software.

  $Revision: 1.4 $ $Date: 1997/10/13 11:36:17 $
*/

#include <Xm/XmAll.h>

#include "optupdate.h"
#include "session.h"
#include "xutil.h"

/* 
** File app menu support 
*/

/* ARGSUSED */
void fileCB( Widget w, int menu_pos, XtPointer call_data)
{
  switch (menu_pos) {

    case 0: /* Update from network now */
            triggerUpdate (TRIGGER_REFRESH, (XtIntervalId)NULL);
            break;

    case 1: /* Stop Update */
            triggerUpdate (TRIGGER_STOP, (XtIntervalId)NULL);
            break;

    case 2: /* Manual Save State */
            { 
              char *filename = sessSaveFile (True);
              saveState (filename);
              XtFree (filename);
            }
            break;

    case 3: /* Log to File */
            break;

    case 4: /* End Log to File */
            break;

    case 5: /* Quit */
#if XtSpecificationRelease > 5
            /* close session connection before quitting */
            XtVaSetValues ( GetTopShell(w), XtNjoinSession, False, NULL);
            XtCallCallbacks ( GetTopShell(w), XtNdieCallback, NULL);
#endif
            exit (0);
            break;
  
    default:
            break;
  }
}
