diff -ruPN 9.00/ButtonBox.c 9.01/ButtonBox.c
--- 9.00/ButtonBox.c	Thu Jun  5 07:11:34 1997
+++ 9.01/ButtonBox.c	Sun Mar 22 14:03:06 1998
@@ -71,6 +71,19 @@
     XtManageChild(w);
 }
 
+void ButtonBoxEmpty(w)
+     Widget w;
+{
+  WidgetList children;
+  Cardinal num_children;
+  
+  XtVaGetValues(w, XtNchildren, &children,
+		XtNnumChildren, &num_children, 0);
+
+  while (num_children-- >= 1)
+    XtDestroyWidget(children[num_children]);
+}
+
 void ButtonBoxDestroy(w)
     Widget w;
 {
diff -ruPN 9.00/ButtonBox.h 9.01/ButtonBox.h
--- 9.00/ButtonBox.h	Thu Jun  5 07:11:34 1997
+++ 9.01/ButtonBox.h	Sun Mar 22 13:37:16 1998
@@ -9,6 +9,7 @@
 extern Widget	ButtonBoxAddButton	_ARGUMENTS((String, XtCallbackRec *,
 						    Widget));
 extern void	ButtonBoxDoneAdding	_ARGUMENTS((Widget));
+extern void	ButtonBoxEmpty		_ARGUMENTS((Widget));
 extern void	ButtonBoxDestroy	_ARGUMENTS((Widget));
 
 #endif /* _BUTTONBOX_H_ */
diff -ruPN 9.00/Buttons.c 9.01/Buttons.c
--- 9.00/Buttons.c	Sun Jun 29 13:30:11 1997
+++ 9.01/Buttons.c	Sun Mar 22 18:47:20 1998
@@ -1,6 +1,6 @@
 
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: Buttons.c,v 1.4 1997/06/29 17:30:11 jik Exp $";
+static char XRNrcsid[] = "$Id: Buttons.c,v 1.5 1998/03/22 23:47:20 jik Exp $";
 #endif
 
 /*
@@ -293,6 +293,8 @@
     int j, i = 0;
     Widget button;
 
+    ButtonBoxEmpty(box);
+
     if (resource) {
 	ptr = resource;
 
@@ -303,12 +305,13 @@
 		  if (buttonList[j].active) {
 		    button = ButtonBoxAddButton(buttonList[j].name,
 						buttonList[j].callbacks, box);
-		    if (infoLine == TOP) {
+		    if (buttonList[j].message)
+		      if (infoLine == TOP) {
 			setTopInfoLineHandler(button, buttonList[j].message);
-		    } else {
+		      } else {
 			setBottomInfoLineHandler(button,
 						 buttonList[j].message);
-		    }
+		      }
 		    i++;
 		  }
 		  break;
@@ -326,11 +329,12 @@
 	  if (buttonList[i].active) {
 	    button = ButtonBoxAddButton(buttonList[i].name,
 					buttonList[i].callbacks, box);
-	    if (infoLine == TOP) {
+	    if (buttonList[i].message)
+	      if (infoLine == TOP) {
 		setTopInfoLineHandler(button, buttonList[i].message);
-	    } else {
+	      } else {
 		setBottomInfoLineHandler(button, buttonList[i].message);
-	    }
+	      }
 	  }
 	}
     }
diff -ruPN 9.00/COMMON-PROBLMS 9.01/COMMON-PROBLMS
--- 9.00/COMMON-PROBLMS	Sun Oct 19 18:28:50 1997
+++ 9.01/COMMON-PROBLMS	Fri Jan 23 14:43:20 1998
@@ -1,5 +1,5 @@
 
-$Id: COMMON-PROBLMS,v 1.12 1997/10/19 22:28:50 jik Exp $
+$Id: COMMON-PROBLMS,v 1.13 1998/01/23 19:43:20 jik Exp $
 
 List of Common Problems:
 
@@ -23,7 +23,7 @@
     You are using an old version of the X11 libraries (e.g., you're
     using SunOS 4.x).  As noted in the README file, XRN requires at
     least X11R5 to work properly.  You need to get a newer version of
-    X11 (e.g., the X11R6.1 release from the X Consortium), compile and
+    X11 (e.g., the X11R6.3 release from the Open Group), compile and
     install it, and link XRN against it.
 
 *.  You are linking XRN against INN's libraries, and you get errors
diff -ruPN 9.00/CREDITS 9.01/CREDITS
--- 9.00/CREDITS	Wed Dec 31 19:00:00 1969
+++ 9.01/CREDITS	Sun Mar 22 10:47:49 1998
@@ -0,0 +1,125 @@
+I would like to thank the following people, in no particular order,
+who have contributed to XRN in minor and major ways over the years.
+	
+		      *************************
+
+Rick Spickelmier and Ellen Santovich, the original authors and
+	maintainers of XRN
+Odd Einar Aurbakken <oea@ifi.uio.no>, who contributed numerous bug
+	reports and fixes, and who did the Good Net-Keeping Seal of
+	Approval review for XRN
+Nicolas Courtel <courtel@cenatls.cena.dgac.fr>, who contributed the
+	initial patches for French language support
+Jean-Marc.Lasgouttes@inria.fr
+Michel Eyckmans <mce@tornado.be>, who contributed numerous
+	suggestions, bug reports, fixes and enhancements, including
+	support for nested kill files
+Jens.Schleusener@dlr.de
+Adrian T. Filipi-Martin <atf3r@stretch.cs.virginia.edu>
+Albert Chin-A-Young <chinay@cig.mot.com>
+Zdenek Sekera <zdenek@patpsun1.epfl.ch>
+Taed Nelson <nelson@lan.nsc.com>
+Thorsten Frueauf <frueauf@ira.uka.de>
+Tim <tda10@cus.cam.ac.uk>
+Rob Leland <root@dial-in.nw.dc.us>
+Rein Tollevik <reint@a.sn.no>
+Steven Tepper <greep@datatools.com>
+John Robert LoVerso <loverso@osf.org>
+Reg Clemens <reg@dwf.com>
+Chris Lewis <clewis@bnr.ca>, who contributed various fixes and the
+	initial support for NNTP authentication
+Kay Marquardt <kay@zhv.basf-ag.de>, who contributed various bug
+	reports, fixes and enhancements, including the initial patches
+	for German language support and numerous updates to them
+Glen Reesor <glenr@cu74.crl.aecl.ca>
+Ralph R. Swick <swick@x.org>, who contributed various changes to make
+	XRN more "X compliant", including updates for new Xaw/Xt
+	versions and support for the X11R6 session manager
+Randy Coulman <coulman@skdad.usask.ca>
+Matt Bush <xomox@boris.eden.com>
+Vincent Archer <archer@cett.alcatel-alsthom.fr>
+Phil Gross <phigro@phigro.rnd.symix.com>
+Per Hedeland <per@erix.ericsson.se>, who contributed numerous bug
+	reports, fixes and enhancements
+Mike Yang <mikey@euky.engr.sgi.com>
+Lucas James  <jj@ldjpc.apana.org.au>
+mikes@bioch.ox.ac.uk
+carson@lehman.com
+David W. Schuler <dschuler@VNET.IBM.COM>
+Brian Rice <bri@whitestone.com>
+Jay Vassos-Libove <libove@libove.mindspring.com>
+Alan Rooks <vedge!alan@iros1.IRO.UMontreal.CA>
+Gerhard Niklasch <nikl@pchelwig1.mathematik.tu-muenchen.de>, who
+	contributed bug reports, fixes, and major revisions to the
+	German language support and a major clean-up to the English
+	language support as well
+Thomas.Foks@hub.de
+Daniel Kabs <kabs@physik.uni-kl.de>
+Paul Kirkaas <pki@malibu.cri.dk>
+Wayne D Richardson <wdr@VNET.IBM.COM>
+Philippe Brieu <philippe@pablo.physics.lsa.umich.edu>
+Gordon Berkley <gordonb@mcil.comm.mot.com>
+Richard Lloyd <R.K.Lloyd@csc.liv.ac.uk>
+Charles R. Dennett <dennett@image.Kodak.COM>
+Ivar Ruyter <ivarr@troll.hz.kfa-juelich.de>
+George Ross <gdmr@dcs.ed.ac.uk>
+Stan Smith <ssmith@gothamcity.jsc.nasa.gov>
+Brian V. Smith <envbvs@epb1.lbl.gov>
+Michael.Salmon@eos99.ericsson.se
+Davin Milun <milun@cs.Buffalo.EDU>
+Clemmitt Sigler <siglercm@alphamb.phys.vt.edu>
+Richard Dyson <dyson@sunfish.physics.uiowa.edu>
+Chris Sherman <sherman@unx.sas.com>
+Philippe Michel <michel@thomson-lcr.fr>
+sturle.sunde@usit.uio.no
+Gerry.Tomlinson@newcastle.ac.uk
+dbrooks@ics.com
+Kurt J. Lidl <lidl@va.pubnix.com>
+Brad_Appleton-GBDA001@email.mot.com
+Jim Berilla <jb@falstaff.MAE.cwru.edu>
+Alain Nissen <nissen@montefiore.ulg.ac.be>
+Harald Leinders <hl@arthur.ph2.Uni-Koeln.DE>
+Klaus Hartmuth <klaus@gauguin.legg.u-nancy.fr>
+Richard Allen <ra@os.is>
+David.Starks-Browning@EMBL-Heidelberg.de
+Axel Nennker <nennker@cs.tu-berlin.de>
+Paul Mauschbaugh <mush@sunota.cat.com>
+Marcin.Skubiszewski@inria.fr
+John DiMarco <jdd@cdf.toronto.edu>
+Masahiko Suenaga <f77266a@kyu-cc.cc.kyushu-u.ac.jp>
+Vyacheslav Shubinsky <slava@usgs.gov>
+Wolfgang Roeckelein <wolfgang@wi.WHU-Koblenz.de>
+Robert Broughton <bob@zadall.com>
+Daniel Israel <daniel@neptune.ame.arizona.edu>
+Mike O'Brien <obrien@leonardo.net>
+Hugues.Leroy@irisa.fr
+Michael Schmitz <schmitz@ph-cip.Uni-Koeln.DE>
+Konstantin Laufer <laufer@math.luc.edu>
+Paul Menage <pbm1001@hermes.cam.ac.uk>
+Joseph F. Backo <jback@tristan.corsair.com>
+Raphael.Quinet@eed.ericsson.se
+Ken Fox <kfox@ford.com>
+Volker Borchert <bt@teknon.de>
+Clarence W. Wilkerson <wilker@math.purdue.edu>
+Anton Ertl <anton@mips.complang.tuwien.ac.at>
+Mike Abbott <mja@trudge.engr.sgi.com>
+Franz.Mauch@uni-konstanz.de
+Jozsef Kadlecsik <kadlec@blackhole.kfki.hu>
+Joe Konstan <konstan@cs.umn.edu>
+David A. Curry <davy@ecn.purdue.edu>
+Phil Garner <garner@signal.dra.hmg.gb>
+Richard Mitchell <mitchell@aol14.wff.nasa.gov>
+Chris Torek <torek@purr.bsdi.com>
+Alec Wolman <wolman@cs.washington.edu>
+Marc Pawliger <pawliger@mv.us.adobe.com>
+Gedaliah Friedenberg <gedaliah@panix.com>
+uri@watson.ibm.com
+Olivier David <olivier@lise.paris.sgi.com>
+Kevin Brannen <kevin@inetspace.com>
+
+		      *************************
+
+I am indebted to everyone who sends me feedback of any sort about
+XRN.  Please don't hesitate to contact me!
+
+  Jonathan Kamens
diff -ruPN 9.00/ChangeLog 9.01/ChangeLog
--- 9.00/ChangeLog	Wed Jan 14 22:03:41 1998
+++ 9.01/ChangeLog	Mon May 25 10:34:04 1998
@@ -1,10 +1,87 @@
+1998-05-25  Jonathan I. Kamens  <jik@kamens.brookline.ma.us>
+
+	* Significant user-visible changes in XRN 9.01:
+
+	** Bug fixes:
+
+	* The amount of memory used when threading a newsgroup with many
+	unavailable articles has been greatly reduced.
+
+	* Threading while prefetching a newsgroup (i.e., threading
+	newsgroup B in the background while reading newsgroup A) now works
+	properly; previously, a newsgroup would not be threaded until the
+	user actually went to read it.
+
+	* Some minor improvements to newsgroup prefetching and fetching,
+	including some speed improvements, have been made.
+
+	* When the "Date" header field of articles is being converted into
+	the local timezone, XRN will no longer delete the final newline
+	from the field and thus cause it to be concatenated to the next
+	line in the article header.
+
+	* A newsrc corruption problem caused by a bug in gcc 2.8.1 on
+	Solaris has been fixed by introducing a workaround.
+
+	* The rot13 function will no longer rotate non-ASCII characters.
+
+	* Some memory leaks and questionable memory references have been
+	fixed.
+
+
+	** Enhancements:
+
+	* XRN is now compliant with the "Good Net-Keeping Seal of
+	Approval" (<http://www.xs4all.nl/~js/gnksa/>).
+
+	* Automatic scrolling of the Subject list in Article mode now
+	notices what direction the cursor is moving and scrolls only in
+	that direction.
+
+	* The German language support in XRN has been improved.
+
+	* Some support for a French version of XRN has been added,
+	although it is incomplete (it will compile and run, but some
+	messages will be in English rather than French).
+
+	* A CREDITS file, listing all of the people who have contributed
+	to XRN, has been added.
+
+	* When composing a response to an article, the user can now switch
+	between posting it, mailing it, and both posting and mailing it.
+
+	* "From" lines in outgoing postings are now checked for validity
+	before the messages are sent.
+
+	* XRN now detects and warns about attempts to post or mail
+	messages with no body.
+
+	* XRN now detects and warns about attempts to post messages
+	containing only included text.
+
+	* When a message is both posted and mailed, XRN now inserts a note
+	at the beginning of the mailed copy indicating that it is a
+	courtesy copy of a message that was also posted.
+
+
+	** Changes in functionality:
+
+	* Instead of putting a long label on the Information window, it
+	now displays a message the first time it pops up, informing the
+	user that it can be left up or dismissed.
+
+	* When the NNTP server name is appended to the newsrc file name,
+	it is now also appended to the lock and save file names.  This
+	makes it easier to run multiple XRNs at the same time talking to
+	different NNTP servers.
+
 1998-01-14  Jonathan I. Kamens  <jik@kamens.brookline.ma.us>
 
 	*** Significant user-visible changes in XRN 9.00 (some changes are
 	not listed; consult the XRN man page for additional information
 	about these changes):
 
-	
+
 	** Enhancements:
 
 	* Article threading and sorting
@@ -20,7 +97,7 @@
 	Article sorting by subject has been sped up significantly.
 
 	* Improved caching of fetched articles
-	
+
 	Article files are now stored in a rotating article cache whose
 	size and number of files can be configured by the user (see
 	"cacheFilesMaxFiles" and "cacheFilesMaxSize" in the man page).
@@ -32,14 +109,14 @@
 	to save or print it).
 
 	* Improved authentication support
-	
+
 	Username/password authentication, using the "AUTHINFO USER" and
 	"AUTHINFO PASS" NNTP commands, is now supported.  A new
 	compile-time config.h option, ALLOW_RESOURCE_PASSWORDS, controls
 	whether the user is allowed to encode passwords in X resources.
 
 	* Improved-kill support
-	
+
 	Kill-file entries can now compare against the "Newsgroups",
 	"Date", "Message-ID", "References", and "Xref" header fields in
 	addition to the "From" and "Subject" fields.  Furthermore, the 'h'
@@ -58,7 +135,7 @@
 	A kill file can now include other kill files.
 
 	* Enhancements to Article mode
-	
+
 	An error message is now displayed when the user attempts to cancel
 	a message he is not authorized to cancel.
 
@@ -78,7 +155,7 @@
 	All mode).
 
 	* Enhancements to All mode
-	
+
 	A "Search" button and key binding ('/') has been added.
 
 	A "Limit" button and corresponding 'l' binding has been added, to
@@ -86,7 +163,7 @@
 	specified regular expression.
 
 	* Enhancements to multiple modes
-	
+
 	Newsgroup and subject list widths are now adjusted automatically
 	when the XRN window is resized.
 
@@ -105,11 +182,11 @@
 	for individual articles to XHDR requests.  A server shouldn't do
 	that, but XRN tries to handle those that do.
 
-	
+
 	** Bug fixes:
 
 	* Don't falsly claim that there are no articles in a newsgroup.
-	
+
 	* Don't hang forever when prefetching a newsgroup with lots of
 	unread but unavailable articles in it.
 
@@ -145,9 +222,9 @@
 	* Don't coredump when encountering newsgroups with really long
 	names.
 
-	
+
 	** Changes in functionality:
-	
+
 	* To improve performance, NNTP_REREADS_ACTIVE_FILE is now defined
 	by default in config.h.  Sites running very old NNTP servers which
 	do not reread the active file each time the client sends a LIST
@@ -180,7 +257,7 @@
 	* Conversion of backspace characters, pagebreak characters, or the
 	"Date" field no longer takes place when an article is being saved
 	or piped.
-	
+
 Thu May  9 17:48:38 1996  Jonathan Kamens  <jik@annex-1-slip-jik.cam.ov.com>
 
 	*** Significant user-visible changes in XRN 8.02:
@@ -1074,4 +1151,4 @@
 	Always include article text when calling an external editor
 	command.  Fix from per@erix.ericsson.se (Per Hedeland).
 
-# $Id: ChangeLog,v 1.122 1998/01/15 03:03:41 jik Exp $
+# $Id: ChangeLog,v 1.127 1998/05/25 14:34:03 jik Exp $
diff -ruPN 9.00/Imakefile 9.01/Imakefile
--- 9.00/Imakefile	Thu Jan 15 21:57:57 1998
+++ 9.01/Imakefile	Wed Jan 28 22:06:12 1998
@@ -1,5 +1,5 @@
 /*
- * $Id: Imakefile,v 1.123 1998/01/16 02:57:57 jik Exp $
+ * $Id: Imakefile,v 1.124 1998/01/29 03:05:57 jik Exp $
  *
  * xrn - an X-based NNTP news reader
  *
@@ -55,10 +55,11 @@
 
 /*
  * What language do you want messages to be in?  Legal values are
- * "english" and "german"; case is significant!
+ * "english", "german", and "french"; case is significant!
  */
 LANGUAGE= english
 /* LANGUAGE= german */
+/* LANGUAGE= french */
 
 #ifdef BandAidCompiler
 #include BandAidCompiler
diff -ruPN 9.00/InfoLine.c 9.01/InfoLine.c
--- 9.00/InfoLine.c	Thu Jun  5 07:11:34 1997
+++ 9.01/InfoLine.c	Wed Jan 28 19:53:22 1998
@@ -59,16 +59,25 @@
     Widget w;
     String text;
 {
+    char *newString = XtNewString(text), *ptr;
 #ifdef MOTIF
     XmString x;
+#endif
+
+    /* Info lines are one line long, so they can't have newlines in them,
+       and tabs just waste space. */
+    for (ptr = strpbrk(newString, "\n\t"); ptr; ptr = strpbrk(newString, "\n\t"))
+      *ptr = ' ';
 
+#ifdef MOTIF
     /* Yes, I know this is an old function and not the preferred way, but for now...kb */
-    x = XmStringCreateSimple(text);
+    x = XmStringCreateSimple(newString);
     XtVaSetValues(w, XmNlabelString, x, 0);
     XmStringFree(x);
 #else
-    XtVaSetValues(w, XtNlabel, text, 0);
+    XtVaSetValues(w, XtNlabel, newString, 0);
 #endif
+    XtFree(newString);
 }
 
 void InfoLineDestroy(widget)
diff -ruPN 9.00/Makefile 9.01/Makefile
--- 9.00/Makefile	Thu Jan 15 21:58:19 1998
+++ 9.01/Makefile	Thu Jan 29 16:31:25 1998
@@ -2,7 +2,7 @@
 # $TOG: imake.c /main/97 1997/06/20 20:23:51 kaleb $
 
 # ----------------------------------------------------------------------
-# Makefile generated from "Imake.tmpl" and </tmp/IIf.a24158>
+# Makefile generated from "Imake.tmpl" and </tmp/IIf.a16567>
 # $TOG: Imake.tmpl /main/245 1997/05/20 10:05:47 kaleb $
 #
 #
diff -ruPN 9.00/TODO 9.01/TODO
--- 9.00/TODO	Wed Dec 24 19:19:41 1997
+++ 9.01/TODO	Tue May 12 07:34:15 1998
@@ -1,9 +1,19 @@
 
-$Id: TODO,v 1.192 1997/12/25 00:19:41 jik Exp $
+$Id: TODO,v 1.199 1998/05/12 11:34:15 jik Exp $
 
 The Ever growing list of things that should be done and things that would 
 be nice if they were done.... (and even worse, it's not up to date)
 
+- Allow the user to retry after mistyping his NNTP password.
+- Allow users to Supersede their own articles, similar to their
+  current ability to cancel their own articles.
+- Make XRN behave better in the face of groups in the active file
+  which claim to have many more unread articles than they actually do
+  because the active file hasn't been renumbered.
+- Make it possible to undo changes made to a newsgroup after exiting
+  the group.
+- Make XRN display a list of valid distributions (or make the list
+  available to the user in some other way) while composing a posting.
 - Support a separate colormap for XRN.
 - XRN should notice when the contents of a THRU line makes no sense,
   and ignore it if so.
@@ -170,17 +180,6 @@
   it in the list whenever updating all mode.
 - Support WM_DELETE_WINDOW.  Suggested by nissen@montefiore.ulg.ac.be
   (Alain Nissen).
-- Append the NNTP server name to saveNewsrcFile and to lockFile just
-  as it's appended to newsrcFile, so that when using multiple news
-  servers, just specifying a different nntpServer is enough for
-  everything to work.
-
-  Note that we should only append the NNTP server name to
-  saveNewsrcFile and lockFile if we found a newsrcfile with the NNTP
-  server name appended to it.  That way, multiple XRN processes will
-  not try to write to a non-extended newsrcFile at the same time.
-
-  Suggested by nissen@montefiore.ulg.ac.be (Alain Nissen).
 - Display newsgroup descriptions somehow in all mode and/or newsgroup
   mode. and/or add mode.
 - Allow subject index and article text fonts to be specified on a
diff -ruPN 9.00/XRn.src 9.01/XRn.src
--- 9.00/XRn.src	Thu Jan 15 21:36:45 1998
+++ 9.01/XRn.src	Mon May 25 11:12:43 1998
@@ -1,8 +1,8 @@
 !
-! $Id: XRn.src,v 1.168 1998/01/16 02:36:44 jik Exp $
+! $Id: XRn.src,v 1.178 1998/05/25 15:12:43 jik Exp $
 !
-MOTIFxAPP_CLASSx.version:			9.00 (Motif)
-XAWxAPP_CLASSx.version:			9.00
+MOTIFxAPP_CLASSx.version:			9.01 (Motif)
+XAWxAPP_CLASSx.version:			9.01
 xAPP_CLASSx.Geometry:			680x700
 *breakLength:			0
 *font:			8x13
@@ -291,231 +291,349 @@
 
 ! button names
 LANG_english*addQuit.label:		Quit
-LANG_german*addQuit.label:		Gruppenauswahl
+LANG_french*addQuit.label:		Pas d'abonnement
+LANG_german*addQuit.label:		Auswahl beenden
 LANG_english*addIgnoreRest.label:	Ignore rest
+LANG_french*addIgnoreRest.label:	Ignore rest
 LANG_german*addIgnoreRest.label:	Rest ignorieren
 LANG_english*addFirst.label:		Add first
-LANG_german*addFirst.label:		an den Anfang
+LANG_french*addFirst.label:		Ajouter en tte
+LANG_german*addFirst.label:		Abo, Anfang
 LANG_english*addLast.label:		Add last
-LANG_german*addLast.label:            ans Ende
+LANG_french*addLast.label:		Ajouter en queue
+LANG_german*addLast.label:		Abo, Ende
 LANG_english*addAfter.label:		Add after group
-LANG_german*addAfter.label:           Plazieren
+LANG_french*addAfter.label:		Ajouter aprs le groupe
+LANG_german*addAfter.label:		Abo&plazieren
 LANG_english*addUnsub.label:		Add unsubscribed
-LANG_german*addUnsub.label:		Gruppe verwerfen
+LANG_french*addUnsub.label:		Ajouter non abonn
+LANG_german*addUnsub.label:		Nicht abonnieren
 LANG_english*addIgnore.label:		Ignore
+LANG_french*addIgnore.label:		Ignore
 LANG_german*addIgnore.label:		Ignorieren
 
 LANG_english*ngQuit.label:		Quit
+LANG_french*ngQuit.label:		Quitter
 LANG_german*ngQuit.label:		Beenden
 LANG_english*ngRead.label:		Read
-LANG_german*ngRead.label:		Gruppe lesen
+LANG_french*ngRead.label:		Lire groupe
+LANG_german*ngRead.label:		NG lesen
 LANG_english*ngNext.label:		Next
-LANG_german*ngNext.label:		n\344chste Gruppe
+LANG_french*ngNext.label:		Suivant
+LANG_german*ngNext.label:		N\344chste NG
 LANG_english*ngPrev.label:		Prev
-LANG_german*ngPrev.label:		vorherige Gruppe
+LANG_french*ngPrev.label:		Prcdent
+LANG_german*ngPrev.label:		Vorige NG
 LANG_english*ngCatchUp.label:		Catch up
-LANG_german*ngCatchUp.label:		Gruppe gelesen
+LANG_french*ngCatchUp.label:		Rattraper
+LANG_german*ngCatchUp.label:		Alles gelesen
 LANG_english*ngSubscribe.label:		Subscribe
-LANG_german*ngSubscribe.label:                Gruppe abonnieren
+LANG_french*ngSubscribe.label:		S'abonner
+LANG_german*ngSubscribe.label:		NG abonnieren
 LANG_english*ngUnsub.label:		Unsubscribe
-LANG_german*ngUnsub.label:		Gruppe verwerfen
+LANG_french*ngUnsub.label:		Se dsabonner
+LANG_german*ngUnsub.label:		NG abbestellen
 LANG_english*ngGoto.label:		Goto group
-LANG_german*ngGoto.label:		gehe zu Gruppe
+LANG_french*ngGoto.label:		Aller au groupe
+LANG_german*ngGoto.label:		Gehe zu NG
 LANG_english*ngListOld.label:		List old
-LANG_german*ngListOld.label:          abonnierte Gruppen
+LANG_french*ngListOld.label:		Groupes abonns
+LANG_german*ngListOld.label:		Alle Abos zeigen
 LANG_english*ngAllGroups.label:		All groups
-LANG_german*ngAllGroups.label:		Gruppen\374bersicht
+LANG_french*ngAllGroups.label:		Tous les groupes
+LANG_german*ngAllGroups.label:		Alle NG zeigen
 LANG_english*ngRescan.label:		Rescan
-LANG_german*ngRescan.label:		Server abfragen
+LANG_french*ngRescan.label:		Rafrachir
+LANG_german*ngRescan.label:		Serverabfrage
 LANG_english*ngGetList.label:		Get newsgroup list
-LANG_german*ngGetList.label:		Hole Newsgruppen Liste
+LANG_french*ngGetList.label:		Get newsgroup list
+LANG_german*ngGetList.label:		Hole NG-Liste
 LANG_english*ngPrevGroup.label:		Prev group
-LANG_german*ngPrevGroup.label:		vorherige Gruppe
+LANG_french*ngPrevGroup.label:		Groupe prcdent
+LANG_german*ngPrevGroup.label:		Zuletzt gelesene NG
 LANG_english*ngSelect.label:		Select groups
-LANG_german*ngSelect.label:		Merken
+LANG_french*ngSelect.label:		Slectionner groupes
+LANG_german*ngSelect.label:		Vormerken
 LANG_english*ngMove.label:		Move
+LANG_french*ngMove.label:		Dplacer
 LANG_german*ngMove.label:		Verschieben
 LANG_english*ngExit.label:		Exit
-LANG_german*ngExit.label:		Verlassen
+LANG_french*ngExit.label:		Terminer
+LANG_german*ngExit.label:		Abbrechen
 LANG_english*ngCheckPoint.label:	Checkpoint
-LANG_german*ngCheckPoint.label:		Aktualisieren
+LANG_french*ngCheckPoint.label:		Point de contrle
+LANG_german*ngCheckPoint.label:		Liste sichern
 LANG_english*ngPost.label:		Post
-LANG_german*ngPost.label:		Artikel ver\366ffentlichen
+LANG_french*ngPost.label:		Poster
+LANG_german*ngPost.label:		Neuer Artikel
 LANG_english*ngPostAndMail.label:	Post & Mail
-LANG_german*ngPostAndMail.label:	Ver\366ffentlichen & Versenden
+LANG_french*ngPostAndMail.label:	Post & Mail
+LANG_german*ngPostAndMail.label:	Neuer Art.&EMail
 LANG_english*ngMail.label:		Send Mail
-LANG_german*ngMail.label:		Sende E-Mail
+LANG_french*ngMail.label:		Send Mail
+LANG_german*ngMail.label:		EMail
 LANG_english*ngGripe.label:		Gripe
-LANG_german*ngGripe.label:            Nachricht an XRN-Betreuer
+LANG_french*ngGripe.label:		Rler
+LANG_german*ngGripe.label:		XRN-Betreuer
 LANG_english*ngScroll.label:		Scroll forward
-LANG_german*ngScroll.label:		Seite nach unten
+LANG_french*ngScroll.label:		Ascenseur avant
+LANG_german*ngScroll.label:		Seite vorw.
 LANG_english*ngScrollBack.label:	Scroll backward
-LANG_german*ngScrollBack.label:		Seite nach oben
+LANG_french*ngScrollBack.label:		Ascenseur arrire
+LANG_german*ngScrollBack.label:		Seite zur\374ck
 
 LANG_english*allQuit.label:		Quit
-LANG_german*allQuit.label:		Gruppenauswahl
+LANG_french*allQuit.label:		Quitter
+LANG_german*allQuit.label:		Auswahl beenden
 LANG_english*allNext.label:		Next
-LANG_german*allNext.label:		n\344chste Gruppe
+LANG_french*allNext.label:		Next
+LANG_german*allNext.label:		N\344chste NG
 LANG_english*allPrev.label:		Prev
-LANG_german*allPrev.label:		vorherige Gruppe
+LANG_french*allPrev.label:		Prev
+LANG_german*allPrev.label:		Vorige NG
 LANG_english*allSub.label:		Subscribe
-LANG_german*allSub.label:             Gruppe abonnieren
+LANG_french*allSub.label:		S'abonner
+LANG_german*allSub.label:		NG abonnieren
 LANG_english*allFirst.label:		Subscribe first
-LANG_german*allFirst.label:		an den Anfang
+LANG_french*allFirst.label:		S'abonner en tte
+LANG_german*allFirst.label:		Abo,  Anfang
 LANG_english*allLast.label:		Subscribe last
-LANG_german*allLast.label:		ans Ende
+LANG_french*allLast.label:		S'abonner en queue
+LANG_german*allLast.label:		Abo,  Ende
 LANG_english*allAfter.label:		Subscribe after group
-LANG_german*allAfter.label:           Plazieren
+LANG_french*allAfter.label:		S'abonner aprs un groupe
+LANG_german*allAfter.label:		Abo&plazieren
 LANG_english*allUnsub.label:		Unsubscribe
-LANG_german*allUnsub.label:		Gruppe verwerfen
+LANG_french*allUnsub.label:		Se dsabonner
+LANG_german*allUnsub.label:		NG abbestellen
 LANG_english*allIgnore.label:		Ignore
+LANG_french*allIgnore.label:		Ignore
 LANG_german*allIgnore.label:		Ignorieren
 LANG_english*allGoto.label:		Goto group
-LANG_german*allGoto.label:		gehe zu Gruppe
+LANG_french*allGoto.label:		Aller au groupe
+LANG_german*allGoto.label:		Gehe zu NG
 LANG_english*allSelect.label:		Select groups
-LANG_german*allSelect.label:		Merken
+LANG_french*allSelect.label:		Slectionner groupes
+LANG_german*allSelect.label:		Vormerken
 LANG_english*allMove.label:		Move
+LANG_french*allMove.label:		Dplacer
 LANG_german*allMove.label:		Verschieben
 LANG_english*allToggle.label:		Toggle order
-LANG_german*allToggle.label:		Anzeige umschalten
+LANG_french*allToggle.label:		Changer l'ordre
+LANG_german*allToggle.label:		ABC/.newsrc-Rhf.
 LANG_english*allScroll.label:		Scroll forward
-LANG_german*allScroll.label:		Seite nach unten
+LANG_french*allScroll.label:		Ascenseur avant
+LANG_german*allScroll.label:		Seite vorw.
 LANG_english*allScrollBack.label:	Scroll backward
-LANG_german*allScrollBack.label:	Seite nach oben
+LANG_french*allScrollBack.label:	Ascenseur arrire
+LANG_german*allScrollBack.label:	Seite zur\374ck
 LANG_english*allSearch.label:		Search
-LANG_german*allSearch.label:		Search
+LANG_french*allSearch.label:		Search
+LANG_german*allSearch.label:		Suchen
 LANG_english*allLimit.label:		Limit list
-LANG_german*allLimit.label:		Limit list
+LANG_french*allLimit.label:		Limit list
+LANG_german*allLimit.label:		Liste begrenzen
 LANG_english*allPost.label:		Post
-LANG_german*allPost.label:		Artikel ver\366ffentlichen
+LANG_french*allPost.label:		Poster
+LANG_german*allPost.label:		Neuer Artikel
 LANG_english*allPostAndMail.label:	Post & Mail
-LANG_german*allPostAndMail.label:	Ver\366ffentlichen & Versenden
+LANG_french*allPostAndMail.label:	Post & Mail
+LANG_german*allPostAndMail.label:	Neuer Art.&EMail
 LANG_english*allMail.label:		Send Mail
-LANG_german*allMail.label:		Sende E-Mail
+LANG_french*allMail.label:		Send Mail
+LANG_german*allMail.label:		EMail
 
 LANG_english*artQuit.label:		Quit
-LANG_german*artQuit.label:		Gruppenauswahl
+LANG_french*artQuit.label:		Quitter
+LANG_german*artQuit.label:		NG verlassen
 LANG_english*artNext.label:		Next
-LANG_german*artNext.label:		Artikel weiter
+LANG_french*artNext.label:		Suivant
+LANG_german*artNext.label:		N\344chster Art.
 LANG_english*artCurrent.label:		Current
-LANG_german*artCurrent.label:		Aktuellen
+LANG_french*artCurrent.label:		Current
+LANG_german*artCurrent.label:		Gew\344hlter Art.
 LANG_english*artUp.label:		Up index line
-LANG_german*artUp.label:		Index nach oben
+LANG_french*artUp.label:		Up index line
+LANG_german*artUp.label:		Vorige Indexzeile
 LANG_english*artDown.label:		Down index line
-LANG_german*artDown.label:		Index nach unten
+LANG_french*artDown.label:		Down index line
+LANG_german*artDown.label:		N\344chste Indexzeile
 LANG_english*artScroll.label:		Scroll forward
-LANG_german*artScroll.label:		Seite nach unten
+LANG_french*artScroll.label:		Ascenseur avant
+LANG_german*artScroll.label:		Seite vorw.
 LANG_english*artScrollBack.label:	Scroll backward
-LANG_german*artScrollBack.label:	Seite nach oben
+LANG_french*artScrollBack.label:	Ascenseur arrire
+LANG_german*artScrollBack.label:	Seite zur\374ck
 LANG_english*artScrollLine.label:	Scroll line forward
-LANG_german*artScrollLine.label:	Zeile nach unten
+LANG_french*artScrollLine.label:	Avancer d'une ligne
+LANG_german*artScrollLine.label:	Zeile vorw.
 LANG_english*artScrollBackLine.label:	Scroll line backward
-LANG_german*artScrollBackLine.label:	Zeile nach oben
+LANG_french*artScrollBackLine.label:	Reculer d'une ligne
+LANG_german*artScrollBackLine.label:	Zeile zur\374ck
 LANG_english*artScrollEnd.label:	Scroll to end
+LANG_french*artScrollEnd.label:		Fin de liste
 LANG_german*artScrollEnd.label:		Zum Ende
 LANG_english*artScrollBeginning.label:	Scroll to beginning
+LANG_french*artScrollBeginning.label:	Dbut de liste
 LANG_german*artScrollBeginning.label:	Zum Anfang
 LANG_english*artScrollIndex.label:	Scroll index
-LANG_german*artScrollIndex.label:	Index nach unten
+LANG_french*artScrollIndex.label:	En avant vers l'index
+LANG_german*artScrollIndex.label:	Indexseite vorw.
 LANG_english*artScrollIndexBack.label:	Scroll index backward
-LANG_german*artScrollIndexBack.label:	Index nach oben
+LANG_french*artScrollIndexBack.label:	En arrire vers l'index
+LANG_german*artScrollIndexBack.label:	Indexseite zur\374ck
 LANG_english*artNextUnread.label:	Next unread
-LANG_german*artNextUnread.label:	n\344chster ungelesener Artikel
+LANG_french*artNextUnread.label:	Suivant non lu
+LANG_german*artNextUnread.label:	N\344chster ungelesener Art.
 LANG_english*artPrev.label:		Prev
-LANG_german*artPrev.label:		Gruppe zur\374ck
+LANG_french*artPrev.label:		Prcdent
+LANG_german*artPrev.label:		Voriger Art.
 LANG_english*artLast.label:		Last
-LANG_german*artLast.label:		Letzter
+LANG_french*artLast.label:		Dernier
+LANG_german*artLast.label:		Zuetzt gelesener Art.
 LANG_english*artNextGroup.label:	Next group
-LANG_german*artNextGroup.label:		n\344chste Gruppe
+LANG_french*artNextGroup.label:		Groupe suivant
+LANG_german*artNextGroup.label:		N\344chste NG
 LANG_english*artGotoArticle.label:	Goto article
-LANG_german*artGotoArticle.label:	gehe zu Artikel
+LANG_french*artGotoArticle.label:	Aller  l'article
+LANG_german*artGotoArticle.label:	Gehe zu Art.
 LANG_english*artCatchUp.label:		Catch up
-LANG_german*artCatchUp.label:		bis Artikel gelesen
+LANG_french*artCatchUp.label:		Rattraper
+LANG_german*artCatchUp.label:		NG bis Art. gelesen
 LANG_english*artFedUp.label:		Fed up
-LANG_german*artFedUp.label:		Gruppe gelesen
+LANG_french*artFedUp.label:		Consommer
+LANG_german*artFedUp.label:		NG gelesen, zur n\344chsten
 LANG_english*artMarkRead.label:		Mark read
-LANG_german*artMarkRead.label:		Artikel gelesen
+LANG_french*artMarkRead.label:		Marquer lu
+LANG_german*artMarkRead.label:		Art.`gelesen'
 LANG_english*artMarkUnread.label:	Mark unread
-LANG_german*artMarkUnread.label:	Artikel nicht gelesen
+LANG_french*artMarkUnread.label:	Marquer non lu
+LANG_german*artMarkUnread.label:	Art.`ungelesen'
 LANG_english*artUnsub.label:		Unsubscribe
-LANG_german*artUnsub.label:		Gruppe verwerfen
+LANG_french*artUnsub.label:		Se dsabonner
+LANG_german*artUnsub.label:		NG abbestellen
 LANG_english*artSub.label:		Subscribe
-LANG_german*artSub.label:		Gruppe abonnieren
+LANG_french*artSub.label:		Subscribe
+LANG_german*artSub.label:		NG abonnieren
 LANG_english*artSubNext.label:		Subject next
-LANG_german*artSubNext.label:		Suche vorw\344rts
+LANG_french*artSubNext.label:		Suivant du sujet
+LANG_german*artSubNext.label:		Suche vorw.
 LANG_english*artSubPrev.label:		Subject prev
+LANG_french*artSubPrev.label:		Prcdent du sujet
 LANG_german*artSubPrev.label:		Suche zur\374ck
 LANG_english*artThreadParent.label:	Goto parent
-LANG_german*artThreadParent.label:	Goto parent
+LANG_french*artThreadParent.label:	Goto parent
+LANG_german*artThreadParent.label:	Zum Vorg\344nger
 LANG_english*artKillSubject.label:	Subject kill
-LANG_german*artKillSubject.label:	Subject kill
+LANG_french*artKillSubject.label:	Subject kill
+LANG_german*artKillSubject.label:	Thema ausblenden
 LANG_english*artKillAuthor.label:	Author kill
-LANG_german*artKillAuthor.label:	Verfasser l\366schen 
+LANG_french*artKillAuthor.label:	Tuer l'auteur
+LANG_german*artKillAuthor.label:	Verf. ausblenden
 LANG_english*artKillThread.label:	Thread kill
-LANG_german*artKillThread.label:	Thread kill
+LANG_french*artKillThread.label:	Thread kill
+LANG_german*artKillThread.label:	Serie ausblenden
 LANG_english*artKillSubthread.label:	Subthread kill
-LANG_german*artKillSubthread.label:	Subthread kill
+LANG_french*artKillSubthread.label:	Subthread kill
+LANG_german*artKillSubthread.label:	Teilserie ausblenden
 LANG_english*artSubSearch.label:	Subject search
-LANG_german*artSubSearch.label:		Suchen Thema
+LANG_french*artSubSearch.label:		Chercher par sujet
+LANG_german*artSubSearch.label:		Thema Suchen
 LANG_english*artContinue.label:		Continue
+LANG_french*artContinue.label:		Continuer
 LANG_german*artContinue.label:		Thema Weitersuchen
 LANG_english*artPost.label:		Post
-LANG_german*artPost.label:		Artikel ver\366ffentlichen
+LANG_french*artPost.label:		Poster
+LANG_german*artPost.label:		Neuer Artikel
 LANG_english*artPostAndMail.label:	Post & Mail
-LANG_german*artPostAndMail.label:	Ver\366ffentlichen & Versenden
+LANG_french*artPostAndMail.label:	Post & Mail
+LANG_german*artPostAndMail.label:	Neuer Art.&EMail
 LANG_english*artMail.label:		Send Mail
-LANG_german*artMail.label:		Sende E-Mail
+LANG_french*artMail.label:		Send Mail
+LANG_german*artMail.label:		EMail
 LANG_english*artExit.label:		Exit
-LANG_german*artExit.label:		Verlassen
+LANG_french*artExit.label:		Terminer
+LANG_german*artExit.label:		Abbrechen
 LANG_english*artGripe.label:		Gripe
-LANG_german*artGripe.label:           Nachricht an XRN-Betreuer
+LANG_french*artGripe.label:		Rler
+LANG_german*artGripe.label:		XRN-Betreuer
 LANG_english*artListOld.label:		List old
-LANG_german*artListOld.label:		alle Artikel
+LANG_french*artListOld.label:		Tous les articles
+LANG_german*artListOld.label:		Alte Art. zeigen
 LANG_english*artResort.label:		Resort list
-LANG_german*artResort.label:		Resort list
+LANG_french*artResort.label:		Resort list
+LANG_german*artResort.label:		Liste neu sortieren
 LANG_english*artCheckPoint.label:	Checkpoint
-LANG_german*artCheckPoint.label:	Aktualisieren
+LANG_french*artCheckPoint.label:	Point de contrle
+LANG_german*artCheckPoint.label:	Liste sichern
 
 LANG_english*artSave.label:		Save
-LANG_german*artSave.label:		Sichern
+LANG_french*artSave.label:		Sauver
+LANG_german*artSave.label:		Art. speichern
 LANG_english*artReply.label:		Reply
-LANG_german*artReply.label:		Nachricht
+LANG_french*artReply.label:		Rpondre
+LANG_german*artReply.label:		Antwort EMail
 LANG_english*artForward.label:		Forward
-LANG_german*artForward.label:		Weiterreichen
+LANG_french*artForward.label:		Faire suivre
+LANG_german*artForward.label:		Weiterreichen EMail
 LANG_english*artFollowup.label:		Followup
-LANG_german*artFollowup.label:		Bezug
+LANG_french*artFollowup.label:		Poursuivre
+LANG_german*artFollowup.label:		Folgeartikel
 LANG_english*artFollowupAndReply.label:	Followup & Reply
-LANG_german*artFollowupAndReply.label:	Bezug und Nachricht
+LANG_french*artFollowupAndReply.label:	Poursuivre & rpondre
+LANG_german*artFollowupAndReply.label:	Folgeart.&EMail
 LANG_english*artCancel.label:		Cancel
-LANG_german*artCancel.label:		Zur\374ckziehen
+LANG_french*artCancel.label:		Annuler
+LANG_german*artCancel.label:		Art. zur\374ckziehen
 LANG_english*artXlate.label:		Translate
-LANG_german*artXlate.label:		Anpassen
+LANG_french*artXlate.label:		Traduire
+LANG_german*artXlate.label:		Zeichensatz anpassen
 LANG_english*artRot13.label:		Rot-13
+LANG_french*artRot13.label:		Rot-13
 LANG_german*artRot13.label:		Rot-13
 LANG_english*artHeader.label:		Toggle header
-LANG_german*artHeader.label:		Artikelkopf
+LANG_french*artHeader.label:		En-tte
+LANG_german*artHeader.label:		Kopf ein/ausblenden
 LANG_english*artPrint.label:		Print
+LANG_french*artPrint.label:		Imprimer
 LANG_german*artPrint.label:		Drucken
 
 LANG_english*compAbort.label:		abort
+LANG_french*compAbort.label:		Annuler
 LANG_german*compAbort.label:		Abbrechen
+LANG_english*compSwitchFollowup.label:	Post instead
+LANG_french*compSwitchFollowup.label:	Post instead
+LANG_german*compSwitchFollowup.label:	Post instead
+LANG_english*compSwitchReply.label:	Mail instead
+LANG_french*compSwitchReply.label:	Mail instead
+LANG_german*compSwitchReply.label:	Mail instead
+LANG_english*compSwitchBoth.label:	Post & mail instead
+LANG_french*compSwitchBoth.label:	Post & mail instead
+LANG_german*compSwitchBoth.label:	Post & mail instead
 LANG_english*compSend.label:		send
+LANG_french*compSend.label:		Envoyer
 LANG_german*compSend.label:		Verschicken
 LANG_english*compSave.label:		save
+LANG_french*compSave.label:		Sauver
 LANG_german*compSave.label:		Sichern
 LANG_english*compIncludeArticle.label:	include article
-LANG_german*compIncludeArticle.label:	Artikel einf\374gen
+LANG_french*compIncludeArticle.label:	Inclure article
+LANG_german*compIncludeArticle.label:	Art. einf\374gen
 LANG_english*compIncludeFile.label:	include file
+LANG_french*compIncludeFile.label:	Inclure fichier
 LANG_german*compIncludeFile.label:	Datei einf\374gen
 
 LANG_english*Cancel*label:		Cancel Search
+LANG_french*Cancel*label:		Annuler recherche
 LANG_german*Cancel*label:		Suche abbrechen
 
 LANG_english*CancelListOld*label:	Cancel
-LANG_german*CancelListOld*label:	Abbruch
+LANG_french*CancelListOld*label:	Cancel
+LANG_german*CancelListOld*label:	Abbrechen
 
 LANG_english*CancelThreadParent*label:	Cancel
-LANG_german*CancelThreadParent*label:	Abbruch
+LANG_french*CancelThreadParent*label:	Cancel
+LANG_german*CancelThreadParent*label:	Abbrechen
 
 XAW*Information.geometry:		600x150
 XAW*Information.pane.label.showGrip:	False
@@ -525,20 +643,25 @@
 XAW	<Key>Linefeed: set() notify() unset() \n\
 XAW	<Key>Return: set() notify() unset()
 XAWLANG_english*Information*mesgDismiss*label:	Dismiss
-XAWLANG_german*Information*mesgDismiss*label:	Verwerfen
+XAWLANG_french*Information*mesgDismiss*label:	Supprimer
+XAWLANG_german*Information*mesgDismiss*label:	Schlie\337en
 XAWLANG_english*Information*mesgClear*label:	Clear
+XAWLANG_french*Information*mesgClear*label:	Effacer
 XAWLANG_german*Information*mesgClear*label:	L\366schen
 
 MOTIF*Information.autoUnmanage:		False
 MOTIF*Information*text.width:		500
 MOTIF*Information*text.height:		150
 MOTIFLANG_english*Information*cancelLabelString:	Dismiss
-MOTIFLANG_german*Information*cancelLabelString:	Verwerfen
-MOTIFLANG_english*Information*okLabelString:	Clear
-MOTIFLANG_german*Information*okLabelString:	L\366schen
-
-LANG_english*Information*label.label:	Information (can be left up or dismissed)
-LANG_german*Information*label.label:	Informationen (Fenster kann ge\366ffnet bleiben)
+MOTIFLANG_french*Information*cancelLabelString:		Supprimer
+MOTIFLANG_german*Information*cancelLabelString:		Schlie\337en
+MOTIFLANG_english*Information*okLabelString:		Clear
+MOTIFLANG_french*Information*okLabelString:		Effacer
+MOTIFLANG_german*Information*okLabelString:		L\366schen
+
+LANG_english*Information*label.label:	Information
+LANG_french*Information*label.label:	Information
+LANG_german*Information*label.label:	Informationen
 *Information.saveUnder:			False
 *Information*text.displayCaret:		False
 XAW*Information*text.scrollVertical:	always
diff -ruPN 9.00/Xresources.sam 9.01/Xresources.sam
--- 9.00/Xresources.sam	Tue Dec 16 22:10:56 1997
+++ 9.01/Xresources.sam	Wed May 13 21:25:38 1998
@@ -0,0 +1,98 @@
+!
+! $Id: Xresources.sam,v 1.2 1994/11/23 01:42:47 jik Exp $
+!
+xrn.newsrcFile:		~/.newsrc
+xrn.nntpServer:		news-server-machine
+xrn.editorCommand:	xterm -e vi %s
+xrn.iconGeometry:	+64+521
+xrn.leaveHeaders:	subject,from,organization
+xrn.Gripe.geometry:	+50+50
+!
+xrn.ngButtonList: ngQuit,ngRead,ngCatchUp,ngGoto,ngRescan,\
+			ngSubscribe,ngPost,ngGripe,ngAllGroups
+xrn.artButtonList: artQuit,artNextUnread,artNext,artPrev,artCatchUp,\
+			artPost,artGripe,artNextGroup
+!
+xrn*index.accelerators: #override \n\
+		<Key>Down:	next-line() \n\
+ 		<Key>Up:	previous-line()
+!
+xrn.ngBindings: \
+   <Key>Q:		ngQuit()	\n\
+   <Key>N:		ngRead()	\n\
+   <Key>P:		ngPrev()
+xrn.artBindings: \
+   <Key>Q:		artQuit()	\n\
+   <Key>N:		artNextUnread()	\n\
+   <Key>P:		artPrev()
+!
+xrn*background:		plum
+xrn*foreground:		red
+xrn*font:		9x15
+xrn*border:		LightGray
+!
+xrn.Information.geometry: +400+400
+!
+xrn*breakLength:		0
+xrn*Composition*Text*wrap:	never
+xrn*Composition*Text*autoFill:	true
+xrn*Composition.geometry:	660+0+0
+!
+xrn*Text*background:	DarkSlateGray
+xrn*Text*foreground:	yellow
+xrn*Text*Background:	DarkSlateGray
+xrn*Text*Foreground:	yellow
+!
+xrn.vpane.index.thickness: 22
+xrn.vpane.articleText.thickness: 10
+!
+xrn*Label.background:		cyan
+xrn*Label.foreground:		blue
+xrn*Label.font:			-adobe-times-bold-r-normal--14-140-75-75-p-77-iso8859-1
+
+xrn*Command.foreground:		White
+xrn*Command.background:		coral
+xrn*Command.font:		-adobe-itc avant garde gothic-book-r-normal--12-120-75-75-p-70-iso8859-1
+!
+xrn*Box.ngQuit.foreground:	Black
+xrn*Box.ngQuit.background:	red
+xrn*Box.ngExit.foreground:	yellow
+xrn*Box.ngExit.background:	orange
+xrn*Box.ngRescan.foreground:	cyan
+xrn*Box.ngRescan.background:	violet
+xrn*Box.ngUnsub.foreground: green
+xrn*Box.ngUnsub.background: blue
+xrn*Box.ngSubscribe.foreground: blue
+xrn*Box.ngSubscribe.background:	green
+xrn*Box.artQuit.foreground:	Black
+xrn*Box.artQuit.background:	red
+xrn*Box.artSave.foreground:	NavyBlue
+xrn*Box.artSave.background:	LimeGreen
+xrn*Box.artNextUnread.font:	9x15
+xrn*Box.addQuit.foreground:	Black
+xrn*Box.addQuit.background:	red
+!
+xrn*dialog*font:		-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1
+xrn*dialog*background:		LimeGreen
+xrn*dialog*foreground:		CornflowerBlue
+xrn*dialog*Label.foreground:	NavyBlue
+xrn*dialog*Command.foreground:	Black
+xrn*dialog*Command.background:	yellow
+xrn*dialog*Text*background:	white
+xrn*dialog*Text*foreground:	black
+xrn*dialog*borderWidth:		2
+!
+xrn.confirm:			ngCatchUp,artCatchUp
+xrn.signatureFile:		~/.signature
+xrn.geometry:			=760x770+25+25
+xrn.deadLetters:		~/dead.letters
+xrn.savePostings:		~/Articles
+xrn.topLines:			9
+xrn.saveMode:			mailbox,headers
+xrn.minLines:			3
+xrn.maxLines:			6
+xrn.tmpDir:			/tmp
+xrn.mailer:			/usr/lib/sendmail -oi -t
+!xrn.organization:		your organization name here
+!xrn.replyTo:			somebody@somehost.edu
+!
diff -ruPN 9.00/artMode.c 9.01/artMode.c
--- 9.00/artMode.c	Sun Dec 28 11:35:27 1997
+++ 9.01/artMode.c	Mon Mar 23 07:51:50 1998
@@ -282,8 +282,13 @@
   defaultLines are above the cursor, if defaultLines is within the
   valid range, or just enough to put us within the valid range,
   otherwise.  In any case, the cursor will be visible when done.
+
+  If motion is FORWARD, then we'll only scroll forwards as long as the
+  cursor is visible.  If motion os BACK, then we'll only scroll
+  backwards as long as the cursor is visible.
   */
-static void adjustMinMaxLines()
+static void adjustMinMaxLines(motion)
+     int motion;
 {
     long CursorPosition = TextGetInsertionPoint(SubjectText);
     long top = TextGetTopPosition(SubjectText), TopPosition = top, end;
@@ -291,6 +296,7 @@
     int min = app_resources.minLines, max = app_resources.maxLines;
     int def = app_resources.defaultLines;
     int numLines, below;
+    Boolean off_screen = False;
 
     if (height == 0)
 	return;
@@ -313,8 +319,10 @@
     /*
       If the cursor isn't even currently visible, it should be.
       */
-    if (top > CursorPosition)
+    if (top > CursorPosition) {
 	top = CursorPosition;
+	off_screen = True;
+    }
 
     /*
       Figure out how many lines are above the cursor.
@@ -324,6 +332,13 @@
 	assert(ret);
     }
 
+    while (numLines > height) {
+      /* We've scrolled down, but the Text widget hasn't realized it yet. */
+      numLines -= 1;
+      (void) moveCursor(FORWARD, SubjectString, &TopPosition);
+      off_screen = True;
+    }
+
     /*
       Figure out how many lines are below the cursor.
       */
@@ -331,6 +346,13 @@
     end = top;
     while (moveCursor(FORWARD, SubjectString, &end) && (below < height))
 	below++;
+    if (! below) 
+      /* Special case: if the cursor is at the end of the Subject
+	string, it'll be on a line by itself, and "below" will
+	therefore be 0 (since there's nothing after the cursor), but
+	we want the empty line that the cursor is on to count as a
+	line so that it'll be displayed properly.  */
+      below = 1;
 
     /*
       If necessary, reposition.
@@ -339,14 +361,17 @@
 	for (numLines = 1; numLines < def; numLines++) {
 	    if (! moveCursor(BACK, SubjectString, &top))
 		break;
-
 	}
 	for (below += numLines; below <= height; below++) {
 	    if (! moveCursor(BACK, SubjectString, &top))
 		break;
 	}
-	if (TopPosition != top)
-	    TextSetTopPosition(SubjectText, top);
+	if ((TopPosition != top) &&
+	    (off_screen ||
+	     (motion == JUMP) ||
+	     (motion == FORWARD && TopPosition < top) ||
+	     (motion == BACK && top < TopPosition)))
+	  TextSetTopPosition(SubjectText, top);
     }
 }
 
@@ -361,20 +386,23 @@
   constraints are met, if update_top is true.
   */
 static void updateSubjectWidget _ARGUMENTS((String, long,
-					    long, Boolean, Boolean));
+					    long, Boolean, Boolean,
+					    int));
 
 static void updateSubjectWidget(
 				_ANSIDECL(String,	string),
 				_ANSIDECL(long,		left),
 				_ANSIDECL(long,		right),
 				_ANSIDECL(Boolean,	update_top),
-				_ANSIDECL(Boolean,	preserve_top)
+				_ANSIDECL(Boolean,	preserve_top),
+				_ANSIDECL(int,		motion)
 				)
      _KNRDECL(String,	string)
      _KNRDECL(long,	left)
      _KNRDECL(long,	right)
      _KNRDECL(Boolean,	update_top)
      _KNRDECL(Boolean,	preserve_top)
+     _KNRDECL(int,	motion)
 {
     Boolean disable = False;
     long top WALL(= 0);
@@ -399,7 +427,7 @@
     if (preserve_top)
 	TextSetTopPosition(SubjectText, top);
     else if (update_top)
-	adjustMinMaxLines();
+	adjustMinMaxLines(motion);
 
     if (disable)
 	TextEnableRedisplay(SubjectText);
@@ -874,7 +902,7 @@
     TextDisableRedisplay(SubjectText);
 
     /* get and display the article */
-    updateSubjectWidget(SubjectString, 0, 0, True, False);
+    updateSubjectWidget(SubjectString, 0, 0, True, False, JUMP);
     ArtStatus = art_FORWARD | art_CURRENT | art_WRAP;
     artNextFunction(0, 0, 0, 0);
 
@@ -965,11 +993,12 @@
 /*
  * Display new article, mark as read.
  */
-static void foundArticle _ARGUMENTS((file_cache_file *, char *));
+static void foundArticle _ARGUMENTS((file_cache_file *, char *, int));
 
-static void foundArticle(file, ques)
+static void foundArticle(file, ques, motion)
     file_cache_file *file;
     char *ques;
+    int motion;
 {
     long ArtPosition = TextGetInsertionPoint(SubjectText);
 
@@ -985,7 +1014,8 @@
     CurrentGroup->current = markStringRead(SubjectString, ArtPosition);
     CurrentArticle = CurrentGroup->current;
 
-    updateSubjectWidget(SubjectString, ArtPosition, ArtPosition + 1, True, False);
+    updateSubjectWidget(SubjectString, ArtPosition, ArtPosition + 1,
+			True, False, motion);
 
     /*
       This is necessary because of a bug in the Xaw Text widget -- it
@@ -1022,7 +1052,7 @@
 	(void) moveCursor(FORWARD, SubjectString, &left);
     }
     (void) moveCursor(BACK, SubjectString, &left);
-    updateSubjectWidget(SubjectString, 0, ArtPosition, True, False);
+    updateSubjectWidget(SubjectString, 0, ArtPosition, True, False, JUMP);
     if (getNearbyArticle(art_FORWARD | art_CURRENT | art_WRAP | art_UNREAD,
 			 &file, &question, &artNum) ==
 	art_DONE) {
@@ -1032,7 +1062,7 @@
 	    artNextGroupFunction(NULL, NULL, NULL, NULL);
 	return;
     }
-    foundArticle(file, question);
+    foundArticle(file, question, JUMP);
 
     return;
 }
@@ -1124,7 +1154,7 @@
 	goto done;
     }
     /* update the text window */
-    foundArticle(file, question);
+    foundArticle(file, question, FORWARD);
 
     ArtStatus = art_FORWARD;
 
@@ -1166,7 +1196,7 @@
 	goto done;
     }
     /* update the text window */
-    foundArticle(file, question);
+    foundArticle(file, question, JUMP);
 
     ArtStatus = art_FORWARD;
 
@@ -1386,7 +1416,7 @@
 	art_DONE) {
 	goto done;
     }
-    foundArticle(file, question);
+    foundArticle(file, question, BACK);
 
   done:
     TextEnableRedisplay(SubjectText);
@@ -1627,7 +1657,7 @@
     TextSetInsertionPoint(SubjectText, ArtPosition);
     updateSubjectWidget(SubjectString, left, right,
 			app_resources.subjectScrollBack,
-			!app_resources.subjectScrollBack);
+			!app_resources.subjectScrollBack, JUMP);
 
     TextEnableRedisplay(SubjectText);
 
@@ -1784,7 +1814,7 @@
 	case NOCHANGE:
 	    (void) sprintf(error_buffer, ERROR_SUBJ_SEARCH_MSG, subject);
 	    INFO(error_buffer);
-	    foundArticle(file, question);
+	    foundArticle(file, question, FORWARD);
 	    goto done;
 
 	case DONE:
@@ -1804,7 +1834,7 @@
 	}
     }
 
-    foundArticle(file, question);
+    foundArticle(file, question, FORWARD);
 
   done:
     TextEnableRedisplay(SubjectText);
@@ -1873,7 +1903,7 @@
 	}
     }
 
-    foundArticle(file, question);
+    foundArticle(file, question, BACK);
 
   done:
     FREE(subject);
@@ -1906,7 +1936,7 @@
     else if ((event->type == ButtonPress) || (event->type == ButtonRelease))
       state = &event->xbutton.state;
     assert(state);
-    if (*state & ShiftMask)
+    if ((*state & ShiftMask) || (count && *count))
       prefer_listed = False;
   }
 
@@ -2002,7 +2032,7 @@
       setListed(parent, parent, False);
     }
     else {
-      foundArticle(file, question);
+      foundArticle(file, question, BACK);
     }
   }
   else if (parent == 0) {
@@ -2141,7 +2171,7 @@
 	  goto done;
 	}
 
-	foundArticle(file, question);
+	foundArticle(file, question, FORWARD);
     }
 
   done:
@@ -2383,7 +2413,7 @@
       TextSetInsertionPoint(SubjectText, ArtPosition);
     }
 
-    adjustMinMaxLines();
+    adjustMinMaxLines(JUMP);
     TextEnableRedisplay(SubjectText);
 
     if (finished) {
@@ -2479,7 +2509,7 @@
   ArtPosition = findArticle(SubjectString, CurrentArticle, False);
   TextSetInsertionPoint(SubjectText, ArtPosition);
 
-  adjustMinMaxLines();
+  adjustMinMaxLines(JUMP);
 
   if (newsort) {
     XtFree(newsort);
@@ -2590,7 +2620,7 @@
 
 	TextSetInsertionPoint(SubjectText, ArtPosition);
 
-	foundArticle(file, question);
+	foundArticle(file, question, JUMP);
 
 	TextEnableRedisplay(SubjectText);
 
@@ -2967,7 +2997,7 @@
 	(void) sprintf(error_buffer, ERROR_SEARCH_MSG,
 		       regexp);
 	infoNow(error_buffer);
-	foundArticle(file, question);
+	foundArticle(file, question, direction);
 	break;
 
     case EXIT:
@@ -3115,7 +3145,7 @@
     } else {
 	CurrentGroup->current = PrevArticle;
 	TextSetInsertionPoint(SubjectText, ArtPosition);
-	foundArticle(file, question);
+	foundArticle(file, question, JUMP);
     }
 
     TextEnableRedisplay(SubjectText);
@@ -3176,7 +3206,7 @@
 	left = findArticle(SubjectString, CurrentGroup->current, False);
 	TextSetInsertionPoint(SubjectText, left);
 	if (app_resources.subjectScrollBack)
-	    adjustMinMaxLines();
+	    adjustMinMaxLines(JUMP);
 	else
 	    TextSetTopPosition(SubjectText, top);
     }
@@ -3477,7 +3507,7 @@
 
     TextSetInsertionPoint(SubjectText, ArtPosition);
 
-    adjustMinMaxLines();
+    adjustMinMaxLines(JUMP);
 
     setListSorted(True);
 
@@ -3646,7 +3676,7 @@
 
     TextDisableRedisplay(SubjectText);
     TextMoveLine(SubjectText, BACK);
-    adjustMinMaxLines();
+    adjustMinMaxLines(BACK);
     TextEnableRedisplay(SubjectText);
 }
 
@@ -3664,7 +3694,7 @@
 
     TextDisableRedisplay(SubjectText);
     TextMoveLine(SubjectText, FORWARD);
-    adjustMinMaxLines();
+    adjustMinMaxLines(FORWARD);
     TextEnableRedisplay(SubjectText);
 }
 
diff -ruPN 9.00/butexpl.h 9.01/butexpl.h
--- 9.00/butexpl.h	Fri Jul 18 08:10:46 1997
+++ 9.01/butexpl.h	Wed Jan 28 20:58:11 1998
@@ -42,6 +42,7 @@
  *
  *           english
  *           german
+ *           french
  *
  *
  * The German section was created and translated by K.Marquardt
@@ -49,6 +50,9 @@
  * Jansohn@zxt.basf-ag.de.  Some revisions were provided by by T.Foks
  * (foks@hub.de).
  *
+ * The french section was created and translated by
+ *            N. Courtel (courtel@cena.dgac.fr)  March 23, 1995
+ *
  * ...............................................................
  * Note: all items should appear in all sections, if you add a item,
  *       please add it in every section. Items can also appear in
@@ -65,9 +69,11 @@
 
 #ifndef XRN_LANG_english
 #ifndef XRN_LANG_german
+#ifndef XRN_LANG_french
 #define XRN_LANG_english
 #endif
 #endif
+#endif
 
 
 #ifdef XRN_LANG_english
@@ -194,6 +200,130 @@
 
 #endif /* XRN_LANG_english */
 
+#ifdef XRN_LANG_french
+
+/* 
+ * explanation strings add mode
+ *
+ * default version, international (english)
+ */
+
+#define ADDQUIT_EXSTR		"Quitter le mode insertion, pas d'abonnement aux groupes restants"
+#define ADDIGNORE_REST_EXSTR	"Quit add mode, ignoring all remaining groups"
+#define ADDFIRST_EXSTR		"Insrer les groupes slectionns au dbut du fichier .newsrc"
+#define ADDLAST_EXSTR		"Insrer les groupes slectionns  la fin du fichier .newsrc"
+#define ADDAFTER_EXSTR		"Insrer les groupes slectionns aprs un groupe dans le fichier .newsrc"
+#define ADDUNSUB_EXSTR		"Insrer les groupes slectionns sans s'y abonner"
+#define ADDIGNORE_EXSTR		"Ignore the selected group(s)"
+
+/* 
+ * explanation strings ng mode
+ */
+
+#define NGQUIT_EXSTR		"Quitter XRN"
+#define NGREAD_EXSTR		"Lire les articles du groupe actuel"
+#define NGNEXT_EXSTR		"Dplacer le curseur vers le groupe suivant"
+#define NGPREV_EXSTR		"Dplacer le curseur vers le groupe prcdent"
+#define NGCATCHUP_EXSTR		"Marquer tous les articles du groupe actuel comme lus"
+#define NGSUBSCRIBE_EXSTR	"S'abonner  un groupe"
+#define NGUNSUB_EXSTR		"Se dsabonner du groupe actuel"
+#define NGGOTO_EXSTR		"Aller dans un groupe (en s'y abonnant si ncessaire)"
+#define NGALLGROUPS_EXSTR	"Voir tous les groupes disponibles, avec la possibilit de s'y abonner"
+#define NGLISTOLD_EXSTR		"Voir tous les groupes sans nouvel article (bascule)"
+#define NGRESCAN_EXSTR		"Demander au serveur de news les nouveaux articles et groupes"
+#define NGGETLIST_EXSTR		"Get a complete list of groups from the news server"
+#define NGPREVGROUP_EXSTR	"Retourner au groupe prcdent (en s'y abonnant si ncessaire)"
+#define NGSELECT_EXSTR		"Marquer la slection courante pour un futur dplacement"
+#define NGMOVE_EXSTR		"Dplacer les groupes slectionns prcdemment en tte de la slection actuelle"
+#define NGEXIT_EXSTR		"Quitter XRN, sans mettre  jour le fichier .newsrc"
+#define NGCHECKPOINT_EXSTR	"Mettre  jour le fichier .newsrc"
+#define NGGRIPE_EXSTR		"Envoyer une rclamation au support local XRN"
+#define NGPOST_EXSTR		"Poster un article dans un ou plusieurs groupes de news"
+#define NGPOST_AND_MAIL_EXSTR	"Post an article to one or more newsgroups and mail it"
+#define NGSCROLL_EXSTR		"Avancer dans la liste des groupes de news"
+#define NGSCROLLBACK_EXSTR	"Reculer dans la liste des groupes de news"
+
+/* 
+ * explanation strings all mode
+ */
+
+#define ALLQUIT_EXSTR		"Retour au mode groupe, en sauvant les modifications"
+#define ALLSUB_EXSTR		"S'abonner au groupe actuel, en conservant la position dans .newsrc"
+#define ALLFIRST_EXSTR		"S'abonner aux groupes slectionns, en les insrant au dbut du fichier .newsrc"
+#define ALLLAST_EXSTR		"S'abonner aux groupes slectionns, en les insrant  la fin du fichier .newsrc"
+#define ALLAFTER_EXSTR		"S'abonner aux groupes slectionns, en les insrant aprs un groupe du fichier .newsrc"
+#define ALLUNSUB_EXSTR		"Se dsabonner des groupes slectionns"
+#define ALLIGNORE_EXSTR 	"Ignore the selected group(s)"
+#define ALLGOTO_EXSTR		"Aller dans le groupe actuel"
+#define ALLSELECT_EXSTR		"Marquer la slection actuelle pour un futur dplacement"
+#define ALLMOVE_EXSTR		"Dplacer les groupes prcedemment slectionns vers la position actuelle"
+#define ALLTOGGLE_EXSTR		"Basculer l'ordre des groupes : ordre alphabtique/ordre de .newsrc"
+#define ALLSCROLL_EXSTR		"Avancer dans l'cran `tous les groupes'"
+#define ALLSCROLLBACK_EXSTR	"Reculer dans l'cran `tous les groupes'"
+#define ALLSEARCH_EXSTR		"Search the group list"
+#define ALLLIMIT_EXSTR		"Display a subset of the group list"
+#define ALLPOST_EXSTR		"Poster dans le groupe de news actuel"
+#define ALLPOST_AND_MAIL_EXSTR	"Post to the current newsgroup and mail the posting to someone"
+
+/* 
+ * explanation strings art mode
+ *
+ */
+
+#define ARTQUIT_EXSTR		"Retourner au mode groupes"
+#define ARTNEXTUNREAD_EXSTR	"Lire le prochain article non lu"
+#define ARTNEXT_EXSTR		"Lire le prochain article"
+#define ARTCURRENT_EXSTR	"Read the article under the cursor"
+#define ARTUP_EXSTR		"Move up one line in the subject list"
+#define ARTDOWN_EXSTR		"Move down one line in the subject list"
+#define ARTSCROLL_EXSTR		"Avancer dans l'article actuel"
+#define ARTSCROLLBACK_EXSTR	"Reculer dans l'article actuel"
+#define ARTSCROLLLINE_EXSTR	"Avancer d'une ligne dans l'article actuel"
+#define ARTSCROLLBCKLN_EXSTR	"Reculer d'une ligne dans l'article actuel"
+#define ARTSCROLLEND_EXSTR	"Aller  la fin de l'article actuel"
+#define ARTSCROLLBEG_EXSTR	"Aller au debut de l'article actuel"
+#define ARTSCROLLINDEX_EXSTR	"Avancer l'index d'une page"
+#define ARTSCROLLINDBCK_EXSTR	"Reculer l'index d'une page"
+#define ARTPREV_EXSTR		"Lire l'article prcdent"
+#define ARTLAST_EXSTR		"Retourner au dernier article visualis"
+#define ARTNEXTGROUP_EXSTR	"Aller au prochain groupe non lu, sans passer par le mode groupes"
+#define ARTCATCHUP_EXSTR	"Marquer tous les articles (jusqu' celui slectionn par le bouton du milieu) commu lus"
+#define ARTFEEDUP_EXSTR		"Marquer tous les articles du groupe actuel comme lus et aller au prochain groupe"
+#define ARTGOTOARTICLE_EXSTR	"Aller  l'article de numro choisi dans le groupe actuel"
+#define ARTMARKREAD_EXSTR	"Marquer les articles slectionns comme lus"
+#define ARTMARKUNREAD_EXSTR	"Marquer les articles slectionns comme non lus"
+#define ARTSUB_EXSTR		"Subscribe to the current group"
+#define ARTUNSUB_EXSTR		"Se dsabonner du groupe actuel"
+#define ARTSUBNEXT_EXSTR	"Rechercher le prochain article sur le mme sujet"
+#define ARTSUBPREV_EXSTR	"Rechercher les articles prcdents sur le sujet slectionn"
+#define ARTPARENT_EXSTR		"Search for the parent of the current or selected article"
+#define ARTKILLSUBJECT_EXSTR	"Mark all articles with this subject as read"
+#define ARTKILLAUTHOR_EXSTR	"Marquer tous les articles de cet auteur comme lus, pour cette session seulement"
+#define ARTKILLTHREAD_EXSTR	"Mark all articles in this thread as read"
+#define ARTKILLSUBTHREAD_EXSTR	"Mark all articles in this subthread as read"
+#define ARTSUBSEARCH_EXSTR	"Rechercher une expression rgulire dans les sujets"
+#define ARTCONTINUE_EXSTR	"Continuer la recherche d'expression rgulire"
+#define ARTPOST_EXSTR		"Poster un article dans ce groupe de news"
+#define ARTPOST_MAIL_EXSTR	"Post an article to this newsgroup and mail it too"
+#define MAIL_EXSTR		"Send a mail message"
+#define ARTEXIT_EXSTR		"Revenir au mode groupes, en marquant tous les articles comme non lus"
+#define ARTCHECKPOINT_EXSTR	"Mettre  jour le fichier .newsrc"
+#define ARTGRIPE_EXSTR		"Envoyer une rclamation au support local d'XRN"
+#define ARTLISTOLD_EXSTR	"Lister tous les articles du groupe actuel (peut tre long)"
+#define ARTRESORT_EXSTR		"Resort the article list"
+#define ARTSAVE_EXSTR		"Sauver l'article actuel dans un fichier"
+#define ARTREPLY_EXSTR		"Envoyer un rponse par mail  l'auteur de l'article actuel"
+#define ARTFORWARD_EXSTR	"Faire suivre un article  un utilisateur"
+#define ARTFOLLOWUP_EXSTR	"Poster une rponse dans les news  l'article actuel"
+#define ARTFOLLOWREPL_EXSTR	"Envoyer une rponse  l'aricle actuel par mail et dans les news"
+#define ARTCANCEL_EXSTR		"Annuler l'article actuel"
+#define ARTROT13_EXSTR		"Dcrypter un article crypt par rot-13"
+#define ARTXLATE_EXSTR		"Traduire l'article actuel"
+#define ARTHEADER_EXSTR		"Visualiser l'en-tte complet/rduit"
+#define ARTPRINT_EXSTR		"Imprimer l'article"
+
+#endif /* XRN_LANG_french */
+
 #ifdef XRN_LANG_german
 
 /* 
@@ -205,7 +335,7 @@
  * The German section was created and translated by K.Marquardt
  * (K.Marquardt@zhv.basf-ag.de) based on a version from
  * Jansohn@zxt.basf-ag.de.  Some revisions were provided by by T.Foks
- * (foks@hub.de).
+ * (Thomas.Foks@hub.de) and G. Niklasch (nikl@mathematik.tu-muenchen.de).
  *
  * german version (iso8859-1), use LANGUAGE= german in Imakefile/Makefile
  *
@@ -216,13 +346,13 @@
  * sz = \337
  */
 
-#define ADDQUIT_EXSTR	"Gruppieren verlassen und verbleibende Gruppen als `nicht abonniert' kennzeichnen."
-#define ADDIGNORE_REST_EXSTR	"Hinzuf\374gen verlassen und alle verbleibenden Gruppen ignorieren."
-#define ADDFIRST_EXSTR	"Gew\344hlte Newsgruppe(n) an den Anfang der Datei .newsrc setzen."
-#define ADDLAST_EXSTR	"Gew\344hlte Newsgruppe(n) an das Ende der Datei .newsrc setzen."
+#define ADDQUIT_EXSTR	"Auswahl neuer Gruppen beenden, restliche als `nicht abonniert' kennzeichnen."
+#define ADDIGNORE_REST_EXSTR	"Auswahl neuer Gruppen beenden, die restlichen ignorieren."
+#define ADDFIRST_EXSTR	"Gew\344hlte Newsgruppe(n) abonnieren und an den Anfang der Datei .newsrc setzen."
+#define ADDLAST_EXSTR	"Gew\344hlte Newsgruppe(n) abonnieren und ans Ende der Datei .newsrc setzen."
 #define ADDAFTER_EXSTR  "Gew\344hlte Newsgruppe(n) hinter eine andere in der Datei .newsrc setzen."
 #define ADDUNSUB_EXSTR	"Gew\344hlte Newsgruppe(n) als `nicht abonniert' kennzeichnen."
-#define ADDIGNORE_EXSTR	"Ignoriere die ausgew\344hlte(n) Gruppe(n)."
+#define ADDIGNORE_EXSTR	"Gew\344hlte Newsgruppe(n) ignorieren."
 
 /* 
  * explanation strings ng mode
@@ -237,98 +367,99 @@
 #define NGUNSUB_EXSTR		"Aktuelle Newsgruppe als `nicht abonniert' kennzeichnen."
 #define NGGOTO_EXSTR		"Zur gew\344hlten Newsgruppe gehen (und abonnieren, falls n\366tig)."
 #define NGALLGROUPS_EXSTR	"Alle verf\374gbaren Newsgruppen anzeigen - auch die nicht abonnierten."
-#define NGLISTOLD_EXSTR		"Alle abonnierten Newsgruppen anzeigen - auch wenn keine neuen Artikel (toggle)."
+#define NGLISTOLD_EXSTR		"Abonnierte Newsgruppen auch anzeigen, wenn keine neuen Artikel vorliegen (ein/aus)."
 #define NGRESCAN_EXSTR		"Den News-Server abfragen, ob neue Artikel oder Newsgruppen existieren."
 #define NGGETLIST_EXSTR		"Eine komplette Liste der Newsgruppen vom News-Server holen."
 #define NGPREVGROUP_EXSTR  	"Zur zuletzt gelesenen Newsgruppe zur\374ckkehren (und abonnieren, falls n\366tig)."
-#define NGSELECT_EXSTR		"Aktuelle Auswahl f\374r eine nachfolgende Verschiebung merken."
-#define NGMOVE_EXSTR		"Gemerkte Auswahl vor die gew\344hlte Newsgruppe setzen."
+#define NGSELECT_EXSTR		"Aktuelle Auswahl f\374r eine nachfolgende Verschiebung vormerken."
+#define NGMOVE_EXSTR		"Vorgemerkte Newsgruppe(n) vor die gew\344hlte Newsgruppe setzen."
 #define NGEXIT_EXSTR		"Programm XRN verlassen, ohne die Datei .newsrc zu aktualisieren."
 #define NGCHECKPOINT_EXSTR	"Die Datei .newsrc aktualisieren."
-#define NGGRIPE_EXSTR		"Eine Nachricht an die XRN-Systembetreuer senden."
-#define NGPOST_EXSTR		"Einen Artikel zu einer oder mehreren Newsgruppen ver\366ffentlichen."
-#define NGPOST_AND_MAIL_EXSTR	"Einen Artikel zu einer oder mehreren Newsgruppen ver\366ffentlichen und ihn versenden."
-#define NGSCROLL_EXSTR		"Liste der Newsgruppen nach oben schieben."
-#define NGSCROLLBACK_EXSTR	"Liste der Newsgruppen nach unten schieben."
+#define NGGRIPE_EXSTR		"Nachricht an die XRN-Systembetreuer senden."
+#define NGPOST_EXSTR		"Artikel schreiben und in einer oder mehreren Newsgruppen ver\366ffentlichen."
+#define NGPOST_AND_MAIL_EXSTR	"Artikel schreiben, in Newsgruppe(n) ver\366ffentlichen und als E-Mail versenden."
+#define NGSCROLL_EXSTR		"Liste der Newsgruppen weiterbl\344ttern."
+#define NGSCROLLBACK_EXSTR	"Liste der Newsgruppen zur\374ckbl\344ttern."
 
 /* 
  * explanation strings all mode
  */
 
-#define ALLQUIT_EXSTR		"Die Datei .newsrc aktualisieren und zur Gruppenauswahl zur\374ckkehren."
-#define ALLSUB_EXSTR		"Aktuelle Newsgruppe als `abonniert' kennzeichnen ohne die Reihenfolge zu \344ndern."
+#define ALLQUIT_EXSTR		"Die Datei .newsrc aktualisieren; weiter zur \334bersicht der abonnierten Gruppen."
+#define ALLSUB_EXSTR		"Aktuelle Newsgruppe als `abonniert' kennzeichnen, ohne die Reihenfolge zu \344ndern."
 #define ALLFIRST_EXSTR		"Gew\344hlte Newsgruppe(n) als `abonniert' kennzeichnen und an den Anfang setzen."
 #define ALLLAST_EXSTR		"Gew\344hlte Newsgruppe(n) als `abonniert' kennzeichnen und ans Ende setzen."
 #define ALLAFTER_EXSTR		"Gew\344hlte Newsgruppe(n) als `abonniert' kennzeichnen und plazieren."
-#define ALLUNSUB_EXSTR		"Gew\344hlte Newsgruppe(n) als `nicht abonniert' kennzeichnen"
-#define ALLIGNORE_EXSTR		"Ausgew\344hlte Newsgruppe(n) ignorieren."
-#define ALLGOTO_EXSTR		"Zur gew\344hlten Newsgruppe gehen"
-#define ALLSELECT_EXSTR		"Aktuelle Auswahl f\374r eine nachfolgende Verschiebung merken."
-#define ALLMOVE_EXSTR		"Gemerkte Auswahl vor die gew\344hlte Newsgruppe setzen."
-#define ALLTOGGLE_EXSTR		"Reihenfolge der Anzeige \344ndern - alphabtisch/.newsrc ."
-#define ALLSCROLL_EXSTR		"Liste der Newsgruppen nach oben schieben."
-#define ALLSCROLLBACK_EXSTR	"Liste der Newsgruppen nach unten schieben."
-#define ALLSEARCH_EXSTR		"Search the group list"
-#define ALLLIMIT_EXSTR		"Display a subset of the group list"
-#define ALLPOST_EXSTR		"Einen Artikel zu einer Newsgruppe ver\366ffentlichen."
-#define ALLPOST_AND_MAIL_EXSTR	"Einen Artikel zu einer Newsgruppe ver\366ffentlichen und ihn an jemanden senden."
+#define ALLUNSUB_EXSTR		"Gew\344hlte Newsgruppe(n) als `nicht abonniert' kennzeichnen."
+#define ALLIGNORE_EXSTR		"Gew\344hlte Newsgruppe(n) ignorieren."
+#define ALLGOTO_EXSTR		"Aktuelle Newsgruppe lesen."
+#define ALLSELECT_EXSTR		"Aktuelle Auswahl f\374r eine nachfolgende Verschiebung vormerken."
+#define ALLMOVE_EXSTR		"Vorgemerkte Newsgruppe(n) vor die gew\344hlte Newsgruppe setzen."
+#define ALLTOGGLE_EXSTR		"Reihenfolge der Anzeige umschalten: alphabetisch/.newsrc ."
+#define ALLSCROLL_EXSTR		"Liste der Newsgruppen weiterbl\344ttern."
+#define ALLSCROLLBACK_EXSTR	"Liste der Newsgruppen zur\374ckbl\344ttern."
+#define ALLSEARCH_EXSTR		"Suchen in der Gruppenliste."
+#define ALLLIMIT_EXSTR		"Gruppenliste gem\344\337 Suchmuster einschr\344nken."
+#define ALLPOST_EXSTR		"Artikel schreiben und in der aktuellen Newsgruppe ver\366ffentlichen."
+#define ALLPOST_AND_MAIL_EXSTR	"Artikel schreiben, in der aktuellen Newsgruppe ver\366ffentlichen und als E-Mail senden."
 
 /* 
  * explanation strings art mode
  *
  */
 
-#define ARTQUIT_EXSTR		"Zur Gruppenauswahl zur\374ckkehren."
+#define ARTQUIT_EXSTR		"Zur Gruppen\374bersicht zur\374ckkehren."
 #define ARTNEXTUNREAD_EXSTR	"N\344chsten noch nicht gelesenen Artikel anzeigen."
 #define ARTNEXT_EXSTR		"N\344chsten Artikel anzeigen."
-#define ARTCURRENT_EXSTR	"Artikel unter der Schreibmarke lesen."
+#define ARTCURRENT_EXSTR	"Gew\344hlten Artikel anzeigen."
 #define ARTUP_EXSTR		"Eine Zeile nach oben in der Themenliste."
 #define ARTDOWN_EXSTR		"Eine Zeile nach unten in der Themenliste."
-#define ARTSCROLL_EXSTR		"Aktuellen Artikel nach oben schieben."
-#define ARTSCROLLBACK_EXSTR	"Aktuellen Artikel nach unten schieben."
-#define ARTSCROLLLINE_EXSTR	"Aktuellen Artikel eine Zeile nach oben schieben."
-#define ARTSCROLLBCKLN_EXSTR	"Aktuellen Artikel eine Zeile nach unten schieben."
-#define ARTSCROLLEND_EXSTR	"Zum Ende des Aktuellen Artikels gehen."
-#define ARTSCROLLBEG_EXSTR	"Zum Anfang des Aktuellen Artikels gehen."
-#define ARTSCROLLINDEX_EXSTR	"Liste der Artikel nach oben schieben."
-#define ARTSCROLLINDBCK_EXSTR	"Liste der Artikel nach unten schieben."
-#define ARTPREV_EXSTR		"Den vorhergehenden Artikel lesen."
-#define ARTLAST_EXSTR		"Den zuletzt angezeigten Artikel lesen."
-#define ARTNEXTGROUP_EXSTR	"Zur n\344chsten noch nicht gelesenen Newsgruppe gehen, dabei Gruppenauswahl \374bergehen."
-#define ARTCATCHUP_EXSTR	"Alle Artikel (bis zum aktuellen) als `gelesen' kennzeichnen und Newsgruppe verlassen."
-#define ARTFEEDUP_EXSTR		"Alle Artikel als `gelesen' kennzeichnen und zur n\344chsten noch nicht gelesenen Newsgruppe gehen."
-#define ARTGOTOARTICLE_EXSTR	"Einen bestimmten Artikel in der aktuellen Newsgruppe lesen."
+#define ARTSCROLL_EXSTR		"Aktuellen Artikel weiterbl\344ttern."
+#define ARTSCROLLBACK_EXSTR	"Aktuellen Artikel zur\374ckbl\344ttern."
+#define ARTSCROLLLINE_EXSTR	"Aktuellen Artikel eine Zeile weiterschieben."
+#define ARTSCROLLBCKLN_EXSTR	"Aktuellen Artikel eine Zeile zur\374ckschieben."
+#define ARTSCROLLEND_EXSTR	"Zum Ende des aktuellen Artikels gehen."
+#define ARTSCROLLBEG_EXSTR	"Zum Anfang des aktuellen Artikels gehen."
+#define ARTSCROLLINDEX_EXSTR	"Themenliste weiterbl\344ttern."
+#define ARTSCROLLINDBCK_EXSTR	"Themenliste zur\374ckbl\344ttern."
+#define ARTPREV_EXSTR		"Vorhergehenden Artikel anzeigen."
+#define ARTLAST_EXSTR		"Den zuletzt gelesenen Artikel anzeigen."
+#define ARTNEXTGROUP_EXSTR	"Zur n\344chsten ungelesenen Newsgruppe gehen; Gruppen\374bersicht \374berspringen."
+#define ARTCATCHUP_EXSTR	"Alle Artikel (bis zum gew\344hlten) als `gelesen' markieren; dann Gruppen\374bersicht."
+#define ARTFEEDUP_EXSTR		"Alle Artikel als `gelesen' markieren; dann zur n\344chsten ungelesenen Newsgruppe."
+#define ARTGOTOARTICLE_EXSTR	"Einen bestimmten Artikel in der aktuellen Newsgruppe anzeigen."
 #define ARTMARKREAD_EXSTR	"Gew\344hlte Artikel als `gelesen' kennzeichnen."
 #define ARTMARKUNREAD_EXSTR	"Gew\344hlte Artikel als `nicht gelesen' kennzeichnen."
-#define ARTSUB_EXSTR		"Subscribe to the current group"
-#define ARTUNSUB_EXSTR		"Aktuelle Newsgruppe als `nicht abonniert' kennzeichnen."
+#define ARTSUB_EXSTR		"Aktuellen Gruppe abonnieren."
+#define ARTUNSUB_EXSTR		"Aktuelle Gruppe als `nicht abonniert' kennzeichnen."
 #define ARTSUBNEXT_EXSTR	"Den n\344chsten Artikel mit dem gleichen Thema suchen."
 #define ARTSUBPREV_EXSTR	"Einen vorhergehenden Artikel mit dem gleichen Thema suchen."
-#define ARTPARENT_EXSTR		"Search for the parent of the current or selected article"
-#define ARTKILLSUBJECT_EXSTR	"Markiere alle Artikel mit diesem Betreff als gelesen."
-#define ARTKILLAUTHOR_EXSTR	"Markiere alle Artikel mit diesem Autor als gelesen."
-#define ARTKILLTHREAD_EXSTR	"Mark all articles in this thread as read"
-#define ARTKILLSUBTHREAD_EXSTR	"Mark all articles in this subthread as read"
+#define ARTPARENT_EXSTR		"Den Vorg\344nger des aktuellen oder gew\344hlten Artikels suchen."
+#define ARTKILLSUBJECT_EXSTR	"Markiere alle Artikel mit diesem Thema als gelesen."
+#define ARTKILLAUTHOR_EXSTR	"Markiere alle Artikel von diesem Autor als gelesen."
+#define ARTKILLTHREAD_EXSTR	"Markiere alle Artikel in dieser Serie als gelesen."
+#define ARTKILLSUBTHREAD_EXSTR	"Markiere alle Artikel in dieser Teilserie als gelesen."
 #define ARTSUBSEARCH_EXSTR	"Artikel zu einem bestimmten Thema suchen."
-#define ARTCONTINUE_EXSTR	"Suchen nach einem bestimmten Thema fortsetzen."
-#define ARTPOST_EXSTR		"Einen Artikel zu dieser Newsgruppe ver\366ffentlichen."
-#define ARTPOST_MAIL_EXSTR	"Einen Artikel zu dieser Newsgruppe ver\366ffentlichen und gleichzeitig versenden."
-#define MAIL_EXSTR		"Versende eine E-Mail."
-#define ARTEXIT_EXSTR		"Zur Gruppenauswahl zur\374ckkehren und alle Artikel als `nicht gelesen' kennzeichnen."
+#define ARTCONTINUE_EXSTR	"Suchen nach Thema fortsetzen."
+#define ARTPOST_EXSTR		"Artikel schreiben und in dieser Newsgruppe ver\366ffentlichen."
+#define ARTPOST_MAIL_EXSTR	"Artikel schreiben, in dieser Newsgruppe ver\366ffentlichen und als E-Mail versenden."
+#define MAIL_EXSTR		"E-Mail-Nachricht schreiben und versenden."
+#define ARTEXIT_EXSTR		"Alle Artikel als `nicht gelesen' markieren; dann zur Gruppen\374bersicht."
 #define ARTCHECKPOINT_EXSTR	"Die Datei .newsrc aktualisieren."
-#define ARTGRIPE_EXSTR		"Eine Nachricht an den XRN-Systembetreuer senden."
-#define ARTLISTOLD_EXSTR	"Alle Artikel der aktuellen Newsgruppe zeigen (evtl. langsam)."
-#define ARTRESORT_EXSTR		"Resort the article list"
+#define ARTGRIPE_EXSTR		"Nachricht an den XRN-Systembetreuer senden."
+#define ARTLISTOLD_EXSTR	"Alle, auch alte, Artikel der aktuellen Newsgruppe zeigen (evtl. langsam)."
+#define ARTRESORT_EXSTR		"Themenliste neu sortieren."
 #define ARTSAVE_EXSTR		"Aktuellen Artikel in eine Datei speichern."
-#define ARTREPLY_EXSTR		"Eine Nachricht an den Verfasser des aktuellen Artikels senden."
+#define ARTREPLY_EXSTR		"Antwort per E-Mail an den Verfasser des aktuellen Artikels senden."
 #define ARTFORWARD_EXSTR	"Aktuellen Artikel an weitere Benutzer senden."
-#define ARTFOLLOWUP_EXSTR	"Einen, zum aktuellen Artikel bezugnehmenden, Artikel verfassen."
-#define ARTFOLLOWREPL_EXSTR	"Einen bezugnehmenden Artikel verfassen und diesen auch an den Verfasser senden."
+#define ARTFOLLOWUP_EXSTR	"Folgeartikel zum aktuellen Artikel schreiben und ver\366ffentlichen."
+#define ARTFOLLOWREPL_EXSTR	"Folgeartikel schreiben, ver\366ffentlichen, und dem Autor des aktuellen Artikels senden."
 #define ARTCANCEL_EXSTR		"Aktuellen, eigenen Artikel zur\374ckziehen."
 #define ARTROT13_EXSTR		"Aktuellen Artikel entschl\374sseln."
 #define ARTXLATE_EXSTR		"Aktuellen Artikel an Zeichensatz anpassen."
-#define ARTHEADER_EXSTR		"Den kompletten/gek\374rzten Artikelkopf ausgeben (wechselweise)."
+#define ARTHEADER_EXSTR		"Den kompletten/gek\374rzten Artikelkopf zeigen (wechselweise)."
 #define ARTPRINT_EXSTR		"Aktuellen Artikel auf dem Drucker ausgeben."
 
 #endif /* XRN_LANG_german */
+
 #endif /* BUTEXPL_H */
diff -ruPN 9.00/compose.c 9.01/compose.c
--- 9.00/compose.c	Sun Dec 28 11:29:44 1997
+++ 9.01/compose.c	Wed May 13 21:29:15 1998
@@ -1,5 +1,5 @@
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: compose.c,v 1.111 1997/12/28 16:29:44 jik Exp $";
+static char XRNrcsid[] = "$Id: compose.c,v 1.122 1998/05/14 01:29:15 jik Exp $";
 #endif
 
 /*
@@ -99,8 +99,46 @@
 #include <libinn.h>
 #endif
 
+struct header {
+    struct newsgroup *newsgroup;
+    art_num article;
+    file_cache_file artFile;
+    char *newsgroups;
+    char *subject;
+    char *id;
+    char *followupTo;
+    char *references;
+    char *from;
+    char *sender;
+    char *replyTo;
+    char *distribution;
+    char *keywords;
+
+    char *user;
+    char *real_user;
+    char *fullname;
+    char *host;
+    char *real_host;
+#ifndef INEWS
+    char *sender_host;
+#endif
+#ifndef INN
+    char *path;
+#endif
+    char *organization;
+
+    char  *date; /* added to header structure....... */
+};
+
+static void freeHeader _ARGUMENTS((struct header *));
 static void saveDeadLetter _ARGUMENTS((char *));
 static int trim_references _ARGUMENTS((char *));
+static void switch_message_type _ARGUMENTS((struct header *));
+static char *update_headers _ARGUMENTS((struct header *, int, int, int));
+static char *followup_or_reply_title _ARGUMENTS((struct header *, int, int));
+static void compose_buttons _ARGUMENTS((Widget, int));
+static int check_quoted_text _ARGUMENTS((char *));
+static char *insert_courtesy_tag _ARGUMENTS((char *));
 
 #ifdef GENERATE_EXTRA_FIELDS
 static char *gen_id _ARGUMENTS((void));
@@ -116,7 +154,9 @@
 /* entire pane */
 static Widget ComposeTopLevel = (Widget) 0;
 /* text window */
+static Widget ComposeLabel = (Widget) 0;
 static Widget ComposeText = (Widget) 0;
+static Widget ComposeButtonBox = (Widget) 0;
 
 /*
   This stuff is used by the external editorCommand code.  See
@@ -135,7 +175,7 @@
 EditStatus editing_status = NoEdit;
 extern int inchannel;
 
-static int Call_Editor _ARGUMENTS((Boolean save_message));
+static int Call_Editor _ARGUMENTS((Boolean save_message, Boolean preserve_mtime));
 
 /*
   End stuff used for editorCommand support.
@@ -158,38 +198,6 @@
 #define IS_RESPONSE(mode) ((mode == FOLLOWUP) || (mode == REPLY) || \
 			   (mode == FOLLOWUP_REPLY))
 
-struct header {
-    art_num article;
-    file_cache_file artFile;
-    char *newsgroups;
-    char *subject;
-    char *id;
-    char *followupTo;
-    char *references;
-    char *from;
-    char *sender;
-    char *replyTo;
-    char *distribution;
-    char *keywords;
-
-    char *user;
-    char *real_user;
-    char *fullname;
-    char *host;
-    char *real_host;
-#ifndef INEWS
-    char *sender_host;
-#endif
-#ifndef INN
-    char *path;
-#endif
-    char *organization;
-
-    char  *date; /* added to header structure....... */
-};
-
-static void freeHeader _ARGUMENTS((struct header *));
-
 /*
  * storage for the header information needed for building, checking,
  * and repairing the header.  Once this is created, the user can go
@@ -199,13 +207,30 @@
 
 static struct header Header, CancelHeader;
 
+#define SIG_PREFIX "-- \n"
 
 BUTTON(compAbort,abort);
 BUTTON(compSave,save);
+BUTTON(compSwitchFollowup,switch to followup);
+BUTTON(compSwitchReply,switch to reply);
+BUTTON(compSwitchBoth,switch to followup/reply);
 BUTTON(compSend,send);
 BUTTON(compIncludeArticle,include article);
 BUTTON(compIncludeFile,include file);
 
+static ButtonList CompButtonList[] = {
+  {"compAbort",			compAbortCallbacks,		0,	True},
+  {"compSwitchFollowup",	compSwitchFollowupCallbacks,	0,	True},
+  {"compSwitchReply",		compSwitchReplyCallbacks,	0,	True},
+  {"compSwitchBoth",		compSwitchBothCallbacks,	0,	True},
+  {"compSend",			compSendCallbacks,		0,	True},
+  {"compSave",			compSaveCallbacks,		0,	True},
+  {"compIncludeArticle",	compIncludeArticleCallbacks,	0,	True},
+  {"compIncludeFile",		compIncludeFileCallbacks,	0,	True},
+};
+
+static int CompButtonListCount = XtNumber(CompButtonList);
+
 /*
  * Get the username of the user running the program, or an empty string
  * if the username can't be determined.  The returned string is
@@ -311,6 +336,8 @@
 
   (void) memset((char *)Header, 0, sizeof(*Header));
 
+  Header->newsgroup = newsgroup;
+
   if (article > 0) {
 #define CHECK(field,name) if (art->field) Header->field = XtNewString(art->field); else xhdr(newsgroup, article, name, &Header->field);
 
@@ -1277,7 +1304,7 @@
      * be the way things are done elsewhere in this file, so I'll
      * stick with it.
      */
-    char *ptr;
+    char *ptr, *ptr2;
     int mode, i, j, comma;
     unsigned long newsgroups_status WALL(= 0);
     int tries = 1, saved = 0;
@@ -1295,7 +1322,7 @@
 	    XBell(XtDisplay(TopLevel), 0);
 	    mesgPane(XRN_SERIOUS, mesg_name, MULTI_MSG, "Subject");
 	    if (app_resources.editorCommand)
-		Call_Editor(True);
+		Call_Editor(True, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
 	}
@@ -1309,7 +1336,7 @@
 		mesgPane(XRN_SERIOUS | XRN_SAME_LINE, mesg_name,
 			 FILL_IN_RESEND_MSG);
 		if (app_resources.editorCommand)
-		    Call_Editor(True);
+		    Call_Editor(True, False);
 		TextEnableRedisplay(ComposeText);
 		CLEANUP(); return;
 	    }
@@ -1329,7 +1356,7 @@
 	    mesgPane(XRN_SERIOUS, mesg_name, EMPTY_SUBJECT_MSG);
 	    mesgPane(XRN_SERIOUS | XRN_SAME_LINE, mesg_name, FILL_IN_RESEND_MSG);
 	    if (app_resources.editorCommand)
-		Call_Editor(False);
+		Call_Editor(False, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
  	}
@@ -1355,7 +1382,7 @@
 	    XBell(XtDisplay(TopLevel), 0);
 	    mesgPane(XRN_SERIOUS, mesg_name, MULTI_MSG, "From");
 	    if (app_resources.editorCommand)
-		Call_Editor(True);
+		Call_Editor(True, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
 	}
@@ -1372,6 +1399,61 @@
 	    buffer2_size = 0;
 	    buildRealFrom(&Header, &buffer2, &buffer2_size, &buffer2_total_size);
 	    if (strcmp(buffer, buffer2)) {
+#ifdef SENDMAIL_VERIFY
+	      if (app_resources.verifyFrom) {
+		char *verify_command, *addr, *addr_buf, *ptr, *ptr2;
+		int cmd_length;
+
+		addr = strchr(buffer, ':') + 1;
+		addr_buf = addr = XtNewString(addr);
+		
+		while (isspace((unsigned char)*addr))
+		  addr++;
+		if ((ptr = strchr(addr, '\n'))) {
+		  *ptr-- = '\0';
+		  while ((ptr >= addr) && isspace((unsigned char)*ptr))
+		    *ptr-- = '\0';
+		}
+
+		cmd_length = strlen(SENDMAIL_VERIFY) + strlen(addr) + 4;
+		for (ptr = strpbrk(addr, "\'\\"); ptr;
+		     ptr = strpbrk(ptr + 1, "\'\\"))
+		  cmd_length += 3;
+
+		verify_command = XtMalloc(cmd_length);
+		(void) strcpy(verify_command, SENDMAIL_VERIFY);
+		ptr = &verify_command[sizeof(SENDMAIL_VERIFY)-1];
+		*ptr++ = ' ';
+		*ptr++ = '\'';
+		for (ptr2 = addr; *ptr2; ptr2++) {
+		  if (*ptr2 == '\'' || *ptr2 == '\\') {
+		    *ptr++ = '\'';
+		    *ptr++ = '\\';
+		    *ptr++ = *ptr2;
+		    *ptr++ = '\'';
+		  }
+		  else {
+		    *ptr++ = *ptr2;
+		  }
+		}
+		*ptr++ = '\'';
+		*ptr++ = '\0';
+
+		if (system(verify_command)) {
+		  XBell(XtDisplay(TopLevel), 0);
+		  mesgPane(XRN_SERIOUS, 0, BAD_FROM_MSG, addr);
+		  XtFree(addr_buf);
+		  if (app_resources.editorCommand)
+		    Call_Editor(True, False);
+		  TextEnableRedisplay(ComposeText);
+		  CLEANUP();
+		  return;
+		}
+
+		XtFree(addr_buf);
+	      }
+#endif /* SENDMAIL_VERIFY */
+
 		*buffer = '\0';
 		buffer_size = 0;
 		buildSender(&Header, &buffer, &buffer_size, &buffer2_size);
@@ -1384,7 +1466,7 @@
 	    XBell(XtDisplay(TopLevel), 0);
 	    mesgPane(XRN_SERIOUS, mesg_name, MULTI_MSG, "Newsgroups");
 	    if (app_resources.editorCommand)
-		Call_Editor(True);
+		Call_Editor(True, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
 	}
@@ -1409,7 +1491,7 @@
 			 FILL_IN_RESEND_MSG);
 	    }
 	    if (app_resources.editorCommand)
-		Call_Editor(True);
+		Call_Editor(True, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
 	}
@@ -1461,7 +1543,7 @@
 	if (! (newsgroups_status & NG_POSTABLE)) {
 	    mesgPane(XRN_ERROR, mesg_name, NO_POSTABLE_NG_MSG);
 	    if (app_resources.editorCommand)
-		Call_Editor(False);
+		Call_Editor(False, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
 	}
@@ -1496,7 +1578,7 @@
 	  XBell(XtDisplay(TopLevel), 0);
 	  ChoiceBox(TopLevel, buf, 1, OK_MSG);
 	  if (app_resources.editorCommand)
-	    Call_Editor(True);
+	    Call_Editor(True, False);
 	  TextEnableRedisplay(ComposeText);
 	  CLEANUP(); XtFree(buf); return;
 	}
@@ -1509,7 +1591,7 @@
 	      sprintf(buf, CROSSPOST_CONFIRM_MSG, i) &&
 	      (ChoiceBox(TopLevel, buf, 2, POST_MSG, EDIT_MSG) == 2)) {
 	    if (app_resources.editorCommand)
-	      Call_Editor(True);
+	      Call_Editor(True, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); XtFree(buf); return;
 	  }
@@ -1533,7 +1615,7 @@
 		  sprintf(buf, FOLLOWUP_FOLLOWUPTO_CONFIRM_MSG, i, j) &&
 		  (ChoiceBox(TopLevel, buf, 2, POST_MSG, EDIT_MSG) == 2)) {
 		if (app_resources.editorCommand)
-		  Call_Editor(True);
+		  Call_Editor(True, False);
 		TextEnableRedisplay(ComposeText);
 		CLEANUP(); XtFree(buf); return;
 	      }
@@ -1546,7 +1628,7 @@
 	      sprintf(buf, FOLLOWUP_CONFIRM_MSG, i);
 	      if (ChoiceBox(TopLevel, buf, 2, POST_MSG, EDIT_MSG) == 2) {
 		if (app_resources.editorCommand)
-		  Call_Editor(True);
+		  Call_Editor(True, False);
 		TextEnableRedisplay(ComposeText);
 		CLEANUP(); XtFree(buf); return;
 	      }
@@ -1558,7 +1640,7 @@
 	    XBell(XtDisplay(TopLevel), 0);
 	    mesgPane(XRN_SERIOUS, mesg_name, MULTI_MSG, "Path");
 	    if (app_resources.editorCommand)
-		Call_Editor(True);
+		Call_Editor(True, False);
 	    TextEnableRedisplay(ComposeText);
 	    CLEANUP(); return;
 	}
@@ -1608,6 +1690,36 @@
 
     ptr = TextGetString(ComposeText);
 
+    if ((ptr2 = strstr(ptr, "\n\n"))) {
+      ptr2 += 2;
+      while (*ptr2 && isspace((unsigned char)*ptr2))
+	ptr2++;
+    }
+
+    if (! (ptr2 && *ptr2 && strncmp(ptr2, SIG_PREFIX, sizeof(SIG_PREFIX)-1))) {
+      XBell(XtDisplay(TopLevel), 0);
+      mesgPane(XRN_SERIOUS, mesg_name, NO_BODY_MSG);
+      if (app_resources.editorCommand)
+	Call_Editor(True, False);
+      TextSetInsertionPoint(ComposeText, TextGetLength(ComposeText));
+      TextEnableRedisplay(ComposeText);
+      XtFree(ptr);
+      CLEANUP();
+      return;
+    }
+
+    if (! check_quoted_text(ptr) &&
+	(ConfirmationBox(ComposeTopLevel, ONLY_INCLUDED_MSG, YES_STRING,
+			 RE_EDIT_MSG, True) == XRN_CB_ABORT)) {
+      if (app_resources.editorCommand)
+	Call_Editor(True, True);
+      TextSetInsertionPoint(ComposeText, ptr2 - ptr);
+      TextEnableRedisplay(ComposeText);
+      XtFree(ptr);
+      CLEANUP();
+      return;
+    }
+
     if ((PostingMode == FOLLOWUP_REPLY) || (PostingMode == POST_MAIL)) {
 	tries = 2;
     }
@@ -1672,7 +1784,8 @@
 	tries--;
 	if ((mode == XRN_NEWS) &&
 	    ((PostingMode == FOLLOWUP_REPLY) || (PostingMode == POST_MAIL))) {
-	    mode = XRN_MAIL;
+	  ptr = insert_courtesy_tag(ptr);
+	  mode = XRN_MAIL;
 	}
     } while (tries > 0);
 
@@ -1960,34 +2073,59 @@
     FILE *filefp;
     struct stat buf;
     char buffer[10];
-    char *ptr, *msg_type, *confirm1, *confirm2;
+    char *ptr, *confirms[5], *question;
+    int confirm_count = 0;
     int mesg_name = newMesgPaneName();
+    int choice;
+    int mode1 = PostingMode, mode2 = PostingMode;
 
     read(inchannel,buffer,1);
     if(editing_status != Completed || EditorFileName == NIL(char)){
 	return;
     }
 
+    confirms[confirm_count++] = ABORT_STRING;
+
+    confirms[confirm_count++] = RE_EDIT_MSG;
+   
     switch (PostingMode) {
     case POST:
+      question = ASK_POST_ARTICLE_MSG;
+      break;
     case FOLLOWUP:
-      msg_type = POST_FOLLOWUP_MSG;
-      confirm1 = ASK_POST_ARTICLE_MSG ;
-      confirm2 = ASK_RE_EDIT_ARTCILE_MSG ;
-	break;
+      question = ASK_POST_ARTICLE_MSG;
+      confirms[confirm_count++] = AS_REPLY_MSG;
+      confirms[confirm_count++] = AS_FOLLOWUP_REPLY_MSG;
+      mode1 = REPLY;
+      mode2 = FOLLOWUP_REPLY;
+      break;
+    case REPLY:
+      question = ASK_SEND_MSG;
+      confirms[confirm_count++] = AS_FOLLOWUP_MSG;
+      confirms[confirm_count++] = AS_FOLLOWUP_REPLY_MSG;
+      mode1 = FOLLOWUP;
+      mode2 = FOLLOWUP_REPLY;
+      break;
+    case FORWARD:
+    case GRIPE:
+    case MAIL:
+      question = ASK_SEND_MSG;
+      break;
     case FOLLOWUP_REPLY:
+      question = ASK_POST_SEND_MSG;
+      confirms[confirm_count++] = AS_FOLLOWUP_MSG;
+      confirms[confirm_count++] = AS_REPLY_MSG;
+      mode1 = FOLLOWUP;
+      mode2 = REPLY;
+      break;
     case POST_MAIL:
-      msg_type = FOLLOWUP_REPLY_MSG;
-      confirm1 = ASK_POST_SEND_MSG;  /* ... and/or ... */
-      confirm2 = ASK_RE_EDIT_MSG;
-	break;
     default:
-      msg_type= DEFAULT_MAIL_MSG;
-      confirm1 = ASK_POST_SEND_MSG; /* ... and/or ... */
-      confirm2 = ASK_RE_EDIT_MSG;
-	break;
+      question = ASK_POST_SEND_MSG;
+      break;
     }
 
+    confirms[confirm_count++] = YES_STRING;
+      
     if ((filefp = fopen(EditorFileName, "r")) == NULL) {
 	mesgPane(XRN_SERIOUS, mesg_name, CANT_OPEN_TEMP_MSG, EditorFileName,
 		 errmsg(errno));
@@ -2007,7 +2145,7 @@
     }
 
     if (originalBuf.st_mtime == buf.st_mtime) {
-	mesgPane(XRN_INFO, mesg_name, NO_CHANGE_MSG, EditorFileName);
+	mesgPane(XRN_SERIOUS, mesg_name, NO_CHANGE_MSG, EditorFileName);
 	(void) fclose(filefp);
 	(void) unlink(EditorFileName);
 	editing_status = NoEdit;
@@ -2016,7 +2154,7 @@
     }
 
     if (buf.st_size == 0) {
-	mesgPane(XRN_INFO, mesg_name, ZERO_SIZE_MSG, EditorFileName);
+	mesgPane(XRN_SERIOUS, mesg_name, ZERO_SIZE_MSG, EditorFileName);
 	(void) fclose(filefp);
 	(void) unlink(EditorFileName);
 	editing_status = NoEdit;
@@ -2032,20 +2170,26 @@
     TextSetString(ComposeText, ptr);
     FREE(ptr);
 
-    /* pop up a confirm box */
+    choice = ChoiceBox(TopLevel, question, confirm_count, confirms[0],
+		       confirms[1], confirms[2], confirms[3], confirms[4]);
 
-    if (ConfirmationBox(TopLevel, confirm1, 0, 0, False) == XRN_CB_ABORT) {
-	if (ConfirmationBox(TopLevel, confirm2, 0, 0, False) == XRN_CB_ABORT) {
-	    compAbortUtil(mesg_name, True);
-	    (void) unlink(EditorFileName);
-	    editing_status = NoEdit;
-	} else {
-	    Call_Editor(False);
-	}
-	return;
+    if (choice == 1) {
+      compAbortUtil(mesg_name, True);
+      (void) unlink(EditorFileName);
+      editing_status = NoEdit;
+    }
+    else if (choice == 2) {
+      Call_Editor(False, False);
+    }
+    else if (choice == confirm_count) {
+      compSendFunction(0, 0, 0, 0);
+    }
+    else {
+      PostingMode = (choice == 3) ? mode1 : mode2;
+      switch_message_type(&Header);
+      Call_Editor(True, True);
     }
 
-    compSendFunction(0, 0, 0, 0);
     return;
 }
 
@@ -2080,15 +2224,18 @@
 
 static int
 Call_Editor(
-	    _ANSIDECL(Boolean,	save_message)
+	    _ANSIDECL(Boolean,	save_message),
+	    _ANSIDECL(Boolean,	preserve_mtime)
 	    )
      _KNRDECL(Boolean,	save_message)
+     _KNRDECL(Boolean,	preserve_mtime)
 {
     char *dsp, *file;
     char buffer[1024], buffer2[1024];
     FILE *filefp;
     char *header = 0;
     int mesg_name = newMesgPaneName();
+    struct stat statbuf1, statbuf2;
 
     if (save_message) {
 	header = TextGetString(ComposeText);
@@ -2096,8 +2243,13 @@
     
     if ((editing_status == NoEdit) || header) {
 	editing_status = InProgress;
-	if(EditorFileName != NIL(char))
-	    utTempnamFree(EditorFileName);
+	if (EditorFileName) {
+	  if (preserve_mtime) {
+	    statbuf1.st_mtime = 0;
+	    (void) stat(EditorFileName, &statbuf1);
+	  }
+	  utTempnamFree(EditorFileName);
+	}
 	EditorFileName = utTempnam(app_resources.tmpDir, "xrn");
 	if ((filefp = fopen(EditorFileName, "w")) == NULL) {
 	    mesgPane(XRN_SERIOUS, mesg_name, CANT_OPEN_TEMP_MSG, EditorFileName,
@@ -2119,14 +2271,16 @@
 
 	(void) fclose(filefp);
 
-	if (stat(EditorFileName, &originalBuf) == -1) {
+	if (stat(EditorFileName, &statbuf2) == -1) {
 	    mesgPane(XRN_SERIOUS, mesg_name, CANT_STAT_TEMP_MSG, EditorFileName,
 		     errmsg(errno));
 	    editing_status = NoEdit;
 	    compAbortUtil(mesg_name, False);
 	    return (-1);
 	}
-
+	if (!preserve_mtime || !statbuf1.st_mtime ||
+	    (originalBuf.st_mtime == statbuf1.st_mtime))
+	  originalBuf = statbuf2;
     }
 
     /*
@@ -2238,7 +2392,7 @@
     long point;
 {
     char *signature;
-    Widget pane, buttonBox, label;
+    Widget pane;
     Dimension height_val;
     static char titleStorage[LABEL_SIZE];
     Dimension width_val;
@@ -2276,30 +2430,19 @@
 
     (void) strcpy(titleStorage, titleString);
 
-    label = XtCreateManagedWidget("label", labelWidgetClass, pane,
-				  labelArgs, XtNumber(labelArgs));
+    ComposeLabel = XtCreateManagedWidget("label", labelWidgetClass, pane,
+					 labelArgs, XtNumber(labelArgs));
 
     ComposeText = TextCreate("text", False, pane);
     TextSetString(ComposeText, header);
     FREE(header);
  
-    buttonBox = ButtonBoxCreate("box", pane);
-
-    (void) ButtonBoxAddButton("compAbort", compAbortCallbacks, buttonBox);
-    (void) ButtonBoxAddButton("compSend", compSendCallbacks, buttonBox);
-    (void) ButtonBoxAddButton("compSave", compSaveCallbacks, buttonBox);
-
-    if ((PostingMode != POST) && 
-	(PostingMode != GRIPE) &&
-	(PostingMode != FORWARD)) {
-	(void) ButtonBoxAddButton("compIncludeArticle",
-				  compIncludeArticleCallbacks, buttonBox);
-    }
-    (void) ButtonBoxAddButton("compIncludeFile", compIncludeFileCallbacks,
-			      buttonBox);
+    ComposeButtonBox = ButtonBoxCreate("box", pane);
 
+    compose_buttons(ComposeButtonBox, True);
+    
     if (app_resources.editorCommand != NIL(char)) {
-	return(Call_Editor(True));
+	return(Call_Editor(True, False));
     }
     else {
 	XtRealizeWidget(ComposeTopLevel);
@@ -2307,15 +2450,15 @@
 	  Needs to happen after widget is realized, so that the width
 	  of the button box is correct.
 	  */
-	ButtonBoxDoneAdding(buttonBox);
+	ButtonBoxDoneAdding(ComposeButtonBox);
 
 	XtSetKeyboardFocus(ComposeTopLevel, ComposeText);
 
-	XtVaGetValues(label,
+	XtVaGetValues(ComposeLabel,
 		      XtNheight, (XtPointer) &height_val,
 		      (char *) 0);
 
-	XawPanedSetMinMax(label, (int) height_val, (int) height_val);
+	XawPanedSetMinMax(ComposeLabel, (int) height_val, (int) height_val);
 	XawPanedAllowResize(TEXT_PANE_CHILD(ComposeText), True);
     
 	{
@@ -2347,6 +2490,28 @@
     }
 }
 
+static void compose_buttons(box, first_time)
+     Widget box;
+     int first_time;
+{
+  int both, followup, reply;
+  
+  both = (PostingMode == FOLLOWUP_REPLY);
+  followup = both || (PostingMode == FOLLOWUP);
+  reply = both || (PostingMode == REPLY);
+
+  setButtonActive(CompButtonList, "compSwitchFollowup", reply);
+  setButtonActive(CompButtonList, "compSwitchReply", followup);
+  setButtonActive(CompButtonList, "compSwitchBoth",
+		  (followup || reply) && !both);
+  setButtonActive(CompButtonList, "compIncludeArticle", followup || reply);
+
+  doButtons(NULL, box, CompButtonList, &CompButtonListCount, BOTTOM);
+
+  if (! first_time)
+    ButtonBoxDoneAdding(box);
+}
+
 
 static char *signatureFile()
 /*
@@ -2490,7 +2655,7 @@
 	}
     }
 
-    (void) strcpy(info, "-- \n");
+    (void) strcpy(info, SIG_PREFIX);
     count = fread(&info[4], sizeof(char), sizeof(info) - 4, infofp);
     info[count + 4] = '\0';
 
@@ -2499,8 +2664,7 @@
 	mesgPane(XRN_SERIOUS, 0, SIGNATURE_TOO_BIG_MSG, sigfile);
 	retinfo = NIL(char);
     }
-    else if (strncmp(info + 4, "--\n", 3) == 0 ||
-	     strncmp(info + 4, "-- \n", 4) == 0) {
+    else if (strncmp(info + 4, SIG_PREFIX, 4) == 0) {
 	retinfo = info + 4;
     } else {
 	retinfo = info;
@@ -2512,6 +2676,143 @@
 }
 
 
+/*
+  Update the headers of a message so that it has all the appropriate
+  headers for either a followup, reply, or both.
+
+  If "first_time" is true, then assume that there is no current
+  message and all headers have to be created from scratch.  Otherwise,
+  check for headers in the current message and only create the ones
+  that need to be created; also, delete headers that are no longer
+  relevant.
+
+  Return an allocated string containing the headers to be added.
+*/
+static char *update_headers(Header, first_time, followup, reply)
+     struct header *Header;
+     int first_time, followup, reply;
+{
+  char *message = 0;
+  int message_size = 0, message_total_size = 0;
+
+  CHECK_SIZE(1);
+  message[0] = '\0';
+  message_size = 0;
+
+  if (first_time || (fieldExists("From:", NULL)  < 0))
+    buildFrom(Header, &message, &message_size, &message_total_size);
+  if (first_time || (fieldExists("Reply-To:", NULL) < 0))
+    buildReplyTo(&message, &message_size, &message_total_size);
+  if (first_time || (fieldExists("Subject:", NULL) < 0))
+    buildSubject(Header, &message, &message_size, &message_total_size);
+
+  if (followup) {
+    int num_groups;
+
+    if (first_time || (fieldExists("Path:", NULL) < 0))
+      buildPath(Header, &message, &message_size, &message_total_size);
+
+    if (first_time || (fieldExists("Newsgroups:", NULL) < 0)) {
+      num_groups = buildNewsgroups(Header, &message, &message_size,
+				   &message_total_size);
+      if (app_resources.warnings.followup.crossPost &&
+	  num_groups >= app_resources.warnings.followup.crossPost)
+	mesgPane(XRN_WARNING, 0, FOLLOWUP_MULTIPLE_NGS_MSG);
+      if (app_resources.warnings.followup.followupTo &&
+	  *Header->followupTo && strcmp(Header->followupTo, Header->newsgroups))
+	mesgPane(XRN_WARNING, 0, FOLLOWUP_FOLLOWUPTO_MSG);
+    }
+
+    if (first_time || (fieldExists("Distribution:", NULL) < 0))
+      buildDistribution(Header, &message, &message_size, &message_total_size);
+
+    if (first_time || (fieldExists("Followup-To:", NULL) < 0)) {
+      CHECK_SIZE(sizeof("Followup-To: \n") - 1);
+      (void) strcat(message, "Followup-To: \n");
+    }
+
+    if (first_time || (fieldExists("References:", NULL) < 0))
+      buildReferences(Header, &message, &message_size, &message_total_size);
+
+    if (first_time || (fieldExists("Organization:", NULL) < 0)) {
+      CHECK_SIZE(sizeof("Organization: \n") - 1 + strlen(Header->organization));
+      (void) sprintf(&message[strlen(message)], "Organization: %s\n",
+		     Header->organization);
+    }
+
+    if (first_time || (fieldExists("Keywords:", NULL) < 0)) {
+      CHECK_SIZE(sizeof("Keywords: \n") - 1);
+      (void) strcat(message, "Keywords: ");
+      if ((Header->keywords != NIL(char)) && (*Header->keywords != '\0')) {
+	CHECK_SIZE(strlen(Header->keywords));
+	(void) strcat(message, Header->keywords);
+      }
+      (void) strcat(message, "\n");
+    }
+  }
+  else if (! first_time) {
+    stripField("Path:");
+    stripField("Newsgroups:");
+    stripField("Distribution:");
+    stripField("Followup-To:");
+    stripField("References:");
+    stripField("Organization:");
+    stripField("Keywords:");
+  }
+
+  if (reply) {
+    if (first_time || (fieldExists("To:", NULL) < 0)) {
+      char *reply_addr = (Header->replyTo && *Header->replyTo)
+	? Header->replyTo : Header->from;
+      CHECK_SIZE(sizeof("To: \n") - 1 + strlen(reply_addr));
+      (void) sprintf(&message[strlen(message)], "To: %s\n", reply_addr);
+    }
+
+    if (app_resources.cc == True) {
+      if (first_time || (fieldExists("Cc:", NULL) < 0)) {
+	CHECK_SIZE(sizeof("Cc: \n") - 1 + strlen(Header->user));
+	sprintf(&message[strlen(message)], "Cc: %s\n", Header->user);
+      }
+    }
+
+    if (! followup) {
+      if (first_time || (fieldExists("X-Newsgroups:", NULL) < 0)) {
+	CHECK_SIZE(sizeof("X-Newsgroups: \n") - 1 +
+		   strlen(Header->newsgroups));
+	(void)sprintf(&message[strlen(message)],
+		      "X-Newsgroups: %s\n", Header->newsgroups);
+      }
+      if (first_time || (fieldExists("In-reply-to:", NULL) < 0)) {
+	CHECK_SIZE(sizeof("In-reply-to: \n") - 1 + strlen(Header->id));
+	(void) sprintf(&message[strlen(message)],
+		       "In-reply-to: %s\n", Header->id);
+      }
+    }
+  }
+  else if (! first_time) {
+    stripField("To:");
+    stripField("Cc:");
+    stripField("X-Newsgroups:");
+    stripField("In-reply-to:");
+  }
+  
+  return message;
+}
+
+static char *followup_or_reply_title(Header, followup, reply)
+     struct header *Header;
+     int followup, reply;
+{
+  struct newsgroup *newsgroup = Header->newsgroup;
+  art_num current = newsgroup->current;
+  static char title[LABEL_SIZE];
+
+  (void) sprintf(title, followup ? (reply ? FOLLOWUP_REPLY_TO_TITLE_MSG
+				    : FOLLOWUP_TO_TITLE_MSG) :
+		 REPLY_TO_TITLE_MSG, current, newsgroup->name);
+  return title;
+}
+
 static void followup_or_reply _ARGUMENTS((int, int));
 
 static void followup_or_reply(followup, reply)
@@ -2519,7 +2820,7 @@
 {
     struct newsgroup *newsgroup = CurrentGroup;
     art_num current = newsgroup->current;
-    char title[LABEL_SIZE];
+    char *title;
     char *message = 0;
     int message_size = 0, message_total_size = 0;
     int OldPostingMode = PostingMode;
@@ -2559,102 +2860,57 @@
 	}
     }
 
-    if (followup) {
-	if (reply) {
-	    PostingMode = FOLLOWUP_REPLY;
-          (void) sprintf(title, FOLLOWUP_REPLY_TO_TITLE_MSG,
-                           current, newsgroup->name);
-	}
-	else {
-	    PostingMode = FOLLOWUP;
-          (void) sprintf(title, FOLLOWUP_TO_TITLE_MSG,
-                           current, newsgroup->name);
-	}
-    }
-    else {
-	PostingMode = REPLY;
-          (void) sprintf(title, REPLY_TO_TITLE_MSG,
-                           current, newsgroup->name);
-    }
-    
-    CHECK_SIZE(1);
-    message[0] = '\0';
-    message_size = 0;
-    
-    buildFrom(&Header, &message, &message_size, &message_total_size);
-    buildReplyTo(&message, &message_size, &message_total_size);
-    buildSubject(&Header, &message, &message_size, &message_total_size);
-
-    if (followup) {
-      int num_groups;
-
-	buildPath(&Header, &message, &message_size, &message_total_size);
+    title = followup_or_reply_title(&Header, followup, reply);
 
-	num_groups = buildNewsgroups(&Header, &message, &message_size,
-				     &message_total_size);
-	if (app_resources.warnings.followup.crossPost &&
-	    (num_groups >= app_resources.warnings.followup.crossPost)) {
-	  mesgPane(XRN_WARNING, 0, FOLLOWUP_MULTIPLE_NGS_MSG);
-	}
+    if (followup)
+	if (reply)
+	  PostingMode = FOLLOWUP_REPLY;
+	else
+	  PostingMode = FOLLOWUP;
+    else
+      PostingMode = REPLY;
 
-	if (app_resources.warnings.followup.followupTo &&
-	    *Header.followupTo &&
-	    strcmp(Header.followupTo, Header.newsgroups))
-	  mesgPane(XRN_WARNING, 0, FOLLOWUP_FOLLOWUPTO_MSG);
+    message = update_headers(&Header, True, followup, reply);
+    message_size = strlen(message);
+    message_total_size = message_size;
+    
+    CHECK_SIZE(1);
+    (void) strcat(message, "\n");
 
-	buildDistribution(&Header, &message, &message_size,
-			  &message_total_size);
+    if (composePane(title, message, strlen(message))) {
+	 PostingMode = OldPostingMode;
+    }
 
-	CHECK_SIZE(sizeof("Followup-To: \n") - 1);
-	(void) strcat(message, "Followup-To: \n");
+    return;
+}
 
-	buildReferences(&Header, &message, &message_size, &message_total_size);
-	
-	buildExtraFields(&message, &message_size, &message_total_size);
-	
-	CHECK_SIZE(sizeof("Organization: \n") - 1 + strlen(Header.organization));
-	(void) sprintf(&message[strlen(message)], "Organization: %s\n",
-		       Header.organization);
+static void switch_message_type(Header)
+     struct header *Header;
+{
+  int both, followup, reply;
+  char *title;
+  char *headers;
 
-	CHECK_SIZE(sizeof("Keywords: \n") - 1);
-	(void) strcat(message, "Keywords: ");
-	if ((Header.keywords != NIL(char)) && (*Header.keywords != '\0')) {
-	    CHECK_SIZE(strlen(Header.keywords));
-	    (void) strcat(message, Header.keywords);
-	}
-	(void) strcat(message, "\n");
-    }
+ if (! ComposeTopLevel)
+   return;
 
-    if (reply) {
-	char *reply_addr;
+  both = (PostingMode == FOLLOWUP_REPLY);
+  followup = both || (PostingMode == FOLLOWUP);
+  reply = both || (PostingMode == REPLY);
 
-	reply_addr = ((Header.replyTo != NIL(char)) &&
-		      (*Header.replyTo != '\0')) ? Header.replyTo : Header.from;
-	CHECK_SIZE(sizeof("To: \n") - 1 + strlen(reply_addr));
-	(void) sprintf(&message[strlen(message)], "To: %s\n", reply_addr);
+  if (! (followup || reply))
+    return;
 
-        if (app_resources.cc == True) {
-	    CHECK_SIZE(sizeof("Cc: \n") - 1 + strlen(Header.user));
-	    sprintf(&message[strlen(message)], "Cc: %s\n", Header.user);
-	}
+  title = followup_or_reply_title(Header, followup, reply);
+  XtVaSetValues(ComposeLabel, XtNlabel, title, 0);
 
-	if (! followup) {
-	    CHECK_SIZE(sizeof("X-Newsgroups: \nIn-reply-to: %s\n") - 1 +
-		       strlen(Header.newsgroups) + strlen(Header.id));
-	    (void) sprintf(&message[strlen(message)],
-			   "X-Newsgroups: %s\nIn-reply-to: %s\n",
-			   Header.newsgroups, Header.id);
-	}
-    }
-	
-    CHECK_SIZE(1);
-    (void) strcat(message, "\n");
+  headers = update_headers(Header, False, followup, reply);
+  addField(headers);
+  XtFree(headers);
 
-    if (composePane(title, message, strlen(message))) {
-	 PostingMode = OldPostingMode;
-    }
+  compose_buttons(ComposeButtonBox, False);
 
-    return;
+  TextSetInsertionPoint(ComposeText, TextGetLength(ComposeText));
 }
 
 
@@ -2964,7 +3220,7 @@
   for (at = strchr(art_line, '@'); at; at = strchr(at + 1, '@')) {
     line_user = at - 1;
     while ((line_user > art_line) &&
-	   !isspace(*line_user) && (*line_user != '<'))
+	   !isspace((unsigned char)*line_user) && (*line_user != '<'))
       line_user--;
     line_host = at + 1;
     if (! ((strncmp(line_user, user, at - line_user) &&
@@ -3061,6 +3317,10 @@
     (void) sprintf(&message[strlen(message)], "Control: cancel %s\n",
 		   CancelHeader.id);
 
+    CHECK_SIZE(sizeof("\nCancel message from XRN .\n") + sizeof(XRN_VERSION) - 2);
+    (void) sprintf(&message[strlen(message)], "\nCancel message from XRN %s.\n",
+		   XRN_VERSION);
+
     switch (postArticle(message, XRN_NEWS,&ErrMessage)) {
     case POST_FAILED:
 	if (ErrMessage) {
@@ -3101,86 +3361,223 @@
 }
 
 /*
-  Trim the "References:" field starting at the input string, so that
-  it is 512 characters or less long, including the field name and the
-  newline and null at the end.  Do this by first reducing all
-  whitespace sequences to a single space, then trimming off any
-  garbage at the beginning of the line, then copying the first valid
-  message ID and trimming subsequent message ID's until the whole
-  thing will be short enough.
+  Reformat and trim the "References:" line.  Separate the IDs from the
+  field name with a single space, and separate all IDs with a single
+  space.  Remove corrupted IDs, and make sure the length of the whole
+  thing including the final newline is MAXREFSIZE or less characters
+  when done.  When trimming because there are too many IDs, preserve
+  the first ID and then as many as possible at the end while remaining
+  within the length limit.
 
-  Returns the new string length of the header, not including the final
+  Returns the length of the reformatted line, not including the final
   null.
+*/
+#define MAXREFSIZE 510 /* Includes the final newline but not the trailing null */
 
-  Doesn't modify the input string if it's already short enough.
-  */
 static int trim_references(refs)
      char *refs;
 {
-  char *outptr, *inptr;
-  int len;
+  char *inptr = XtNewString(refs), *inbuf = inptr;
+  char *outptr = XtMalloc(strlen(inptr)+1), *outbuf = outptr;
+  char *ptr, **ids;
+  int id_count = 0, id_count_size = 1, start_at;
+  int total_length = 1; /* the final newline */
   
-  if ((len = strlen(refs)) < 512)
-    return len;
+  ids = (char **) XtMalloc(id_count_size * sizeof(*ids));
 
-  inptr = outptr = refs;
-  while (*inptr) {
-    if (isspace(*inptr)) {
-      *outptr++ = ' ';
-      inptr++;
-      while (*inptr && isspace(*inptr)) {
-	inptr++;
-	len--;
-      } 
+  /* Copy field name */
+  while (*inptr != ':') {
+    *outptr++ = *inptr++;
+    total_length++;
+  }
+  *outptr++ = *inptr++;
+  total_length++;
+
+  /* Skip beginning whitespace */
+  while (isspace((unsigned char)*inptr))
+    inptr++;
+
+  /* Tokenize */
+  for (ptr = strtok(inptr, " \t\n"); ptr; ptr = strtok(NULL, " \t\n")) {
+    int len;
+
+    if ((*ptr != '<') /* No opening brace */
+	|| strchr(ptr + 1, '<') /* An extra opening brace */
+	|| (ptr[(len = strlen(ptr)) - 1] != '>') /* No closing brace */
+	|| (strchr(ptr, '>') - ptr != len - 1)) /* An extra closing brace */
+      continue;
+
+    if (id_count == id_count_size) {
+      id_count_size *= 2;
+      ids = (char **) XtRealloc((char *)ids, id_count_size * sizeof(*ids));
     }
-    else
-      *outptr++ = *inptr++;
+
+    ids[id_count++] = ptr;
+    total_length += 1 + len;	/* space and then message ID */
   }
 
-  inptr = outptr = strchr(refs, ':') + 1;
+  /* Always include the first Message ID.  Other than that, figure out
+     how many we can include at the end while still remaining within
+     the line length limit.
+
+     The GNKSA says that we should always include message IDs that are
+     mentioned in the body of the message.  We're not doing that
+     explicitly right now.
+  */
 
-  if (*inptr && isspace(*inptr)) {
-    outptr++;
-    inptr++;
+  for (start_at = 1; (start_at < id_count) && (total_length > MAXREFSIZE);
+       start_at++) {
+    total_length -= 1 + strlen(ids[start_at]);
   }
 
-  /* Skip garbage at the beginning (e.g., because of a References:
-     line that was truncated at the beginning improperly by some other
-     software) */
-  while (*inptr && *inptr != '<') {
-    inptr++;
-    len--;
+  /* Copy the first ID */
+  *outptr++ = ' ';
+  if (! id_count) {
+    goto done;
   }
-  if (! *inptr)
-    goto finished;
+  strcpy(outptr, ids[0]);
+  outptr += strlen(ids[0]);
 
-  /* Copy the first message ID */
-  while (*inptr && (*inptr != '>'))
-    *outptr++ = *inptr++;
-  if (! *inptr)
-    goto finished;
-  /* Copy the final '>' and the space after it. */
-  *outptr++ = *inptr++;
-  if (*inptr && isspace(*inptr))
-    *outptr++ = *inptr++;
+  /* Copy remaining IDs */
+  while (start_at < id_count) {
+    *outptr++ = ' ';
+    strcpy(outptr, ids[start_at]);
+    outptr += strlen(ids[start_at]);
+    start_at++;
+  }
+
+ done:
+  *outptr++ = '\n';
+  *outptr++ = '\0';
+  (void) strcpy(refs, outbuf);
+  XtFree(inbuf);
+  XtFree(outbuf);
+  XtFree((char *)ids);
+  return(total_length);
+}
+
+void compSwitchFollowupFunction(widget, event, string, count)
+    Widget widget;
+    XEvent *event;
+    String *string;
+    Cardinal *count;
+{
+  PostingMode = FOLLOWUP;
+  switch_message_type(&Header);
+}
+
+void compSwitchReplyFunction(widget, event, string, count)
+    Widget widget;
+    XEvent *event;
+    String *string;
+    Cardinal *count;
+{
+  PostingMode = REPLY;
+  switch_message_type(&Header);
+}
+
+void compSwitchBothFunction(widget, event, string, count)
+    Widget widget;
+    XEvent *event;
+    String *string;
+    Cardinal *count;
+{
+  PostingMode = FOLLOWUP_REPLY;
+  switch_message_type(&Header);
+}
+
+/*
+  Check if the article appears to contain only quoted text.  If so,
+  return False; else, return True.  That is, the return value of this
+  function indicates whether the article "should be posted," given its
+  included-text content.
+
+  Does this as follows:
+
+  1) Skip past the header and any whitespace following it.
+  2) If the first line doesn't start with "I" (as in "In article..."),
+     return True.
+  3) If the next line doesn't start with whitespace, return True.
+  4) If, before the end of the message or a line containing the
+     signature prefix, we encounter a line containing something other
+     than whitespace that doesn't start with the include prefix,
+     return True.
+  5) Else, return false.
+*/
   
-  while (len >= 512) {
-    char *newptr = strchr(inptr + 1, '<');
-    if (newptr) {
-      len -= (newptr - inptr);
-      inptr = newptr;
+static int check_quoted_text(article)
+     char *article;
+{
+  char *ptr;
+  int prefix_len = strlen(app_resources.includePrefix);
+
+  /* 1) */
+  if (! (ptr = strstr(article, "\n\n")))
+    return True;
+  ptr += 2;
+  while (*ptr && isspace((unsigned char)*ptr))
+    ptr++;
+
+  /* 2) */
+  if (*ptr != 'I')
+    return True;
+
+  /* 3) */
+  if (! (ptr = strchr(ptr, '\n')))
+    return True;
+  ptr++;
+  if (! isspace((unsigned char)*ptr))
+    return True;
+
+  /* 4) */
+  for (article = strchr(ptr, '\n');
+       article && strncmp(article + 1, SIG_PREFIX, sizeof(SIG_PREFIX)-1);
+       article = ptr) {
+    article++;
+    ptr = strchr(article, '\n');
+    if (*article && ! strncmp(article, app_resources.includePrefix, prefix_len))
       continue;
-    }
-    else {
-      len -= strlen(inptr);
-      break;
-    }
+    while (*article && isspace((unsigned char)*article) &&
+	   (!ptr || article < ptr))
+      article++;
+    if (*article && !isspace((unsigned char)*article))
+      return True;
   }
-  
-  while (*inptr)
-    *outptr++ = *inptr++;
 
-finished:
-  *outptr = '\0';
-  return len;
+  return False;
+}
+
+static char *insert_courtesy_tag(message)
+     char *message;
+{
+  char *header, *note, *body, *new_message;
+  int note_len;
+
+  if (! (note = app_resources.courtesyCopyMessage))
+    note = COURTESY_COPY_MSG;
+  if (! *note)
+    return message;
+
+  header = message;
+
+  body = strstr(message, "\n\n");
+  body += 2;
+
+  new_message = XtMalloc(strlen(message) + strlen(note) + 3);
+
+  strncpy(new_message, header, body - header);
+  new_message[body - header] = '\0';
+
+  strcat(new_message, note);
+  if (note[(note_len = strlen(note))-1] != '\n') {
+    strcat(new_message, "\n\n");
+  }
+  else if ((note_len == 1) || note[note_len-2] != '\n') {
+    strcat(new_message, "\n");
+  }
+
+  strcat(new_message, body);
+
+  XtFree(message);
+  return(new_message);
 }
diff -ruPN 9.00/compose.h 9.01/compose.h
--- 9.00/compose.h	Thu Jun  5 07:11:40 1997
+++ 9.01/compose.h	Sun Mar 22 18:47:48 1998
@@ -4,7 +4,7 @@
 #include "butdefs.h"
 
 /*
- * $Id: compose.h,v 1.11 1997/01/12 03:41:22 jik Exp $
+ * $Id: compose.h,v 1.12 1998/03/22 23:47:48 jik Exp $
  */
 
 /*
@@ -52,6 +52,9 @@
 
 BUTDECL(compAbort);
 BUTDECL(compSave);
+BUTDECL(compSwitchFollowup);
+BUTDECL(compSwitchReply);
+BUTDECL(compSwitchBoth);
 BUTDECL(compSend);
 BUTDECL(compIncludeArticle);
 BUTDECL(compIncludeFile);
diff -ruPN 9.00/config.h 9.01/config.h
--- 9.00/config.h	Tue Dec 16 21:30:46 1997
+++ 9.01/config.h	Sun Mar 22 22:21:34 1998
@@ -2,7 +2,7 @@
 #define CONFIG_H
 
 /*
- * $Id: config.h,v 1.80 1997/12/17 02:30:46 jik Exp $
+ * $Id: config.h,v 1.81 1998/03/23 01:13:06 jik Exp $
  */
 
 /*
@@ -443,6 +443,15 @@
 
 #ifndef SENDMAIL
 #define SENDMAIL       "/usr/lib/sendmail -oi -t"
+#endif
+/* The command to use to verify that an E-mail address is valid.  it
+   should exit with status 0 if the address is valid.  It shouldn't
+   have any characters in it that are "special" to the shell.
+
+   If you don't want XRN to ever attempt to verify sender addresses in
+   postings and messages, don't define this. */
+#ifndef SENDMAIL_VERIFY
+#define SENDMAIL_VERIFY "/usr/lib/sendmail -bv >/dev/null"
 #endif
 
 #define SAVEMODE       "normal,headers,onedir"
diff -ruPN 9.00/contrib/PERL-MAILER 9.01/contrib/PERL-MAILER
--- 9.00/contrib/PERL-MAILER	Wed Nov 30 11:26:47 1994
+++ 9.01/contrib/PERL-MAILER	Sun Jan 25 13:00:42 1998
@@ -1,27 +1,22 @@
 #!/usr/local/bin/perl 
 #
-# $Id: PERL-MAILER,v 1.2 1994/11/23 01:46:17 jik Exp $
-#
 # Prepare a mail message from xrn for piping through a mailer, notably one
 # that handles aliases, unlike the raw sendmail default.
 # The script gets the text of the message as stdin, with the format
 #	To: addresses 
 # 	Subject: some text strings
+#	<blank line>
 # on the top. It's dumb about assuming that it's given this format. 
 # These lines are stripped off to be passed to /usr/ucb/Mail or a derivative of
 # your choice. 
 # Currently works only for single-line To: and Subject:
-#
-# Note: my first perl script; sorry for the ugliness. 
-#
-# David B. Lewis  			Lewis, Trachtenberg & Associates (LTA)
-# Note new address!:  david@lta.com	+1 617 225 0366
-#
+
 # Could pass mailer in as argument.
 die "Usage: no arguments; just the script's name, please\n" if $#ARGV != -1;
 
 $to='';
 $subject='';
+$home=$ENV{'HOME'};
 
 # Abort when we finally hit a nothing line.
 # Assume no initial whitespace for now.
@@ -34,12 +29,17 @@
   $head = $1;
 
   $subject = $2	if $head eq 'Subject';
+# backslash the quotes because of expansion later
+  $subject =~ s#"#\\\"#g;
+  $subject =~ s#!#\\\!#g;
 
    if ($head eq 'To')
 	{
 	# parse out (User Name). Be cheesy and use this pattern as a separator,
-	# so that all stuff of form (a) (a b) (a b c) drops out.
-	@addresses = split ( /\s*\([\w\s\.\-]+\)\s*|\s+/ , $2);
+	# so that all stuff of form (a) (a b) (a b c) drops out and leaves
+	# behind only addresses. This is easier to do than figure out valid
+	# addresses or go through the line word-by-word.
+	@addresses = split ( /\s*\([\w\s\.\,\-]+\)\s*|\s+/ , $2);
 	foreach $whom (@addresses)
 		{
 		$to = join (' ',$to,$whom);
@@ -47,21 +47,22 @@
 	}
 }
 
-#print STDERR $to;
+#print STDERR "\n", $to,"\n", $subject, "\n";
 #exit 0;
 
 # use mush, or /usr/ucb/Mail, /usr/ucb/mail or possibly just mail
 if ($subject ne '')	
 	{
-	$MAILER = "| mush -s \"$subject\" $to ";
+	$MAILER = "|tee $home/dead.letter | mush -s \"$subject\" $to ";
 	}
 else	# line Subject: is missing or is there but blank; can't pass -s
 	{
-	$MAILER = "| mush $to ";
+	$MAILER = "|tee $home/dead.letter | mush $to ";
 	}
 
 open(MAILER,$MAILER) || die "Can't pipe to $MAILER: $!";
 
+# push the rest of the message out
 print MAILER <STDIN>;
 
 close (MAILER);
diff -ruPN 9.00/cursor.h 9.01/cursor.h
--- 9.00/cursor.h	Sun Jun 29 22:53:14 1997
+++ 9.01/cursor.h	Wed Jan 21 22:09:00 1998
@@ -5,7 +5,7 @@
 #include "file_cache.h"
 
 /*
- * $Id: cursor.h,v 1.14 1997/06/30 02:53:14 jik Exp $
+ * $Id: cursor.h,v 1.15 1998/01/22 03:09:00 jik Exp $
  */
 
 /*
@@ -38,6 +38,7 @@
  *           text window
  */
 
+#define JUMP -1
 #define BACK 0
 #define FORWARD 1
 
diff -ruPN 9.00/dialogs.c 9.01/dialogs.c
--- 9.00/dialogs.c	Thu Jun  5 07:11:41 1997
+++ 9.01/dialogs.c	Thu Feb 26 13:43:17 1998
@@ -1,6 +1,6 @@
 
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: dialogs.c,v 1.21 1997/04/07 02:07:46 jik Exp $";
+static char XRNrcsid[] = "$Id: dialogs.c,v 1.22 1998/02/26 18:43:16 jik Exp $";
 /* Modified 2/20/92 dbrooks@osf.org to clean up dialog layout */
 #endif
 
@@ -92,6 +92,11 @@
         {XtNtransientFor, (XtArgVal) NULL},
     };
     Widget typein;
+    char *t = XtNewString(title), *p;
+
+    p = t;
+    while ((p = strchr(p, '\t')))
+      *p = ' ';
 
     XtSetArg(shellArgs[2], XtNtransientFor, GetAncestorShell(parent));
     /* override does not get titlebar, transient does */
@@ -100,11 +105,12 @@
     
     /* create the dialog box */
     XtSetArg(dargs[cnt], XtNvalue, textField); cnt++;
-    XtSetArg(dargs[cnt], XtNlabel, title); cnt++;
+    XtSetArg(dargs[cnt], XtNlabel, t); cnt++;
     XtSetArg(dargs[cnt], XtNinput, True); cnt++;
     dialog = XtCreateManagedWidget("dialog", dialogWidgetClass, popup, dargs, cnt);
 
     /* add the buttons */
+    XtFree(t);
     for (i = 0; i < count; i++) {
 	Arg bargs[2];
 	static XtCallbackRec callbacks[] = {
diff -ruPN 9.00/getdate.y 9.01/getdate.y
--- 9.00/getdate.y	Thu Jun  5 07:11:41 1997
+++ 9.01/getdate.y	Tue May 12 12:54:13 1998
@@ -664,7 +664,7 @@
 
     /* Make it lowercase. */
     for (p = buff; *p; p++)
-	if (isupper(*p))
+	if (isupper((unsigned char)*p))
 	    *p = tolower(*p);
 
     if (strcmp(buff, "am") == 0 || strcmp(buff, "a.m.") == 0) {
@@ -733,7 +733,7 @@
 	}
 
     /* Military timezones. */
-    if (buff[1] == '\0' && isalpha(*buff)) {
+    if (buff[1] == '\0' && isalpha((unsigned char)*buff)) {
 	for (tp = MilitaryTable; tp->name; tp++)
 	    if (strcmp(buff, tp->name) == 0) {
 		yylval.Number = tp->value;
@@ -769,13 +769,13 @@
     int			sign;
 
     for ( ; ; ) {
-	while (isspace(*yyInput))
+	while (isspace((unsigned char)*yyInput))
 	    yyInput++;
 
 	if (isdigit(c = *yyInput) || c == '-' || c == '+') {
 	    if (c == '-' || c == '+') {
 		sign = c == '-' ? -1 : 1;
-		if (!isdigit(*++yyInput))
+		if (!isdigit((unsigned char)*++yyInput))
 		    /* skip the '-' sign */
 		    continue;
 	    }
diff -ruPN 9.00/internals.c 9.01/internals.c
--- 9.00/internals.c	Sun Dec 28 11:36:37 1997
+++ 9.01/internals.c	Tue May 12 13:00:49 1998
@@ -1,5 +1,5 @@
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: internals.c,v 1.215 1997/12/28 16:36:37 jik Exp $";
+static char XRNrcsid[] = "$Id: internals.c,v 1.222 1998/05/12 17:00:24 jik Exp $";
 #endif
 
 /*
@@ -130,11 +130,12 @@
 char *cache_file;
 
 /*
- * see if another xrn is running
+ * see if another xrn is running for this nntpserver
  */
 void checkLock()
 {
-    char *buffer = utTildeExpand(app_resources.lockFile);
+    char *buffer = findServerFile(app_resources.lockFile, isLongNewsrcFile(),
+				  NULL);
     char host[64];
     char myhost[64];
     int pid;
@@ -153,8 +154,10 @@
     if ((fp = fopen(buffer, "r")) == NULL) {
 	if ((fp = fopen(buffer, "w")) == NULL) {
 	    /* silently ignore this condition */
-	    return;
+	  XtFree(buffer);
+	  return;
 	}
+	XtFree(buffer);
 	(void) fprintf(fp, "%s %d\n", myhost, getpid());
 	(void) fclose(fp);
 	return;
@@ -170,10 +173,12 @@
 	    /* why do it right when you can just do this... */
 	    removeLock();
 	    checkLock();
+	    XtFree(buffer);
 	    return;
 	}
     }
     (void) fprintf(stderr, ERR_XRN_RUN_MSG , host, pid, buffer);
+    XtFree(buffer);
 
     exit(-1);
 
@@ -183,10 +188,11 @@
 
 void removeLock()
 {
-    char *buffer = utTildeExpand(app_resources.lockFile);
+    char *buffer = findServerFile(app_resources.lockFile, True, NULL);
 
     if (buffer) {
 	(void) unlink(buffer);
+	XtFree(buffer);
     }
     return;
 }
@@ -205,7 +211,7 @@
 
     xrnBusyCursor();
 
-    if (! (cache_file = findServerFile(app_resources.cacheFile, True))) {
+    if (! (cache_file = findServerFile(app_resources.cacheFile, True, NULL))) {
 	err_buf = XtMalloc(strlen(CANT_EXPAND_MSG)+MAXPATHLEN);
 	(void) sprintf(err_buf, CANT_EXPAND_MSG, app_resources.cacheFile);
 	ehErrorExitXRN(err_buf);
@@ -230,8 +236,7 @@
 	     getactive(True);
 	 }
 
-	 if (readnewsrc(app_resources.newsrcFile,
-			app_resources.saveNewsrcFile))
+	 if (readnewsrc())
 	      break;
 	 
        ehErrorRetryXRN(ERROR_CANT_READ_NEWSRC_MSG, True);
@@ -496,24 +501,30 @@
   */
 static Boolean setCurrentArticle _ARGUMENTS((struct newsgroup *,
 					     Boolean, Boolean,
-					     Boolean *, int));
+					     Boolean *, int *));
 
 static Boolean setCurrentArticle(
 				 _ANSIDECL(struct newsgroup *,	newsgroup),
 				 _ANSIDECL(Boolean,		unread_only),
 				 _ANSIDECL(Boolean,		check_available),
 				 _ANSIDECL(Boolean *,		finished),
-				 _ANSIDECL(int,			max)
+				 _ANSIDECL(int *,		max_ptr)
 				 )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(Boolean,			unread_only)
      _KNRDECL(Boolean,			check_available)
      _KNRDECL(Boolean *,		finished)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max_ptr)
 {
     struct article *art;
     art_num i, start, avail = 0;
     art_num orig = newsgroup->current;
+    int max;
+
+    if (max_ptr)
+      max = *max_ptr;
+    else
+      max = 0;
 
     if (app_resources.onlyShow > 0) {
 	/* if the resource 'onlyShow' is > 0, then mark all but the last
@@ -775,7 +786,11 @@
 	                   (total > 0 ? NEWS_IN_MSG : ""),
 			   -newsgroup_length, newsgroup->name, unread,
 			   ((unread != 1) ? NOT_ONE_MSG : " "),
-			   total - unread);
+			   total - unread,
+			   /* It's OK if you get warnings about this
+			      argument not being used when compiling
+			      anything besides the French version. */
+			   ((total - unread != 1) ? NOT_ONE_MSG : " "));
 
 	    ar[subscribedGroups++] = XtNewString(dummy);
 	    bytes += strlen(dummy);
@@ -887,11 +902,11 @@
     }
     else {
 	*chunk_size = *chunk_size * desired_time / actual_time;
-	if (*chunk_size < PREFETCH_MIN_CHUNK)
-	    *chunk_size = PREFETCH_MIN_CHUNK;
     }
 
   done:
+    if (*chunk_size < PREFETCH_MIN_CHUNK)
+      *chunk_size = PREFETCH_MIN_CHUNK;
 #ifdef DEBUG
     fprintf(stderr, "adjustPrefetchChunk(%ld, %ld, %d) done\n",
 	    actual_time, desired_time, *chunk_size);
@@ -1156,11 +1171,11 @@
  * Returns True if it gets to the end of the group, False otherwise.
  */
 /* XXX  THIS ROUTINE REALLY NEEDS TO BE CLEANED UP */
-static Boolean killArticles _ARGUMENTS((struct newsgroup *, int));
+static Boolean killArticles _ARGUMENTS((struct newsgroup *, int *));
 
 static Boolean killArticles(newsgroup, max)
     struct newsgroup *newsgroup;
-    int max;
+    int *max;
 {
     struct article *art;
     art_num i, start, last;
@@ -1181,7 +1196,7 @@
     } while (IS_KILLED(art) && (start <= newsgroup->last));
 
     if (max)
-	last = MIN(newsgroup->last, start + max - 1);
+	last = MIN(newsgroup->last, start + *max - 1);
     else
 	last = newsgroup->last;
 
@@ -1330,8 +1345,11 @@
 
     if (last == newsgroup->last)
 	return True;
-    else
-	return False;
+    else {
+      if (max)
+	*max = last - start + 1;
+      return False;
+    }
 }
 
     
@@ -1387,7 +1405,7 @@
     if (prefetching)
 	start = time(0);
     
-    finished = killArticles(newsgroup, prefetching ? chunk_size : 0);
+    finished = killArticles(newsgroup, prefetching ? &chunk_size : 0);
 
     if (prefetching && !finished) {
 	end = time(0);
@@ -1502,20 +1520,26 @@
   return 0;
 }
 
+#define THREAD_IT(art) ((listed_or_read == ART_LISTED) ? \
+			IS_LISTED(art) : IS_UNREAD(art))
+
 static Boolean threadIncremental _ARGUMENTS((struct newsgroup *,
 					     int *,
-					     art_num, art_num));
+					     art_num, art_num,
+					     int));
 
 static Boolean threadIncremental(
 				 _ANSIDECL(struct newsgroup *,	newsgroup),
 				 _ANSIDECL(int *,		stage),
 				 _ANSIDECL(art_num,		first),
-				 _ANSIDECL(art_num,		last)
+				 _ANSIDECL(art_num,		last),
+				 _ANSIDECL(int,			listed_or_read)
 				 )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(int *,			stage)
      _KNRDECL(art_num,			first)
      _KNRDECL(art_num,			last)
+     _KNRDECL(int,			listed_or_read)
 {
   static int chunk_size = PREFETCH_CHUNK;
   time_t start_time WALL (= 0), end_time;
@@ -1532,10 +1556,32 @@
   }
 
   if (! newsgroup->thread_table) {
+    art_num this_first, this_last;
+    art_num count = 0;
+    struct article *this_art;
+
     (void) sprintf(dummy, THREADING_FOR_MSG, newsgroup->name);
     maybeInfoNow(dummy);
 
-    newsgroup->thread_table = hash_table_create(last - first + 1,
+    this_art = artStructGet(newsgroup, first, False);
+    if (artStructNext(newsgroup, this_art, &this_first, &this_last))
+      this_last--;
+    else
+      this_last = last;
+    this_first = first;
+
+    do {
+      if (THREAD_IT(this_art))
+	count += this_last - this_first + 1;
+      this_art = artStructNext(newsgroup, this_art, &this_first, &this_last);
+    } while (this_art);
+
+    if (! count)
+      /* We can't thread yet because we haven't decided which articles
+	 to display. */
+      return True;
+
+    newsgroup->thread_table = hash_table_create(count,
 						hash_string_calc,
 						hash_string_compare,
 						art_num_compare,
@@ -1543,7 +1589,7 @@
 
     for (i = first; i <= last; i++) {
       struct article *art = artStructGet(newsgroup, i, False);
-      if (art->id && IS_LISTED(art)) {
+      if (art->id && THREAD_IT(art)) {
 	int ret = hash_table_insert(newsgroup->thread_table,
 				    (void *)art->id, (void *)i, 0);
 	assert(ret);
@@ -1556,22 +1602,22 @@
 
   
   for (i = first; (i <= last) && (! stage || (done_count < chunk_size)); i++) {
-    struct article *art = artStructGet(newsgroup, i, True);
+    struct article *art = artStructGet(newsgroup, i, False), copy = *art;
     char *references, *ptr;
     art_num parent;
-    struct article *parent_struct;
 
-    if (art->parent || !IS_LISTED(art))
+    if (copy.parent || !THREAD_IT(&copy))
       continue;
 
-    if (! (art->references && *art->references)) {
-      art->parent = (art_num)-1;
+    if (! (copy.references && *copy.references)) {
+      copy.parent = (art_num)-1;
+      artStructReplace(newsgroup, &art, &copy, i);
       continue;
     }
 
     done_count++;
 
-    references = XtNewString(art->references);
+    references = XtNewString(copy.references);
 
     for (ptr = strrchr(references, '>'); ptr;
 	 ptr = backTo(references, ptr, '>')) {
@@ -1584,8 +1630,9 @@
       if ((parent = (art_num)hash_table_retrieve(newsgroup->thread_table,
 						 (void *)ptr, 0)) !=
 	  (art_num)HASH_NO_VALUE) {
-	art->parent = parent;
-	parent_struct = artStructGet(newsgroup, parent, True);
+	struct article *parent_struct = artStructGet(newsgroup, parent, True);
+
+	copy.parent = parent;
 	artStructAddChild(parent_struct, i);
 	artStructSet(newsgroup, &parent_struct);
 	break;
@@ -1594,9 +1641,9 @@
 
     XtFree(references);
 
-    if (! art->parent)
-      art->parent = (art_num)-1;
-    artStructSet(newsgroup, &art);
+    if (! copy.parent)
+      copy.parent = (art_num)-1;
+    artStructReplace(newsgroup, &art, &copy, i);
   }
 
   if (i > last) {
@@ -1620,11 +1667,14 @@
   }
 
   end_time = time(0);
+  chunk_size = done_count;
   adjustPrefetchChunk(end_time - start_time,
 		      PREFETCH_CHUNK_TIME, &chunk_size);
   return False;
 }
-  
+
+#undef THREAD_IT
+
 static void checkThreading _ARGUMENTS((struct newsgroup *, art_num));
 
 static void checkThreading(
@@ -1690,7 +1740,7 @@
     checkThreading(newsgroup, art);
   }
 
-  (void) threadIncremental(newsgroup, 0, art, newsgroup->last);
+  (void) threadIncremental(newsgroup, 0, art, newsgroup->last, ART_LISTED);
 }
      
 static Boolean fetchHeadersIncremental _ARGUMENTS((struct newsgroup *,
@@ -1727,47 +1777,47 @@
       finished = getsubjectlist(newsgroup, first, last,
 				unread_only,
 				(stage && ! FinishingPrefetch)
-				? chunk_size : 0);
+				? &chunk_size : 0);
     if (! stage || *stage == PREFETCH_AUTHOR_STAGE)
       finished = getauthorlist(newsgroup, first, last,
 			       unread_only,
 			       (stage && ! FinishingPrefetch)
-			       ? chunk_size : 0);
+			       ? &chunk_size : 0);
     if (! stage || *stage == PREFETCH_LINES_STAGE)
       finished = getlineslist(newsgroup, first, last,
 			      unread_only,
 			      (stage && ! FinishingPrefetch)
-			      ? chunk_size : 0);
+			      ? &chunk_size : 0);
     if ((newsgroup->fetch & FETCH_NEWSGROUPS) && kill_files &&
 	(! stage || *stage == PREFETCH_NEWSGROUPS_STAGE))
       finished = getnewsgroupslist(newsgroup, first, last,
 				   unread_only,
 				   (stage && ! FinishingPrefetch)
-				   ? chunk_size : 0);
+				   ? &chunk_size : 0);
     if ((newsgroup->fetch & FETCH_DATES) &&
 	(! stage || *stage == PREFETCH_DATE_STAGE))
       finished = getdatelist(newsgroup, first, last,
 			     unread_only,
 			     (stage && ! FinishingPrefetch)
-			     ? chunk_size : 0);
+			     ? &chunk_size : 0);
     if ((newsgroup->fetch & FETCH_IDS) &&
 	(! stage || *stage == PREFETCH_IDS_STAGE))
       finished = getidlist(newsgroup, first, last,
 			   unread_only,
 			   (stage && ! FinishingPrefetch)
-			   ? chunk_size : 0);
+			   ? &chunk_size : 0);
     if ((newsgroup->fetch & FETCH_XREF) &&
 	(! stage || *stage == PREFETCH_XREF_STAGE))
       finished = getxreflist(newsgroup, first, last,
 			     unread_only,
 			     (stage && ! FinishingPrefetch)
-			     ? chunk_size : 0);
+			     ? &chunk_size : 0);
     if ((newsgroup->fetch & FETCH_REFS) &&
 	(! stage || *stage == PREFETCH_REFS_STAGE))
       finished = getreflist(newsgroup, first, last,
 			    unread_only,
 			    (stage && ! FinishingPrefetch)
-			    ? chunk_size : 0);
+			    ? &chunk_size : 0);
     if (! finished) { /* that means it was a full chunk */
       end_time = time(0);
       adjustPrefetchChunk(end_time - start_time,
@@ -1863,10 +1913,18 @@
 	if (! EMPTY_GROUP(newsgroup)) {
 	    art_num my_first = first, my_last = last;
 
-	    if (! stage || *stage == PREFETCH_SETCURRENT_STAGE)
+	    if (! stage || *stage == PREFETCH_SETCURRENT_STAGE) {
+	      time_t start_time, end_time;
+	      start_time = time(0);
 	      (void) setCurrentArticle(newsgroup, unread_only, False,
 				       (stage && ! FinishingPrefetch)
-				       ? &finished : 0, chunk_size);
+				       ? &finished : 0, &chunk_size);
+	      end_time = time(0);
+	      if (! finished) {
+		adjustPrefetchChunk(end_time - start_time,
+				    PREFETCH_CHUNK_TIME, &chunk_size);
+	      }
+	    }
 
 	    if (! my_first)
 	      my_first = newsgroup->current;
@@ -1935,7 +1993,8 @@
 		}
 	    }
 	    if ((! stage || *stage == PREFETCH_THREAD_STAGE) && threading)
-	      finished = threadIncremental(newsgroup, stage, my_first, my_last);
+	      finished = threadIncremental(newsgroup, stage, my_first, my_last,
+					   ART_READ);
 	}
     }
 
@@ -3554,8 +3613,10 @@
 }    
 
 
-#define STRIPLEADINGSPACES   for (; *start && isspace(*start); start++);
-#define STRIPENDINGSPACES  for (; (end >= start) && isspace(*end); *end-- = '\0');
+#define STRIPLEADINGSPACES   for (; *start && isspace((unsigned char)*start);\
+				    start++);
+#define STRIPENDINGSPACES  for (; (end >= start) && \
+			isspace((unsigned char)*end); *end-- = '\0');
 
 char * subjectStrip(str)
     char *str;
diff -ruPN 9.00/killfile.c 9.01/killfile.c
--- 9.00/killfile.c	Sun Dec 28 10:57:38 1997
+++ 9.01/killfile.c	Tue May 12 12:54:13 1998
@@ -140,7 +140,7 @@
   /*
     Ignore whitespace at the beginning of the line.
     */
-  for (ptr = str; *ptr && isspace(*ptr); ptr++)
+  for (ptr = str; *ptr && isspace((unsigned char)*ptr); ptr++)
     /* empty */;
 
   if ((*ptr == '&') || (*ptr == '#') || (! *ptr)) {
@@ -154,14 +154,14 @@
   if (!strncmp (ptr, "include", 7)) {
     ptr += 7;
 
-    if (!isspace(*ptr)) {
+    if (!isspace((unsigned char)*ptr)) {
       mesgPane(XRN_SERIOUS, mesg_name, MALFORMED_KILL_ENTRY_MSG, str,
                file_name, ERROR_INCLUDE_NOT_SEPARATED_MSG);
       my_entry.type = KILL_OTHER;
       goto done;
     }
 
-    for (; *ptr && isspace(*ptr); ptr++)
+    for (; *ptr && isspace((unsigned char)*ptr); ptr++)
       /* empty */;
 
     if (! *ptr) {
@@ -172,7 +172,7 @@
     }
 
     for (ptr2 = strchr(ptr, '\0');
-	 (ptr2 > ptr) && isspace(*(ptr2 - 1));
+	 (ptr2 > ptr) && isspace((unsigned char)*(ptr2 - 1));
 	 ptr2--)
       /* empty */;
 
@@ -262,7 +262,7 @@
 
       if (my_entry.entry.check_flags) {
 	ptr = ptr3 + 1;
-	while (*ptr && isspace(*ptr))
+	while (*ptr && isspace((unsigned char)*ptr))
 	  ptr++;
 	*--ptr = '^';
       }
@@ -270,13 +270,13 @@
 	my_entry.entry.check_flags = ALL_CHECK_FLAGS;
     }
     else if (*ptr2 == 't') {	/* kill timeout */
-      for ( ; *(ptr2+1) && isdigit(*(ptr2 + 1)); ptr2++) {
+      for ( ; *(ptr2+1) && isdigit((unsigned char)*(ptr2 + 1)); ptr2++) {
 	my_entry.entry.timeout *= 10;
 	my_entry.entry.timeout += (*(ptr2+1) - '0');
       }
     }
     else if (*ptr2 == 'u') {	/* last used */
-      for ( ; *(ptr2+1) && isdigit(*(ptr2 + 1)); ptr2++) {
+      for ( ; *(ptr2+1) && isdigit((unsigned char)*(ptr2 + 1)); ptr2++) {
 	my_entry.entry.last_used *= 10;
 	my_entry.entry.last_used += (*(ptr2+1) - '0');
       }
diff -ruPN 9.00/mesg.c 9.01/mesg.c
--- 9.00/mesg.c	Thu Jun  5 07:11:41 1997
+++ 9.01/mesg.c	Wed Jan 28 19:52:16 1998
@@ -1,5 +1,5 @@
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: mesg.c,v 1.27 1997/03/30 18:15:00 jik Exp $";
+static char XRNrcsid[] = "$Id: mesg.c,v 1.28 1998/01/28 21:18:29 jik Exp $";
 #endif
 
 /*
@@ -61,6 +61,7 @@
 #include "ButtonBox.h"
 #include "InfoLine.h"
 #include "InfoDialog.h"
+#include "mesg_strings.h"
 
 char error_buffer[2048];
 static char *MesgString = 0;
@@ -114,6 +115,8 @@
     time_t tm;
     char *time_str;
     char addBuff[MESG_SIZE];
+    static Boolean intro_displayed = False;
+    char *separator = "\n--------\n";
 
     if (name && last_name && (name == last_name))
 	type |= XRN_APPEND;
@@ -148,6 +151,11 @@
 
     if (! (MesgLength() || MesgString)) {
 	(void) sprintf(addBuff, "%s: ", time_str);
+	if (! intro_displayed) {
+	  intro_displayed = True;
+	  (void) sprintf(&addBuff[strlen(addBuff)], "%s%s%s: ",
+			 MESG_PANE_DISMISS_MSG, separator, time_str);
+	}
     }
     else if (type & XRN_SAME_LINE) {
 	*addBuff = '\0';
@@ -156,7 +164,7 @@
 	(void) sprintf(addBuff, "\n%8s  ", "");
     }
     else {
-	(void) sprintf(addBuff, "\n--------\n%s: ", time_str);
+	(void) sprintf(addBuff, "%s%s: ", separator, time_str);
     }
 
     (void) vsprintf(&addBuff[strlen(addBuff)], fmtString, args);
diff -ruPN 9.00/mesg_strings.c 9.01/mesg_strings.c
--- 9.00/mesg_strings.c	Mon Dec 15 11:24:56 1997
+++ 9.01/mesg_strings.c	Mon Mar 23 08:21:32 1998
@@ -1,5 +1,5 @@
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: mesg_strings.c,v 1.75 1997/12/15 16:24:55 jik Exp $";
+static char XRNrcsid[] = "$Id: mesg_strings.c,v 1.88 1998/03/23 13:21:31 jik Exp $";
 #endif
 
 /*
@@ -42,9 +42,11 @@
 
 #ifndef XRN_LANG_english
 #ifndef XRN_LANG_german
+#ifndef XRN_LANG_french
 #define XRN_LANG_english
 #endif
 #endif
+#endif
 
 /*
  * Global messsages and strings like "yes", "no", "OK?", etc.  These
@@ -55,21 +57,21 @@
 
 #ifdef XRN_LANG_english
 
-#define YES_STRING   "yes"
-#define NO_STRING    "no"
-#define ABORT_STRING "abort"
-#define DOIT_STRING  "doit"
-#define SAVE_STRING  "save"
-
-#define ADD_STRING        "add"
-#define FORWARD_STRING    "forward"
-#define BACK_STRING       "back"
-#define LAST_GROUP_STRING "last group"
-#define FIRST_STRING      "first"
-#define LAST_STRING       "last"
-#define CURSOR_POS_STRING "cursor position"
-#define SUB_STRING        "subscribe"
-#define GOTO_NG_STRING    "go to newsgroup"
+#define YES_STRING   "Yes"
+#define NO_STRING    "No"
+#define ABORT_STRING "Abort"
+#define DOIT_STRING  "Do it"
+#define SAVE_STRING  "Save"
+
+#define ADD_STRING        "Add"
+#define FORWARD_STRING    "Forward"
+#define BACK_STRING       "Back"
+#define LAST_GROUP_STRING "Last group"
+#define FIRST_STRING      "First"
+#define LAST_STRING       "Last"
+#define CURSOR_POS_STRING "Cursor position"
+#define SUB_STRING        "Subscribe"
+#define GOTO_NG_STRING    "Go to newsgroup"
 #define CLICK_TO_CONT_STRING "Click to continue"
 
 /* Strings to compose newsgroup line for ngMode */
@@ -80,7 +82,7 @@
  * 4) articles unread
  * 5) NOT_ONE_MSG if *one* unread article is available, else " "
  *
- * example:"Unread news in comp.sys.ibm                            30 articles + 20 old"                  
+ * example:"Unread news in comp.sys.ibm                            30 articles +   20 old"                  
  * Note: maximum line length is normally 200
  */
 /* The number of characters into a newsgroup index line after which
@@ -121,6 +123,74 @@
 #endif /* XRN_LANG_english */
 
 
+#ifdef XRN_LANG_french
+
+#define YES_STRING   "Oui"
+#define NO_STRING    "Non"
+#define ABORT_STRING "Annuler"
+#define DOIT_STRING  "Continuer"
+#define SAVE_STRING  "Sauver"
+
+#define ADD_STRING        "Ajouter"
+#define FORWARD_STRING    "Avancer"
+#define BACK_STRING       "Reculer"
+#define LAST_GROUP_STRING "Dernier groupe"
+#define FIRST_STRING      "Premier"
+#define LAST_STRING       "Dernier"
+#define CURSOR_POS_STRING "Position courante"
+#define SUB_STRING        "S'abonner"
+#define GOTO_NG_STRING    "Aller au newsgroup"
+#define CLICK_TO_CONT_STRING "Continuer"
+
+/* Strings to compose newsgroup line for ngMode */
+/* The format is NEWSGROUPS_INDEX_MSG.  The strings in it are:
+ * 1) UNREAD_MSG ou une chane vide
+ * 2) NEWS_IN_MSG ou une chane vide
+ * 3) groupe de news
+ * 4) articles non lus
+ * 5) NOT_ONE_MSG si *un* article non lu est disponible, sinon " "
+ *
+ * exemple:"(non lus) Messages dans comp.sys.ibm       30 articles + 20 anciens"
+ * Note: la longueur de ligne maximale est normalement 200
+ */
+/* The number of characters into a newsgroup index line after which
+   the newsgroup name actually starts. */
+#define NEWS_GROUP_OFFSET 24
+/*
+  The number of characters on a newsgroup index line, other than the
+  newsgroup name, and not including the newline or the null at the
+  end.
+  */
+#define NEWS_GROUP_LINE_CHARS 53
+/* end strings for ngMode */
+
+/* strings for buildQuestion, bottomline in ngMode */
+/* max len after sprintf is LABEL_SIZE (128)      */
+#define QUEST_ART_NOUNREAD_NONEXT_STRING  "Art. %ld de %s"
+#define QUEST_ART_NOUNREAD_NEXT_STRING    "Art. %ld de %s (Suivant: %s, %ld article%s)"
+#define QUEST_ART_UNREAD_NONEXT_STRING    "Art. %ld de %s (%ld restant)"
+#define QUEST_ART_UNREAD_NEXT_STRING      "Art. %ld de %s (%ld restant) (Suivant: %s, %ld article%s)"
+/*                                               1)    2)   3)              4)  5)
+ * 1) article number
+ * 2) actual newsgroup 
+ * 3) # unread articles
+ * 4) next newsgroup
+ * 5) # unread articles next newsgroup
+ *
+ * example "Art. 4093 in comp.sys.ibm (30 left) (Next: comp.sys.ibm.hardware, 20 articles)
+ */
+/* end strings for buildQuestions */
+
+/* Subject markers */
+
+#define READ_MARKER	'+'
+#define UNREAD_MARKER	'n'
+#define SAVED_MARKER	'S'
+#define PRINTED_MARKER	'I'
+
+#endif /* XRN_LANG_french */
+
+
 #ifdef XRN_LANG_german
 
 #define YES_STRING   "Ja"
@@ -129,10 +199,10 @@
 #define DOIT_STRING  "Ausf\374hren"
 #define SAVE_STRING  "Sichern"
 
-#define ADD_STRING        "hinzuf\374gen"
-#define FORWARD_STRING    "nach unten"
-#define BACK_STRING       "nach oben"
-#define LAST_GROUP_STRING "letzte Gruppe"
+#define ADD_STRING        "Hinzuf\374gen"
+#define FORWARD_STRING    "Weiter"
+#define BACK_STRING       "Zur\374ck"
+#define LAST_GROUP_STRING "Letzte Gruppe"
 #define FIRST_STRING      "Anfang"
 #define LAST_STRING       "Ende"
 #define CURSOR_POS_STRING "Aktuelle Position"
@@ -142,8 +212,8 @@
 
 /* Strings to compose newsgroup line for ngMode */
 /* The format is NEWSGROUPS_INDEX_MSG.  The strings in it are:
- * 1) UNREAD_MSG oder leerer string 
- * 2) NEWS_IN_MSG oder leere string 
+ * 1) UNREAD_MSG oder leerer string
+ * 2) NEWS_IN_MSG oder leerer string
  * 3) Newsgruppe
  * 4) Artikel ungelesen
  * 5) NOT_ONE_MSG wenn *ein* ungelesener Artikel, sonst " "
@@ -153,21 +223,21 @@
  */
 /* The number of characters into a newsgroup index line after which
    the newsgroup name actually starts. */
-#define NEWS_GROUP_OFFSET 26
+#define NEWS_GROUP_OFFSET 16
 /*
   The number of characters on a newsgroup index line, other than the
   newsgroup name, and not including the newline or the null at the
   end.
   */
-#define NEWS_GROUP_LINE_CHARS 45
+#define NEWS_GROUP_LINE_CHARS 42
 /* end strings for ngMode */
 
 /* strings for buildQuestion, bottomline in ngMode */
 /* max len after sprintf is LABEL_SIZE (128)      */
 #define QUEST_ART_NOUNREAD_NONEXT_STRING  "Art. %ld in %s"
-#define QUEST_ART_NOUNREAD_NEXT_STRING    "Art. %ld in %s (N\344chste: %s, %d Artikel%s)"
-#define QUEST_ART_UNREAD_NONEXT_STRING    "Art. %ld in %s (%ld verbleiben)"
-#define QUEST_ART_UNREAD_NEXT_STRING      "Art. %ld in %s (%ld verbleiben) (N\344chste: %s, %d Artikel%s)"
+#define QUEST_ART_NOUNREAD_NEXT_STRING    "Art. %ld in %s (N\344chste: %s, %d Artikel)%s"
+#define QUEST_ART_UNREAD_NONEXT_STRING    "Art. %ld in %s (%ld \374brig)"
+#define QUEST_ART_UNREAD_NEXT_STRING      "Art. %ld in %s (%ld \374brig) (N\344chste: %s, %d Artikel)%s"
 /*                                              1)    2)   3)                          4)  5)
  * 1) article number
  * 2) actual newsgroup 
@@ -189,11 +259,11 @@
 #endif /* XNR_LANG_german */
 
 /*
- * Messages for use in mesgPane calls below.  Many of these messages
- * are used multiple times, which is why they are all here are
- * constants.  Also, putting them all here makes it easy to make sure
- * they're all consistent.  Finally, putting them here saves space in
- * the executable since there's only one copy of each string.
+ * Messages for use in mesgPane calls.  Many of these messages are
+ * used multiple times, which is why they are constants.  Also,
+ * putting them all here makes it easy to make sure they're all
+ * consistent.  Finally, putting them here saves space in the
+ * executable since there's only one copy of each string.
  */
 
 #ifdef XRN_LANG_english
@@ -202,17 +272,17 @@
 /* < BAD_BUTTON_NAME > */
     "XRN error: bad button name `%s'.", /* button name */
 /* < NO_SUCH_NG_DELETED > */
-    "Newsgroup `%s' does not exist.  It may have been deleted.  ", /* newsgroup name */
+    "Newsgroup `%s' does not exist.\n\tIt may have been deleted.", /* newsgroup name */
 /* < UNKNOWN_FUNC_RESPONSE > */
     "Internal XRN error: unknown response %d from %s in %s.", /* return value, called function, calling function */
 /* < DISPLAYING_LAST_UNREAD > */
-    "No unread articles in `%s'.  Displaying last available article.", /* newsgroup name */
+    "No unread articles in `%s'.\n\tDisplaying last available article.", /* newsgroup name */
 /* < PROBABLY_KILLED > */
-    "No unread articles in `%s'.  They were probably killed.  ", /* newsgroup name */
+    "No unread articles in `%s'.\n\tThey were probably killed.", /* newsgroup name */
 /* < NO_ARTICLES > */
     "No articles in `%s'.", /* newsgroup name */
 /* < PROBABLY_EXPIRED > */
-    "No articles in `%s'.  They were probably expired or cancelled.  ", /* newsgroup name */
+    "No articles in `%s'.\n\tThey were probably expired or cancelled.", /* newsgroup name */
 /* < NO_NG_SPECIFIED > */
     "No newsgroup name specified.",
 /* < NO_SUCH_NG > */
@@ -222,7 +292,7 @@
 /* < NO_GROUPS_SELECTED > */
     "No newsgroups were selected.",
 /* < NG_NOT_MOVED > */
-    "New position for newsgroups can't be in block of selected newsgroups.  Newsgroups have not been moved.",
+    "New position for newsgroups can't be\n\tin block of selected newsgroups.\n\tNewsgroups have not been moved.",
 /* < SKIPPING_TO_NEXT_NG > */
     "Skipping to next newsgroup.",
 /* < BAD_ART_NUM > */
@@ -240,33 +310,33 @@
 /* < MSG_ABORTED > */
     "Aborted %s.", /* "article" or "message" */
 /* < NO_FILE_NOT_SAVED > */
-    "Cannot determine save file name.  Article/message not saved.",
+    "Cannot determine save file name.\n\tArticle/message not saved.",
 /* < NO_SUBJECT > */
-    "The Subject field is missing in your message!  ",
+    "The Subject field is missing in your message!\n\t",
 /* < EMPTY_SUBJECT > */
-    "The Subject field in your message is empty!  ",
+    "The Subject field in your message is empty!\n\t",
 /* < NO_NEWSGROUPS > */
-    "The Newsgroups field is missing in your message!  ",
+    "The Newsgroups field is missing in your message!\n\t",
 /* < MULTI > */
-    "There are multiple %s fields in your message!  Please delete all but one of them and resend.", /* field name */
+    "There are multiple %s fields in your message!\n\tPlease delete all but one of them\n\tand resend.", /* field name */
 /* < DEFAULT_ADDED > */
-    "A default value has been added.  Please edit it as necessary and resend.",
+    "A default value has been added.\n\tPlease edit it as necessary\n\tand resend.",
 /* < EMPTY_ADDED > */
-    "An empty one has been added.  ",
+    "An empty one has been added.\n\t",
 /* < FILL_IN_RESEND > */
     "Please fill it in and resend.",
 /* < NO_POSTABLE_NG > */
-    "No postable newsgroups in `Newsgroups' line.  Please fix and resend or save and abort.",
+    "No postable newsgroups in `Newsgroups' line.\n\tPlease fix it and resend or save and abort.",
 /* < SAVING_DEAD > */
     "Saving in `%s'.", /* file name */
 /* < COULDNT_POST > */
-    "Could not post article.  ",
+    "Could not post article.",
 /* < POST_NOTALLOWED > */
-    "Posting not allowed from this machine.  ",
+    "Posting not allowed from this machine.",
 /* < COULDNT_SEND > */
-    "Could not send mail message.  ",
+    "Could not send mail message.",
 /* < MAILED_TO_MODERATOR > */
-    "One or more moderated newsgroups in `Newsgroups' line of message.  Article will be mailed to moderator by server.",
+    "One or more moderated newsgroups in `Newsgroups' line of message.\n\tArticle will be mailed to moderator by server.",
 /* < ARTICLE_POSTED > */
     "Article posted.",
 /* < MAIL_MESSAGE_SENT > */
@@ -274,125 +344,125 @@
 /* < CANT_INCLUDE_CMD > */
     "Cannot execute includeCommand (`popen' failed).",
 /* < CANT_OPEN_ART > */
-    "Cannot open article file `%s': %s.", /* file name, error string */
+    "Cannot open article file `%s':\n\t%s.", /* file name, error string */
 /* < CANT_OPEN_FILE > */
-    "Cannot open file `%s': %s.", /* error string */
+    "Cannot open file `%s':\n\t%s.", /* error string */
 /* < NO_FILE_SPECIFIED > */
     "No file specified.",
 /* < CANT_OPEN_TEMP > */
-    "Cannot open temporary file `%s': %s.", /* file name, error string */
+    "Cannot open temporary file `%s':\n\t%s.", /* file name, error string */
 /* < CANT_STAT_TEMP > */
-    "Cannot stat temporary file `%s': %s.", /* file name, error string */
+    "Cannot stat temporary file `%s':\n\t%s.", /* file name, error string */
 /* < NO_CHANGE > */
     "No change in temporary file `%s'.", /* file name */
 /* < ZERO_SIZE > */
-    "Temporary file `%s' has zero size.", /* file name */
+    "Temporary file `%s'\n\thas zero size.", /* file name */
 /* < NO_MSG_TEMPLATE > */
     "Internal XRN error: no message template in call to Call_Editor.",
 /* < CANT_EDITOR_CMD > */
-    "Cannot execute editor command `%s': %s.", /* command, error string */
+    "Cannot execute editor command `%s':\n\t%s.", /* command, error string */
 /* < ONE_COMPOSITION_ONLY > */
     "Only one composition allowed at a time.",
 /* < EXECUTING_SIGNATURE > */
     "Executing signature command `%s'.", /* command */
 /* < CANT_EXECUTE_SIGNATURE > */
-    "Cannot execute signature file `%s'.  Reading instead.", /* signature file name */
+    "Cannot execute signature file `%s'.\n\tReading instead.", /* signature file name */
 /* < READING_SIGNATURE > */
     "Reading signature file `%s'.", /* signature file name */
 /* < CANT_READ_SIGNATURE > */
-    "Cannot read signature file `%s': %s.", /* signature file name, error string */
+    "Cannot read signature file `%s':\n\t%s.", /* signature file name, error string */
 /* < SIGNATURE_TOO_BIG > */
-    "Signature file `%s' is too large; ignoring it.", /* signature file name */
+    "Signature file `%s'\n\tis too large; ignoring it.", /* signature file name */
 /* < CANCEL_ABORTED > */
     "Article not cancelled.",
 /* < CANCELLED_ART > */
     "Article has been cancelled.",
 /* < CANCEL_TO_MODERATOR > */
-    "Message being canceled appears in one or more moderated newsgroups.  Cancel request will be mailed to moderator by server.",
+    "Message being canceled appears\n\tin one or more moderated newsgroups.\n\tCancel request will be\n\tmailed to moderator by server.",
 /* < UNKNOWN_REGEXP_ERROR > */
     "Unknown error in regular expression `%s'.", /* regexp string */
 /* < KNOWN_REGEXP_ERROR > */
-    "Error in regular expression `%s': %s.", /* regexp, error string */
+    "Error in regular expression `%s':\n\t%s.", /* regexp, error string */
 /* < ART_NUMBERING_PROBLEM > */
-    "Article numbering problem.  Marking all articles in newsgroup `%s' unread.", /* newsgroup name */
+    "Article numbering problem.\n\tMarking all articles in newsgroup `%s' unread.", /* newsgroup name */
 /* < CANT_OPEN_KILL > */
-    "Cannot open kill file `%s': %s.", /* file name, error string */
+    "Cannot open kill file `%s':\n\t%s.", /* file name, error string */
 /* < CANT_OPEN_INCLUDED_KILL > */
-    "Cannot open kill file `%s' (included from `%s': %s.", /* file name, parent file name, error string */
+    "Cannot open kill file `%s'\n\t(included from `%s'):\n\t%s.", /* file name, parent file name, error string */
 /* < MALFORMED_KILL_ENTRY > */
-    "Error in KILL file entry `%s' in KILL file `%s': %s.", /* entry, file, reason for error */
+    "Error in KILL file entry `%s'\n\tin KILL file `%s':\n\t%s.", /* entry, file, reason for error */
 /* < ERROR_INCLUDE_MISSING > */
     "No newsgroup or file name specified in include directive",
 /* < ERROR_INCLUDE_NOT_SEPARATED > */
    " Include operand not separated",
 /* < KILL_ERROR_UNKNOWN_OPTION > */
-    "Error in KILL file entry `%s' in KILL file `%s': Unknown option `%c'.", /* entry, file, unknown option */
+    "Error in KILL file entry `%s'\n\tin KILL file `%s':\n\tUnknown option `%c'.", /* entry, file, unknown option */
 /* < UNKNOWN_KILL_REGEXP_ERROR > */
     "Unknown regular expression error in KILL file entry `%s' in KILL file `%s'.", /* entry */
 /* < KNOWN_KILL_REGEXP_ERROR > */
-    "Regular expression error in KILL file entry `%s' in KILL file `%s': %s.", /* entry, error string */
+    "Regular expression error in KILL file entry `%s'\n\tin KILL file `%s': %s.", /* entry, error string */
 /* < KILL_TOO_LONG > */
-    "Discarding too-long entry starting with `%s' in KILL file `%s'.", /* start of entry, file */
+    "Discarding too-long entry starting with `%s'\n\tin KILL file `%s'.", /* start of entry, file */
 /* < NOT_IN_NEWSRC > */
     "Newsgroup `%s' is not in your .newsrc file.", /* newsgroup name */
 /* < BOGUS_NG_REMOVING > */
-    "Newsgroup `%s' does not exist.  Removing it from your .newsrc file.", /* newsgroup name */
+    "Newsgroup `%s' does not exist.\n\tRemoving it from your .newsrc file.", /* newsgroup name */
 /* < MISSING_NG_LISTING > */
-    "Newsgroup `%s' not found in cache.  Retrieving newsgroup list to find it.", /* newsgroup name */
+    "Newsgroup `%s' not found in cache.\n\tRetrieving newsgroup list to find it.", /* newsgroup name */
 /* < MAYBE_LIST > */
     "Newsgroup `%s' not found in cache.\nRetrieve newsgroup list to find it?", /* newsgroup name */
 /* < DUP_NEWSRC_ENTRY > */
-    "Duplicate .newsrc entry for newsgroup `%s'.  Using the first one.", /* newsgroup name */
+    "Duplicate .newsrc entry for newsgroup `%s'.\n\tUsing the first one.", /* newsgroup name */
 /* < BAD_NEWSRC_LINE > */
-    "Unable to parse line %d in .newsrc file.  Ignoring it.", /* line number */
+    "Unable to parse line %d in .newsrc file.\n\tIgnoring it.", /* line number */
 /* < CANT_OPEN_NEWSRC_COPYING > */
-    "Cannot open .newsrc file `%s' for copying: %s.", /* file name, error string */
+    "Cannot open .newsrc file `%s'\n\tfor copying: %s.", /* file name, error string */
 /* < CANT_EXPAND > */
     "Cannot expand file name `%s'.", /* file name */
 /* < EMPTY_NEWSRC_SAVE_NAME > */
     ".newsrc save file name is the empty string.",
 /* < CANT_OPEN_NEWSRC_SAVE > */
-    "Cannot open .newsrc save file `%s' for writing: %s.", /* file name, error string */
+    "Cannot open .newsrc save file `%s'\n\tfor writing: %s.", /* file name, error string */
 /* < NEWSRC_SAVE_FILE_WRITE_ERR > */
-    "Error writing to .newsrc save file `%s': %s.", /* file name, error string */
+    "Error writing to .newsrc save file `%s':\n\t%s.", /* file name, error string */
 /* < CANT_READ_NEWSRC > */
-    "Cannot read .newsrc file `%s': %s.", /* file name, error string */
+    "Cannot read .newsrc file `%s':\n\t%s.", /* file name, error string */
 /* < CREATING_NEWSRC > */
     "Creating .newsrc file `%s' for you.", /* file name */
 /* < CANT_CREATE_NEWSRC > */
-    "Cannot create .newsrc file `%s': %s.", /* file name, error string */
+    "Cannot create .newsrc file `%s':\n\t%s.", /* file name, error string */
 /* < CANT_STAT_NEWSRC > */
-    "Cannot stat .newsrc file `%s': %s.", /* file name, error string */
+    "Cannot stat .newsrc file `%s':\n\t%s.", /* file name, error string */
 /* < ZERO_LENGTH_NEWSRC > */
-    ".newsrc file `%s' is empty.  Aborting.", /* file name */
+    ".newsrc file `%s' is empty.\n\tAborting.", /* file name */
 /* < CANT_OPEN_NEWSRC > */
-    "Cannot open .newsrc file `%s' for reading: %s.", /* file name, error string */
+    "Cannot open .newsrc file `%s'\n\tfor reading: %s.", /* file name, error string */
 /* < CANT_PARSE_NEWSRC > */
-    "Cannot parse .newsrc file `%s' -- error on line %d.", /* file name, error line */
+    "Cannot parse .newsrc file `%s' --\n\terror on line %d.", /* file name, error line */
 /* < CANT_OPEN_NEWSRC_TEMP > */
-    "Cannot open .newsrc temporary file `%s' for writing: %s.", /* file name, error string */
+    "Cannot open .newsrc temporary file `%s'\n\tfor writing: %s.", /* file name, error string */
 /* < CANT_OPEN_NEWSRC_WRITING > */
-    "Cannot open .newsrc file `%s' for writing: %s.", /* file name, error string */
+    "Cannot open .newsrc file `%s'\n\tfor writing: %s.", /* file name, error string */
 /* < ERROR_UNLINKING_NEWSRC > */
-    "Error unlinking .newsrc file `%s': %s.", /* file name, error string */
+    "Error unlinking .newsrc file `%s':\n\t%s.", /* file name, error string */
 /* < ERROR_RENAMING > */
-    "Error renaming temporary file `%s' to file `%s': %s.", /* temporary file name, file name, error string */
+    "Error renaming temporary file `%s'\n\tto file `%s':\n\t%s.", /* temporary file name, file name, error string */
 /* < NO_MAIL_DIR > */
     "No Mail directory `%s'.", /* directory name */
 /* < NO_SUCH_MAIL_DIR > */
-    "No such folder `%s'; Create it?", /* directory name */
+    "No such folder `%s';\nCreate it?", /* directory name */
 /* < CANT_STAT_MAIL_DIR > */
-    "Cannot stat directory `%s': %s.", /* directory name, error string */
+    "Cannot stat directory `%s':\n\t%s.", /* directory name, error string */
 /* < MAIL_DIR_NOT_DIR > */
-    "Cannot create folder -- mail path `%s' is not a directory.", /* directory name */
+    "Cannot create folder --\n\tmail path `%s' is not a directory.", /* directory name */
 /* < FOLDER_NOT_DIR > */
     "Path `%s' is not a folder.", /* folder name */
 /* < NO_SUCH_RMAIL > */
-    "No such RMAIL file `%s'; Create it?", /* file name */
+    "No such RMAIL file `%s'.\nCreate it?", /* file name */
 /* < CANT_OPEN_RMAIL > */
-    "Cannot open RMAIL file `%s' for writing: %s.", /* file name, error string */
+    "Cannot open RMAIL file `%s'\n\tfor writing: %s.", /* file name, error string */
 /* < CANT_WRITE_RMAIL > */
-    "Cannot write to RMAIL file `%s': %s.", /* file name, error string */
+    "Cannot write to RMAIL file `%s':\n\t%s.", /* file name, error string */
 /* < UNKNOWN_CONFIRM_BUTTON > */
     "XRN error: unknown confirm button `%s'.", /* button name */
 /* < CANT_EXECUTE_CMD_POPEN > */
@@ -400,14 +470,14 @@
 /* < CANT_EXPAND_DIR > */
     "Cannot expand directory `%s'.", /* directory name */
 /* < CANT_CREATE_SAVE_DIR > */
-    "Cannot create save directory `%s': %s.", /* drectory name, error string */
+    "Cannot create save directory `%s':\n\t%s.", /* drectory name, error string */
 /* < CANT_FIGURE_FILE_NAME > */
     "Cannot figure out file name `%s'.", /* file name */
 /* < CANT_CREAT_APPEND_SAVE_FILE > */
-    "Cannot %s file `%s': %s.", /* "create" or "append to", file name, error string */
+    "Cannot %s file `%s':\n\t%s.", /* "create" or "append to", file name, error string */
 /* < ERROR_WRITING_FILE > */
 /* < ERROR_WRITING_SAVE_FILE > */
-    "Error writing to file `%s': %s.", /* file name, error string */
+    "Error writing to file `%s':\n\t%s.", /* file name, error string */
 /* < CONNECTING > */
     "Connecting to NNTP server `%s'...", /* server name */
 /* < GETTING_LIST > */
@@ -417,100 +487,100 @@
 /* < FAILED_CONNECT > */
     "Failed to connect to NNTP server `%s'.", /* server name */
 /* < LOST_CONNECT_ATTEMPT_RE > */
-    "Lost connection to the NNTP server.  Attempting to reconnect.",
+    "Lost connection to the NNTP server.\n\tAttempting to reconnect.",
 /* < RECONNECTED > */
     "Reconnected to the NNTP server.",
 /* < CANT_TEMP_NAME > */
     "Cannot create temporary file name for article.",
 /* < CANT_CREATE_TEMP > */
-    "Cannot open temporary file `%s' for writing: %s.", /* file name, error string */
+    "Cannot open temporary file `%s'\n\tfor writing: %s.", /* file name, error string */
 /* < BOGUS_ACTIVE_ENTRY > */
     "Skipping bogus active file entry `%s'.", /* entry */
 /* < BOGUS_ACTIVE_CACHE > */
     "Skipping bogus active cache entry `%s'.", /* entry */
 /* < XHDR_ERROR > */
-    "XHDR command to the NNTP server failed.  Either the NNTP server does not\n\tsupport XHDR (in which case XRN will not work), or an internal\n\tXRN error occurred.",
+    "XHDR command to the NNTP server failed.\n\tEither the NNTP server does not support XHDR\n\t(in which case XRN will not work),\n\tor an internal XRN error occurred.",
 /* < NNTP_ERROR > */
     "NNTP serious error: `%s'.", /* error string */
 /* < MALFORMED_XHDR_RESPONSE > */
-    "NNTP server sent malformed XHDR response.  XHDR command was `%s', response was `%s'.", /* command, response */
+    "NNTP server sent malformed XHDR response.\n\tXHDR command was `%s',\n\tresponse was `%s'.", /* command, response */
 /* < NO_APP_DEFAULTS > */
-    "The current XRN Application Defaults file is not installed.  As a result, some XRN functionality may be missing.  If XRN was installed by someone else at your site, contact the installer about this error.  If you are the installer, see the COMMON-PROBLMS file in the XRN source directory to find out how to fix this problem.  ",
+    "The current XRN Application Defaults file is not installed.\n\tAs a result, some XRN functionality may be missing.\n\tIf XRN was installed by someone else at your site,\n\tcontact the installer about this error.\n\tIf you are the installer, see the\n\tCOMMON-PROBLMS file in the XRN source directory\n\tto find out how to fix this problem.\n\t",
 /* < VERSIONS > */
-    "Installed Application Defaults file version is `%s'.  XRN executable version is `%s'.", /* app-defaults version, executable version */
+    "Installed Application Defaults file version is `%s'.\n\tXRN executable version is `%s'.", /* app-defaults version, executable version */
 /* < NO_DOMAIN > */
-    "Could not determine your host's domain.\nRerun XRN with the DOMAIN environment variable or the domainName X resource set\nin order to post or send mail.",
+    "Could not determine your host's domain.\n\tRerun XRN with the DOMAIN environment variable\nor the domainName X resource set\nin order to post or send mail.",
 /* < NO_SERVER > */
-    "Could not determine the news server.\nRerun XRN with the NNTPSERVER environment variable, the nntpServer X resource or\nthe -nntpServer command line argument.",
+    "Could not determine the news server.\nRerun XRN with the NNTPSERVER environment variable,\nthe nntpServer X resource or the -nntpServer\ncommand line argument.",
 /* < UNKNOWN_LIST_REGEXP_ERROR > */
-    "Unknown regular expression error in %s list entry `%s'; entry ignored.", /* list name, entry */
+    "Unknown regular expression error\n\tin %s list entry `%s';\n\tentry ignored.", /* list name, entry */
 /* < KNOWN_LIST_REGEXP_ERROR > */
-    "Regular expression error in %s list entry `%s': %s; entry ignored.", /* list name, entry, error string */
+    "Regular expression error\n\tin %s list entry `%s':\n\t%s; entry ignored.", /* list name, entry, error string */
 /* < OPEARATION_APPLY_CURSOR > */
-   "Operations apply to current selection or cursor position",
+    "Operations apply to current selection or cursor position",
 /* < NO_MORE_UNREAD_ART > */
-   "No more unread articles in the subscribed to newsgroups",
+    "No more unread articles in the subscribed to newsgroups",
 /* < SEL_GROUPS_ADDSUB > */
-   "Select groups to `add', `quit' unsubscribes remaining groups",
+    "Select groups to `add', `quit' unsubscribes remaining groups",
 /* < ARE_YOU_SURE > */
-   "Are you sure?",
+    "Are you sure?",
 /* SUB, UNSUB and IGNORED strings must have the same len */
-/* < SUBED >  */ 
-   "subscribed  ",
+/* < SUBED > */ 
+    "subscribed  ",
 /* < UNSUBED > */
-   "unsubscribed",
+    "unsubscribed",
 /* < IGNORED > */
-   "ignored     ",
+    "ignored     ",
 /* < OK_CATCHUP > */
-   "OK to Catchup?",
+    "OK to Catchup?",
 /* < OK_CATCHUP_CUR > */ 
-   "OK to catch up to current position?",
+    "OK to catch up to current position?",
 /* < OK_GETLIST > */
     "OK to fetch newsgroup list from the server?",
 /* < OK_TO_UNSUB > */
-   "OK to unsubscribe?",
+    "OK to unsubscribe?",
 /* < OK > */
     "OK",
 /* < EDIT > */
     "edit",
 /* < SEARCH_ABORTED > */
-   "search has been aborted",
+    "search has been aborted",
 /* < ERROR_SUBJ_SEARCH > */ 
-   "Subject search: %s", /* regular expression */
+    "Subject search: %s", /* regular expression */
 /* < ERROR_SUBJ_EXH > */ 
-   "Subject has been exhausted",
+    "Subject has been exhausted",
 /* < ERROR_NO_PARENT > */
     "Article has no parent.",
 /* < ERROR_PARENT_UNAVAIL > */
     "Article's parent is unavailable.",
 /* < ERROR_SUBJ_ABORT > */
-   "search aborted",
+    "search aborted",
 /* < KILL_DONE > */
-   "Returning to first unread article.",
+    "Returning to first unread article.",
 /* < UNKNOWN_KILL_TYPE > */
     "Unknown kill type \"%s\" in \"%s\" kill request.", /* field type argument, field name */
 /* < ERROR_CANT_UPDATE_NEWSRC > */
-   "Cannot update the newsrc file",
+    "Cannot update the newsrc file",
 /* < ARTICLE_NUMBER > */ 
-   "Article Number:",
+    "Article Number:",
 /* < LIST_OLD_NUMBER > */ 
-   "First article to list:",
+    "First article to list:",
 /* < ERROR_SUBJ_EXPR > */
-   "Search for expression %s: no match was found", /* regular expression */
+    "Search for expression %s: no match was found", /* regular expression */
 /* < ERROR_SEARCH > */ 
-   "Search for expression %s", /* regular expression */
+    "Search for expression %s", /* regular expression */
 /* < REGULAR_EXPR > */
-   "Regular Expression:",
+    "Regular Expression:",
 /* < BEHIND_WHAT_GROUP > */
-   "After which newsgroup?",
+    "After which newsgroup?",
 /* < ARTICLE_QUEUED > */
-   "Article sucessfully queued",
+    "Article successfully queued",
 /* < GROUP_SUB_TO > */
-   "Group to subscribe to:",
+    "Group to subscribe to:",
 /* < GROUP_TO_GO > */ 
-   "Group to go to:",
+    "Group to go to:",
 /* < VIEW_ALLNG_SUB > */
-   "View all available groups, with option to subscribe",
+    "View all available groups, with option to subscribe",
 /* < SUB_DONE > */
     "You are now subscribed to `%s'.", /* newsgroup name */
 /* < AUTOMATIC_RESCAN > */
@@ -518,84 +588,90 @@
 /* < RESCANNING_BACKGROUND > */
     "Rescanning in the background...",
 /* < ERROR_UNSUP_TRANS > */
-   "unsupported transition: %d to %d", /* transition from, to */
+    "unsupported transition: %d to %d", /* transition from, to */
 /* < POST_FOLLOWUP > */
-   "article",
+    "article",
 /* < FOLLOWUP_REPLY > */ 
-   "article and mail message",
+    "article and mail message",
 /* < DEFAULT_MAIL > */
-   "mail message",
+    "mail message",
 /* < SAVE_IN > */
-   "Saving in %s",  /* file */
+    "Saving in %s",  /* file */
 /* < ERROR_SEND_MAIL > */
-   "Error sending mail:",
+    "Error sending mail:",
 /* < ASK_FILE > */
-   "File Name?",
+    "File Name?",
 /* < ASK_POST_ARTICLE > */
-   "Post the article?",
+    "Post the article?",
+/* < ASK_SEND > */
+    "Send the message?",
 /* < ASK_POST_SEND > */
-   "Post and/or send the message?",
-/* < ASK_RE_EDIT_ARTCILE > */
-   "Re-edit the article?",
-/* < ASK_RE_EDIT > */
-   "Re-edit the message?",
+    "Post and send the message?",
+/* < RE_EDIT > */
+    "Re-edit",
+/* < AS_FOLLOWUP > */
+    "as followup",
+/* < AS_REPLY > */
+    "as reply",
+/* < AS_FOLLOWUP_REPLY > */
+   "as followup/reply",
 /* < ERROR_EXEC_FAILED > */
-   "XRN Error: execl of `%s' failed\n", /* prog */
+    "XRN Error: execl of `%s' failed\n", /* prog */
 /* < ASK_POSTER_FANDR > */
-   "`Followup-To' line in message says to reply to poster.\nIgnore it and post as well, or just send E-mail?",
+    "`Followup-To' line in message says to reply to poster.\nIgnore it and post as well, or just send E-mail?",
 /* < ASK_POSTER_REPLY > */
-   "`Followup-To' line in message says to reply to poster.\nPost followup or mail reply?",
+    "`Followup-To' line in message says to reply to poster.\nPost followup or mail reply?",
 /* < POST_AND_SEND > */
-   "post and send mail",
+    "post and send mail",
 /* < SEND_MAIL > */
-   "send mail",
-/* < POST > */ 
-   "post",
+    "send mail",
+/* < POST > */
+    "post",
 /* < FOLLOWUP_MULTIPLE_NGS > */
-    "The default `Newsgroups' line of your followup contains multiple newsgroups.  Please be sure to remove inappropriate newsgroups before sending your message, and/or to put a more appropriate list of groups in your `Followup-To' line.",
+    "The default `Newsgroups' line of your followup contains multiple newsgroups.\n\tPlease be sure to remove inappropriate newsgroups before sending your message,\n\tand/or to put a more appropriate list of groups in your `Followup-To' line.",
 /* < FOLLOWUP_FOLLOWUPTO > */
-    "Note that the article to which you are responding contains a `Followup-To' line, so the default `Newsgroups' line of your followup has been set from that line rather than from the `Newsgroups' line of the original article.",
+    "Note that the article to which you are responding contains a `Followup-To' line,\n\tso the default `Newsgroups' line of your followup has been set from that line\n\trather than from the `Newsgroups' line of the original article.",
 /* < CROSSPOST_PROHIBIT > */
-    "The `Newsgroups' line of your message contains %d newsgroups.  The maximum\nnumber of groups to which you are allowed to post a message is %d.  Please\nreduce the number of groups to which you are posting and then send your\nmessage again.",
+    "The `Newsgroups' line of your message contains %d newsgroups.\n\tThe maximum number of groups to which you are allowed to post a message is %d.\n\tPlease reduce the number of groups to which you are posting\n\tand then send your message again.",
 /* < CROSSPOST_CONFIRM > */
-    "The `Newsgroups' line of your message contains %d newsgroups.  Please\nconsider reducing the number of groups to which you are posting.",
+    "The `Newsgroups' line of your message contains %d newsgroups.\n\tPlease consider reducing the number of groups to which you are posting.",
 /* < FOLLOWUP_FOLLOWUPTO_CONFIRM > */
-    "The `Newsgroups' line of your message contains %d newsgroups, and the\n`Followup-To' line contains %d newsgroups.  Please consider reducing the\nnumber of groups in your `Newsgroups' and/or `Followup-To' line.",
+    "The `Newsgroups' line of your message contains %d newsgroups,\n\tand the `Followup-To' line contains %d newsgroups.\n\tPlease consider reducing the number of groups in your `Newsgroups' and/or `Followup-To' line.",
 /* < FOLLOWUP_CONFIRM > */
-    "The `Newsgroups' line of your message contains %d newsgroups.  Please consider\neither reducing the number of newsgroups to which you are posting or adding a\n`Followup-To' line containing a smaller number of groups.",
+    "The `Newsgroups' line of your message contains %d newsgroups.\n\tPlease consider either reducing the number of newsgroups to which you are posting\n\tor adding a `Followup-To' line containing a smaller number of groups.",
 /* < ERROR_STRIPFIELD_NL > */
-   "ouch!  can't find newline in stripField\n",
+    "ouch!  can't find newline in stripField\n",
 /* < FOLLOWUP_REPLY_TO_TITLE > */
-   "Followup and reply to article %ld in `%s'", /* article number, newsgroup */
+    "Followup and reply to article %ld in `%s'", /* article number, newsgroup */
 /* < FOLLOWUP_TO_TITLE > */
-   "Followup to article %ld in `%s'", /* article number, newsgroup */
+    "Followup to article %ld in `%s'", /* article number, newsgroup */
 /* < REPLY_TO_TITLE > */
-   "Reply to article %ld in `%s'", /* article number, newsgroup */
+    "Reply to article %ld in `%s'", /* article number, newsgroup */
 /* < FORWARD_TO_TITLE > */
-   "Forward article %ld in `%s' to a user", /* article number, newsgroup */
+    "Forward article %ld in `%s' via mail", /* article number, newsgroup */
 /* < POST_ARTICLE > */
-   "Post article",
+    "Post article",
 /* < POST_ARTICLE_TO > */
-   "Post article to `%s'", /* newsgroup */
+    "Post article to `%s'", /* newsgroup */
 /* < POST_MAIL_ARTICLE > */
     "Post and mail article",
 /* < POST_MAIL_ARTICLE_TO > */
-    "Post article to `%s' and mail it",
+    "Post article to `%s' and mail it", /* newsgroup */
 /* < MAIL > */
     "Send a mail message",
 /* < USER_CANT_CANCEL > */
-   "Not entitled to cancel the article",
+    "Not entitled to cancel the article",
 /*
  ### may be the following messages shouldn't translate ###
  */
 /* < REPLY_YOU_WRITE > */
-   "In article %s, you write:\n", /* messageid */
+    "In article %s,\n you write:\n", /* messageid */
 /* < FORWARDED_ARTIKEL > */
-   "\n------ Forwarded Article %s\n------ From %s\n\n", /* messageid , author */
+    "\n------ Forwarded Article %s\n------ From %s\n\n", /* messageid , author */
 /* < FORWARDED_ARTICLE_END > */
-   "\n------ End of Forwarded Article\n",
+    "\n------ End of Forwarded Article\n",
 /* < FOLLOWUP_AUTHOR_WRITE > */
-"In article %s, %s writes:\n", /* messageid , author */
+    "In article %s,\n %s writes:\n", /* messageid , author */
 /* #### end may be not translate #### */
 /* < NEWSGROUPS_INDEX > */
     "%6s %7s %*s %4d article%1.1s +%6d old",
@@ -616,65 +692,65 @@
 /* < APPEND > */
     "append to",
 /* < ERR_XRN_RUN > */
-   "An XRN of yours is running on %s as process %d.\nIf it is no longer running, remove the file \"%s\".\n", /* host, pid, lockfile */
+    "An XRN of yours is running on %s as process %d.\nIf it is no longer running, remove the file \"%s\".\n", /* host, pid, lockfile */
 /* < ERROR_CANT_READ_NEWSRC > */
-   "Can not read the .newsrc file",
+    "Cannot read the .newsrc file",
 /* < PROCESS_KILL_FOR > */
-   "Processing KILL file for newsgroup `%s'...", /* newsgroup */
+    "Processing KILL file for newsgroup `%s'...", /* newsgroup */
 /* < ERROR_REGEX_NOSLASH > */
-   "no slash terminating the regular expression",
+    "no slash terminating the regular expression",
 /* < ERROR_REGEX_NOSLASH_START > */
     "no slash preceding the regular expression",
 /* < ERROR_REGEX_NOCOLON > */
-   "no colon after the regular expression",
+    "no colon after the regular expression",
 /* < ERROR_REGEX_UNKNOWN_COMMAND > */
-   "unknown command (valid commands are `j', `m', and `s')",
+    "unknown command (valid commands are `j', `m', and `s')",
 /* < KILL_LINE > */
     "Processing entry `%s' in KILL file `%s'.",
 /* < KILL_KILLED > */
-   "killed - %s",         /* subject */
+    "killed - %s",         /* subject */
 /* < KILL_UNREAD > */
-   "marked unread - %s",  /* subject */
+    "marked unread - %s",  /* subject */
 /* < KILL_SAVED > */
-   "saved - %s",         /* subject */
+    "saved - %s",         /* subject */
 /* < COUNT_KILLED > */
-   "killed %d article%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+    "killed %d article%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
 /* < COUNT_UNREAD > */
-   "marked %d article%s unread in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+    "marked %d article%s unread in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
 /* < COUNT_SAVED > */
-   "saved %d article%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+    "saved %d article%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
 /* < ERROR_CORNERED > */
-   "XRN error in `cornered': expecting nglist to be valid\n",
+    "XRN error in `cornered': expecting nglist to be valid\n",
 /* < ERROR_OUT_OF_MEM > */
-   "out of memory",
+    "out of memory",
 /* < PREFETCHING > */
     "Fetching `%s'...",
 /* < SERVER_POSTING_ERROR > */
     "Error from NNTP server: %s", /* error message */
 /* < ASK_SAVEBOX > */
-   "FileName, +FolderName, or @FolderName?",
+    "FileName, +FolderName, or @FolderName?",
 /* < SAVE_PIPE_TO > */
-   "Piping article %ld into command `%s'...",  /* articlenumber, command */
+    "Piping article %ld into command `%s'...",  /* articlenumber, command */
 /* < ERROR_SAVE_PIPE > */
-   "`%s' exited with status %d", /* command, status */
+    "`%s' exited with status %d", /* command, status */
 /* < SAVE_MH_REFILE > */
-   "MH refile to folder %s %s", /* folder, status */
+    "MH refile to folder %s %s", /* folder, status */
 /* < SAVE_RMAIL_REFILE > */
-   "RMAIL refile to folder %s %s", /* folder, status */
+    "RMAIL refile to folder %s %s", /* folder, status */
 /* < SAVE_OK > */
-   "Saving article %ld in file `%s'...", /* articlenumber, filename */
+    "Saving article %ld in file `%s'...", /* articlenumber, filename */
 /* < SAVE_APPEND_OK > */
-   "Appending article %ld to file `%s'...", /* articlenumber, filename */
+    "Appending article %ld to file `%s'...", /* articlenumber, filename */
 /* < SAVE_ARTICLE > */
-   "Article: %ld of %s\n", /* articlenumber, newsgroup */
+    "Article: %ld of %s\n", /* articlenumber, newsgroup */
 /* < ERROR_INFINITE_LOOP > */
-   "XRN panic: moveBeginning / moveEnd in infinite loop",
+    "XRN panic: moveBeginning / moveEnd in infinite loop",
 /* < ERROR_FINDARTICLE > */
-   "Valid article number not found in findArticle",
+    "Valid article number not found in findArticle",
 /* < ERROR_STRIP_LEAVE_HEADERS > */
-   "Only one of `stripHeaders', `leaveHeaders' resources allowed",
+    "Only one of `stripHeaders', `leaveHeaders' resources allowed",
 /* < ERROR_REQUEST_FAILED > */
-   "        Request was: `%s'\n        Failing response was: `%s'", /* command, message */
+    "        Request was: `%s'\n        Failing response was: `%s'", /* command, message */
 /* < ASK_FILE_MODIFIED > */
     "%s file %s\nhas been modified; overwrite it?", /* file type, file name */
 /* < PENDING_COMPOSITION > */
@@ -682,19 +758,544 @@
 /* < NNTP_PASSWORD > */
     "Enter NNTP password:",
 /* < UNKNOWN_SORT_TYPE > */
-    "Unknown subject sort type: %s",
+    "Unknown subject sort type: %s", /* type */
 /* < TOO_MANY_SORT_TYPES > */
     "Too many subject sort types specified.",
 /* < UNPARSEABLE_DATE > */
-    "Unparseable date (article %ld in %s): %s",
+    "Unparseable date (article %ld in %s):\n\t%s", /* number, newsgroup, string */
 /* < THREADING_FOR > */
     "Threading newsgroup `%s'...", /* newsgroup */
 /* < FILE_CACHE_OPEN > */
-    "Error opening cache file in %s: %s", /* directory, error string */
+    "Error opening cache file in %s:\n\t%s", /* directory, error string */
+/* < MESG_PANE_DISMISS > */
+    "This window can be left open or dismissed.\n\tIf dismissed, it will reappear whenever there are new messages.",
+/* < BAD_FROM > */
+    "Bad `From' address `%s'.\n\tPlease fix it and resend, or abort your message.",
+/* < NO_BODY > */
+    "Your message has no body, or the blank line after the header is missing.\n\tPlease fix this and resend, or abort your message.",
+/* < ONLY_INCLUDED > */
+    "Message appears to contain only\nincluded text.  Post anyway?",
+/* < COURTESY_COPY > */
+    "[This is a courtesy copy of a message which was also posted to the\n newsgroup(s) shown in the header.]",
 };
 
 #endif /* XRN_LANG_english */
 
+#ifdef XRN_LANG_french
+
+char *message_strings[] = {
+/* < BAD_BUTTON_NAME > */
+    "Erreur XRN : nom de bouton incorrect `%s'.", /* button name */
+/* < NO_SUCH_NG_DELETED > */
+    "Le groupe de news `%s' n'existe pas.\n\tIl peut avoir t supprim.", /* newsgroup name */
+/* < UNKNOWN_FUNC_RESPONSE > */
+    "Internal XRN error: unknown response %d from %s in %s.", /* return value, called function, calling function */
+/* < DISPLAYING_LAST_UNREAD > */
+    "Aucun article non lu dans `%s'.\n\tLecture du dernier article disponible.", /* newsgroup name */
+/* < PROBABLY_KILLED > */
+    "Aucun article non lu dans `%s'.\n\tIls ont probablement t tus.", /* newsgroup name */
+/* < NO_ARTICLES > */
+    "Aucun article dans `%s'.", /* newsgroup name */
+/* < PROBABLY_EXPIRED > */
+    "Aucun article dans `%s'.\n\tIls ont probablement expir ou t annuls.", /* newsgroup name */
+/* < NO_NG_SPECIFIED > */
+    "Pas de nom de groupe de news spcifi.",
+/* < NO_SUCH_NG > */
+    "Le groupe de news `%s' n'existe pas.", /* newsgroup name */
+/* < NO_PREV_NG > */
+    "Pas de groupe de news prcdent",
+/* < NO_GROUPS_SELECTED > */
+    "Aucun groupe de news slectionn.",
+/* < NG_NOT_MOVED > */
+    "La nouvelle position d'un groupe ne peut pas figurer\n\tdans un bloc de groupes slectionns.\n\tLes groupes n'ont pas t dplacs.",
+/* < SKIPPING_TO_NEXT_NG > */
+    "Lecture du groupe de news suivant.",
+/* < BAD_ART_NUM > */
+    "Article numro `%s' invalide.", /* article number string */
+/* < NO_ART_NUM > */
+    "Numro d'article non spcifi.",
+/* < ART_NOT_AVAIL > */
+    "L'article numro %d n'est pas disponible.", /* article number */
+/* < ARTS_NOT_AVAIL > */
+    "Les articles numro %d-%d ne sont pas disponibles.", /* first, last article number */
+/* < NO_PREV_REGEXP > */
+    "Pas d'expression rgulire prcdente.",
+/* < NO_PREV_ART > */
+    "Pas d'article prcdent.",
+/* < MSG_ABORTED > */
+    "%s annul.", /* "article" or "message" */
+/* < NO_FILE_NOT_SAVED > */
+    "Impossible de determiner le nom du fichier de sauvegarde.\n\tArticle/message non sauv.",
+/* < NO_SUBJECT > */
+    "Le champ Subject manque dans votre message!\n\t",
+/* < EMPTY_SUBJECT > */
+    "Le champ Subject de votre message est vide!\n\t",
+/* < NO_NEWSGROUPS > */
+    "Le champ Newsgroups manque dans votre message!\n\t",
+/* < MULTI > */
+    "Il y a plusieurs champs %s dans votre message!\n\tVeuillez n'en conserver qu'un\n\tet l'envoyer  nouveau.", /* field name */
+/* < DEFAULT_ADDED > */
+    "Un valeur par dfaut a t ajoute.\n\tVeuillez la modifier si ncessaire\n\tet envoyer votre message  nouveau.",
+/* < EMPTY_ADDED > */
+    "Une valeur vide a t ajoute.\n\t",
+/* < FILL_IN_RESEND > */
+    "Veuillez le remplir et envoyer votre message  nouveau.",
+/* < NO_POSTABLE_NG > */
+    "Pas de groupe appropri sur la ligne `Newsgroups'.\n\tVeuillez corriger et envoyer votre message  nouveau ou annuler.",
+/* < SAVING_DEAD > */
+    "Sauv dans `%s'.", /* file name */
+/* < COULDNT_POST > */
+    "Impossible de poster l'article.",
+/* < POST_NOTALLOWED > */
+    "Cette machine n'a pas l'autorisation de poster.",
+/* < COULDNT_SEND > */
+    "Impossible d'envoyer le message par mail.",
+/* < MAILED_TO_MODERATOR > */
+    "La ligne `Newsgroups' comporte au moins un groupe modr.\n\tL'article sera envoy par mail au modrateur.",
+/* < ARTICLE_POSTED > */
+    "Article post.",
+/* < MAIL_MESSAGE_SENT > */
+    "Message envoy par mail.",
+/* < CANT_INCLUDE_CMD > */
+    "Impossible d'excuter includeCommand (`popen' n'a pas fonctionn).",
+/* < CANT_OPEN_ART > */
+    "Impossible d'ouvrir le fichier correspondant  l'article `%s':\n\t%s.", /* file name, error string */
+/* < CANT_OPEN_FILE > */
+    "Impossible d'ouvrir le fichier `%s':\n\t%s.", /* error string */
+/* < NO_FILE_SPECIFIED > */
+    "Aucun fichier spcifi.",
+/* < CANT_OPEN_TEMP > */
+    "Impossible d'ouvrir le fichier temporaire `%s':\n\t%s.", /* file name, error string */
+/* < CANT_STAT_TEMP > */
+    "Impossible de trouver le fichier temporaire `%s':\n\t%s.", /* file name, error string */
+/* < NO_CHANGE > */
+    "Pas de modification dans le fichier temporaire `%s'.", /* file name */
+/* < ZERO_SIZE > */
+    "Le fichier temporaire `%s'\n\test de taille nulle.", /* file name */
+/* < NO_MSG_TEMPLATE > */
+    "Erreur interne XRN : pas de gabarit de message pour appeler Call_Editor.",
+/* < CANT_EDITOR_CMD > */
+    "Impossible d'excuter la commande `%s' de l'diteur:\n\t%s.", /* command, error string */
+/* < ONE_COMPOSITION_ONLY > */
+    "Une seule composition permise a la fois.",
+/* < EXECUTING_SIGNATURE > */
+    "Execution de la commande de signature `%s'.", /* command */
+/* < CANT_EXECUTE_SIGNATURE > */
+    "Impossible d'excuter la commande de signature `%s'.\n\tRemplace par son nom.", /* signature file name */
+/* < READING_SIGNATURE > */
+    "Lecture du fichier de signature `%s'.", /* signature file name */
+/* < CANT_READ_SIGNATURE > */
+    "Impossible de lire le fichier de signature `%s':\n\t%s.", /* signature file name, error string */
+/* < SIGNATURE_TOO_BIG > */
+    "Signature file `%s'\n\tis too large; ignoring it.", /* signature file name */
+/* < CANCEL_ABORTED > */
+    "Article non annul.",
+/* < CANCELLED_ART > */
+    "L'article a t annul.",
+/* < CANCEL_TO_MODERATOR > */
+    "Message being canceled appears\n\tin one or more moderated newsgroups.\n\tCancel request will be\n\tmailed to moderator by server.",
+/* < UNKNOWN_REGEXP_ERROR > */
+    "Erreur inconnue dans l'expression rgulire `%s'.", /* regexp string */
+/* < KNOWN_REGEXP_ERROR > */
+    "Erreur dans l'expression rgulire `%s':\n\t%s.", /* regexp, error string */
+/* < ART_NUMBERING_PROBLEM > */
+    "Problme de numrotation d'articles.\n\tTous les articles du groupe `%s'\n\tsont marqus non lus.", /* newsgroup name */
+/* < CANT_OPEN_KILL > */
+    "Cannot open kill file `%s':\n\t%s.", /* file name, error string */
+/* < CANT_OPEN_INCLUDED_KILL > */
+    "Cannot open kill file `%s'\n\t(included from `%s'):\n\t%s.", /* file name, parent file name, error string */
+/* < MALFORMED_KILL_ENTRY > */
+    "Error in KILL file entry `%s'\n\tin KILL file `%s':\n\t%s.", /* entry, file, reason for error */
+/* < ERROR_INCLUDE_MISSING > */
+    "No newsgroup or file name specified in include directive",
+/* < ERROR_INCLUDE_NOT_SEPARATED > */
+   " Include operand not separated",
+/* < KILL_ERROR_UNKNOWN_OPTION > */
+    "Error in KILL file entry `%s'\n\tin KILL file `%s':\n\tUnknown option `%c'.", /* entry, file, unknown option */
+/* < UNKNOWN_KILL_REGEXP_ERROR > */
+    "Unknown regular expression error in KILL file entry `%s' in KILL file `%s'.", /* entry */
+/* < KNOWN_KILL_REGEXP_ERROR > */
+    "Regular expression error in KILL file entry `%s'\n\tin KILL file `%s': %s.", /* entry, error string */
+/* < KILL_TOO_LONG > */
+    "Discarding too-long entry starting with `%s'\n\tin KILL file `%s'.", /* start of entry, file */
+/* < NOT_IN_NEWSRC > */
+    "Le groupe `%s' ne figure pas dans votre fichier .newsrc.", /* newsgroup name */
+/* < BOGUS_NG_REMOVING > */
+    "Le groupe `%s' n'existe pas.\n\tIl est supprim de votre fichier .newsrc.", /* newsgroup name */
+/* < MISSING_NG_LISTING > */
+    "Newsgroup `%s' not found in cache.\n\tRetrieving newsgroup list to find it.", /* newsgroup name */
+/* < MAYBE_LIST > */
+    "Newsgroup `%s' not found in cache.\nRetrieve newsgroup list to find it?", /* newsgroup name */
+/* < DUP_NEWSRC_ENTRY > */
+    "Le groupe `%s' figure plusieurs fois dans votre fichier .newsrc.\n\tSeule la premi`ere occurence est utilise.", /* newsgroup name */
+/* < BAD_NEWSRC_LINE > */
+    "Impossible de lire la ligne %d de votre fichier .newsrc.\n\tLa ligne est ignore.", /* line number */
+/* < CANT_OPEN_NEWSRC_COPYING > */
+    "Impossible d'ouvrir le fichier .newsrc `%s'\n\tpour copie: %s.", /* file name, error string */
+/* < CANT_EXPAND > */
+    "Cannot expand file name `%s'.", /* file name */
+/* < EMPTY_NEWSRC_SAVE_NAME > */
+    "Le nom du fichier de sauvegarde .newsrc est vide.",
+/* < CANT_OPEN_NEWSRC_SAVE > */
+    "Impossible d'ouvrir le fichier de sauvegarde .newsrc `%s'\n\ten criture: %s.", /* file name, error string */
+/* < NEWSRC_SAVE_FILE_WRITE_ERR > */
+    "Erreur lors de l'criture dans le fichier de sauvegarde .newsrc `%s':\n\t%s.", /* file name, error string */
+/* < CANT_READ_NEWSRC > */
+    "Impossible de lire le fichier .newsrc `%s':\n\t%s.", /* file name, error string */
+/* < CREATING_NEWSRC > */
+    "Cration du fichier .newsrc `%s' pour vous.", /* file name */
+/* < CANT_CREATE_NEWSRC > */
+    "Impossible de crer le fichier .newsrc `%s':\n\t%s.", /* file name, error string */
+/* < CANT_STAT_NEWSRC > */
+    "Impossible de trouver le fichier .newsrc `%s':\n\t%s.", /* file name, error string */
+/* < ZERO_LENGTH_NEWSRC > */
+    "Le fichier .newsrc `%s' est vide.\n\tAnnulation.", /* file name */
+/* < CANT_OPEN_NEWSRC > */
+    "Impossible d'ouvrir le fichier .newsrc `%s'\n\ten lecture: %s.", /* file name, error string */
+/* < CANT_PARSE_NEWSRC > */
+    "Impossible d'analyser le fichier .newsrc `%s' --\n\terreur  la ligne %d.", /* file name, error line */
+/* < CANT_OPEN_NEWSRC_TEMP > */
+    "Impossible d'ouvrir le fichier temporaire `%s'\n\ten criture: %s.", /* file name, error string */
+/* < CANT_OPEN_NEWSRC_WRITING > */
+    "Impossible d'ouvrir le fichier .newsrc `%s'\n\ten criture: %s.", /* file name, error string */
+/* < ERROR_UNLINKING_NEWSRC > */
+    "Erreur lors de l'effacement du fichier .newsrc `%s':\n\t%s.", /* file name, error string */
+/* < ERROR_RENAMING > */
+    "Error renaming temporary file `%s'\n\tto file `%s':\n\t%s.", /* temporary file name, file name, error string */
+/* < NO_MAIL_DIR > */
+    "Pas de rpertoire de Mail `%s'.", /* directory name */
+/* < NO_SUCH_MAIL_DIR > */
+    "Pas de classeur `%s';\nle crer?", /* directory name */
+/* < CANT_STAT_MAIL_DIR > */
+    "Impossible de voir le rpertoire `%s':\n\t%s.", /* directory name, error string */
+/* < MAIL_DIR_NOT_DIR > */
+    "Impossible de crer le claseur --\n\tle chemin `%s' n'est pas un rpertoire.", /* directory name */
+/* < FOLDER_NOT_DIR > */
+    "Le chemin `%s' n'est pas un classeur.", /* folder name */
+/* < NO_SUCH_RMAIL > */
+    "Le fichier RMAIL `%s' n'existe pas.\nLe crer?", /* file name */
+/* < CANT_OPEN_RMAIL > */
+    "Impossible d'ouvrir le fichier RMAIL `%s'\n\ten criture: %s.", /* file name, error string */
+/* < CANT_WRITE_RMAIL > */
+    "Impossible d'crire dans le fichier RMAIL `%s':\n\t%s.", /* file name, error string */
+/* < UNKNOWN_CONFIRM_BUTTON > */
+    "Erreur XRN : bouton de confirmation inconnu `%s'.", /* button name */
+/* < CANT_EXECUTE_CMD_POPEN > */
+    "Impossible d'xcuter la commande `%s' (`popen' a chou).", /* command string */
+/* < CANT_EXPAND_DIR > */
+    "Cannot expand directory `%s'.", /* directory name */
+/* < CANT_CREATE_SAVE_DIR > */
+    "Impossible de crer le rpertoire de sauvegarde `%s':\n\t%s.", /* drectory name, error string */
+/* < CANT_FIGURE_FILE_NAME > */
+    "Impossible de dterminer le nom de fichier `%s'.", /* file name */
+/* < CANT_CREAT_APPEND_SAVE_FILE > */
+    "Impossible de %s le fichier `%s':\n\t%s.", /* "create" or "append to", file name, error string */
+/* < ERROR_WRITING_FILE > */
+/* < ERROR_WRITING_SAVE_FILE > */
+    "Erreur lors de l'criture dans le fichier `%s':\n\t%s.", /* file name, error string */
+/* < CONNECTING > */
+    "Connexion au serveur NNTP `%s'...", /* server name */
+/* < GETTING_LIST > */
+    "Lecture de la liste des groupes de news...",
+/* < GETTING_NEWGROUPS > */
+    "Getting list of new newsgroups...",
+/* < FAILED_CONNECT > */
+    "La connexion au serveur NNTP `%s' a chou.", /* server name */
+/* < LOST_CONNECT_ATTEMPT_RE > */
+    "La connexion au serveur NNTP a t perdue.\n\tReconnexion en cours.",
+/* < RECONNECTED > */
+    "Reconnexion au serveur NNTP effectue.",
+/* < CANT_TEMP_NAME > */
+    "Impossible de crer un fichier temporaire pour l'article",
+/* < CANT_CREATE_TEMP > */
+    "Impossible d'ouvrir le fichier temporaire `%s'\n\ten criture : %s.", /* file name, error string */
+/* < BOGUS_ACTIVE_ENTRY > */
+    "Entre errone `%s' du fichier des groupes ignore.", /* entry */
+/* < BOGUS_ACTIVE_CACHE > */
+    "Skipping bogus active cache entry `%s'.", /* entry */
+/* < XHDR_ERROR > */
+    "La requte XHDR auprs du serveur NNTP a chou.\n\tLe serveur NNTP ne supporte pas XHDR\n\t(auquel cas XRN ne fonctionnera pas),\n\tou une erreur interne  XRN s'est produite.",
+/* < NNTP_ERROR > */
+    "Erreur grave NNTP : `%s'.", /* error string */
+/* < MALFORMED_XHDR_RESPONSE > */
+    "Le serveur NNTP a retourn une rponse incorrecte.\n\tLa commande XHDR tait `%s',\n\tla rponse `%s'.", /* command, response */
+/* < NO_APP_DEFAULTS > */
+    "Le fichier de ressources par dfaut d'XRN n'est pas install.\n\tEn consquence, certaines fonctionnalit'es d'XRN pourraient manquer.\n\tContacter la personne ayant ralis l'installation\n\tpour rsoudre ce problme.",
+/* < VERSIONS > */
+    "La version du fichier de ressource install est `%s'.\n\tLa version de l'xcutable XRN est `%s'.", /* app-defaults version, executable version */
+/* < NO_DOMAIN > */
+    "Impossible de dterminer le domaine de votre machine.\n\tRelancer XRN en positionnant la variable d'environnement DOMAIN\n\tou la ressource X domainName\nafin de poster ou d'envoyer un mail.",
+/* < NO_SERVER > */
+    "Impossible de trouver le serveur de news.\nRelanceer XRN en positionnant la variable d'environnement NNTPSERVER\nou la ressource X nntpServer\nou en utilisant l'option -nntpServer.",
+/* < UNKNOWN_LIST_REGEXP_ERROR > */
+    "Erreur d'expression rgulire inconnue\n\tdans la liste %s;\n\tentre `%s' ignore.", /* list name, entry */
+/* < KNOWN_LIST_REGEXP_ERROR > */
+    "Regular expression error\n\tin %s list entry `%s':\n\t%s; entry ignored.", /* list name, entry, error string */
+/* < OPEARATION_APPLY_CURSOR > */
+    "Les oprations s'appliquent  la slection en cours ou  la position du curseur",
+/* < NO_MORE_UNREAD_ART > */
+    "Plus d'article non lu dans les groupes auquels vous tes abonn(e)",
+/* < SEL_GROUPS_ADDSUB > */
+    "Slectionner les groupes  ajouter, `quit' refuse l'abonnement aux groupes restants",
+/* < ARE_YOU_SURE > */
+    "tes-vous sr(e)?",
+/* SUB and UNSUB string must have the same len */
+/* < SUBED > */ 
+    "    abonn",
+/* < UNSUBED > */
+    "non abonn",
+/* < IGNORED > */
+    "ignored     ",
+/* < OK_CATCHUP > */
+    "Confirmation du rattrapage?",
+/* < OK_CATCHUP_CUR > */ 
+    "Confirmation du rattrapage jusqu' la position courante?",
+/* < OK_GETLIST > */
+    "OK to fetch newsgroup list from the server?",
+/* < OK_TO_UNSUB > */
+    "Confirmation du dsabonnement?",
+/* < OK > */
+    "OK",
+/* < EDIT > */
+    "edit",
+/* < SEARCH_ABORTED > */
+    "Recherche abandonne",
+/* < ERROR_SUBJ_SEARCH > */ 
+    "Recherche de sujet : %s", /* regular expression */
+/* < ERROR_SUBJ_EXH > */ 
+    "Le sujet a t puis",
+/* < ERROR_NO_PARENT > */
+    "Article has no parent.",
+/* < ERROR_PARENT_UNAVAIL > */
+    "Article's parent is unavailable.",
+/* < ERROR_SUBJ_ABORT > */
+    "Recherche abandonne",
+/* < KILL_DONE > */
+    "Returning to first unread article.",
+/* < UNKNOWN_KILL_TYPE > */
+    "Unknown kill type \"%s\" in \"%s\" kill request.", /* field type argument, field name */
+/* < ERROR_CANT_UPDATE_NEWSRC > */
+    "Impossible de mettre  jour le fichier newsrc",
+/* < ARTICLE_NUMBER > */ 
+    "Numro d'article :",
+/* < LIST_OLD_NUMBER > */ 
+    "First article to list:",
+/* < ERROR_SUBJ_EXPR > */
+    "Recherche de l'expression %s : pas de sujet appropri", /* regular expression */
+/* < ERROR_SEARCH > */ 
+    "Recherche de l'expression %s", /* regular expression */
+/* < REGULAR_EXPR > */
+    "Expression rgulire :",
+/* < BEHIND_WHAT_GROUP > */
+    "Aprs quel groupe de news?",
+/* < ARTICLE_QUEUED > */
+    "Article insr dans la file",
+/* < GROUP_SUB_TO > */
+    "Groupe auquel s'abonner :",
+/* < GROUP_TO_GO > */ 
+    "Groupe sur lequel aller :",
+/* < VIEW_ALLNG_SUB > */
+    "Visualiser tous les groupes disponibles, avec possibilit d'abonnement",
+/* < SUB_DONE > */
+    "You are now subscribed to `%s'.", /* newsgroup name */
+/* < AUTOMATIC_RESCAN > */
+   "Rafrachissement en cours...",
+/* < RESCANNING_BACKGROUND > */
+    "Rescanning in the background...",
+/* < ERROR_UNSUP_TRANS > */
+    "Transition impossible de %d  %d", /* transition from, to */
+/* < POST_FOLLOWUP > */
+    "article",
+/* < FOLLOWUP_REPLY > */ 
+    "article et courrier lectronique",
+/* < DEFAULT_MAIL > */
+    "courrier lectronique",
+/* < SAVE_IN > */
+    "Sauvegarde dans %s",  /* file */
+/* < ERROR_SEND_MAIL > */
+    "Error lors de l'expdition du courrier :",
+/* < ASK_FILE > */
+    "Nom du fichier?",
+/* < ASK_POST_ARTICLE > */
+    "Poster l'article?",
+/* < ASK_SEND > */
+    "Send the message?",
+/* < ASK_POST_SEND > */
+    "Post and send the message?",
+/* < RE_EDIT > */
+    "Re-edit",
+/* < AS_FOLLOWUP > */
+    "as followup",
+/* < AS_REPLY > */
+    "as reply",
+/* < AS_FOLLOWUP_REPLY > */
+   "as followup/reply",
+/* < ERROR_EXEC_FAILED > */
+    "Erreur XRN : l'excution de `%s' (execl) a chou\n", /* prog */
+/* < ASK_POSTER_FANDR > */
+    "La ligne `Followup-To' du message indique\nde rpondre directement  l'auteur.\nVoulez-vous l'ignorer, et poster,\nou simplement envoyer un courrier?",
+/* < ASK_POSTER_REPLY > */
+    "La ligne `Followup-To' du message indique\nde rpondre directement  l'auteur.\nVoulez-vous rpondre dans les news\nou envoyer une rponse par courrier?",
+/* < POST_AND_SEND > */
+    "poster et envoyer un courrier",
+/* < SEND_MAIL > */
+    "envoyer un courrier",
+/* < POST > */
+    "poster",
+/* < FOLLOWUP_MULTIPLE_NGS > */
+    "The default `Newsgroups' line of your followup contains multiple newsgroups.\n\tPlease be sure to remove inappropriate newsgroups before sending your message,\n\tand/or to put a more appropriate list of groups in your `Followup-To' line.",
+/* < FOLLOWUP_FOLLOWUPTO > */
+    "Note that the article to which you are responding contains a `Followup-To' line,\n\tso the default `Newsgroups' line of your followup has been set from that line\n\trather than from the `Newsgroups' line of the original article.",
+/* < CROSSPOST_PROHIBIT > */
+    "The `Newsgroups' line of your message contains %d newsgroups.\n\tThe maximum number of groups to which you are allowed to post a message is %d.\n\tPlease reduce the number of groups to which you are posting\n\tand then send your message again.",
+/* < CROSSPOST_CONFIRM > */
+    "The `Newsgroups' line of your message contains %d newsgroups.\n\tPlease consider reducing the number of groups to which you are posting.",
+/* < FOLLOWUP_FOLLOWUPTO_CONFIRM > */
+    "The `Newsgroups' line of your message contains %d newsgroups,\n\tand the `Followup-To' line contains %d newsgroups.\n\tPlease consider reducing the number of groups in your `Newsgroups' and/or `Followup-To' line.",
+/* < FOLLOWUP_CONFIRM > */
+    "The `Newsgroups' line of your message contains %d newsgroups.\n\tPlease consider either reducing the number of newsgroups to which you are posting\n\tor adding a `Followup-To' line containing a smaller number of groups.",
+/* < ERROR_STRIPFIELD_NL > */
+    "argh! je ne trouve pas de retour  la ligne dans stripField\n",
+/* < FOLLOWUP_REPLY_TO_TITLE > */
+    "Rpondre  l'article %ld de `%s' dans les news et par courrier", /* article number, newsgroup */
+/* < FOLLOWUP_TO_TITLE > */
+    "Rpondre  l'article %ld de `%s' dans les news", /* article number, newsgroup */
+/* < REPLY_TO_TITLE > */
+    "Rpondre  l'article %ld de `%s' par courrier", /* article number, newsgroup */
+/* < FORWARD_TO_TITLE > */
+    "Faire suivre l'article %ld de `%s'  un utilisateur", /* article number, newsgroup */
+/* < POST_ARTICLE > */
+    "Poster l'article",
+/* < POST_ARTICLE_TO > */
+    "Poster l'article dans `%s'", /* newsgroup */
+/* < POST_MAIL_ARTICLE > */
+    "Post and mail article",
+/* < POST_MAIL_ARTICLE_TO > */
+    "Post article to `%s' and mail it", /* newsgroup */
+/* < MAIL > */
+    "Send a mail message",
+/* < USER_CANT_CANCEL > */
+    "Vous n'avez pas le droit d'annuler l'article",
+/*
+ ### les messages ci-dessous ne devraient pas tre traduits ###
+ */
+/* < REPLY_YOU_WRITE > */
+    "In article %s,\n you write:\n", /* messageid */
+/* < FORWARDED_ARTIKEL > */
+    "\n------ Forwarded Article %s\n------ From %s\n\n", /* messageid , author */
+/* < FORWARDED_ARTICLE_END > */
+    "\n------ End of Forwarded Article\n",
+/* < FOLLOWUP_AUTHOR_WRITE > */
+    "In article %s,\n %s writes:\n", /* messageid , author */
+/* #### fin des messages  ne pas traduire #### */
+/* < NEWSGROUPS_INDEX > */
+    "%9s %13s %*s %4d article%1.1s +%5d ancien%1.1s",
+/* < UNREAD > */
+    "(non lus)",
+/* < NEWS_IN > */
+    "Messages dans",
+/* < NOT_ONE > */
+    "s", /* see NEWSGROUPS_INDEX in STRING section */
+/* < DONE > */
+    "termin",
+/* < ABORTED > */
+    "annul",
+/* < FAILED > */
+    "echou",
+/* < CREATE > */
+    "crer",
+/* < APPEND > */
+    "modifier",
+/* < ERR_XRN_RUN > */
+    "Un autre XRN vous appartenant existe sur %s (processus %d).\nS'il a disparu, supprimez le fichier \"%s\".\n", /* host, pid, lockfile */
+/* < ERROR_CANT_READ_NEWSRC > */
+    "Impossible de lire le fichier .newsrc",
+/* < PROCESS_KILL_FOR > */
+    "Excution du fichier de slection du groupe `%s'...", /* newsgroup */
+/* < ERROR_REGEX_NOSLASH > */
+    "pas de '/' pour terminer l'expression rguli`ere",
+/* < ERROR_REGEX_NOSLASH_START > */
+    "no slash preceding the regular expression",
+/* < ERROR_REGEX_NOCOLON > */
+    "pas de '.' aprs l'expression rgulire",
+/* < ERROR_REGEX_UNKNOWN_COMMAND > */
+    "commande inconnue (les commandes valides sont `j', `m', et `s')",
+/* < KILL_LINE > */
+    "Processing entry `%s' in KILL file `%s'.",
+/* < KILL_KILLED > */
+    "tu - %s",         /* subject */
+/* < KILL_UNREAD > */
+    "marqu non lu - %s",  /* subject */
+/* < KILL_SAVED > */
+    "sauv - %s",         /* subject */
+/* < COUNT_KILLED > */
+    "%d article%s tus dans %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+/* < COUNT_UNREAD > */
+    "%d article%s marqus non lus dans %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+/* < COUNT_SAVED > */
+    "%d article%s sauvs dans %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+/* < ERROR_CORNERED > */
+    "Erreur XRN dans `cornered' : nglist aurait d tre valide\n",
+/* < ERROR_OUT_OF_MEM > */
+    "plus de mmoire disponible",
+/* < PREFETCHING > */
+    "Lecture de `%s'...",
+/* < SERVER_POSTING_ERROR > */
+    "Erreur dans le serveur NNTP : %s", /* error message */
+/* < ASK_SAVEBOX > */
+    "NomFichier, +NomClasseur, ou @NomClasseur?",
+/* < SAVE_PIPE_TO > */
+    "Envoi de l'article %ld vers la commande `%s'...",  /* articlenumber, command */
+/* < ERROR_SAVE_PIPE > */
+    "`%s' a termin avec le status %d", /* command, status */
+/* < SAVE_MH_REFILE > */
+    "Archivage MH vers le dossier %s : %s", /* folder, status */
+/* < SAVE_RMAIL_REFILE > */
+    "Archivage RMAIL vers le dossier %s : %s", /* folder, status */
+/* < SAVE_OK > */
+    "Article %ld sauv dans le fichier `%s'...", /* articlenumber, filename */
+/* < SAVE_APPEND_OK > */
+    "Article %ld ajout au fichier `%s'...", /* articlenumber, filename */
+/* < SAVE_ARTICLE > */
+    "Article: %ld de %s\n", /* articlenumber, newsgroup */
+/* < ERROR_INFINITE_LOOP > */
+    "Panique dans XRN : boucle infinie entre moveBeginning & moveEnd",
+/* < ERROR_FINDARTICLE > */
+    "Numro d'article valable non trouv dans findArticle (cursor.c)",
+/* < ERROR_STRIP_LEAVE_HEADERS > */
+    "Use seule des ressource `stripHeaders' & `leaveHeaders' est autorise",
+/* < ERROR_REQUEST_FAILED > */
+    "        La requte tait : `%s'\n        La rponse en dfaut tait : `%s'", /* command, message */
+/* < ASK_FILE_MODIFIED > */
+    "%s file %s\nhas been modified; overwrite it?", /* file type, file name */
+/* < PENDING_COMPOSITION > */
+    "You cannot exit when a composition is pending!",
+/* < NNTP_PASSWORD > */
+    "Enter NNTP password:",
+/* < UNKNOWN_SORT_TYPE > */
+    "Unknown subject sort type: %s", /* type */
+/* < TOO_MANY_SORT_TYPES > */
+    "Too many subject sort types specified.",
+/* < UNPARSEABLE_DATE > */
+    "Unparseable date (article %ld in %s):\n\t%s", /* number, newsgroup, string */
+/* < THREADING_FOR > */
+    "Threading newsgroup `%s'...", /* newsgroup */
+/* < FILE_CACHE_OPEN > */
+    "Error opening cache file in %s:\n\t%s", /* directory, error string */
+/* < MESG_PANE_DISMISS > */
+    "This window can be left open or dismissed.\n\tIf dismissed, it will reappear whenever there are new messages.",
+/* < BAD_FROM > */
+    "Bad `From' address `%s'.\n\tPlease fix it and resend, or abort your message.",
+/* < NO_BODY > */
+    "Your message has no body, or the blank line after the header is missing.\n\tPlease fix this and resend, or abort your message.",
+/* < ONLY_INCLUDED > */
+    "Message appears to contain only\nincluded text.  Post anyway?",
+/* < COURTESY_COPY > */
+    "[This is a courtesy copy of a message which was also posted to the\n newsgroup(s) shown in the header.]",
+};
+
+#endif /* XRN_LANG_french */
+
 #ifdef XRN_LANG_german
 
 /*
@@ -705,7 +1306,7 @@
  * --------------
  * The German section was created and translated by K.Marquardt
  * (K.Marquardt@zhv.basf-ag.de).  Some revisions were provided by
- * T.Foks (foks@hub.de).
+ * T.Foks (foks@hub.de) and G.Niklasch (nikl@mathematik.tu-muenchen.de).
  *
  * german version (iso8859-1), use LANGUAGE= german in Imakefile/Makefile
  *
@@ -718,19 +1319,19 @@
 
 char *message_strings[] = {
 /* < BAD_BUTTON_NAME > */
-    "XRN Fehler: Falscher Knopf Name `%s'.", /* button Name */
+    "XRN Fehler: Falscher Knopf-Name `%s'.", /* button Name */
 /* < NO_SUCH_NG_DELETED > */
-    "Newsgruppe `%s' existiert nicht, m\366glicherweise wurde sie gel\366scht.", /* Newsgruppe Name */
+    "Newsgruppe `%s' existiert nicht.\n\tM\366glicherweise wurde sie entfernt.", /* Newsgruppe Name */
 /* < UNKNOWN_FUNC_RESPONSE > */
     "Interner XRN Fehler: unbekannte R\374ckmeldung %d von %s in %s.", /* return value, called function, calling function */
 /* < DISPLAYING_LAST_UNREAD > */
-    "Keine ungelesenen Artikel in `%s'. Zeige letzten vorhandenen Artikel an.", /* Newsgruppe Name */
+    "Keine ungelesenen Artikel in `%s'.\n\tZeige letzten vorhandenen Artikel an.", /* Newsgruppe Name */
 /* < PROBABLY_KILLED > */
-    "Keine ungelesenen Artikel in `%s', m\366glicherweise wurden sie gel\366scht.", /* Newsgruppe Name */
+    "Keine ungelesenen Artikel in `%s'.\n\tWahrscheinlich wurden sie ausgeblendet.", /* Newsgruppe Name */
 /* < NO_ARTICLES > */
     "Keine Artikel in `%s'.", /* Newsgruppe Name */
 /* < PROBABLY_EXPIRED > */
-    "Keine Artikel in `%s', m\366glicherweise wurden sie zur\374ckgezogen.", /* Newsgruppe Name */
+    "Keine Artikel in `%s'.\n\tSie sind wohl veraltet oder wurden zur\374ckgezogen.", /* Newsgruppe Name */
 /* < NO_NG_SPECIFIED > */
     "Keine Newsgruppe angegeben.",
 /* < NO_SUCH_NG > */
@@ -740,9 +1341,9 @@
 /* < NO_GROUPS_SELECTED > */
     "Keine Newsgruppen ausgew\344hlt.",
 /* < NG_NOT_MOVED > */
-    "Die neue Position kann nicht innerhalb der angew\344hlten Newsgruppen liegen.  Es wurden keine Newsgruppen verschoben.",
+    "Die neue Position kann nicht innerhalb\n\tder vorgemerkten Newsgruppen liegen.\n\tEs wurden keine Newsgruppen verschoben.",
 /* < SKIPPING_TO_NEXT_NG > */
-    "Verzweige zur n\344chsten Newsgruppe.",
+    "Zur n\344chsten Newsgruppe gesprungen.",
 /* < BAD_ART_NUM > */
     "Falsche Artikelnummer `%s'.", /* Artikel.number string */
 /* < NO_ART_NUM > */
@@ -756,371 +1357,377 @@
 /* < NO_PREV_ART > */
     "Kein vorheriger Artikel.",
 /* < MSG_ABORTED > */
-    "Abbruch: %s.", /* "article" or "message" */
+    "%s abgebrochen.", /* "Artikel" oder "E-Mail-Nachricht" */
 /* < NO_FILE_NOT_SAVED > */
-    "Kann den Dateinamen nicht ermitteln, Artikel/Nachricht nicht gespeichert.",
+    "Kann den Dateinamen nicht ermitteln.\n\tArtikel/Nachricht nicht gespeichert.",
 /* < NO_SUBJECT > */
-    "Ihre Nachricht enth\344lt kein Thema!",
+    "Ihr Artikel enth\344lt keine `Subject'-Zeile!\n\t",
 /* < EMPTY_SUBJECT > */
-    "Die `Subject` Zeile Ihrer Nachricht ist leer!",
+    "Die `Subject'-Zeile Ihres Artikels ist leer!\n\t",
 /* < NO_NEWSGROUPS > */
-    "Ihre Nachricht enth\344lt keine `Newsgroups` Zeile!",
+    "Ihr Artikel enth\344lt keine `Newsgroups'-Zeile!\n\t",
 /* < MULTI > */
-    "Sie haben mehrere %s Zeilen in Ihrer Nachricht!  Bitte alle, bis auf eine, entfernen und erneut abschicken.", /* field name */
+    "Sie haben mehrere `%s'-Zeilen in Ihrem Artikel!\n\tBitte alle bis auf eine entfernen\n\tund erneut abschicken.", /* field name */
 /* < DEFAULT_ADDED > */
-    "Es wurde ein Standardwert eingef\374gt, bitte passen Sie ihn entsprechend an.",
+    "Ein voreingestellter Wert wurde eingef\374gt.\n\tBitte passen Sie ihn entsprechend an,\n\tdann erneut abschicken.",
 /* < EMPTY_ADDED > */
-    "Es wurde ein leeres Feld eingef\374gt.",
+    "Es wurde ein leeres Feld eingef\374gt.\n\t",
 /* < FILL_IN_RESEND > */
-    "Bitte Ausf\374llen und erneut abschicken.",
+    "Bitte ausf\374llen und erneut abschicken.",
 /* < NO_POSTABLE_NG > */
-    "Sie k\366nnen in keine der angegebenen Newsgruppen ver\366ffentlichen.  Bitte `Newsgroups` Zeile ab\344ndern und erneut abschicken.",
+    "Keine der angegebenen Newsgruppen existiert und akzeptiert Artikel.\n\tBitte `Newsgroups'-Zeile ab\344ndern\n\tund erneut abschicken (oder sichern und abbrechen).",
 /* < SAVING_DEAD > */
-    "Speichere in `%s'.", /* file Name */
+    "Abgespeichert in `%s'.", /* file Name */
 /* < COULDNT_POST > */
-    "Kann Artikel nicht ver\366ffentlichen.",
+    "Artikel konnte nicht eingespeist werden.",
 /* < POST_NOTALLOWED > */
-    "Von diesem Rechner k\366nnen keine Artikel ver\366ffentlicht werden.",
+    "Von diesem Rechner aus d\374rfen\n\tkeine Artikel ver\366ffentlicht werden.",
 /* < COULDNT_SEND > */
-    "Konnte Nachricht nicht senden.",
+    "Konnte E-Mail-Nachricht nicht senden.",
 /* < MAILED_TO_MODERATOR > */
-    "Es wurden eine oder mehrere moderierte Newsgruppen angegeben. Der Artikel wird vom Server zum Moderator geschickt.",
+    "Es wurden eine oder mehrere moderierte Newsgruppen angegeben.\n\tDer Artikel wird vom Server per E-Mail zum Moderator geschickt.",
 /* < ARTICLE_POSTED > */
-    "Artikel ver\366ffentlicht.",
+    "Artikel eingespeist.",
 /* < MAIL_MESSAGE_SENT > */
-    "Nachricht verschickt.",
+    "E-Mail-Nachricht verschickt.",
 /* < CANT_INCLUDE_CMD > */
-    "Kann includeCommand nicht ausf\374hren, `popen' fehlgeschlagen.",
+    "Konnte includeCommand nicht ausf\374hren, `popen()' fehlgeschlagen.",
 /* < CANT_OPEN_ART > */
-    "Kann Artikeldatei `%s' nicht \366ffnen: %s.", /* file name, Fehler string */
+    "Kann Artikeldatei `%s'\n\tnicht \366ffnen: %s.", /* file name, Fehler string */
 /* < CANT_OPEN_FILE > */
-    "Kann Datei `%s' nicht \366ffnen: %s.", /* Fehler string */
+    "Kann Datei `%s'\n\tnicht \366ffnen: %s.", /* Fehler string */
 /* < NO_FILE_SPECIFIED > */
     "Keine Datei angegeben.",
 /* < CANT_OPEN_TEMP > */
-    "Kann Datei `%s' nicht \366ffnen: %s.", /* file name, Fehler string */
+    "Kann tempor\344re Datei `%s'\n\tnicht \366ffnen: %s.", /* file name, Fehler string */
 /* < CANT_STAT_TEMP > */
-    "Kann den Status der Datei `%s' nicht ermitteln: %s.", /* file name, Fehler string */
+    "Kann den Status der tempor\344ren Datei `%s'\n\tnicht ermitteln: %s.", /* file name, Fehler string */
 /* < NO_CHANGE > */
-    "Keine Ver\344nderung der Datei `%s'.", /* file Name */
+    "Keine Ver\344nderung der tempor\344ren Datei `%s'.", /* file Name */
 /* < ZERO_SIZE > */
-    "Datei `%s' ist leer.", /* file Name */
+    "Die tempor\344re Datei `%s'\n\tist leer.", /* file Name */
 /* < NO_MSG_TEMPLATE > */
-    "Interner XRN Fehler: Keine Nachrichtenvorlage beim Aufruf des Editors.",
+    "Interner XRN Fehler: Kein Artikelschema beim Aufruf des Editors.",
 /* < CANT_EDITOR_CMD > */
-    "Kann Editorbefehl `%s'nicht ausf\374hren: %s.", /* command, Fehler string */
+    "Kann Editorbefehl `%s'\n\t nicht ausf\374hren: %s.", /* command, Fehler string */
 /* < ONE_COMPOSITION_ONLY > */
-    "Verfassen nur eines Artikels gleichzeitig m\366glich.",
+    "Es kann nur ein Artikel auf einmal geschrieben werden.",
 /* < EXECUTING_SIGNATURE > */
-    "F\374hre Signaturbefehl `%s' aus.", /* command */
+    "Signaturbefehl `%s' wird ausgef\374hrt.", /* command */
 /* < CANT_EXECUTE_SIGNATURE > */
-    "Kann Signaturdatei `%s' nicht ausf\374hren, lese sie ein.", /* signature file Name */
+    "Kann Signaturdatei `%s' nicht ausf\374hren\n\t.Lese sie stattdessen ein.", /* signature file Name */
 /* < READING_SIGNATURE > */
-    "Lese Signaturdatei `%s' ein.", /* signature file Name */
+    "Signaturdatei `%s' wird eingelesen.", /* signature file Name */
 /* < CANT_READ_SIGNATURE > */
-    "Kann Signaturdatei nicht `%s' lesen: %s.", /* signature file name, Fehler string */
+    "Kann Signaturdatei `%s'\n\tnicht lesen: %s.", /* signature file name, Fehler string */
 /* < SIGNATURE_TOO_BIG > */
-    "Signaturdatei `%s' ist zu gro\337; wird ignoriert.", /* signature file name */
+    "Signaturdatei `%s'\n\tist zu gro\337; wird ignoriert.", /* signature file name */
 /* < CANCEL_ABORTED > */
     "Artikel nicht zur\374ckgezogen.",
 /* < CANCELLED_ART > */
     "Artikel zur\374ckgezogen.",
 /* < CANCEL_TO_MODERATOR > */
-    "Message being canceled appears in one or more moderated newsgroups.  Cancel request will be mailed to moderator by server.",
+    "Der zur\374ckzuziehende Artikel erscheint\n\tin einer oder mehreren moderierten Newsgruppen.\n\tDie R\374ckzugswunsch wird durch den Server\n\tan die Moderatoren geschickt.",
 /* < UNKNOWN_REGEXP_ERROR > */
     "Unbekannter Fehler im Suchmuster `%s'.", /* regexp string */
 /* < KNOWN_REGEXP_ERROR > */
-    "Fehler im Suchmuster `%s': %s.", /* regexp, Fehler string */
+    "Fehler im Suchmuster `%s':\n\t%s.", /* regexp, Fehler string */
 /* < ART_NUMBERING_PROBLEM > */
-    "Probleme mit den Artikelnummern, markiere alle Artikel in `%s' als nicht gelesen.", /* Newsgruppe Name */
+    "Probleme mit den Artikelnummern.\n\tAlle Artikel in `%s' als nicht gelesen markiert.", /* Newsgruppe Name */
 /* < CANT_OPEN_KILL > */
-    "Kann KILL-Datei (`%s') nicht \366ffnen: %s.", /* file name, error string */
+    "Kann KILL-Datei `%s'\n\tnicht \366ffnen: %s.", /* file name, error string */
 /* < CANT_OPEN_INCLUDED_KILL > */
-    "Kann KILL-Datei (`%s') nicht \366ffnen (included from `%s'): %s.", /* file name, parent file name, error string */
+    "Kann KILL-Datei `%s'\n\tnicht \366ffnen (include von `%s' aus):\n\t%s.", /* file name, parent file name, error string */
 /* < MALFORMED_KILL_ENTRY > */
-    "Fehler in KILL-Datei Eintrag `%s' in KILL-Datei `%s': %s.", /* entry, file, reason for error */
+    "Fehler in Eintrag `%s'\n\tin KILL-Datei `%s':\n\t%s.", /* entry, file, reason for error */
 /* < ERROR_INCLUDE_MISSING > */
-    "Keine Newsgruppe oder Dateiname in include-Direktive angegeben",
+    "Weder Newsgruppe noch Dateiname in include-Direktive angegeben",
 /* < ERROR_INCLUDE_NOT_SEPARATED > */
-   " Include Operand nicht separat",
+    "Include-Operand nicht abgetrennt",
 /* < KILL_ERROR_UNKNOWN_OPTION > */
-    "Fehler in KILL-Datei Eintrag `%s' in KILL-Datei `%s': Unbekannte Option `%c'.", /* entry, file, unknown option */
+    "Fehler in Eintrag `%s'\n\tin KILL-Datei `%s':\n\tUnbekannte Option `%c'.", /* entry, file, unknown option */
 /* < UNKNOWN_KILL_REGEXP_ERROR > */
-    "Fehler: Unbekannter Regul\344rer Ausdruck in KILL-Datei Eintrag `%s' in KILL-Datei `%s'.", /* entry */
+    "Unbekannter Fehler in Regul\344rem Ausdruck in Eintrag `%s'\n\tin KILL-Datei `%s'.", /* entry */
 /* < KNOWN_KILL_REGEXP_ERROR > */
-    "Fehler: Regul\344rer Ausdruck in KILL-Datei Eintrag `%s' in KILL-Datei `%s': %s.", /* entry, error string */
+    "Fehler in Regul\344rem Ausdruck in Eintrag `%s' in KILL-Datei `%s': %s.", /* entry, error string */
 /* < KILL_TOO_LONG > */
-    "Verwerfe zu langen Eintrag beginnend mit `%s' in KILL-Datei `%s'.", /* start of entry, file */
+    "\334berlanger Eintrag beginnend mit `%s'\n\tin KILL-Datei `%s' wurde verworfen.", /* start of entry, file */
 /* < NOT_IN_NEWSRC > */
-    "Newsgruppe `%s' ist nicht in der Datei .newsrc.", /* Newsgruppe Name */
+    "Newsgruppe `%s' kommt nicht in der Datei .newsrc vor.", /* Newsgruppe Name */
 /* < BOGUS_NG_REMOVING > */
-    "Newsgruppe `%s' existiert nicht, entferne sie aus der Datei .newsrc.", /* Newsgruppe Name */
+    "Newsgruppe `%s' existiert nicht.\n\tSie wird aus der Datei .newsrc entfernt.", /* Newsgruppe Name */
 /* < MISSING_NG_LISTING > */
-    "Newsgruppe `%s' nicht im Cache gefunden. Hole Newsgruppen-Liste um sie zu finden.", /* newsgroup name */
+    "Newsgruppe `%s' nicht im Cache gefunden.\n\tNewsgruppen-Liste wird geholt, um sie zu finden.", /* newsgroup name */
 /* < MAYBE_LIST > */
     "Newsgruppe `%s' nicht im Cache gefunden.\nNewsgruppen-Liste holen, um sie zu finden?", /* newsgroup name */
 /* < DUP_NEWSRC_ENTRY > */
-    "Doppelter Eintrag in der Datei .newsrc f\374r `%s', verwende den ersten.", /* newsgroup name */
+    "Mehrfacher Eintrag in der Datei .newsrc f\374r `%s'.\n\tVerwendet wird der erste.", /* newsgroup name */
 /* < BAD_NEWSRC_LINE > */
-    "Kann Zeile %d in der Datei .newsrc nicht interpretieren, \374bergehe sie.", /* line number */
+    "Kann Zeile %d in der Datei .newsrc nicht interpretieren.\n\t\334bergehe sie.", /* line number */
 /* < CANT_OPEN_NEWSRC_COPYING > */
-    "Kann Datei .newsrc `%s' nicht kopieren: %s.", /* file name, Fehler string */
+    "Kann .newsrc-Datei `%s'\n\tnicht kopieren: %s.", /* file name, Fehler string */
 /* < CANT_EXPAND > */
-    "Kann Dateinamen `%s' nicht erweitern.", /* file name */
+    "Kann Dateinamen `%s'\n\tnicht expandieren.", /* file name */
 /* < EMPTY_NEWSRC_SAVE_NAME > */
     "Dateiname zum Abspeichern der Datei .newsrc ist leer.",
 /* < CANT_OPEN_NEWSRC_SAVE > */
-    "Kann .newsrc-Datei `%s' nicht schreiben: %s.", /* file name, Fehler string */
+    "Kann .newsrc-Datei `%s'\n\tnicht schreiben: %s.", /* file name, Fehler string */
 /* < NEWSRC_SAVE_FILE_WRITE_ERR > */
-    "Fehler beim Schreiben in .newsrc-Datei `%s': %s.", /* file name, Fehler string */
+    "Fehler beim Schreiben in .newsrc-Datei `%s':\n\t%s.", /* file name, Fehler string */
 /* < CANT_READ_NEWSRC > */
-    "Kann .newsrc-Datei `%s' nicht lesen: %s.", /* file Name, error string */
+    "Kann .newsrc-Datei `%s'\n\tnicht lesen: %s.", /* file Name, error string */
 /* < CREATING_NEWSRC > */
     "Erzeuge .newsrc-Datei `%s'.", /* file Name */
 /* < CANT_CREATE_NEWSRC > */
-    "Kann .newsrc-Datei `%s' nicht erstellen: %s.", /* file name, Fehler string */
+    "Kann .newsrc-Datei `%s'\n\tnicht erstellen: %s.", /* file name, Fehler string */
 /* < CANT_STAT_NEWSRC > */
-    "Kann Status der .newsrc-Datei `%s' nicht ermitteln: %s.", /* file name, Fehler string */
+    "Kann Status der .newsrc-Datei `%s'\n\tnicht ermitteln: %s.", /* file name, Fehler string */
 /* < ZERO_LENGTH_NEWSRC > */
-    ".newsrc-Datei `%s' ist leer, gebe auf.", /* file Name */
+    ".newsrc-Datei `%s'\n\tist leer, ich gebe auf.", /* file Name */
 /* < CANT_OPEN_NEWSRC > */
-    "Kann .newsrc-Datei `%s' nicht lesen: %s.", /* file name, Fehler string */
+    "Kann .newsrc-Datei `%s'\n\tnicht lesen: %s.", /* file name, Fehler string */
 /* < CANT_PARSE_NEWSRC > */
-    "Kann .newsrc-Datei `%s' nicht interpretieren -- Fehler in Zeile %d.", /* file name, error line */
+    "Kann .newsrc-Datei `%s'\n\tnicht interpretieren -- Fehler in Zeile %d.", /* file name, error line */
 /* < CANT_OPEN_NEWSRC_TEMP > */
-    "Kann .newsrc-Datei `%s' nicht schreiben: %s.", /* file name, Fehler string */
+    "Kann tempor\344re .newsrc-Datei `%s'\n\tnicht schreiben: %s.", /* file name, Fehler string */
 /* < CANT_OPEN_NEWSRC_WRITING > */
-    "Kann .newsrc-Datei `%s' nicht schreiben: %s.", /* file name, Fehler string */ 
+    "Kann .newsrc-Datei `%s'\n\tnicht schreiben: %s.", /* file name, Fehler string */ 
 /* < ERROR_UNLINKING_NEWSRC > */
-    "Fehler beim Entfernen des Links der .newsrc-Datei `%s': %s.", /* file name, Fehler string */
+    "Fehler beim Entfernen der .newsrc-Datei `%s':\n\t%s.", /* file name, Fehler string */
 /* < ERROR_RENAMING > */
-    "Fehler beim Umbenennen der Datei `%s' in `%s': %s.", /* temporary file name, file name, Fehler string */
+    "Fehler beim Umbenennen der Datei `%s'\n\tin `%s':\n\t%s.", /* temporary file name, file name, Fehler string */
 /* < NO_MAIL_DIR > */
-    "Kein Postverzeichnis `%s'.", /* directory Name */
+    "Kein E-Mail-Verzeichnis `%s'.", /* directory Name */
 /* < NO_SUCH_MAIL_DIR > */
-    "Kein Postverzeichnis `%s';  Verzeichnis anlegen?", /* directory name */
+    "Kein E-Mail-Verzeichnis `%s';\nVerzeichnis anlegen?", /* directory name */
 /* < CANT_STAT_MAIL_DIR > */
-    "Kann Status der Verzeichnisses `%s' nicht ermitteln: %s.", /* directory name, error string */
+    "Kann Status des Verzeichnisses `%s'\n\tnicht ermitteln: %s.", /* directory name, error string */
 /* < MAIL_DIR_NOT_DIR > */
-    "Kann Verzeichnis nicht anlegen -- Postpfad `%s' ist kein Verzeichnis.", /* directory Name */
+    "Kann E-Mail-Verzeichnis nicht anlegen --\n\tPfad `%s' ist kein Verzeichnis.", /* directory Name */
 /* < FOLDER_NOT_DIR > */
-    "Pfad `%s' ist kein Verzeichnis.", /* folder Name */
+    "Pfad `%s' ist kein Ordner.", /* folder Name */
 /* < NO_SUCH_RMAIL > */
-    "Keine RMAIL-Datei `%s';  Datei anlegen?", /* file name */
+    "RMAIL-Datei `%s' existiert nicht.\nDatei anlegen?", /* file name */
 /* < CANT_OPEN_RMAIL > */
-    "Kann RMAIL-Datei `%s' nicht \366ffnen: %s.", /* file name, Fehler string */
+    "Kann RMAIL-Datei `%s'\n\tnicht \366ffnen: %s.", /* file name, Fehler string */
 /* < CANT_WRITE_RMAIL > */
-    "Kann nicht in die RMAIL-Datei `%s' schreiben: %s.", /* file name, Fehler string */
+    "Kann nicht in die RMAIL-Datei `%s'\n\tschreiben: %s.", /* file name, Fehler string */
 /* < UNKNOWN_CONFIRM_BUTTON > */
     "XRN Fehler: unbekannter Best\344tigungsknopf `%s'.", /* button Name */
 /* < CANT_EXECUTE_CMD_POPEN > */
-    "Konnte Befehl `%s' nicht ausf\374hren, `popen' fehlgeschlagen.", /* command string */
+    "Konnte Befehl `%s'\n\tnicht ausf\374hren, `popen()' fehlgeschlagen.", /* command string */
 /* < CANT_EXPAND_DIR > */
-    "Kann Verzeichnisname `%s' nicht erweitern.", /* directory name */
+    "Kann Verzeichnisname `%s' nicht expandieren.", /* directory name */
 /* < CANT_CREATE_SAVE_DIR > */
-    "Kann Verzeichnis `%s' nicht anlegen: %s.", /* drectory name, Fehler string */
+    "Kann Sicherungs-Verzeichnis `%s'\n\tnicht anlegen: %s.", /* drectory name, Fehler string */
 /* < CANT_FIGURE_FILE_NAME > */
-    "Kann Dateinamen `%s' nicht ermitteln.", /* file name */  
+    "Kann mit Dateiname `%s'\n\tnichts anfangen.", /* file name */
 /* < CANT_CREAT_APPEND_SAVE_FILE > */
-    "%s Datei `%s' nicht ausf\374hrbar: %s.", /* "create" or "append to", file name, Fehler string */
+    "%s Datei `%s'\n\tfehlgeschlagen: %s.", /* "create" or "append to", file name, Fehler string */
 /* < ERROR_WRITING_FILE > */
 /* < ERROR_WRITING_SAVE_FILE > */
-    "Fehler beim Schreiben in Datei `%s': %s.", /* file name, Fehler string */
+    "Fehler beim Schreiben in Datei `%s':\n\t%s.", /* file name, Fehler string */
 /* < CONNECTING > */
-    "Verbindungsaufbau zum NNTP Server `%s'...", /* server name */
+    "Verbindungsaufbau zum NNTP-Server `%s'...", /* server name */
 /* < GETTING_LIST > */
-    "Lese die Liste der Newsgruppen...",
+    "Liste der Newsgruppen wird geholt...",
 /* < GETTING_NEWGROUPS > */
-    "Lese die Liste der neuen Newsgruppen...",
+    "Liste der neuen Newsgruppen wird geholt...",
 /* < FAILED_CONNECT > */
-    "Verbindungsaufbau zum NNTP Server `%s' fehlgeschlagen .", /* server name */
+    "Verbindungsaufbau zum NNTP-Server `%s' fehlgeschlagen.", /* server name */
 /* < LOST_CONNECT_ATTEMPT_RE > */
-    "Verbindung zum NNTP Server abgebrochen, versuche neuen Verbindungsaufbau.",
+    "Verbindung zum NNTP-Server unterbrochen.\n\tVersuche neuen Verbindungsaufbau.",
 /* < RECONNECTED > */
-    "Verbindung zum NNTP Server wieder hergestellt.",
+    "Verbindung zum NNTP-Server wieder hergestellt.",
 /* < CANT_TEMP_NAME > */
     "Kann keinen tempor\344ren Dateinamen f\374r Artikel erzeugen.",
 /* < CANT_CREATE_TEMP > */
-    "Kann kann tempor\344re Datei `%s' nicht schreiben: %s.", /* file name, Fehler string */
+    "Kann tempor\344re Datei `%s'\n\tnicht schreiben: %s.", /* file name, Fehler string */
 /* < BOGUS_ACTIVE_ENTRY > */
-    "\334bergehe fehlerhaften Eintrag `%s' der active-Datei.", /* entry */
+    "Fehlerhaften Eintrag `%s'\n\tder active-Datei \374bergangen.", /* entry */
 /* < BOGUS_ACTIVE_CACHE > */
-    "\334bergehe fehlerhaften Eintrag `%s' im Cache.", /* entry */
+    "Fehlerhaften Eintrag `%s'\n\tim Cache \374bergangen.", /* entry */
 /* < XHDR_ERROR > */
-    "XHDR Befehl beim NNTP Server fehlgeschlagen.\nEntweder unterst\374tzt der NNTP Server den XHDR Befehl nicht oder es ist ein interner Fehler in XRN aufgetreten.",
+    "XHDR Befehl beim NNTP-Server fehlgeschlagen.\n\tEntweder unterst\374tzt der NNTP-Server den XHDR Befehl nicht\n\t(dann funktioniert XRN nicht),\n\toder es ist ein interner Fehler in XRN aufgetreten.",
 /* < NNTP_ERROR > */
-    "NNTP Fehler: `%s'.", /* Fehler string */
+    "NNTP-Fehler: `%s'.", /* Fehler string */
 /* < MALFORMED_XHDR_RESPONSE > */
-    "NNTP Server sendete nicht erwartete XHDR Antwort.\nXHDR Befehl: `%s', Antwort `%s'.", /* command, response */
+    "NNTP-Server sendete nicht die erwartete XHDR-Antwort.\n\tXHDR-Befehl: `%s',\n\tAntwort `%s'.", /* command, response */
 /* < NO_APP_DEFAULTS > */
-    "Die XRN Application-Defaults-Datei ist nicht vorhanden. Es ist m\366glich das einige XRN Funktionen nicht gehen. Falls XRN von jemand anderem installiert wurde, teilen Sie ihm bitte diesen Fehler mit. Wenn Sie XRN installiert haben, lesen Sie bitte die Datei COMMON-PROBLEMS im XRN Quellcode Verzeichnis, dort steht wie Sie das Problem beheben k\366nnen.",
+    "Die XRN-Application-Defaults-Datei ist nicht vorhanden.\n\tEs ist m\366glich, dass einige XRN-Funktionen nicht verf\374gbar sind.\n\tFalls XRN von jemand anderem installiert wurde,\n\tteilen Sie ihm bitte diesen Fehler mit.\n\tWenn Sie XRN installiert haben, lesen Sie bitte die Datei\n\tCOMMON-PROBLEMS im XRN-Quellcode-Verzeichnis;\n\tdort steht, wie Sie das Problem beheben k\366nnen.\n\t",
 /* < VERSIONS > */
-    "Application Defaults Version ist `%s',  XRN Version ist `%s'.", /* app-defaults version, executable version */
+    "Die Version der Application-Defaults-Datei ist `%s'.\n\tDie XRN-Version ist `%s'.", /* app-defaults version, executable version */
 /* < NO_DOMAIN > */
-    "Kann die Domain des Rechners nicht ermitteln, verwende die Environmentvariable DOMAIN oder die Resource domainName zum Versenden von Artikeln und Post.",
+    "Kann die Domain Ihres Rechners nicht ermitteln.\n\tSetzen Sie die Environmentvariable DOMAIN\n\toder die X-Ressource domainName\n\tzum Versenden von Artikeln und E-Mail,\n\tund starten Sie XRN erneut.",
 /* < NO_SERVER > */
-    "Kann den NNTP Server nicht ermitteln, verwende die Environmentvariable NNTPSERVER, die Resource nntpServer oder die Option -nntpServer.",
+    "Kann den NNTP-Server nicht ermitteln.\nSetzen Sie die Environmentvariable NNTPSERVER\noder die X-Ressource nntpServer,\noder \374bergeben Sie beim Neustart von XRN\ndie Option -nntpServer.",
 /* < UNKNOWN_LIST_REGEXP_ERROR > */
-    "Unbekannter Suchmusterfehler in %s im Listeneintrag `%s'; ignoriere Eintrag.", /* list name, entry */
+    "Unbekannter Suchmusterfehler in %s\n\tim Listeneintrag `%s';\n\tEintrag wird ignoriert.", /* list name, entry */
 /* < KNOWN_LIST_REGEXP_ERROR > */
-    "Suchmusterfehler in %s im Listeneintrag `%s': %s; ignoriere Eintrag.", /* list name, entry, error string */
+    "Suchmusterfehler in %s\n\tim Listeneintrag `%s': %s;\n\tEintrag wird ignoriert.", /* list name, entry, error string */
 /* < OPEARATION_APPLY_CURSOR > */
-   "Operationen sind abh\344nging von der aktuellen Auswahl und der Position des Zeigers",
+    "Aktionen richten sich nach der aktuellen Auswahl und der Position des Mauszeigers",
 /* < NO_MORE_UNREAD_ART > */
-   "Keine weiteren ungelesenen Artikel in den abonnierten Newsgruppen.",
+    "Keine weiteren ungelesenen Artikel in den abonnierten Newsgruppen.",
 /* < SEL_GROUPS_ADDSUB > */
-   "Zum Abonnieren Newsgruppen ausw\344hlen, verbleibende werden als `nicht abonniert' gekennzeichnet.",
+    "Zum Abonnieren Newsgruppen ausw\344hlen, verbleibende werden als `nicht abonniert' gekennzeichnet.",
 /* < ARE_YOU_SURE > */
-   "Sind Sie sicher?",
+    "Sind Sie sicher?",
 /* SUBED, UNSUBED and IGNORED strings must have the same len */
-/* < SUBED >  */ 
-   "abonniert      ",
+/* < SUBED > */ 
+    "abonniert      ",
 /* < UNSUBED > */
-   "nicht abonniert",
+    "nicht abonniert",
 /* < IGNORED > */
-   "ignoriert      ",
+    "ignoriert      ",
 /* < OK_CATCHUP > */
-   "Als gelesen markieren?",
+    "Als gelesen markieren?",
 /* < OK_CATCHUP_CUR > */ 
-   "Bis zur aktuellen Position als gelesen markieren?",
+    "Bis zur aktuellen Position als gelesen markieren?",
 /* < OK_GETLIST > */
-    "Newsgruppen Liste vom Server holen?",
+    "Newsgruppen-Liste vom Server holen?",
 /* < OK_TO_UNSUB > */
-   "Abonnement aufheben?",
+    "Newsgruppe abbestellen?",
 /* < OK > */
     "OK",
 /* < EDIT > */
-    "Editieren",
+    "Editor",
 /* < SEARCH_ABORTED > */
-   "Suche wurde abgebrochen.",
+    "Suche wurde abgebrochen.",
 /* < ERROR_SUBJ_SEARCH > */ 
-   "Thema suchen: %s", /* regular expression */
+    "Thema suchen: %s", /* regular expression */
 /* < ERROR_SUBJ_EXH > */ 
-   "Thema nicht vorhanden.",
+    "Thema nicht (mehr) gefunden.",
 /* < ERROR_NO_PARENT > */
-    "Article has no parent.",
+    "Artikel hat keinen Vorg\344nger.",
 /* < ERROR_PARENT_UNAVAIL > */
-    "Article's parent is unavailable.",
+    "Vorg\344nger des Artikels nicht verf\374gbar.",
 /* < ERROR_SUBJ_ABORT > */
-   "Suche abgebrochen.",
+    "Suche abgebrochen.",
 /* < KILL_DONE > */
-   "Gehe zum ersten ungelesenen Artikel.",
+    "Zur\374ck zum ersten ungelesenen Artikel.",
 /* < UNKNOWN_KILL_TYPE > */
-    "Unknown kill type \"%s\" in \"%s\" kill request.", /* field type argument, field name */
+    "Unbekannter Typ \"%s\" in \"%s\"-KILL-Befehl.", /* field type argument, field name */
 /* < ERROR_CANT_UPDATE_NEWSRC > */
-   "Kann die Datei .newsrc nicht aktualisieren.",
+    "Kann die Datei .newsrc nicht aktualisieren.",
 /* < ARTICLE_NUMBER > */ 
-   "Artikel Nummer:",
+    "Artikel Nummer:",
 /* < LIST_OLD_NUMBER > */ 
-   "First article to list:",
+    "Erster anzuzeigender Artikel:",
 /* < ERROR_SUBJ_EXPR > */
-   "Suche nach %s: Keine Eintr\344ge gefunden.", /* regular expression */
+    "Suche nach %s: Keine Eintr\344ge gefunden.", /* regular expression */
 /* < ERROR_SEARCH > */ 
-   "Suche nach %s", /* regular expression */
+    "Suche nach %s", /* regular expression */
 /* < REGULAR_EXPR > */
-   "Suchmuster:",
+    "Suchmuster:",
 /* < BEHIND_WHAT_GROUP > */
-   "Nach welcher Newsgrupppe?",
+    "Nach welcher Newsgrupppe?",
 /* < ARTICLE_QUEUED > */
-   "Artikel nacheinander versand.",
+    "Artikel wurde zum Versand \374bergeben.",
 /* < GROUP_SUB_TO > */
-   "Zu abonnierende Gruppe:",
+    "Zu abonnierende Gruppe:",
 /* < GROUP_TO_GO > */ 
-   "Gehen zur Gruppe:",
+    "Gehe zur Gruppe:",
 /* < VIEW_ALLNG_SUB > */
-   "Anzeigen aller Gruppen mit der M\366glichkeit zum Abonnieren.",
+    "Anzeige aller Newsgruppen, Abonnieren m\366glich.",
 /* < SUB_DONE > */
-    "You are now subscribed to `%s'.", /* newsgroup name */
+    "`%s' ist nun abonniert.", /* newsgroup name */
 /* < AUTOMATIC_RESCAN > */
-   "Automatische Abfrage des Servers wird ausgef\374hrt...",
+    "Automatische Abfrage des Servers wird ausgef\374hrt...",
 /* < RESCANNING_BACKGROUND > */
     "Abfrage des Servers im Hintergrund...",
 /* < ERROR_UNSUP_TRANS > */
-   "Nicht unterst\344tzte \334bersetzung: %d nach %d", /* transition from, to */
+    "Nicht unterst\344tzter \334bergang: %d nach %d", /* transition from, to */
 /* < POST_FOLLOWUP > */
-   "Artikel",
+    "Artikel",
 /* < FOLLOWUP_REPLY > */ 
-   "Artikel und Nachricht",
+    "Artikel und E-Mail-Nachricht",
 /* < DEFAULT_MAIL > */
-   "Nachricht",
+    "E-Mail-Nachricht",
 /* < SAVE_IN > */
-   "Sichere in %s",  /* file */
+    "Sichere in %s",  /* file */
 /* < ERROR_SEND_MAIL > */
-   "Fehler beim Versenden einer Nachricht:",
+    "Fehler beim Versenden einer E-Mail-Nachricht:",
 /* < ASK_FILE > */
-   "Dateiname?",
+    "Dateiname?",
 /* < ASK_POST_ARTICLE > */
-   "Artikel ver\366ffentlichen?",
+    "Artikel einspeisen?",
+/* < ASK_SEND > */
+    "Send the message?",
 /* < ASK_POST_SEND > */
-   "Nachricht ver\366ffentlichen und/oder versenden?",
-/* < ASK_RE_EDIT_ARTCILE > */
-   "Artikel nochmals bearbeiten?",
-/* < ASK_RE_EDIT > */
-   "Nachricht nochmals bearbeiten?",
+    "Post and send the message?",
+/* < RE_EDIT > */
+    "Re-edit",
+/* < AS_FOLLOWUP > */
+    "as followup",
+/* < AS_REPLY > */
+    "as reply",
+/* < AS_FOLLOWUP_REPLY > */
+   "as followup/reply",
 /* < ERROR_EXEC_FAILED > */
-   "XRN Fehler: execl von `%s' fehlgeschlagen\n", /* prog */
+    "XRN Fehler: execl von `%s' fehlgeschlagen\n", /* prog */
 /* < ASK_POSTER_FANDR > */
-   "`Followup-To' Zeile der Nachricht lautet `an Verfasser'.\nEintrag ignorieren und Artikel auch ver\366ffentlichen oder nur Nachricht an Verfasser senden?",
+    "`Followup-To'-Zeile der Nachricht lautet `an Verfasser'.\nEintrag ignorieren und Artikel auch ver\366ffentlichen,\noder nur Nachricht an Verfasser senden?",
 /* < ASK_POSTER_REPLY > */
-   "`Followup-To' Zeile der Nachricht lautet `an Verfasser'.\nArtikel ver\366ffentlichen oder Nachricht an Verfasser senden?",
+    "`Followup-To' Zeile der Nachricht lautet `an Verfasser'.\nArtikel ver\366ffentlichen oder Nachricht an Verfasser senden?",
 /* < POST_AND_SEND > */
-   "Bezug und Nachricht",
+    "Artikel einspeisen und versenden",
 /* < SEND_MAIL > */
-   "Nachricht",
+    "Nachricht senden",
 /* < POST > */ 
-   "Artikel",
+    "Artikel einspeisen",
 /* < FOLLOWUP_MULTIPLE_NGS > */
-    "Die Standard 'Newsgroups'-Zeile Ihres Bezuges enth\344lt mehrere Newsgruppen. Bitte stellen Sie sicher, da\337 unzutreffende Newsgruppen entfernt sind bevor Sie den Artikel versenden und/oder f\374gen Sie zutreffendere Newsgruppen in die 'Followup-To'-Zeile ein.",
+    "Die `Newsgroups'-Zeile Ihres Folgeartikels enth\344lt mehrere Newsgruppen.\n\tBitte entfernen Sie unpassende Newsgruppen, bevor Sie ihn versenden,\n\tund/oder f\374gen Sie passendere Newsgruppen in die 'Followup-To'-Zeile ein.",
 /* < FOLLOWUP_FOLLOWUPTO > */
-    "Beachten Sie bitte, da\337 der Artikel, auf den Sie antworten, eine 'Followup-To'-Zeile enth\344lt. Deshalb wurde die Standard 'Newsgroups'-Zeile Ihres Bezuges auf den Inhalt dieser Zeile gesetzt, statt auf die 'Newsgroups'-Zeile des originalen Artikels.",
+    "Beachten Sie bitte, dass der Artikel, auf den Sie antworten, eine 'Followup-To'-Zeile enth\344lt.\n\tDeshalb wurde die `Newsgroups'-Zeile Ihres Folgeartikels auf den Inhalt dieser Zeile gesetzt,\n\tstatt auf die `Newsgroups'-Zeile des urspr\374nglichen Artikels.",
 /* < CROSSPOST_PROHIBIT > */
-    "Die `Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen. Die maximale\nAnzahl von Newsgruppen an die Sie versenden d\374rfen betr\344gt %d. Bitte\nreduzieren Sie die Anzahl der Newsgruppen an die Sie versenden m\366chten und versenden\nSie dann Ihren Artikel erneut.",
+    "Die `Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen.\n\tDie maximale Anzahl von Newsgruppen, in denen Sie gleichzeitig ver\366ffentlichen d\374rfen, betr\344gt %d.\n\tBitte reduzieren Sie die Anzahl der Newsgruppen\n\tund versenden Sie dann Ihren Artikel erneut.",
 /* < CROSSPOST_CONFIRM > */
-    "Die `Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen. Bitte\nerw\344gen Sie eine Reduzierung der Newsgruppen an die Sie versenden m\366chten.",
+    "Die `Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen.\n\tBitte erw\344gen Sie, diese Anzahl zu reduzieren.",
 /* < FOLLOWUP_FOLLOWUPTO_CONFIRM > */
-    "Die 'Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen und die\n`Followup-To'-Zeile enth\344lt %d Newsgruppen. Bitte erw\344gen Sie eine Reduzierung der\nNewsgruppen in Ihrer `Newsgroups'- und/oder `Followup-To'-Zeile.",
+    "Die `Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen\n\tund die `Followup-To'-Zeile %d Newsgruppen.\n\tBitte erw\344gen Sie, die eine und/oder die andere Anzahl zu reduzieren.",
 /* < FOLLOWUP_CONFIRM > */
-    "Die 'Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen. Bitte erw\344gen Sie\nentweder eine Reduzierung der Anzahl der Newsgruppen an die Sie versenden m\366chten oder ein Hinzuf\374gen einer\n`Followup-To'-Zeile, die eine geringere Anzahl an Newsgruppen enth\344lt.",
+    "Die 'Newsgroups'-Zeile Ihres Artikels enth\344lt %d Newsgruppen.\n\tBitte erw\344gen Sie, die Anzahl der Newsgruppen, in denen Sie ihren Artikel ver\366ffentlichen m\366chten, zu reduzieren\n\toder eine `Followup-To'-Zeile einzuf\374gen, die eine geringere Anzahl von Newsgruppen enth\344lt.",
 /* < ERROR_STRIPFIELD_NL > */
-   "Kein Zeilenvorschub in stripField gefunden.\n",
+    "Kein Zeilenvorschub in stripField gefunden.\n",
 /* < FOLLOWUP_REPLY_TO_TITLE > */
-   "Bezug und Nachricht zu Artikel %ld in %s", /* article number, newsgroup */
+    "Folgeartikel und E-Mail-Antwort zu Artikel %ld in %s", /* article number, newsgroup */
 /* < FOLLOWUP_TO_TITLE > */
-   "Bezug zu Artikel %ld in %s", /* article number, newsgroup */
+    "Folgeartikel zu Artikel %ld in %s", /* article number, newsgroup */
 /* < REPLY_TO_TITLE > */
-   "Nachricht zu Artikel %ld in %s", /* article number, newsgroup */
+    "E-Mail-Antwort zu Artikel %ld in %s", /* article number, newsgroup */
 /* < FORWARD_TO_TITLE > */
-   "Weiterreichen des Artikel %ld in `%s' an einen anderen Benutzer", /* article number, newsgroup */
+    "Weiterreichen des Artikel %ld in `%s' per E-Mail", /* article number, newsgroup */
 /* < POST_ARTICLE > */
-   "Artikel ver\366ffentlichen.",
+    "Artikel schreiben und ver\366ffentlichen",
 /* < POST_ARTICLE_TO > */
-   "Artikel in `%s' ver\366ffentlichen.", /* newsgroup */
+    "Artikel schreiben und in `%s' ver\366ffentlichen", /* newsgroup */
 /* < POST_MAIL_ARTICLE > */
-   "Artikel ver\366ffentlichen und versenden.",
+    "Artikel ver\366ffentlichen und versenden",
 /* < POST_MAIL_ARTICLE_TO > */
-   "Ver\366ffentliche Artikel an `%s' und versende ihn.",
+    "Artikel in `%s' ver\366ffentlichen und versenden", /* newsgroup */
 /* < MAIL > */
-   "Versenden einer E-Mail.",
+    "E-Mail-Nachricht versenden",
 /* < USER_CANT_CANCEL > */
-   "Sie sind nicht berechtigt den Artikel zur\374ckzuziehen.",
+    "Sie sind nicht berechtigt, den Artikel zur\374ckzuziehen.",
 /* 
  ### Die folgenden Texte sollten evtl. nicht uebersetzt werden ###
  */
 /* < REPLY_YOU_WRITE > */
-   "In article %s, you write:\n", /* messageid */
+    "In article %s,\n you write:\n", /* messageid */
 /* < FORWARDED_ARTIKEL > */
-   "\n------ Forwarded Article %s\n------ From %s\n\n", /* messageid , author */
+    "\n------ Forwarded Article %s\n------ From %s\n\n", /* messageid , author */
 /* < FORWARDED_ARTICLE_END > */
-   "\n------ End of Forwarded Article\n",
+    "\n------ End of Forwarded Article\n",
 /* < FOLLOWUP_AUTHOR_WRITE > */
-    "In article %s, %s writes:\n", /* messageid , author */
+    "In article %s,\n %s writes:\n", /* messageid , author */
 /* #### Ende des evtl. nicht uebersetzen #### */
 /* < NEWSGROUPS_INDEX > */
-    "%10s %7s %*s %4d Artikel%1.1s +%6d alt",
+    "%4s %10s %*s %4d Artikel%1.1s +%6d alt",
 /* < UNREAD > */
-    "Ungelesene",
+    "Neue",
 /* < NEWS_IN > */
-    "Nachrichten in",
+    "Artikel in",
 /* < NOT_ONE > */
     " ", /* see NEWSGROUPS_INDEX in STRING section */    
 /* < DONE > */
@@ -1130,85 +1737,95 @@
 /* < FAILED > */
     "fehlgeschlagen",
 /* < CREATE > */
-    "erzeugen",
+    "Erzeugen der",
 /* < APPEND > */
-    "anh\344ngen an",
+    "Anh\344ngen an die",
 /* < ERR_XRN_RUN > */
-   "XRN l\344uft bereits auf %s als Proze\337 %d.\nFalls es nicht mehr l\344uft entfernen sie die Datei `%s'.\n", /* host, pid, lockfile */
+    "XRN l\344uft bereits auf %s als Prozess %d.\nFalls es nicht mehr l\344uft, entfernen Sie die Datei `%s'.\n", /* host, pid, lockfile */
 /* < ERROR_CANT_READ_NEWSRC > */
-   "Kann Datei .newsrc nicht lesen",
+    "Kann Datei .newsrc nicht lesen",
 /* < PROCESS_KILL_FOR > */
-   "Bearbeite KILL-Datei f\374 Newsgruppe `%s'...", /* newsgroup */
+    "Bearbeite KILL-Datei f\374r Newsgruppe `%s'...", /* newsgroup */
 /* < ERROR_REGEX_NOSLASH > */
-   "Fehlender Schr\344gstrich `/' am Ende des Suchmusters",
+    "Fehlender Schr\344gstrich `/' am Ende des Suchmusters",
 /* < ERROR_REGEX_NOSLASH_START > */
-    "no slash preceding the regular expression",
+    "Fehlender Schr\344gstrich `/' am Anfang des Suchmusters",
 /* < ERROR_REGEX_NOCOLON > */
-   "Kein Komma nach dem Suchmuster",
+    "Kein Komma nach dem Suchmuster",
 /* < ERROR_REGEX_UNKNOWN_COMMAND > */
-   "Unbekannter Befehl im Suchmuster (Erlaubt: `j', `m' und `s')",
+    "Unbekannter Befehl im Suchmuster (erlaubt sind `j', `m' und `s')",
 /* < KILL_LINE > */
-    "Processing entry `%s' in KILL file `%s'.",
+    "Bearbeite Eintrag `%s' in KILL-Datei `%s'.",
 /* < KILL_KILLED > */
-   "gel\366scht - %s",    /* subject */
+    "ausgeblendet - %s",    /* subject */
 /* < KILL_UNREAD > */
-   "nicht gelesen - %s",  /* subject */
+    "als ungelesen markiert - %s",  /* subject */
 /* < KILL_SAVED > */
-   "gesichert - %s",      /* subject */
+    "gesichert - %s",      /* subject */
 /* < COUNT_KILLED > */
-   "%d gel\366schte Artikel%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+    "%d Artikel%s in %s ausgeblendet", /* count, "" or NOT_ONE_STRING , newsgroup */
 /* < COUNT_UNREAD > */
-   "%d als ungelesen markierte Artikel%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+    "%d Artikel%s in %s als ungelesen markiert", /* count, "" or NOT_ONE_STRING , newsgroup */
 /* < COUNT_SAVED > */
-   "%d gespeicherte Artikel%s in %s", /* count, "" or NOT_ONE_STRING , newsgroup */
+    "%d Artikel%s in %s abgespeichert", /* count, "" or NOT_ONE_STRING , newsgroup */
 /* < ERROR_CORNERED > */
-   "XRN Fehler in `cornered': erwarte g\374ltige nglist\n",
+    "XRN Fehler in `cornered': erwarte g\374ltige nglist\n",
 /* < ERROR_OUT_OF_MEM > */
-   "kein Speicher mehr verf\374gbar",
+    "kein Speicher mehr verf\374gbar",
 /* < PREFETCHING > */
-    "Einlesen von `%s'...",
+    "`%s' wird geholt...",
 /* < SERVER_POSTING_ERROR > */
-    "Fehler des NNTP Servers: %s", /* error message */
+    "Fehlermeldung des NNTP-Servers: %s", /* error message */
 /* < ASK_SAVEBOX > */
-   "Dateiname, +Dateiname oder @Dateiname?",
+    "Dateiname, +Dateiname oder @Dateiname?",
 /* < SAVE_PIPE_TO > */
-   "Leite Artikel %ld zu Befehl `%s'...",  /* articlenumber, command */
+    "Artikel %ld wird an Befehl `%s' \374bergeben...",  /* articlenumber, command */
 /* < ERROR_SAVE_PIPE > */
-   "Befehl `%s' beendet mit R\374ckmeldung %d.", /* command, status */
+    "Befehl `%s' beendet mit R\374ckmeldung %d.", /* command, status */
 /* < SAVE_MH_REFILE > */
-   "MH zu Verzeichnis %s %s", /* folder, status */
+    "MH zu Verzeichnis %s %s", /* folder, status */
 /* < SAVE_RMAIL_REFILE > */
-   "RMAIL zu Verzeichnis %s %s", /* folder, status */
+    "RMAIL zu Verzeichnis %s %s", /* folder, status */
 /* < SAVE_OK > */
-   "Speichere Artikel %ld in Datei `%s'...", /* articlenumber, filename */
+    "Artikel %ld in Datei `%s' speichern...", /* articlenumber, filename */
 /* < SAVE_APPEND_OK > */
-   "H\344nge Artikel %ld an Datei `%s' an...", /* articlenumber, filename */
+    "Artikel %ld an Datei `%s' anh\344ngen...", /* articlenumber, filename */
 /* < SAVE_ARTICLE > */
-   "Artikel: %ld aus %s\n", /* articlenumber, newsgroup */
+    "Artikel: %ld aus %s\n", /* articlenumber, newsgroup */
 /* < ERROR_INFINITE_LOOP > */
-   "XRN Fehler: moveBeginning / moveEnd in Endlosschleife",
+    "XRN Fehler: moveBeginning / moveEnd in Endlosschleife",
 /* < ERROR_FINDARTICLE > */
-   "G\374ltige Artikelnummer nicht gefunden in findArticle",
+    "G\374ltige Artikelnummer nicht gefunden in findArticle",
 /* < ERROR_STRIP_LEAVE_HEADERS > */
-   "Es darf nur eine der Ressourcen `stripHeaders', `leaveHeaders' angegeben werden.",
+    "Es darf nur eine der Ressourcen `stripHeaders' oder `leaveHeaders' angegeben werden.",
 /* < ERROR_REQUEST_FAILED > */
-   "        Anfrage war: `%s'\n        R\374ckmeldung war: `%s'", /* command, message */
+    "        Anfrage war: `%s'\n        R\374ckmeldung war: `%s'", /* command, message */
 /* < ASK_FILE_MODIFIED > */
-    "%s file\nhas been modified; overwrite it?",	/* file name/type */
+    "%s-Datei %s\nwurde modifiziert; \374berschreiben?", /* file type, file name */
 /* < PENDING_COMPOSITION > */
     "Verlassen nicht m\366glich, solange noch ein Artikel verfa\374t wird!",
 /* < NNTP_PASSWORD > */
-    "NNTP Passwort eingeben:",
+    "NNTP-Passwort eingeben:",
 /* < UNKNOWN_SORT_TYPE > */
-    "Unbekannte Betreff Sortierung: %s",
-/* <TOO_MANY_SORT_TYPES > */
-    "Zu viele Betreff Sortierungen angegeben.",
+    "Unbekanntes Sortier-Kriterium: %s", /* type */
+/* < TOO_MANY_SORT_TYPES > */
+    "Zu viele Sortier-Kriterien angegeben.",
 /* < UNPARSEABLE_DATE > */
-    "Unlesbares Datum (Artikel %ld in %s): %s",
+    "Unlesbares Datum (Artikel %ld in %s):\n\t%s", /* Nummer, Gruppe, String */
 /* < THREADING_FOR > */
-    "F\344deln von Newsgruppe `%s'...", /* newsgroup */
+    "Newsgruppe `%s' wird nach Serien sortiert...", /* newsgroup */
 /* < FILE_CACHE_OPEN > */
-    "Error opening cache file in %s: %s", /* directory, error string */
+    "Fehler beim \326ffnen der Cache-Datei in %s:\n\t%s", /* directory, error string */
+/* < MESG_PANE_DISMISS > */
+    "Dieses Fenster kann offengelassen oder geschlossen werden.\n\tIm letzteren Fall erscheint es erneut,\n\tsobald neue Meldungen ausgegeben werden.",
+/* < BAD_FROM > */
+    "Bad `From' address `%s'.\n\tPlease fix it and resend, or abort your message.",
+/* < NO_BODY > */
+    "Your message has no body, or the blank line after the header is missing.\n\tPlease fix this and resend, or abort your message.",
+/* < ONLY_INCLUDED > */
+    "Message appears to contain only\nincluded text.  Post anyway?",
+/* < COURTESY_COPY > */
+    "[This is a courtesy copy of a message which was also posted to the\n newsgroup(s) shown in the header.]",
 };
 
 #endif /* XRN_LANG_german */
diff -ruPN 9.00/newsrcfile.c 9.01/newsrcfile.c
--- 9.00/newsrcfile.c	Wed Aug 20 19:44:38 1997
+++ 9.01/newsrcfile.c	Mon Apr  6 07:40:58 1998
@@ -1,6 +1,6 @@
 
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: newsrcfile.c,v 1.39 1997/08/20 23:44:24 jik Exp $";
+static char XRNrcsid[] = "$Id: newsrcfile.c,v 1.42 1998/04/06 11:40:57 jik Exp $";
 #endif
 
 /*
@@ -140,26 +140,38 @@
     return OKAY;
 }
 
+int isLongNewsrcFile()
+{
+  static Boolean is_long;
+
+  if (NewsrcFile)
+    return is_long;
+
+  NewsrcFile = findServerFile(app_resources.newsrcFile, False, &is_long);
+  return is_long;
+}
+
 /*
  * read, parse, and process the .newsrc file
  *
  *   returns: 0 for fatal error, non-zero for okay
  *
  */
-int readnewsrc(newsrcfile, savenewsrcfile)
-    char *newsrcfile;
-    char *savenewsrcfile;
+int readnewsrc()
 {
     struct stat buf;
     extern int yyparse _ARGUMENTS((void));
     extern int newsrc_mesg_name;
+    char *SaveNewsrcFile;
 
     checkNewsrcSize(ActiveGroupsCount);
 
     optionsLine = NIL(char);
 
-    if (! (NewsrcFile = findServerFile(newsrcfile, False))) {
-      mesgPane(XRN_SERIOUS, 0, CANT_EXPAND_MSG, newsrcfile);
+    /* Make sure NewsrcFile has been set. */
+    (void) isLongNewsrcFile();
+    if (! NewsrcFile) {
+      mesgPane(XRN_SERIOUS, 0, CANT_EXPAND_MSG, app_resources.newsrcFile);
       return FATAL;
     }
 
@@ -230,9 +242,18 @@
 	return FATAL;
     }
 
-    if (!copyNewsrcFile(NewsrcFile, savenewsrcfile)) {
+    if (! (SaveNewsrcFile = findServerFile(app_resources.saveNewsrcFile,
+					   isLongNewsrcFile(), NULL))) {
+      mesgPane(XRN_SERIOUS, 0, CANT_EXPAND_MSG, app_resources.saveNewsrcFile);
+      freeNewsrc();
+      XtFree(NewsrcFile);
+      return FATAL;
+    }
+
+    if (!copyNewsrcFile(NewsrcFile, SaveNewsrcFile)) {
       freeNewsrc();
       XtFree(NewsrcFile);
+      XtFree(SaveNewsrcFile);
       return FATAL;
     }
 
@@ -244,6 +265,7 @@
 
     Newsrcfp = NIL(FILE);
 
+    XtFree(SaveNewsrcFile);
     return(OKAY);
 }
 
@@ -416,7 +438,7 @@
 			    continue;
 			}
 		      do_output:
-			FAILIF(putc(comma ? ',' : ' ', newsrcfp) == EOF);
+			FAILIF(fputc(comma ? ',' : ' ', newsrcfp) == EOF);
 			if (last_first == last_last) {
 			  FAILIF(fprintf(newsrcfp, "%ld", last_first) == EOF);
 			}
diff -ruPN 9.00/newsrcfile.h 9.01/newsrcfile.h
--- 9.00/newsrcfile.h	Wed Aug 20 19:44:39 1997
+++ 9.01/newsrcfile.h	Mon Apr  6 07:41:03 1998
@@ -2,7 +2,7 @@
 #define NEWSRCFILE_H
 
 /*
- * $Id: newsrcfile.h,v 1.8 1997/08/20 23:44:24 jik Exp $
+ * $Id: newsrcfile.h,v 1.9 1998/04/06 11:41:03 jik Exp $
  */
 
 /*
@@ -38,8 +38,9 @@
 
 extern void checkNewsrcSize _ARGUMENTS((ng_num));
 
+extern int isLongNewsrcFile _ARGUMENTS((void));
 /* return 1 for okay, 0 for fatal error */
-extern int readnewsrc _ARGUMENTS((char *,char *));
+extern int readnewsrc _ARGUMENTS((void));
 extern int updatenewsrc _ARGUMENTS((void));
 
 extern FILE *Newsrcfp;
diff -ruPN 9.00/patchlevel.h 9.01/patchlevel.h
--- 9.00/patchlevel.h	Thu Jan 15 21:36:44 1998
+++ 9.01/patchlevel.h	Mon May 25 11:12:43 1998
@@ -1,5 +1,5 @@
 #ifdef MOTIF
-#define XRN_VERSION "9.00 (Motif)"
+#define XRN_VERSION "9.01 (Motif)"
 #else
-#define XRN_VERSION "9.00"
+#define XRN_VERSION "9.01"
 #endif
diff -ruPN 9.00/resources.c 9.01/resources.c
--- 9.00/resources.c	Tue Dec 16 22:05:11 1997
+++ 9.01/resources.c	Sun Mar 22 22:16:55 1998
@@ -1,5 +1,5 @@
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: resources.c,v 1.60 1997/12/17 03:04:19 jik Exp $";
+static char XRNrcsid[] = "$Id: resources.c,v 1.62 1998/03/23 03:16:54 jik Exp $";
 #endif
 
 /*
@@ -108,6 +108,8 @@
 #define XtNcomplainAboutBadDates "complainAboutBadDates"
 #define XtNconfirm              "confirm"
 #define XtCConfirm              "Confirm"
+#define XtNcourtesyCopyMessage	"courtesyCopyMessage"
+#define XtCCourtesyCopyMessage	"CourtesyCopyMessage"
 #define XtNdeadLetters          "deadLetters"
 #define XtCDeadLetters          "DeadLetters"
 #define XtNdefaultLines         "defaultLines"
@@ -243,6 +245,8 @@
 #define XtCValidNewsgroups      "ValidNewsgroups"
 #define XtNverboseKill          "verboseKill"
 #define XtCVerboseKill          "VerboseKill"
+#define XtNverifyFrom		"verifyFrom"
+#define XtCVerifyFrom		"VerifyFrom"
 #define XtNversion              "version"
 #define XtCVersion              "Version"
 #define XtNwatchUnread          "watchUnread"
@@ -394,6 +398,8 @@
      XtOffset(app_res,dumpCore), XtRBoolean, (XtPointer) &defaultFalse},
     {XtNconfirm, XtCConfirm, XtRString, sizeof(char *),
      XtOffset(app_res,confirm), XtRString, (XtPointer) NULL},
+    {XtNcourtesyCopyMessage, XtCCourtesyCopyMessage, XtRString, sizeof(char *),
+     XtOffset(app_res,courtesyCopyMessage), XtRString, (XtPointer) NULL},
     {XtNdeadLetters, XtCDeadLetters, XtRString, sizeof(char *),
      XtOffset(app_res,deadLetters), XtRString, (XtPointer) DEADLETTER},
     {XtNdefaultLines, XtCDefaultLines, XtRInt, sizeof(int),
@@ -550,6 +556,8 @@
      XtOffset(app_res,validNewsgroups), XtRString, (XtPointer) NULL},
     {XtNverboseKill, XtCVerboseKill, XtRString, sizeof(String),
      XtOffset(app_res,verboseKill), XtRString, (XtPointer) "jms"},
+    {XtNverifyFrom, XtCVerifyFrom, XtRBoolean, sizeof(Boolean),
+     XtOffset(app_res,verifyFrom), XtRBoolean, (XtPointer) &defaultTrue},
     {XtNversion, XtCVersion, XtRString, sizeof(char *),
      XtOffset(app_res,version), XtRString, (XtPointer) NULL},
     {XtNwatchUnread, XtCWatchUnread, XtRString, sizeof(char *),
diff -ruPN 9.00/resources.h 9.01/resources.h
--- 9.00/resources.h	Tue Dec 16 22:05:12 1997
+++ 9.01/resources.h	Sun Mar 22 22:17:04 1998
@@ -2,7 +2,7 @@
 #define RESOURCES_H
 
 /*
- * $Id: resources.h,v 1.36 1997/12/17 03:04:19 jik Exp $
+ * $Id: resources.h,v 1.38 1998/03/23 03:17:04 jik Exp $
  */
 
 /*
@@ -145,6 +145,8 @@
       int followupTo, crossPost;
     } posting;
   } warnings;
+  Boolean verifyFrom;
+  String courtesyCopyMessage;
 } app_resourceRec, *app_res;
 
 extern app_resourceRec app_resources;
diff -ruPN 9.00/server.c 9.01/server.c
--- 9.00/server.c	Tue Dec 16 21:57:50 1997
+++ 9.01/server.c	Tue May 12 13:00:50 1998
@@ -1,6 +1,6 @@
 
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: server.c,v 1.145 1997/12/17 02:57:49 jik Exp $";
+static char XRNrcsid[] = "$Id: server.c,v 1.150 1998/05/12 17:00:24 jik Exp $";
 #endif
 
 /*
@@ -166,7 +166,7 @@
     return 1;
   }
      
-  while (*ptr && isspace(*ptr))
+  while (*ptr && isspace((unsigned char)*ptr))
     ptr++;
 
   return(! strncasecmp(ptr, "user/pass", sizeof("user/pass")-1));
@@ -205,18 +205,18 @@
     
     user = buf;
 
-    while (*user && isspace(*user))
+    while (*user && isspace((unsigned char)*user))
       user++;
 
     user += sizeof("user/pass") - 1;
 
-    while (*user && isspace(*user))
+    while (*user && isspace((unsigned char)*user))
       user++;
 
     if (! (ptr = strchr(user, '/')))
       ptr = strchr(user, '\0');
 
-    while ((ptr > user) && isspace(*(ptr - 1)))
+    while ((ptr > user) && isspace((unsigned char)*(ptr - 1)))
       ptr--;
 
     *ptr = '\0';
@@ -225,10 +225,10 @@
     pass = app_resources.authenticator;
     if ((pass = strchr(pass, '/')) && (pass = strchr(pass + 1, '/'))) {
       pass++;
-      while (*pass && isspace(*pass))
+      while (*pass && isspace((unsigned char)*pass))
 	pass++;
       ptr = strchr(pass, '\0');
-      while ((ptr > pass) && isspace(*(ptr - 1)))
+      while ((ptr > pass) && isspace((unsigned char)*(ptr - 1)))
 	ptr--;
       *ptr = '\0';
       if (! *pass)
@@ -698,7 +698,8 @@
     /* handle rotation of the article body */
     if ((flags & ROTATED) && found_sep) {
       for (ptr = buf; *ptr != '\0'; ptr++) {
-	if (isalpha(*ptr)) {
+	if (((*ptr >= 'A') && (*ptr <= 'Z')) ||
+	    ((*ptr >= 'a') && (*ptr <= 'z'))) {
 	  if ((*ptr & 31) <= 13) {
 	    *ptr = *ptr + 13;
 	  } else {
@@ -1461,7 +1462,7 @@
 typedef char * (*_fixfunction) _ARGUMENTS((struct newsgroup *, art_num, char *));
 
 static Boolean getlist _ARGUMENTS((struct newsgroup *, art_num, art_num,
-				   Boolean, int, char *, unsigned,
+				   Boolean, int *, char *, unsigned,
 				   _fixfunction, unsigned, Boolean));
 
 static Boolean getlist(
@@ -1469,7 +1470,7 @@
 		       _ANSIDECL(art_num,		artfirst),
 		       _ANSIDECL(art_num,		artlast),
 		       _ANSIDECL(Boolean,		unreadonly),
-		       _ANSIDECL(int,			max),
+		       _ANSIDECL(int *,			max),
 		       _ANSIDECL(char *,		field),
 		       _ANSIDECL(unsigned,		offset),
 		       _ANSIDECL(_fixfunction, 		fixfunction),
@@ -1480,7 +1481,7 @@
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
      _KNRDECL(char *,			field)
      _KNRDECL(unsigned,			offset)
      _KNRDECL(_fixfunction, 		fixfunction)
@@ -1500,7 +1501,9 @@
   artListSet(newsgroup);
 
   first = artfirst;
-  while ((first <= artlast) && ((! max) || (count < max))) {
+  while ((first <= artlast) && ((! max) || (count < *max))) {
+    art_num sub_count;
+
     art = artStructGet(newsgroup, first, False);
     if (((offset != (unsigned)-1) && *(char **)((char *) art + offset)) ||
 	(fixfunction && *(char **)((char *) art + fixed_offset)) ||
@@ -1510,13 +1513,15 @@
       continue;
     }
 
-    for (last = first + 1; last <= artlast; last++) {
+    for (sub_count = 1, last = first + 1; last <= artlast; last++) {
       art = artStructGet(newsgroup, last, False);
       if (((offset != (unsigned)-1) && *(char **)((char *) art + offset)) ||
 	  (fixfunction && *(char **)((char *) art + fixed_offset)) ||
 	  (unreadonly && IS_READ(art)) ||
-	  IS_UNAVAIL(art) || (max && ((count + (last - first)) >= max)))
+	  (max && ((count + sub_count) >= *max)))
 	break;
+      if (max && IS_AVAIL(art))
+	sub_count++;
     }
     last--;
 
@@ -1553,7 +1558,7 @@
 	support for multi-line XHDR field response.  Grr.
 	 - jik 12/16/97
       */
-      if (isspace(*message))
+      if (isspace((unsigned char)*message))
 	continue;
 
       count++;
@@ -1577,9 +1582,10 @@
       /*
 	Strip leading and trailing spaces.
 	*/
-      while (*line && isspace(*line))
+      while (*line && isspace((unsigned char)*line))
 	line++;
-      for (ptr = strchr(line, '\0') - 1; (ptr >= line) && isspace(*ptr);
+      for (ptr = strchr(line, '\0') - 1; (ptr >= line) &&
+	     isspace((unsigned char)*ptr);
 	   *ptr-- = '\0') /* empty */;
       if (!required && (strcmp(line, "(none)") == 0))
 	continue;
@@ -1627,7 +1633,13 @@
     if (max)
       break;
   }
-  return (first > artlast) ? True : False;
+  if (first > artlast) {
+    return True;
+  }
+  else {
+    *max = count;
+    return False;
+  }
 }
 
 Boolean getsubjectlist(
@@ -1635,13 +1647,13 @@
 		       _ANSIDECL(art_num,		artfirst),
 		       _ANSIDECL(art_num,		artlast),
 		       _ANSIDECL(Boolean,		unreadonly),
-		       _ANSIDECL(int,			max)
+		       _ANSIDECL(int *,			max)
 		       )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -1657,13 +1669,13 @@
 			  _ANSIDECL(art_num,		artfirst),
 			  _ANSIDECL(art_num,		artlast),
 			  _ANSIDECL(Boolean,		unreadonly),
-			  _ANSIDECL(int,		max)
+			  _ANSIDECL(int *,		max)
 			  )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -1679,13 +1691,13 @@
 		    _ANSIDECL(art_num,			artfirst),
 		    _ANSIDECL(art_num,			artlast),
 		    _ANSIDECL(Boolean,			unreadonly),
-		    _ANSIDECL(int,			max)
+		    _ANSIDECL(int *,			max)
 		    )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -1701,13 +1713,13 @@
 		    _ANSIDECL(art_num,			artfirst),
 		    _ANSIDECL(art_num,			artlast),
 		    _ANSIDECL(Boolean,			unreadonly),
-		    _ANSIDECL(int,			max)
+		    _ANSIDECL(int *,			max)
 		    )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -1723,13 +1735,13 @@
 		  _ANSIDECL(art_num,		artfirst),
 		  _ANSIDECL(art_num,		artlast),
 		  _ANSIDECL(Boolean,		unreadonly),
-		  _ANSIDECL(int,		max)
+		  _ANSIDECL(int *,		max)
 		  )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -1745,13 +1757,13 @@
 		   _ANSIDECL(art_num,			artfirst),
 		   _ANSIDECL(art_num,			artlast),
 		   _ANSIDECL(Boolean,			unreadonly),
-		   _ANSIDECL(int,			max)
+		   _ANSIDECL(int *,			max)
 		   )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -1865,13 +1877,13 @@
 		      _ANSIDECL(art_num,		artfirst),
 		      _ANSIDECL(art_num,		artlast),
 		      _ANSIDECL(Boolean,		unreadonly),
-		      _ANSIDECL(int,			max)
+		      _ANSIDECL(int *,			max)
 		      )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset, fixed_offset;
@@ -1922,13 +1934,13 @@
 		     _ANSIDECL(art_num,			artfirst),
 		     _ANSIDECL(art_num,			artlast),
 		     _ANSIDECL(Boolean,			unreadonly),
-		     _ANSIDECL(int,			max)
+		     _ANSIDECL(int *,			max)
 		     )
      _KNRDECL(struct newsgroup *,	newsgroup)
      _KNRDECL(art_num,			artfirst)
      _KNRDECL(art_num,			artlast)
      _KNRDECL(Boolean,			unreadonly)
-     _KNRDECL(int,			max)
+     _KNRDECL(int *,			max)
 {
     struct article foo;
     unsigned offset;
@@ -2169,7 +2181,10 @@
 
 
 
-
+/*
+  The article string passed into this function *must* have both a
+  header and a body, separated by at least one blank line.
+*/
 int postArticle(article, mode, ErrMsg)
     char *article;
     int mode;   /* XRN_NEWS or XRN_MAIL */
@@ -2226,7 +2241,7 @@
 
     ptr = article;
 
-    while (1) {
+    while (ptr) {
 	char *line;
 
 	saveptr = ptr;
@@ -2243,6 +2258,10 @@
 	}
 	break;
     }
+
+    /* If this assertion fails, then the article string passed into
+       this function didn't have a body.  Shame on you! */
+    assert(ptr);
 
 #ifdef INEWS
     fputs("\n\n", inews);
diff -ruPN 9.00/server.h 9.01/server.h
--- 9.00/server.h	Tue Jul  1 10:27:45 1997
+++ 9.01/server.h	Tue Feb 10 22:43:23 1998
@@ -2,7 +2,7 @@
 #define SERVER_H
 
 /*
- * $Id: server.h,v 1.31 1997/07/01 14:25:59 jik Exp $
+ * $Id: server.h,v 1.32 1998/02/11 03:43:23 jik Exp $
  */
 
 /*
@@ -81,21 +81,21 @@
 
 /* get a list of subject lines for a range of articles in the current group from the server */
 extern Boolean getsubjectlist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-					  Boolean, int));
+					  Boolean, int *));
 extern Boolean getnewsgroupslist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-					     Boolean, int));
+					     Boolean, int *));
 extern Boolean getauthorlist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-					 Boolean, int));
+					 Boolean, int *));
 extern Boolean getlineslist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-					Boolean, int));
+					Boolean, int *));
 extern Boolean getdatelist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-				       Boolean, int));
+				       Boolean, int *));
 extern Boolean getidlist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-				     Boolean, int));
+				     Boolean, int *));
 extern Boolean getreflist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-				      Boolean, int));
+				      Boolean, int *));
 extern Boolean getxreflist _ARGUMENTS((struct newsgroup *,art_num,art_num,
-				       Boolean, int));
+				       Boolean, int *));
 
 
 /* xhdr commands */
diff -ruPN 9.00/sort.c 9.01/sort.c
--- 9.00/sort.c	Tue Dec 23 08:06:02 1997
+++ 9.01/sort.c	Tue May 12 12:54:12 1998
@@ -250,7 +250,7 @@
 		   SUB_SORT_WIDTH);
     ((char *)data->articles[i].sort_key)[SUB_SORT_WIDTH] = '\0';
     for (ptr = data->articles[i].sort_key; *ptr; ptr++)
-      if (isupper(*ptr))
+      if (isupper((unsigned char)*ptr))
 	*ptr = tolower(*ptr);
   }
 }
diff -ruPN 9.00/utils.c 9.01/utils.c
--- 9.00/utils.c	Thu Jun  5 07:11:42 1997
+++ 9.01/utils.c	Tue May 12 13:00:52 1998
@@ -1,5 +1,5 @@
 #if !defined(lint) && !defined(SABER) && !defined(GCC_WALL)
-static char XRNrcsid[] = "$Id: utils.c,v 1.29 1997/02/27 11:36:44 jik Exp $";
+static char XRNrcsid[] = "$Id: utils.c,v 1.33 1998/05/12 17:00:24 jik Exp $";
 #endif
 
 /*
@@ -209,7 +209,7 @@
     register char *string;
 {
     for ( ; *string != '\0'; string++) {
-	if (isupper(*string)) {
+	if (isupper((unsigned char)*string)) {
 	    *string = tolower(*string);
 	}
     }
@@ -234,12 +234,12 @@
 	if (!*str2) {
 	    return 1;
 	}
-	if (isupper(*str1)) {
+	if (isupper((unsigned char)*str1)) {
 	    c1 = tolower(*str1);
 	} else {
 	    c1 = *str1;
 	}
-	if (isupper(*str2)) {
+	if (isupper((unsigned char)*str2)) {
 	    c2 = tolower(*str2);
 	} else {
 	    c2 = *str2;
@@ -344,7 +344,7 @@
     char *dest, *source;
 {
   time_t converted = get_date(source);
-  char *ptr, buf[30] /* ctime only takes 26, but who knows if it'll change? */;
+  char buf[30] /* ctime only takes 26, but who knows if it'll change? */;
 
   if (converted == (time_t)-1) {
     if (dest != source)
@@ -364,8 +364,6 @@
     }
     else
       strcpy(dest, buf);
-    if ((ptr = strchr(dest, '\n')))
-      *ptr = '\0';
   }
 }
 
@@ -483,11 +481,13 @@
 }
 
 char *findServerFile(
-		     _ANSIDECL(char *,	basename),
-		     _ANSIDECL(Boolean,	prefer_long)
+		     _ANSIDECL(char *,		basename),
+		     _ANSIDECL(Boolean,		prefer_long),
+		     _ANSIDECL(Boolean *,	returned_long)
 		     )
-     _KNRDECL(char *,	basename)
-     _KNRDECL(Boolean,	prefer_long)
+     _KNRDECL(char *,		basename)
+     _KNRDECL(Boolean,		prefer_long)
+     _KNRDECL(Boolean *,	returned_long)
 {
   char *server_name = nntpServer();
   char *long_name = 0, *expanded;
@@ -498,15 +498,22 @@
   if (server_name) {
     long_name = XtMalloc(strlen(expanded) + strlen(server_name) + 2);
     (void) sprintf(long_name, "%s-%s", expanded, server_name);
-    if (! access(long_name, R_OK))
+    if (! access(long_name, R_OK)) {
+      if (returned_long)
+	*returned_long = True;
       return(long_name);
+    }
   }
 
   if ((! access(expanded, R_OK)) || (! prefer_long) || (! long_name)) {
     XtFree(long_name);
+    if (returned_long)
+      *returned_long = False;
     return(XtNewString(expanded));
   }
 
+  if (returned_long)
+    *returned_long = True;
   return(long_name);
 }
 
diff -ruPN 9.00/utils.h 9.01/utils.h
--- 9.00/utils.h	Sun Oct 19 22:11:55 1997
+++ 9.01/utils.h	Mon Apr  6 07:41:06 1998
@@ -2,7 +2,7 @@
 #define UTILS_H
 
 /*
- * $Id: utils.h,v 1.56 1997/10/20 02:11:55 jik Exp $
+ * $Id: utils.h,v 1.57 1998/04/06 11:41:06 jik Exp $
  */
 
 /*
@@ -300,7 +300,7 @@
 #define WALL(a)
 #endif
 
-char *findServerFile _ARGUMENTS((char *, Boolean));
+char *findServerFile _ARGUMENTS((char *, Boolean, Boolean *));
 
 #if defined(__osf__) || defined(_POSIX_SOURCE) || defined(SOLARIS) \
 	|| defined(sun)
diff -ruPN 9.00/xrn-man.src 9.01/xrn-man.src
--- 9.00/xrn-man.src	Thu Jan 15 21:36:45 1998
+++ 9.01/xrn-man.src	Mon May 25 11:12:44 1998
@@ -1,5 +1,5 @@
-.TH XRN 1 "$Date: 1998/01/16 02:36:44 $" "X"
-.\" $Id: xrn-man.src,v 1.204 1998/01/16 02:36:44 jik Exp $
+.TH XRN 1 "$Date: 1998/05/25 15:12:43 $" "X"
+.\" $Id: xrn-man.src,v 1.214 1998/05/25 15:12:43 jik Exp $
 .\"
 .\" xrn - an X-based NNTP news reader
 .\"
@@ -42,7 +42,7 @@
 users to read news from personal workstations
 by accessing a central news
 repository.
-This manual page applies to version 9.00.
+This manual page applies to version 9.01.
 .\"
 .SH DESCRIPTION
 .PP
@@ -1337,7 +1337,10 @@
 "~/News/SIGNATURE", in that order, and use the first one it finds.
 .TP 10
 .B \-lockFile file
-Set the XRN lock file name to "file".  Defaults to "~/.xrnlock".
+Set the XRN lock file name to "file".  Defaults to "~/.xrnlock".  If
+the \*(NS file has the server name appended to it, then the server
+name is also appended to the lock file name (e.g.,
+"~/.xrnlock-hostname").
 .TP 10
 .B \-mailer mailer
 The command to use for mailing replies.
@@ -1480,10 +1483,11 @@
 "onedir" or "subdirs".  The default is "normal,headers,onedir".
 .TP 10
 .B \-saveNewsrcFile file
-The saved \*(NS filename.
-Before the \*(NS file is modified on startup,
-it is saved in a backup file.
-Defaults to "~/.oldnewsrc".
+The saved \*(NS filename.  Before the \*(NS file is modified on
+startup, it is saved in a backup file.  Defaults to "~/.oldnewsrc".
+If the real \*(NS file has the server name appended to it, then the
+server name is also appended to the save file name (e.g.,
+"~/.oldnewsrc-hostname").
 .TP 10
 .B \-savePostings file
 The name of the file in which to save postings and messages (via the
@@ -1787,6 +1791,14 @@
 .B complainAboutBadDates (class "Debug")
 See "sortedSubjects", below.
 .TP 10
+.B courtesyCopyMessage
+When you both post and mail an article, the mailed copy of the article
+will have a message at the top indicating that it is a courtesy copy
+of an article which was also posted.  The default message depends on
+the language for which XRN was compiled.  You may change the message
+by setting this resource, or you may set this resource to an empty
+string to disable the message entirely.
+.TP 10
 .B domainName
 Your internet domain (e.g., ".Berkeley.EDU", ".orst.edu").  Equivalent
 to setting the DOMAIN environment variable.  You probably don't have
@@ -1917,6 +1929,16 @@
 two backslashes whenever you want a single backslash to appear in a
 regular expression, because the backslash is interpreted as a quoting
 character when X resources are parsed.
+xSENDMAIL_VERIFY_STARTx
+.TP 10
+.B verifyFrom
+By default, \*(XR will verify that the address in the "From" line of
+each outgoing posting is valid (according to sendmail).  You can set
+this resource to false to disable the check.  Note, however, that the
+use of invalid addresses in "From" lines is strongly discouraged.
+Furthermore, note that even if you change your "From" line, \*(XR will
+still insert a "Sender" line with your real address in it.
+xSENDMAIL_VERIFY_ENDx
 .PP
 Furthermore, \*(XR takes a number of specifications for colors, fonts,
 border widths, and other program options.
@@ -2000,7 +2022,7 @@
 internal cache containing \*(XR variable settings and/or cached
 newsgroup data
 .TP 15
-~/.oldnewsrc
+~/.oldnewsrc[-hostname]
 backup of ~/.newsrc (created at startup)
 .TP 15
 ~/.signature*
@@ -2015,7 +2037,7 @@
 ~/dead.letter
 where failed postings and messages are stored
 .TP 15
-~/.xrnlock
+~/.xrnlock[-hostname]
 lock file
 xSERVER_FILE_STARTx
 .TP 15
diff -ruPN 9.00/xrn-man.sym 9.01/xrn-man.sym
--- 9.00/xrn-man.sym	Tue Dec 16 21:11:50 1997
+++ 9.01/xrn-man.sym	Sun Mar 22 20:04:51 1998
@@ -9,6 +9,7 @@
 PATH_FILE
 PRINTCOMMAND
 SENDMAIL
+SENDMAIL_VERIFY
 SERVER_FILE
 UUCPNAME
 XLATE
