/*

This software has been written by Andreas Paul in 1994 (c)

You may use it in any way you want, as long as the information who the
original author is stays intact.
However, if anybody actually discovers a way to make money out of it I want
my fair share ;)


Here are a few ways to reach me: 

 E-Mail : paula@informatik.tu-muenchen.de
 IRC    : Co
 URL    : http://wwwzenger.informatik.tu-muenchen.de/persons/paula.html

*/

#include <stdio.h>
#include <stdlib.h>

#ifdef HPUX
#include <sys/types.h>
#include <utmp.h>
#include <sys/stat.h>
#include <sys/fcntl.h>

#define	pututline _pututline
#endif

#ifdef IRIX
#include <utmp.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#endif

#ifdef MIPS
#include <utmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>

	/* this avoids a warning during compilation ... 
	   I didn't find a man-page for getutent() nor was it mentioned
	   in any of the systems include-files ... => DEC's suck ... ;) */
extern struct utmp *getutent();
#endif

#ifdef SUN
#include <sys/stat.h>
#include <sys/fcntlcom.h>
#include "/usr/xpg2include/utmp.h"
#endif

#ifdef SOLARIS
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <utmp.h>
#include <sys/systm.h>
#include <string.h>
#endif

#ifdef IRIX
#define UTMP_NAME		"/var/adm/utmp"
#define TMP_UTMP_NAME	"/usr/tmp/utmp"
#else
#define UTMP_NAME		"/etc/utmp"
#define TMP_UTMP_NAME	"/tmp/utmp"
#endif

main(argc,argv)
int	argc;
char	**argv;
{
	int		i;

	char	login[9]; 
	char	tty[12];

	login[0]=(char) NULL;
	strcpy(tty,"X0");

	for(i=1;i<argc;i++) {
		if(argv[i][0] != '-') {
			if(strlen(argv[i])>8) {
				fprintf(stderr,"ERROR: login-name too long (%s)\n",argv[i]);
				exit(1);
				}
			else strcpy(login,argv[i]);
			}
		else switch(argv[i][1]) {
			case 't':
			case 'T':
				if(i==argc-1) usage(argv[0]);
				if(strlen(argv[++i])>12) {
					fprintf(stderr,"ERROR: tty too long (%s)\n",argv[i]);
					exit(1);
					}
				else strcpy(tty,argv[i]);
				break;
			default: usage(argv[0]); break;
			}
		}

	write_utmp(login,tty);

	exit(0);
}

int usage(prg)
char *prg;
{
	printf("Usage: %s [-t <tty>] [<login>]\n",prg);
	printf("\n");
	printf("           -t <tty>     set tty-entry name (default 'X0')\n");
	printf("\n");
	printf("   Note: not providing a login name will cause any entrys for\n");
	printf("         the specified tty to be removed.\n");
	exit(0);
}

#ifdef SOLARIS
void bzero(buf,len)
char	*buf;
int		len;
{
	int	t;
	for(t=0;t<len;t++) buf[t]=(char) 0;
}
#endif

int write_utmp(login,tty)
char	*login, *tty;
{
	struct	utmp	ut;
	struct	utmp	*search;

	int		in,out;
	int		i,j;
	int		nr_of_entrys;
	struct	stat	info;
	struct	utmp	*in_utmp;
	struct	utmp	*out_utmp;

	if(login[0]==(char) NULL) {   /* remove utmp entry */

			/* open utmp-file */
		in=open(UTMP_NAME,O_RDONLY);
		if(in==(int)NULL) fprintf(stderr,"ERROR: unable to open utmp-file!\n"),exit(1);

			/* find out how big it is */
		fstat(in,&info);

			/* compute number of entries it contains */
		nr_of_entrys=info.st_size/sizeof(struct utmp);

			/* allocate necessary memory to hold the the utmp-data */
		in_utmp= (struct utmp *) calloc(nr_of_entrys, sizeof(struct utmp));
		if(in_utmp==NULL) fprintf(stderr,"ERROR: out of memory ?!\n"),exit(1);

			/* read the file */
		if(read(in,in_utmp,info.st_size)!=info.st_size)
					fprintf(stderr,"ERROR: reading utmp-file!\n"),exit(1);

			/* close it */
		close(in);


			/* allocate maximum size of utmp-output-file */
		out_utmp= (struct utmp *) calloc(nr_of_entrys, sizeof(struct utmp));
		if(out_utmp==NULL) fprintf(stderr,"ERROR: out of memory ?!\n"),exit(1);

			/* cycle through all utmp-entrys */
		j=0;
		for(i=0;i<nr_of_entrys;i++) {
				/* copy entry to output-data unless the tty-entry matches */
			if(strcmp(in_utmp[i].ut_line,tty)!=(int)NULL) {
				memcpy(&out_utmp[j],&in_utmp[i],sizeof(struct utmp));
				j++;
				}
			}

			/* open utmp-output file */
		out=open(TMP_UTMP_NAME,	O_WRONLY |
								O_CREAT |
								O_TRUNC |
								O_SYNC,
								S_IRUSR |
								S_IWUSR |
								S_IRGRP |
								S_IROTH);
		if(out==(int)NULL) fprintf(stderr,"ERROR: opening utmp-output-file!\n"),exit(1);

			/* write the data to the file */
		if(write(out,out_utmp,sizeof(struct utmp)*j)!= sizeof(struct utmp)*j)
					fprintf(stderr,"ERROR: writing to utmp-output-file!\n"),exit(1);

			/* close file */
		close(out);

		if(rename(TMP_UTMP_NAME,UTMP_NAME)!=0) {
			fprintf(stderr,"ERROR: rename utmp-output-file -> utmp-file\n");

				/* remove the utmp-output-file */
			unlink(TMP_UTMP_NAME);
			exit(1);
			}

			/* ... just in case ... ;) */
		unlink(TMP_UTMP_NAME);
		exit(0);
		}
	else {      /* add utmp entry */

			/* reset utmp-pointer */
		setutent();

#if !defined(SUN)
			/* search for slot to put the entry in */
		while( (search=getutent()) != (struct utmp *)NULL) {
			if(	strcmp(search->ut_line,tty)==(int)NULL ) break;
			}
#else
			/* the above doesn't work for SUN's ... so let's hope
			   pututline is smart enough */
		search = (struct utmp *)NULL;
#endif

			/* found existing slot for tty */
		if(search != NULL) {

				/* alter the entry found */

			strcpy(search->ut_name,login);

#if !defined(MIPS)
			search->ut_type= USER_PROCESS;
			search->ut_pid = getppid();
#endif
		
			time(&(search->ut_time));
			if(pututline(search)==NULL)
						fprintf(stderr,"ERROR: pututline !\n");
			}

				/* no slot for entry found */
		else if(search == NULL) {

				/* fill structure for entry to be added to utmp-file */

			strcpy(ut.ut_line,tty);
			strcpy(ut.ut_name,login);

#if !defined(MIPS)
			if(strlen(tty)>4) tty[5]=(char) NULL;
			strcpy(ut.ut_id,tty);
			ut.ut_pid= getppid();
			ut.ut_type= USER_PROCESS;
#endif

			time(&(ut.ut_time));

			if(pututline(&ut)==NULL)
						fprintf(stderr,"ERROR: pututline !\n");
			}


			/* close utmp-file */
    	endutent();
		}
}
