


XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



NAME
     XpTable - Xt-Based Public Table Widget

SYNOPSIS
     In C++ or C:

     #include <X11/Intrinsic.h>
     #include <X11/Xp/Table.h>

     Widget newTable = XtCreateWidget( name, xpTableWidgetClass, pw, ... );
     Widget another = XpCreateTable( pw, name, arglist, argcount );

LINK BY
     example% ld -o prog prog.o -lXp  -lXaw <WclOption> -lXmu -lXt -lX11
     example% ld -o prog prog.o -lXcp -lXcu <WclOption> -lXmu -lXt -lX11
     example% ld -o prog prog.o -lXop -lXol <WclOption> -lXmu -lXt -lX11

     _X_p_T_a_b_l_e works with any widget set.  If you are using  Motif,
     you  may  want to use the _X_m_p_T_a_b_l_e which is very similar but
     derived from Motif manager classes, hence it works  slightly
     better in some Motif contexts.

     _X_p_T_a_b_l_e _i_s _b_u_i_l_t _i_n_t_o _t_h_e _X_p, distributed with Wcl.  _X_p_T_a_b_l_e
     does  not  require  the use of Wcl, but the author obviously
     encourages its use ;^).  See _W_c_l(_3) for usage and linking of
     Wcl.

DESCRIPTION
     _X_p_T_a_b_l_e is a manager  widget  which  allows  widgets  to  be
     arranged in a tabular form.  The _X_p_T_a_b_l_e widget has a layout
     resource which is used to specify the column and  row  posi-
     tion  of each child.  Children can span rows and/or columns.
     Layout options are available to control the  initial  sizes,
     justification, and dynamic resizing of children.

     Amazing as this  may  sound,  _X_p_T_a_b_l_e  is  internally  fully
     object-oriented,  but  all  methods  and members of internal
     objects are  in  fact  accessible  to  client  applications.
     Rather  than  being pedantic about "information hiding", the
     author tries to follow the principle that _X_p_T_a_b_l_e  is  going
     to be used by programmers, and programmers sometimes need to
     do things the author did not foresee.   The  structures  and
     methods  of the _X_p_T_a_b_l_e and all of its component objects are
     declared in the TableP.h include file.  Some  methods  which
     some  may find useful are XpTableLocFindPosition() and XpTa-
     bleLocFind() which clients can  use  to  find  the  location
     information  for  widgets  at  some  specific location in an
     _X_p_T_a_b_l_e, or for some specific widget in an _X_p_T_a_b_l_e.


  Classes
     _X_p_T_a_b_l_e  inherits  behavior   and   resources   from   Core,



Sun Release 4.1     Last change: 1 March 1992                   1






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



     Composite, and Constraint.

     The class pointer is xpTableWidgetClass.

     The class name is XpTable.


  New Resources
     The following table defines a set of widget  resources  used
     by  the programmer to specify data.  The programmer can also
     set the resource values for the  inherited  classes  to  set
     attributes for this widget.  To reference a resource by name
     or by class in an application defaults file, remove the  XtN
     or XtC prefix and use the remaining letters.

     The codes  in  the  access  column  indicate  if  the  given
     resource  can  be  set  at  creation  time (C), set by using
     XtSetValues (S), retrieved by using XtGetValues (G),  or  is
     not applicable (N/A).

     XpTable Resource Set
     Name              Class             Type        Default Access

     XtNlayout         XtCLayout         XpTableLoc  NULL    CSG
     XtNdefaultOptions XtCDefaultOptions XpTableOpts NULL    CSG
     XtNshrinkSimple   XtCShrinkSimple   Boolean     True    CSG
     XtNcolumnSpacing  XtCSpacing        int         0       CSG
     XtNrowSpacing     XtCSpacing        int         0       CSG
     XtNmarginWidth    XtCMarginWidth    int         0       CSG
     XtNmarginHeight   XtCMarginHeight   int         0       CSG

     XtNlayout
          Specifies the column, row, column span, row  span,  and
          options for each child.  The options field is optional,
          and takes the identical form of  the  XtNdefaultOptions
          resource  discussed below.  If no options are specified
          for a child, that childs options will be the  value  of
          the  XtNdefaultOptions resource when the child is first
          managed.  Children which are not named  in  the  layout
          specification  are  positioned in column 0, row 0, with
          colum and  row  spans  of  1,  and  using  the  default
          options.  If the layout is changed after the _X_p_T_a_b_l_e is
          created, then a complete re-layout is  performed.   The
          internal  type  XpTableLoc  which  must  be  passed  to
          XtCreateWidget() or to  XtSetValues()  is  obtained  by
          passing  a string representation of the layout specifi-
          cation to XpTableLocParse()  which  will  be  discussed
          below.   A  layout  resource  consists  of  one  layout
          specification per named child, with each layout specif-
          ication  being  separated  (or terminated) by a ";" and
          with each layout specification of the form:




Sun Release 4.1     Last change: 1 March 1992                   2






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



               <name> <col> <row> [<opts>]

     XtNdefaultOptions
          Specifies the layout options which apply to  all  chil-
          dren  which  do not have specific layout options in the
          child's layout specification.  The layout options allow
          a  child  widget to be justified within the table cell,
          and allow the initial  size  and  dynamic  resizing  of
          children  to  be  constrained.  Combinations of options
          can be used: tr means top and right, or north-east jus-
          tification.   Note  that  the justification does not do
          anything special with labels of any widgets, or text in
          any Text widgets: it simply sets the positioning of the
          entire child widget within the cell of the _X_p_T_a_b_l_e. The
          layout  options  consist  of  a series of adjacent case
          sensitive letters, each of which sets a layout option:

               l    left justify child in table cell.

               r    right justify child in table cell.

               t    top  justify child in table cell.

               b    bottom justify child in table cell.

               w    do not stretch width of column in which child
                    is  positioned during resizing.  Column width
                    will remain wide enough to contain the widest
                    child in the column.

               h    do not stretch height of row in  which  child
                    is  positioned  during  resizing.  Row height
                    will remain high enough to contain  the  tal-
                    lest child in the row.

               W    do not stretch width of child  during  resiz-
                    ing.   The  width  of  the  column  may  grow
                    (unless constrained by w), and the child will
                    be justified according to its layout options.

               H    do not stretch height of child during  resiz-
                    ing.  The height of the row  may grow (unless
                    constrained by h), and the child will be jus-
                    tified according to its layout options.

     XtNshrinkSimple
          Specifies if simple widgets (widgets  which  have  NULL
          query_geometry  methods)  should be forced smaller when
          the table widget is made smaller.  Such simple  widgets
          will  be  forced to their original preferred sizes, but
          not smaller.  By default, this is True.  Older versions
          of XpTable did not provide this feature, and so setting



Sun Release 4.1     Last change: 1 March 1992                   3






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



          this resource False will give the old  behavior,  which
          the author found obnoxious.

     XtNcolumnSpacing
          Specifies the number of pixels between columns.

     XtNrowSpacing
          Specifies the number of pixels between rows.

     XtNmarginWidth
          Specifies the number of pixels to the left of the first
          column  of  children  widgets, and the the right of the
          last column of children widgets.

     XtNmarginHeight
          Specifies the number of pixels above the first  row  of
          children  widgets,  and  below the last row of children
          widgets.


  Inherited Resources
     _X_p_T_a_b_l_e inherits behavior and resources from  the  following
     superclasses.   For a complete description of each resource,
     refer to the man page for that superclass.

     Composite Resource Set
     Name              Class              Type        Default Access

     XtNchildren       XtCReadOnly        WidgetList  NULL    G
     XtNinsertPosition XtCInsertPosition  (*)()       NULL    CSG
     XtNnumChildren    XtCReadOnly        Cardinal    0       G

     Core Resource Set
     Name                 Class                Type           Default Access

     XtNaccelerators      XtCAccelerators      XtAccelerators NULL    CSG
     XtNancestorSensitive XtCSensitive         Boolean        dynamic G
     XtNbackground        XtCBackground        Pixel          dynamic CSG
     XtNbackgroundPixmap  XtCPixmap            Pixmap  XtUNSPECIFIED_PIXMAP CSG
     XtNborderColor       XtCBorderColor       Pixel   XtDefaultForeground  CSG
     XtNborderPixmap      XtCPixmap            Pixmap  XtUNSPECIFIED_PIXMAP CSG
     XtNborderWidth       XtCBorderWidth       Dimension      0       CSG
     XtNcolormap          XtCColormap          Colormap       dynamic CG
     XtNdepth             XtCDepth             int            dynamic CG
     XtNdestroyCallback   XtCCallback          XtCallbackList NULL    C
     XtNheight            XtCHeight            Dimension      dynamic CSG
     XtNmappedWhenManaged XtCMappedWhenManaged Boolean        True    CSG
     XtNscreen            XtCScreen            Screen*        dynamic CG
     XtNsensitive         XtCSensitive         Boolean        True    CSG
     XtNtranslations      XtCTranslations      XtTranslations NULL    CSG
     XtNwidth             XtCWidth             Dimension      dynamic CSG
     XtNx                 XtCPosition          Position       0       CSG



Sun Release 4.1     Last change: 1 March 1992                   4






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



     XtNy                 XtCPosition          Position       0       CSG

SUPPORT PROCEDURES
     _X_p_T_a_b_l_e provides  the  following  procedures  and  functions
     which  can be used to create and manipulate _X_p_T_a_b_l_e_s and the
     children of _X_p_T_a_b_l_e_s:

     XpTableLoc XpTableLocParse( char* layout );
     void XpTableLocFree( XpTableLoc toFree );
     XpTableOpts XpTableOptsParse( char* options );
     void XpTableChildPosition( Widget child, int col, int row );
     void XpTableChildResize( Widget child, int col_span, int row_span );
     void XpTableChildOptions( Widget child, XpTableOpts opts );
     void XpTableChildConfig( Widget child,
                              int col, int row, int col_span, int row_span,
                              XpTableOpts opts );
     Widget XpCreateTable( Widget, char*, ArgList, Cardinal );
     Widget XpCreateTableDialog( Widget, char*, ArgList, Cardinal );
     Widget XpCreateTableTransient( Widget, char*, ArgList, Cardinal );

     Each of these routines can also  be  invoked  from  resource
     files, as the Xp library procedure XpRegisterAthena() regis-
     ters the names of each of these procedures as  both  actions
     and  callbacks with the Wcl string-to-callback converter and
     with the Xt Translation Manager.  These  routines  are  dis-
     cussed in more detail below.

     XpTableLoc XpTableLocParse( char* layout );
          This function takes a string which specifies  a  layout
          resource  for  and  _X_p_T_a_b_l_e widget and returns an XpTa-
          bleLoc, a pointer to an opaque  type,  which  can  then
          passed  to  XtCreateWidget(),  any of the XpCreateTable
          constructors, or to XtSetValues(). The  _X_p_T_a_b_l_e  copies
          the  storage,  and  so  the  XpTableLoc storage must be
          released by the client when  no  longer  needed  (often
          immediately  after  use)  by  passing the XpTableLoc to
          XpTableLocFree().

     void XpTableLocFree( XpTableLoc toFree );
          This procedure releases the storage pointed to  by  the
          XpTableLoc opaque pointer.

     XpTableOpts XpTableOptsParse( char* options );
          This function parses the options specifier string  into
          an   XpTableOpts   which  can  then  be  passed  to  .B
          XtCreateWidget(), any of  the  XpCreateTable  construc-
          tors,  or to XtSetValues(). XpTableOpts is typedef'd to
          a standard machine data type (currently an int), and so
          does not need to be free'd.

     void XpTableChildPosition( Widget child, int col, int row );
          This procedure allows a child of an _X_p_T_a_b_l_e  widget  to



Sun Release 4.1     Last change: 1 March 1992                   5






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



          be  moved to a different cell.  If the child spans mul-
          tiple columns and/or rows, the column and row indicates
          the  upper  left  corner  of  the  child  widget.   The
          defaultLayout  resource  of  the  _X_p_T_a_b_l_e  is  actually
          changed  by  this procedure, so the new location of the
          child will be remembered even if the child is unmanaged
          and  re-managed.   The  layout of the _X_p_T_a_b_l_e is recom-
          puted, which means all issues involved in the position-
          ing  and  sizes of all children of the _X_p_T_a_b_l_e are also
          re-analyzed.  For example, if the child widget has  the
          option  W specified, then the column to which the child
          widget is moved will then be  prevented  from  becoming
          wider,  and the column from which the child widget came
          may be enabled to be made wider.

     void XpTableChildResize( Widget, int col_span, int row_span );
          This  procedure  allows a child of an _X_p_T_a_b_l_e widget to
          be resized so the child spans  a  different  number  of
          columns  or  rows.  Again, the layout of the _X_p_T_a_b_l_e is
          recomputed, which means  all  issues  involved  in  the
          positioning  and  sizes  of all children of the _X_p_T_a_b_l_e
          are re-analyzed.  For example, if the child widget  has
          the  option  W specified, then all of the columns which
          the child widget spans will be prevented from  becoming
          wider.

     void XpTableChildOptions( Widget child, XpTableOpts opts );
          This procedure allows a child of an _X_p_T_a_b_l_e  widget  to
          have  its layout options changed.  Again, the layout of
          the _X_p_T_a_b_l_e  is  recomputed,  which  means  all  issues
          involved  in  the positioning and sizes of all children
          of the _X_p_T_a_b_l_e are re-analyzed.  For  example,  if  the
          child  widget  has  the option W specified, then all of
          the columns  which  the  child  widget  spans  will  be
          prevented from becoming wider.

     void XpTableChildConfig( Widget child,
                               int col, int row,
                               int col_span, int row_span,
                               XpTableOpts opts );

          This procedure allows a child of an _X_p_T_a_b_l_e  widget  to
          have all of its layout specifications changed at once.

     Widget XpCreateTable( Widget, char*, ArgList, Cardinal );
          This function creates a new _X_p_T_a_b_l_e widget.  The _W_i_d_g_e_t
          argument  specifies  the  parent  widget  ID, the _c_h_a_r*
          argument specifies the name of the created widget,  the
          _A_r_g_L_i_s_t  argument  specifies the argument list, and the
          _C_a_r_d_i_n_a_l   argument    specifies    the    number    of
          attribute/value  pairs  in the argument list.  but with
          the characters "_popup" concatenated to the  end.   The



Sun Release 4.1     Last change: 1 March 1992                   6






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



          _W_i_d_g_e_t  argument  specifies  the  parent widget ID, the
          _c_h_a_r*  argument  specifies  the  name  of  the  created
          _X_p_T_a_b_l_e  widget,  the  _A_r_g_L_i_s_t  argument  specifies the
          argument list, and the _C_a_r_d_i_n_a_l argument specifies  the
          number of attribute/value pairs in the argument list.

     Widget XpCreateTableTransient(Widget,char*,ArgList,Cardinal);
          This  function  creates a new _X_p_T_a_b_l_e widget as a child
          of a new _X_t_T_r_a_n_s_i_e_n_t_S_h_e_l_l. The name of the new  _X_t_T_r_a_n_-
          _s_i_e_n_t_S_h_e_l_l  has  the  same  name as the new _X_p_T_a_b_l_e but
          with the characters "_popup" concatenated to  the  end.
          The _W_i_d_g_e_t argument specifies the parent widget ID, the
          _c_h_a_r*  argument  specifies  the  name  of  the  created
          _X_p_T_a_b_l_e  widget,  the  _A_r_g_L_i_s_t  argument  specifies the
          argument list, and the _C_a_r_d_i_n_a_l argument specifies  the
          number of attribute/value pairs in the argument list.

ACTIONS AND CALLBACKS
     The Xp library provides the following callbacks and  actions
     for manipulating children of XpTable widgets:

     XpTableChildConfig( widget col row [h_span [v_span [opts]]] )
     XpTableChildPosition( widget col row )
     XpTableChildResize( widget h_span v_span )
     XpTableChildOptions( widget options )

     Each callback procedure can also be named in resource  files
     as  the  name  of  the  procedure followed by CB: i.e, XpTa-
     bleChildConfig() can also be invoked as a callback by giving
     the  name  XpTableChildConfigCB()  for  a  callback resource
     value.  Also, each action procedure can  also  be  named  by
     appending  ACT  to the procedure name.  Normally, I just use
     the procedure name, so it is less trouble to change behavior
     from  callbacks  to  actions  triggered  by  translations or
     accelerators, and vice versa.  The CB and  ACT  endings  are
     maintained for backward compatibility, and because some peo-
     ple like to be more explicit.  It is all a matter of taste.

     Arguments to the procedures are  provided  as  strings,  the
     characters  between  the parenthesis following the procedure
     name.  If no parenthesis follow the procedure name,  then  a
     NULL  string  is  passed  to the procedure.  Some procedures
     require arguments, some provide reasonable defaults when  no
     arguments are given.  For example:

          *foo.select:       XpTableChildPosition( this 2 4 )

     Each _X_p_T_a_b_l_e callback and action procedure is  discussed  in
     detail below.

     XpTableChildConfig( w col row [h_span [v_span [opts]]] )
          This allows a child of an XpTable to be moved to a  new



Sun Release 4.1     Last change: 1 March 1992                   7






XpTable(3)             C LIBRARY FUNCTIONS             XpTable(3)



          row  or  column,  to be given a different horizontal or
          vertical span, and to change the justification and  re-
          size options of the child.

     XpTableChildPosition( w col row )
          This allows a child of an XpTable to be moved to a  new
          row or column.

     XpTableChildResize( w h_span v_span )
          This allows a child of an XpTable to be  given  a  dif-
          ferent horizontal or vertical span.

     XpTableChildOptions( w options )
          This allows a child of an XpTable to be given new  jus-
          tification and re-size options.

SEE ALSO
     Xp (3), Xcp (3), Xop (3), Ari (1), Cri  (1),  Ori  (1),  Wcl
     (3), X (1), Core (3X), Composite (3X), Constraint (3X).

AUTHORS
     David E. Smyth  (David.Smyth@sniap.mchp.sni.de)  at  Siemens
     Nixdorf  Informationssysteme AG, Munich Germany.  The origi-
     nal Table widget on which the external  interface  and  many
     concepts  of  the  _X_p_T_a_b_l_e were derived was written by David
     Harrison in 1989 while he was at the University of  Califor-
     nia, Berkeley.




























Sun Release 4.1     Last change: 1 March 1992                   8



