%{

#include "Parser.h"


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

string parsetext = NULL;


%}

%s OUTER_COND
%s DOMAIN_COND SUBHOST_COND GATEWAYS_COND
%s LAYOUT_COND LAYOUTINNER_COND NICK_COND BUTTON_COND BUTTONCOMMAND_COND
%s NOUSER_COND

SPACE		[ \t]*
INTEGER		[0-9]+
LETTER		[A-Za-z_0-9\-\.]
STRING		{LETTER}+
NICKNAME	{LETTER}{1,8}
LABEL		[^"\n]{0,100}
REGEX		[A-Za-z_0-9\-\.\/\+\*\?\^\$\|\(\)\[\]\{\}]+

%%

\{{SPACE}\n	{ ylineno++; return OPEN; }
\{		return OPEN;
\}		return CLOSE;
<<EOF>>		{ YY_NEW_FILE; return CLOSE; }

<OUTER_COND>THIS_DOMAIN		return DOMAIN;
<OUTER_COND>GATEWAYS		return GATEWAYS;
<OUTER_COND>DISPLAY-LAYOUT	return LAYOUT;
<OUTER_COND>NICKNAMES		return NICKNAME;
<OUTER_COND>COMMAND-BUTTONS	return BUTTON;
<OUTER_COND>NOUSER-STRING	return NOUSER;

<DOMAIN_COND>^{STRING}:		return HOST;
<DOMAIN_COND>port{SPACE}=	return PORT;
<DOMAIN_COND>{INTEGER}		return INTEGER;
<DOMAIN_COND>subhost{SPACE}=	return SUBHOST;

<SUBHOST_COND>{STRING}	return HOST;
<SUBHOST_COND>[^ \t\n]+	return FILENAME;
<SUBHOST_COND>\n	{ ylineno++; return CLOSE; }

<GATEWAYS_COND>^{STRING}:	return HOST;
<GATEWAYS_COND>port{SPACE}=	return PORT;

<LAYOUT_COND>default     return DEFAULT;
<LAYOUT_COND>\"{LABEL}\" return LABEL;
<LAYOUT_COND>{REGEX}     return REGEX;

<LAYOUTINNER_COND>MENU		return MENU;
<LAYOUTINNER_COND>\"{LABEL}\"	return LABEL;
<LAYOUTINNER_COND>{STRING}	return HOST;
<LAYOUTINNER_COND>\[{INTEGER}\]	return COUNT;
<LAYOUTINNER_COND>\n		{ ylineno++; return NL; }

<NICK_COND>{NICKNAME}    return NICK;
<NICK_COND>\({STRING}\)  return NICKGROUP;
<NICK_COND>=             return EQ;

<BUTTON_COND>\"{LABEL}\"        return LABEL;
<BUTTONCOMMAND_COND>[^ \t\n].*$ return COMMAND;

<NOUSER_COND>\".{8}\"	return LABEL;

{SPACE}		; /* WHITESPACE */
\\*\n		ylineno++;
#.*$		; /* COMMENT */

{STRING}	return UNKNOWN;
.		return UNKNOWN;

%%


/*----------------------------------------------------------------------------*/
int
    ParseConfig()
{
	BEGIN(OUTER_COND);
	StrFree(&parsetext);
	return (yylex());
}


/*----------------------------------------------------------------------------*/
int
    ParseDomain()
{
	int yret;

	BEGIN(DOMAIN_COND);
	switch (yret = yylex()) {
	    case HOST:
		StrTrueReAlloc(&parsetext, yytext);
		parsetext[strlen(parsetext)-1] = '\0';
		break;
	    case PORT:
		if (yylex() == INTEGER)
		    StrTrueReAlloc(&parsetext, yytext);
		else
		    yerror("illegal portnumber");
		break;
	    default:
		StrTrueReAlloc(&parsetext, yytext);
	}
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseSubhost()
{
	int yret;

	BEGIN(SUBHOST_COND);
	yret = yylex();
	StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseGateways()
{
	int yret;

	BEGIN(GATEWAYS_COND);
	yret = yylex();
	StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseRCFile()
{
	BEGIN(OUTER_COND);
	StrFree(&parsetext);
	return (yylex());
}


/*----------------------------------------------------------------------------*/
int
    ParseLayout()
{
	int yret;

	BEGIN(LAYOUT_COND);
	yret = yylex();
	if (yret == LABEL) {
		StrTrueReAlloc(&parsetext, yytext+1);
		parsetext[strlen(parsetext)-1] = '\0';
	}
	else
	    StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseLayoutInner()
{
	int yret;

	BEGIN(LAYOUTINNER_COND);
	yret = yylex();
	if (yret == LABEL || yret == COUNT) {
		StrTrueReAlloc(&parsetext, yytext+1);
		parsetext[strlen(parsetext)-1] = '\0';
	}
	else
	    StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseNicknames()
{
	int yret;

	BEGIN(NICK_COND);
	yret = yylex();
	if (yret == NICKGROUP) {
		StrTrueReAlloc(&parsetext, yytext+1);
		parsetext[strlen(parsetext)-1] = '\0';
	}
	else
	    StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseButtons()
{
	int yret;

	BEGIN(BUTTON_COND);
	yret = yylex();
	if (yret == LABEL) {
		StrTrueReAlloc(&parsetext, yytext+1);
		parsetext[strlen(parsetext)-1] = '\0';
	}
	else
	    StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseButtonCommand()
{
	int yret;

	BEGIN(BUTTONCOMMAND_COND);
	yret = yylex();
	StrTrueReAlloc(&parsetext, yytext);
	return (yret);
}


/*----------------------------------------------------------------------------*/
int
    ParseNoUser()
{
	int yret;

	BEGIN(NOUSER_COND);
	yret = yylex();
	StrTrueReAlloc(&parsetext, yytext+1);
	parsetext[strlen(parsetext)-1] = '\0';
	return (yret);
}
