/******************************************************************************
 * $RCSfile: ReadRCFile.c,v $   $Revision: 1.8 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "Parser.h"

extern FILE* yyin;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    ReadRCFile();

static void
    ReadLayout();

static void
    ReadLayoutInner();

static void
    ReadNicknames();

static void
    ReadButtons();

static void
    ReadNoUser();


/*----------------------------------------------------------------------------*/
void
    ReadClientConfig(string rcfile,
		     string layout_tag)
{
	Free_nicklist();

	ylineno = 1;
	StrTrueReAlloc(&yfile, DEFAULT_RCFILE);
	if ((yyin = fopen(yfile,"r"))  !=  NULL) {
		ReadRCFile(layout_tag);
		fclose(yyin);
	}
	else
	    Warning("\"%s\" not found", yfile);

	ylineno = 1;
	StrTrueReAlloc(&yfile, rcfile);
	if ((yyin = fopen(yfile,"r"))  !=  NULL) {
		ReadRCFile(layout_tag);
		fclose(yyin);
	}
	else
	    Warning("\"%s\" not found", yfile);

	if (Empty_widgetlines())
	    yerror("can't find layout definition");

	StrFree(&yfile);
}


/*----------------------------------------------------------------------------*/
static void
    ReadRCFile(string layout_tag)
{
	int isready;

	isready = 0;
	while (!isready) {
		switch (ParseRCFile()) {
		    case LAYOUT:
			ReadLayout(layout_tag);
			break;
		    case NICKNAME:
			ReadNicknames();
			break;
		    case BUTTON:
			ReadButtons();
			break;
		    case NOUSER:
			ReadNoUser();
			break;
		    case CLOSE:
			isready = 1;
			break;
		    default:
			yerror("illegal keyword");
		}
	}
}


/*----------------------------------------------------------------------------*/
static void
    ReadLayout(string layout_tag)
{
	string this_tag = NULL;
	int isready;
	int layoutready = 0;
	int token;

	if ((token = ParseLayout()) == LABEL) {
		StrTrueReAlloc(&this_tag, parsetext);
		token = ParseLayout();
	}
	if (token != OPEN)
	    yerror("{ not found");

	if (this_tag != NULL)
	    Add_layoutentries(this_tag);
	else
	    Add_layoutentries("default");

	if (layout_tag != NULL && strcmp(layout_tag,"default") != 0) {
		if (this_tag != NULL && strcmp(layout_tag,this_tag) == 0)
		    Free_widgetlines();
		else
		    layoutready = 1;
	}
	else
	    if (this_tag == NULL || Empty_widgetlines())
		Free_widgetlines();
	    else
		layoutready = 1;
	    
	StrFree(&this_tag);

	isready = 0;
	while (!isready) {

		switch (ParseLayout()) {
		    case DEFAULT:
			if (!layoutready)
			    ReadLayoutInner();
			break;
		    case REGEX:
			if (!layoutready  &&
			    StrMatch(mydisplayhostname,parsetext)) {
				ReadLayoutInner();
				layoutready = 1;
			}
			break;
		    case OPEN:
			while (ParseLayout() != CLOSE);
			break;
		    case CLOSE:
			isready = 1;
			break;
		    default:
			ywarn("illegal hostname");
		}
	}
}


/*----------------------------------------------------------------------------*/
static void
    ReadLayoutInner()
{
	int isready;
	list curwline = NULL;

	Free_widgetlines();

	isready = 0;
	while (!isready) {
		switch (ParseLayout()) {
		    case OPEN:
			isready = 1;
			break;
		    case DEFAULT:
		    case REGEX:
			break;
		    default:
			ywarn("illegal hostname");
		}
	}

	isready = 0;
	while (!isready) {
		xwhowidget neww;

		switch (ParseLayoutInner()) {
		    case HOST:
			if (strcmp(parsetext, "localhost") == 0)
			    StrTrueReAlloc(&parsetext, myhostname);
			if (TestHostname(parsetext))
			    neww = Init_xwhowidget(HOST_W, parsetext);
			else {
				ywarn("illegal hostname in DISPLAY-LAYOUT");
				neww = Init_xwhowidget(LABEL_W, "NoHost");
			}
			AppendTrue_list(&curwline, (void*)neww);
			break;
		    case LABEL:
			neww = Init_xwhowidget(LABEL_W, parsetext);
			AppendTrue_list(&curwline, (void*)neww);
			break;
		    case MENU:
			neww = Init_xwhowidget(MENU_W, NULL);
			AppendTrue_list(&curwline, (void*)neww);
			break;
		    case COUNT:
			if (neww == NULL)
			    yerror("misplaced [n]");
			{
				int columns = atoi(parsetext) - 1;

				if (columns > 0)
				    neww->columns += columns;
				else
				    ywarn("illegal value");
			}
			break;
		    case NL:
			if (! Empty_list(curwline)) {
				Add_widgetlines(curwline);
				curwline = NULL;
				neww = NULL;
			}
			break;
		    case CLOSE:
			if (! Empty_list(curwline))
			    Add_widgetlines(curwline);
			isready = 1;
			break;
		    default:
			yerror("illegal value");
		}
	}
}


/*----------------------------------------------------------------------------*/
static void
    ReadNicknames()
{
	int status = 0;
	int isready;
	xwhonick newnick = NULL;

	if (ParseNicknames() != OPEN)
	    yerror("{ not found");

	Free_nicklist();

	isready = 0;
	while (!isready) {
		switch (status) {
		    case 0:
			switch (ParseNicknames()) {
			    case NICK:
				newnick = Init_xwhonick(parsetext);
				status = 1;
				break;
			    case NICKGROUP:
				ywarn("nickname missing");
				break;
			    case EQ:
				ywarn("misplaced =");
				break;
			    case CLOSE:
				isready = 1;
				break;
			    default:
				ywarn("invalid nickname");
			}
			break;
		    case 1:
			switch (ParseNicknames()) {
			    case NICKGROUP:
				{
					static Widget shell = NULL;
					Widget w;
					Pixel bg, fg;

					if (shell == NULL)
					    shell = XtVaAppCreateShell("xwho", "XWho",
								       applicationShellWidgetClass, mydisplay,
								       NULL, NULL);
					w = XtVaCreateManagedWidget(parsetext, commandWidgetClass, shell, NULL);
					XtVaGetValues(w,
						      XtNbackground, &bg,
						      XtNforeground, &fg,
						      NULL);
					XtDestroyWidget(w);
					SetColors_xwhonick(newnick, bg, fg);
				}
				status = 2;
				break;
			    case EQ:
				status = 3;
				break;
			    case CLOSE:
				ywarn("misplaced or missing }");
				isready = 1;
				break;
			    default:
				ywarn("invalid nickname");
			}
			break;
		    case 2:
			switch (ParseNicknames()) {
			    case EQ:
				status = 3;
				break;
			    case CLOSE:
				ywarn("misplaced or missing }");
				isready = 1;
				break;
			    default:
				ywarn("= not found");
				status = 0;
			}
			break;
		    case 3:
			switch (ParseNicknames()) {
			    case NICK:
				AddLogin_xwhonick(newnick, parsetext);
				Add_nicklist(newnick);
				newnick = NULL;
				status = 0;
				break;
			    case EQ:
				ywarn("misplaced =");
				status = 0;
				break;
			    case CLOSE:
				ywarn("misplaced or missing }");
				isready = 1;
				break;
			    default:
				ywarn("invalid nickname");
				Free_xwhonick((void**)&newnick);
				newnick = NULL;
				status = 0;
			}
		}
	}

	Free_xwhonick((void**)&newnick);
}


/*----------------------------------------------------------------------------*/
static void
    ReadButtons()
{
	int status = 0;
	int isready;
	xwhopopupbutton newbutton = NULL;

	if (ParseButtons() != OPEN)
	    yerror("{ not found");

	Free_popupbuttons();

	isready = 0;
	while (! isready) {
		switch (status) {
		    case 0:
			switch (ParseButtons()) {
			    case LABEL:
				if (newbutton != NULL)
				    Add_popupbuttons(newbutton);
				newbutton = Init_xwhopopupbutton(parsetext);
				status = 1;
				break;
			    case CLOSE:
				isready = 1;
				break;
			    default:
				ywarn("wrong button-name");
			}
			break;
		    case 1:
			switch (ParseButtonCommand()) {
			    case COMMAND:
				SetCommand_xwhopopupbutton(newbutton,
							   parsetext);
				status = 0;
				break;
			    case CLOSE:
				isready = 1;
				Free_xwhopopupbutton((void**)&newbutton);
				break;
			    default:
				ywarn("illegal button-command");
			}
		}
	}

	if (newbutton != NULL)
	    Add_popupbuttons(newbutton);
}


/*----------------------------------------------------------------------------*/
static void
    ReadNoUser()
{
	if (ParseNoUser() == LABEL)
	    StrTrueReAlloc(&nouser, parsetext);
	else
	    yerror("no legal label-string");
}
