/******************************************************************************
 * $RCSfile: xwhod.c,v $   $Revision: 1.29 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"
#include <unistd.h>
#include <signal.h>
#include <sys/resource.h>

extern int
    setpriority(int, int, int);


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

string myhostname = NULL;
const int verboseflag = 0;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static void
    StreamBreak();


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static int superserverflag = 0;
static char** arguments;


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void
    main(int argc,
	 char* argv[])
{
	xwhodaemon thisdaemon;
	xwhodservedhosts hosts;
	int myport;
	xwhodclients clients = New_xwhodclients();
	conn listenconn;
	int niceval = 0;

	arguments = argv;


	/* init global variables */
	programname = "xwhod";
	StrTrueReAlloc(&myhostname, GetFullHostname());


	signal(SIGPIPE, SIG_IGN);


	{
		int c;
		extern int optind;
		extern char* optarg;

		while ((c = getopt(argc, argv, "n:s")) != -1) {
			switch (c) {
			    case 'n':
				niceval = atoi(optarg);
				break;
			    case 's':
				superserverflag = 1;
				break;
			    default:
				Error(-1, "wrong arguments");
			}
		}
		if (optind < argc)
		    Error(-1, "wrong arguments");
	}


	/* init a daemon process */
	close(0);
	close(1);
	close(2);
	signal(SIGPIPE, StreamBreak);
	signal(SIGALRM, StreamBreak);

	if (! superserverflag) {
		pid_t procid;

		if ((procid = fork()) < 0)
		    Error(-1, "can't fork");
		if (procid != 0)
		    exit(0);  /* terminate the parent */
	}

	setsid();    /* become session leader */
	chdir("/");  /* prevent blocking of mounted filesystems */
	umask(0);    /* clear file creation mask */
#if defined(SVR4) || defined(aix)
	nice(niceval - 20);
#else
	setpriority(PRIO_PROCESS, 0, niceval);
#endif

#ifdef _DEBUG
	{
		FILE* errstream;

		errstream = fopen("/tmp/xwhod.errors", "a");
		if (errstream != NULL)
		    errout = errstream;
	}
#else
	errout = NULL;
#endif

	/* build the list of hosts to serve */
	thisdaemon = GetConfigServer(myhostname);
	if (thisdaemon == NULL)
	    thisdaemon = Init_xwhodaemon(myhostname);
	else
	    thisdaemon = Copy_xwhodaemon(thisdaemon);
	if (strcmp(myhostname, GetHostnameByName(thisdaemon->hostname)) != 0)
	    Error(-1, "no server-host");
	myport = thisdaemon->port;
	hosts = Copy_xwhodservedhosts(thisdaemon->subhosts);
	EndConfig();


	/* open the listen-connection */
	listenconn = Open_conn(NULL, myport, myport, CONN_STREAM);
	if (listenconn == NULL)
	    Error(-1, "can't open listen-connection on port %d", myport);


	while (1) {
		conn clientconn;

		/* waiting for clients to connect */
		if (verboseflag)
		    puts("waiting for connections ...");
		clientconn = Accept_conn(listenconn, XWHOD_WAIT_SEC);

		/* read the utmp-files for the served hosts and send the
		 * changed login-data to the clients */
		if (clients != NULL  ||  clientconn != NULL) {
			xwhodservedhosts changed;

			Update_xwhodservedhosts(hosts);

			/* start to serve a new client */
			if (clientconn != NULL) {
				alarm(XWHOD_CONN_TIMEOUT);  /* prevent the incoming connection from hanging */
				if (verboseflag)
				    puts("reading the connection ...");
				Add_xwhodclients(&clients,
						 Init_xwhodclient(clientconn,
								  hosts));
				Close_conn(&clientconn);
				alarm(0);  /* remove the hanging-alarm */
			}

			changed = Changed_xwhodservedhosts(hosts);
			if (changed != NULL) {
				xwhodservedhost h;

				while ((h = TakeOut_xwhodservedhosts(&changed))
				       != NULL) {
					Serve_xwhodclients(clients, h);
				}
			}

			/* remove clients from the client-list, if their
			 * subscription is timed out */
			TimeOut_xwhodclients(&clients);
			if (superserverflag && clients == NULL)
			    Error(0, "clients timed out, exiting ...");
		}
	}
}


/*----------------------------------------------------------------------------*/
static void
    StreamBreak()
{
	/* this function is called when the connection to a client is premature
	 * interrupted or seems to hang in a read()-call.  The savest way to
	 * solve this problem seems to me, to restart this server */

	if (superserverflag)
	    Error(-1, "stream to client broken");
	else {
		extern char** environ;

		execve(SERVER_BINARY, arguments, environ);
		exit (-1);  /* just in case */
	}
}
