/******************************************************************************
 * $RCSfile: xwhologin.h,v $   $Revision: 1.6 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

enum xwhousertype {
	NO_T, USER_T, ALIAS_T, GROUP_T, ME_T
};


struct xwhotty {
	string tty;
	string rhost;
};
typedef struct xwhotty * xwhotty;
typedef list xwhottys;

struct xwhologin {
	string login;
	string fullname;
	string nick;
	xwhottys ttys;
	int islocal;
};
typedef struct xwhologin * xwhologin;
typedef list xwhologins;


/*----------------------------------------------------------------------------*
 * extern prototypes
 *----------------------------------------------------------------------------*/

extern xwhologins
    New_xwhologins();

extern xwhologins
    Get_xwhologins(void*);

extern void
    Add_xwhologins(xwhologins*, xwhologin);

extern xwhologin
    TakeOut_xwhologins(xwhologins*);

extern int
    Cmp_xwhologins(xwhologins, xwhologins);

extern void
    Send_xwhologins(conn, xwhologins);

extern xwhologins
    Recv_xwhologins(conn);

extern void
    InOrder_xwhologins(xwhologins, void (*)(void*));

extern void
    Free_xwhologins(void**);


extern int
    Cmp_xwhologin(void*, void*);

extern int
    IsLocal_xwhologin(xwhologin);

extern void
    Free_xwhologin(void**);


extern int
    Cmp_xwhottys(xwhottys, xwhottys);

extern void
    InOrder_xwhottys(xwhottys, void (*)(void*));

extern int
    IsLocal_xwhottys(xwhottys, string);
