/******************************************************************************
 * $RCSfile: xwhopopupbutton.c,v $   $Revision: 1.6 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"

extern int verboseflag;


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static xwhopopupbuttons popupbuttons = NULL;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static string
    EvalCommand(string, xwhowidget);


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*--- popupbuttons -----------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
void
    Add_popupbuttons(xwhopopupbutton b)
{
	xwhopopupbutton old;

	if (popupbuttons == NULL)
	    popupbuttons = New_list();
	if ((old = Del_list((list*)&popupbuttons, (void*)b, NULL,
			    Cmp_xwhopopupbutton))  !=  NULL)
	    Free_xwhopopupbutton((void**)&old);
	AppendTrue_list((list*)&popupbuttons, (void*)b);
}


/*----------------------------------------------------------------------------*/
void
    Create_popupbuttons(Widget parent,
			xwhowidget w)
{
	list l;

	for (l = popupbuttons; ! Empty_list(l); l = Next_list(l)) {
		xwhopopupbutton b = First_list(l);

		XawDialogAddButton(parent, b->name,
				   (XtCallbackProc)Call_xwhopopupbutton,
				   (XtPointer)w);
	}
}


/*----------------------------------------------------------------------------*/
xwhopopupbutton
    Seek_popupbuttons(string name)
{
	struct xwhopopupbutton b;

	b.name = name;
	return ( Seek_list(popupbuttons, &b, NULL, Cmp_xwhopopupbutton) );
}


/*----------------------------------------------------------------------------*/
void
    Free_popupbuttons()
{
	Free_xwhopopupbuttons((void**)&popupbuttons);
}


/*--- xwhopopupbuttons -------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhopopupbuttons
    New_xwhopopupbuttons()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhopopupbuttons(void** bl_ref)
{
	Free_list((list*)bl_ref, Free_xwhopopupbutton);
}


/*--- xwhopopupbutton --------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhopopupbutton
    New_xwhopopupbutton()
{
	xwhopopupbutton b;

	b = (xwhopopupbutton)TrueReAlloc(NULL, 1,
					 sizeof (struct xwhopopupbutton));
	b->name = b->command = NULL;
	return (b);
}


/*----------------------------------------------------------------------------*/
xwhopopupbutton
    Init_xwhopopupbutton(string name)
{
	xwhopopupbutton b = New_xwhopopupbutton();

	StrTrueReAlloc(&(b->name), name);
	return (b);
}


/*----------------------------------------------------------------------------*/
void
    SetCommand_xwhopopupbutton(xwhopopupbutton b,
			       string command)
{
	StrTrueReAlloc(&(b->command), command);
}


/*----------------------------------------------------------------------------*/
int
    Cmp_xwhopopupbutton(void* button1,
			void* button2)
{
	xwhopopupbutton b1 = button1;
	xwhopopupbutton b2 = button2;

	return ( strcmp(b1->name, b2->name) );
}


/*----------------------------------------------------------------------------*/
void
    Call_xwhopopupbutton(Widget widget,
			 xwhowidget w)
{
	xwhopopupbutton button;
	char* label;

	DestroyLastPopup();
	XtVaGetValues(widget, XtNlabel, &label, NULL);
	if ((button = Seek_popupbuttons(label)) != NULL  &&
	    button->command != NULL) {
		string command = EvalCommand(button->command, w);

		if (verboseflag)
		    printf("/bin/sh -c %s\n", command);
		system(command);
		StrFree(&command);
	}
	else
	    Warning("command for \"%s\" not found", label);
}


/*- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
static string
    EvalCommand(string str,
		xwhowidget w)
{
	string command = NULL;
	char* s;

	for (s = str; *s != '\0'; s++)
	    if (*s == '%')
		switch (*++s) {
		    case 'd':
			StrTrueCat(&command, mydisplayhostname);
			break;
		    case 'h':
			StrTrueCat(&command, w->host.name);
			break;
		    case 'u':
			if (w->host.login != NULL)
			    StrTrueCat(&command, w->host.login->login);
			else
			    StrTrueCat(&command, "NoUser");
			break;
		    case 'n':
			if (w->host.login != NULL)
			    if (w->host.login->nick != NULL &&
				w->host.login->nick[0] != '\0')
				StrTrueCat(&command, w->host.login->nick);
			    else
				StrTrueCat(&command, w->host.login->login);
			else
			    StrTrueCat(&command, "NoUser");
			break;
		    case '%':
			StrTrueAppend(&command, '%');
			break;
		    default:
			Warning("error in command definition \"%s\"", str);
			StrFree(&command);
			return (command);
		    }
	    else
		StrTrueAppend(&command, *s);

	return (command);
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhopopupbutton(void** b_ref)
{
	xwhopopupbutton b = *b_ref;

	if (b != NULL) {
		StrFree(&(b->name));
		StrFree(&(b->command));
		Free(b_ref);
	}
}
