/*
 *  basename()  -   return a file's basename
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      Basename parses a char string containing a path name and
 *      returns a pointer to the file's base name.
 *
 *  Input Parameters:
 *      char *path  -   the fully qualified path to parse
 *
 *  Output Parameters:
 *      None.
 *
 *  Return Values:
 *      (char *)    -   a pointer to the start of the base name within
 *                      'path'
 *
 *  Side Effects:
 *      None.
 *
 *  Limitations and Comments:
 *      Basename handles both DOS and UNIX path separators; it also
 *      handles the DOS device delimiter.
 *
 *      Note that this function can return NULL.
 *
 *  Development History:
 *      3/26/92, jps, first cut
 */

#include "xhead.h"
#include "xymrolo.h"

char *basename(path)
char *path;
{
    char *cptr;
    
    for (cptr = path + strlen(path); cptr >= path; --cptr)
        switch (*cptr)
        {
            case ':':
            case '/':
            case '\\':
                return ++cptr;
        }
        
    return path;
}

#ifdef TEST

main()
{
    int i;
    static char *paths[9] = {
        "",
        "a",
        "a:",
        "a:file.c",
        "file.c",
        "/file.c",
        "\\file.c",
        "/down/the/garden/path/file.c",
        "\\down\\the\\garden\\path\\file.c"
    };
    
    for (i = 0; i < 9; ++i)
        printf("\"%s\" resolves to \"%s\"\n", paths[i], 
                basename(paths[i]));
}

#endif
