/*
 *  PrintFileCB()   - callback routine for Print button in print dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   25-Mar-95   first cut
 */


#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

void PrintFileCB (widget, client_data, call_data)
Widget
    widget;
XtPointer
    client_data,
    call_data;
{
    char
        *print_to = (char *) NULL;

    char
        filename[MaxTextLength];

    int
        rc = 0;

    if (XmToggleButtonGadgetGetState(GprintToFileTbW))
    {
        /*
        ** printing to a file
        */
        print_to = XmTextFieldGetString (GprintToFileTextW);
        if ((int) strlen(print_to) == 0)
        {
            WriteStatus(1,rolomessageTextW, 
                "No filename given for printing!");
            return;
        }
        (void) strcpy (filename, print_to);
#ifdef DEBUG
        (void) fprintf (stderr,"Print to file: %s\n", filename);
#endif        
    }
    else
    {
        /*
        ** printing to the printer
        */
        print_to = XmTextFieldGetString (GprintCommandTextW);
        if ((int) strlen(print_to) == 0)
        {
            WriteStatus(1,rolomessageTextW,
                "Empty Print Command!");
            return;
        }
        (void) sprintf (filename, "|%s", print_to);
#ifdef DEBUG
        (void) fprintf (stderr,"Print command: %s\n", filename);
#endif        
    }


    /*
    ** if the destination is a file, check if the file exists
    */

    if (*filename != '|')
    {
        unsigned int
            status;

        /*
        ** expand file
        */

        status = ExpandTilde (filename);
        if (status == False)
        {
            WriteStatus(1,rolomessageTextW,
                "Failed to Expand filename!");
            return;
        }
        
        /*
        ** check the existence, validity etc.
        */

        rc = CheckFile (filename, 0);

        switch (rc)
        {
            case FILE_IS_A_DIRECTORY:
            {
                WriteStatus (1, rolomessageTextW,
                    "File is a Directory! Could not print!");
                return;
                break;
            }

            case FILE_EXISTS:
            {
                char
                    message[500];

                 (void) sprintf (message, 
                    "File \"%s\" exists! Want to Overwrite?", filename);

                 rc = AskUser(w_special[TOPLEVEL_W], message);

                switch (rc)
                {
                    case YES:
                    {
                        (void) PrintCards (filename);
                        break;
                    }

                    case NO:
                    {
                        return;
                        break;
                    }
                }
                break;
            }

            case FILE_IS_NOT_REGULAR:
            {
                WriteStatus (1, rolomessageTextW,
                    "File is not a regular file! Could not print!");
                break;
            }

            case FILE_IS_NOT_WRITABLE:
            {
                WriteStatus (1, rolomessageTextW,
                    "File is not writable! Could not print!");
                 break;
            }

            default:
            {
                /*
                ** print to it..file does not exist
                */

                (void) PrintCards (filename);
            }
        }

    }   /* it's a file */
    else
        (void) PrintCards (filename);
        

    XtUnmanageChild (GprintDialogW);
    SetBusyCursorState (w_special[MAINWINDOW_W], False);

    if (print_to != (char *) NULL)
        (void) free ((char *) print_to);
}
