package provide util 1.0


proc lremove remove {
upvar thelist y
set newlist ""

        foreach item $y {
                if ![string compare [string tolower [string trimleft $item "@+" ] ] [string tolower [string trimleft $remove "@+" ] ] ] {
                } else {
                        set newlist [linsert $newlist end $item]
                }
        }
        set y $newlist

}        

proc is_on_ignore {user type} {

        global ignore
        set iglist [split $ignore " "]

        foreach element $iglist {

                set igcat [split $element ","]
                set ig [lindex $igcat 0]
                set igtype [string tolower [lindex $igcat 1] ]

                set ig [string tolower $ig]
                set user [string tolower $user]
                if [string match "*m*" $igtype] {
                        if [string match $ig $user] { return 1 }
                }
                if [string match "*c*" $igtype] {
                        if [string match $ig $user] { return 1 }
                }
                if [string match "*p*" $igtype] {
                        if [string match $ig $user] { return 1 }
                }
                if [string match "*n*" $igtype] {
                        if [string match $ig $user] { return 1 }
                }
        }
        return 0

}
                              

proc get_shortnick lorig {
        upvar orig sorig

        if { [string first "!" $lorig] > -1 } {
                set sorig [string range $lorig 0 [string first "!" $lorig] ]
                set sorig [string trimright $sorig "!"]
                set response $sorig
         }


}

proc get_nick_from_hostmask hostmask {

        upvar nickname sorig

        if { [string first "!" $hostmask] > -1 } {
                set sorig [string range $hostmask 0 [string first "!" $hostmask] ]
                set sorig [string trimright $sorig "!"]
                set response $sorig
        }

}             


proc get_nick_from_hostmask2 {hostmask} {


        if { [string first "!" $hostmask] > -1 } {
                set sorig [string range $hostmask 0 [string first "!" $hostmask] ]
                set sorig [string trimright $sorig "!"]
                return $sorig
        }

}
proc get_userhost_from_hostmask hostmask {

        upvar userhost sorig

        if { [string first "!" $hostmask] > -1 } {
                set sorig [string range $hostmask  [string first "!" $hostmast] end ]
                set sorig [string trimleft $sorig "!"]
                set response $sorig
        }

}

proc extract_msg param {
        upvar msg  mmsg
        upvar dest mdest

          set param [string trimleft $param " :=@"]
          scan $param "%s" mdest
          set mmsg [string range $param [string first $mdest $param] end ]
          set mmsg [string trimleft $mmsg $mdest]
          set mmsg [string trimleft $mmsg " "]

          if ![string compare ":" [string index $mmsg 0] ] {
                set mmsg [string range $mmsg 1 end]
          }

}                                        


proc togglemode {switch nick chan mode} {

	if ![string compare $nick ""] {
		return
	}

	if ![string compare "b" $mode] {
		return
	}

	if ![string compare "o" $mode] {
		set mode "@"
	}
	if ![string compare "v" $mode] {
		set mode "+"
	}

        if ![string compare "+" $switch] {
                        remove_nick $chan $nick
                        insert_nick $chan "$mode$nick"

        } else {
                        remove_nick $chan "$mode$nick"
                        insert_nick $chan $nick

        }
}
                          


proc is_me {orig} {
        global nick
	
	set orig [lindex [split $orig "!"] 0]
        if ![string compare [string tolower $orig] [string tolower $nick] ] {
        return 1
        } else {
        return 0
        }
}
proc ison {orig} {

        if [winfo exists ".zipperwin[winman $orig]"] {
                return 1
        } else {
        return 0
        }

}                       

proc insert_nick {chan user} {

        set chan [string tolower $chan]
        set win ".zipperwin[winman $chan]"
        if [ison $chan] {
        $win.list insert end $user
        set thelist [$win.list get 0 end]
        set thelist [lsort -command customsort $thelist]
        $win.list delete 0 end
        foreach name $thelist {
                $win.list insert end $name
        }
        }
}

proc remove_nick {chan user} {


        set chan [string tolower $chan]
        set win ".zipperwin[winman $chan]"
        if [ison $chan] {
        set thelist [$win.list get 0 end]
        lremove $user
        $win.list delete 0 end
        foreach name $thelist {
                $win.list insert end $name
        }
        }


}

proc insert_chan_list chan {

	if [string compare $chan ""] {
        set win ".zipperserver"
        $win.list insert end $chan
        set clist [.zipperserver.list get 0 end]
        set clist [lsort $clist]
        .zipperserver.list delete 0 end
        foreach element $clist {
                .zipperserver.list insert end $element
        }
	}
}                                             

proc remove_chan_list chan {

        set name ""


        set thelist [.zipperserver.list get 0 end]
        lremove $chan
        lremove "> $chan"
        .zipperserver.list delete 0 end
        foreach name $thelist {
                .zipperserver.list insert end $name
        }
}


proc format_user_command {command begin} {

        upvar myl yl
        upvar myc yc
        set yl [string range $yl [string first $begin $yl] end ]
        set yl [string trimleft $yl $yc]
        set yl [string trimleft $yl " "]
        set yl "$command $yl"

}

proc get_chan_name win {
# does not properly handle DCC Chats
# must fix
  global response
  set win [focus]
  set win [lindex [split $win "."] 1]
  set win [string range $win 6 end]

  if ![string compare $win "server"] {
  set response  "server"
  return $response
  }
  
  if [string match "dcc*" $win] {
	set socket [string range $win 3 end]
	set snick [string tolower [get_dcc_nick_from_socket $socket] ]
	set response "dcc:$snick"
	return $response
  }
  if [winfo exists .zipper$win] {
  set win [lindex [split [wm  title .zipper$win] " "] 1]
  set response $win
  return $response
  }
  set reponse "-1"
  return $response
}
                       

proc is_active chan {
  global actwin

  set x .zipperwin[winman $chan]
  set y ".[lindex [split $actwin "."] 1]"

  if ![string compare $y $x] {
        return 1
  } 
  return 0

}         



proc customsort {a b} {


        return [string compare [string tolower $a] [string tolower $b] ]

}    
proc init_user_rc {} {
	global rcdir
        global installpath
        global version
        global nick
        global altnick
        global username
        global realname
        global hostname
        global autorejoin
        global shortnick
        global server
        global port
        global editor
	global textfg
	global textbg
	global device
	
        set f [open $rcdir/zipperrc r]

        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
                set comlist [split $l " "]
                set command [lindex $comlist 0]
                set param [string trimright [lrange $comlist 1 end] " " ]
                set $command $param

        }

}     

proc init_stylecolors {} {
	global rcdir
	global kickcol
	global joincol
	global actcol
	global modecol
	global partcol
	global notfcol
	global notccol
	
        set f [open $rcdir/colorstylesrc r]

        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
                set comlist [split $l " "]
                set command [lindex $comlist 0]
                set param [string trimright [lrange $comlist 1 end] " " ]
                set $command $param

        }


}                 

proc init_servers {} {

        global servers
	global rcdir 

        set servers ""
        set f [open $rcdir/serverrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set servers [linsert $servers end $l]
#                }

        }





}                  
proc init_users {} {

        global userlist 
	global rcdir

        set userlist ""
        set f [open $rcdir/usersrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set userlist [linsert $userlist end $l]
#                }

        }





}                  



                                                                           
proc init_channels {} {

        global channels
	global rcdir

        set channels ""
        set f [open $rcdir/channelsrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set channels [linsert $channels end $l]
#                }

        }





}
proc init_events {} {

        global eventlist
	global rcdir
        set eventlist ""
        set f [open $rcdir/eventsrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set eventlist [linsert $eventlist end $l]
#                }

        }





}
                 

proc init_custom_command {} {

        global zip_command
	global rcdir

        set zip_command ""
        set f [open $rcdir/customrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set zip_command [linsert $zip_command end $l]
#                }

        }

}
proc init_aliases {} {

        global aliaslist
	global rcdir

        set aliaslist ""
        set f [open $rcdir/aliasrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set aliaslist [linsert $aliaslist end $l]
#                }

        }



}              

proc init_notify {} {

        global notify
	global rcdir

        set notify ""
        set f [open $rcdir/notifyrc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set notify [linsert $notify end $l]
#                }

        }



}

proc init_ignore {} {

        global ignore
	global rcdir
        set ignore ""
        set f [open $rcdir/ignorerc r]


        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
#                if [string compare "#" [string index $l 0] ] {
                        set ignore [linsert $ignore end $l]
#                }

        }



}     

proc check_notify {} {
        global notify
        global esvrSock

        after 60000 {send_to_server $esvrSock "ISON $notify" ;check_notify}


}


proc init_check_rc {} {
        global installpath

        if ![file exists "~/.zipper"] {
                puts stdout "Could not find zipper resource files."
                puts stdout "Please cd to $installpath and execute the"
                puts stdout "installrc script."
                exit
        }


}
 

# Read a line of text from stdin and send it to the echoserver socket,
# on eof stdin closedown the echoserver client socket connection
# this implements sending a message to the Server.
proc send_to_server {wsock l} {

  global serveractive

  if $serveractive {
        puts $wsock $l           ;# send the data to the server
  }
}
              

proc fake_user_in {input} {

  global  esvrSock
  global  nick
  global  eventLoop

  set input [string trim $input " "]
  set w [focus]
  set l $input

  if [sNull $l] return
  set w [string range $w 7 end ]
  set w [string range $w 0 [string first "." $w] ]
  set w [string trimright $w "."]
  if [string compare "" $w] {
        set chan [lindex [split [wm  title .zipper$w] " "] 1]
  }
#default is to send to current channel
  if ![string compare "/" [string index $l 0] ] {
	
        	set l [string trimleft $l " /"]
       		set_command $esvrSock
  } else {

        if ![string compare ".zipperserver" $w] {
        } else {
          send_to_window $chan "> $l\n"
          set l ":$nick PRIVMSG $chan :$l"
          send_to_server $esvrSock $l ;# send the data to the server
          }
  }


}

                          

proc read_user_in {wsock w} {
  global  nick
  global  eventLoop
  global  history
  global  historyidx
  
  set l [$w get]
  $w delete 0 end

  set hname [get_chan_name $w]
  set historyidx($hname)  30
  lappend history($hname) $l
  roll_off_hist $hname

  

  set w [string range $w 7 end ]
  set w [string range $w 0 [string first "." $w] ]
  set w [string trimright $w "."]
  set chan [lindex [split [wm  title .zipper$w] " "] 1]


#default is to send to current channel

  if [sNull $l] return
  if ![string compare "/" [string index $l 0] ] {
        set l [string trimleft $l "/"]
        if [string compare "" $l] {
                set_command $wsock
        }
  } else {

        if ![string compare "server" $w] {
        } else {
          send_to_window $chan "> $l\n"
          set l ":$nick PRIVMSG $chan :$l"
          send_to_server $wsock $l ;# send the data to the server
          }
  }


}                            


 
proc set_chan_activity {status win} {
        global dccnicklist
	global installpath
        set s1 ""
        set s2 ""
        set win [string tolower $win]
	set zwin ".zipperwin[winman $win]"

        if [string match "dcc*" $win] { 
		set zwin .zipper$win
		set s [string range $win 3 end]
		set s [get_dcc_nick_from_socket $s]
		set win "DCC:$s"
		if [sNull $s] {return}
		
	}
	set x [chan_exists $win]

	if !$x {return}
        if [string match "" $win] { return }
        if [string match "on" $win] { return }
        if [string match "channel*" $win] { return }
        if [string match "server*" $win] { return }
        if $status {
                remove_chan_list $win
                remove_chan_list "> $win"
                insert_chan_list "> $win"
		wm iconbitmap $zwin "@$installpath/zipperwinicon2.bmp"
        } else {
                remove_chan_list "$win"
                remove_chan_list "> $win"
                insert_chan_list "$win"
		wm iconbitmap $zwin "@$installpath/zipperwinicon.bmp"
        }

}
                                        
proc update_chan_activity {status win} {
global actwin

	set actwin $win
        if [string match "*dcc*" $win] { 
		set win [lindex [split [string range $win 7 end] "."] 0]
		if [sNull $win] {return}
	} else {
        	set win [get_chan_name $win]
	}
        set_chan_activity 0 $win
}



proc substitute {fromnick fromchannel line} {


	global nick
	global ip
	global username
	global myuserhost
	global realname
	global hostname
	global server
	global port
	global version
	global currchan
	global varlist
	global varlist	
	set level [get_level $fromnick]		
	set fromuser $fromnick
	set fromnick [get_nick_from_hostmask2 $fromnick]
	upvar command newcommand
	set newcommand [string trim $newcommand " "]	
	set oldcommand $newcommand
	
	set list [split $oldcommand " "]
	set newlist ""
puts "list:$list"
	foreach word $list {
		set check [string tolower $word]
		if ![string compare "-$" [string range $check 0 1] ] {
			set check [string range $check 1 end]
			set pc [string range $check 1 4]
			switch -exact -- $pc {
			parm	{ set num [string range $check 5 end]
				  incr num -1
				  puts -nonewline "$check "
				  set check [lindex [split $line " "] $num] 	
				  puts "$check"
				}
			default	{set check [expr $check] }
			}
			set newlist [linsert $newlist end $check]
		} elseif ![string compare "-%" [string range $check 0 1] ] {
			set check [string range $check 2 end]
			set check [varvalue $check]
			set newlist [linsert $newlist end $check]
		} elseif ![string compare "-@" [string range $check 0 1] ] {
			set check [string range $check 2 end]
			set check [funcvalue $check $fromuser $fromchannel $line]
			set newlist [linsert $newlist end $check]
		} else {
			set newlist [linsert $newlist end $word]

		}
	}
	set list $newlist

	set newcommand [join $newlist " "]

}



proc do_menu_command {win index type} {
global userpopups
global nick
global parm1
	set win ".[lindex [split $win "."] 1]"

	switch -exact -- $type {
		channel		-
		query		{set parm1 [get_chan_name [focus]] }
		userlist	-
		notify		{set parm1 [string trimleft [$win.list get active] "@+"]}
	}
	set index [expr $index - 1]

	set com [lindex $userpopups($type) $index]
	set command $com
	substitute $nick NA $parm1
	fake_user_in $command

}


proc sNull {string} {

	if ![string compare $string ""] {

		return "1"

	}
	return "0"

}

proc aliasindex {alias} {
	global aliaslist
	set index -1
	foreach var $aliaslist {	
		incr index
		set v [lindex [split $var " "] 0]
		if ![string compare $v $alias] {
			return $index
		}
	}
	return -1
}


proc varindex {varname} {
	global varlist
	set index -1
	foreach var $varlist {	
		incr index
		set v [lindex [split $var " "] 0]
		if ![string compare $v $varname] {
			return $index
		}
	}
	return -1
}




proc varvalue {varname} {

	global varlist
        set index [varindex $varname]
	set value [string trim [join [lrange [split [lindex $varlist $index] " "] 1 end] ]  " "] 
        return $value 

}


proc funcvalue {function fromuser channel line} {
	global whoisvisible
	global whoisuser
	global nick

	set p(1) ""
	set p(2) ""
	set p(3) ""
	set p(4) ""
	set p(5) ""
	set p(6) ""

	set funclist [split $function ","]
	set function [lindex $funclist 0]
	set parmlist [lrange $funclist 1 end]
	set x 0
	foreach parm $parmlist {
		incr x
		if ![string compare "-" [string range $parm 0  0 ] ] {
                	set command $parm
                       	substitute $fromuser $channel $line
                        set parm $command
                }
		set p($x) $parm
	}

	switch $function {
	"level" { 	set whoisvisible 0
			fake_user_in "/echo Looking up user..."
			fake_user_in "/whois $p(1)"
			tkwait variable whoisvisible
			return [get_level $whoisuser] 
		 }
	"add"	{ return [expr $p(1) + $p(2) ] }	
	"sub"	{ return [expr $p(1) - $p(2) ]  }
	"rtime"  { return [exec pingtime] }
	"run"	{ return [exec $p(1) $p(2) $p(3) $p(4) $p(5) $p(6) ] }
	"none"	{ return }
	"time"  { set date [exec date]
		  set time [lindex [split $date " "] 4]
		  return $time }
	"chanlist" { 	set chan $p(1)
			set list [.zipperwin[winman $chan].list get 0 end]
			return $list
		  }	


	}
}



proc process_options {ircuser} {




}


proc get_level {ircuser} {
	global nick
	global userlist

 	set level 0

	foreach user $userlist {	
                set lvs [split $user ":"]
                set ulev [lindex $lvs 0]
                set uname [lindex $lvs 1]
                if [string match $uname $ircuser] {
                        set level $ulev
                        return $level
                }

        } 
	return $level


}

proc get_user_list_entry {ircuser} {
	global userlist

	foreach user $userlist {	
                set lvs [split $user ":"]
                set uname [lindex $lvs 1]


                if [string match $uname $ircuser] {
                        return $uname
                }

        } 
	return "*"
}



proc join_channel_from_list {} {

	set w ".zipperchannellist.channels.list"  
	set item [$w get active]
	set channel [lindex [split $item "\t"] 0]
	fake_user_in "/join $channel"

}

proc playsystembell {} {



}


proc loadstartupscript {script} {
	set f [open $script r]
	 while 1 {
     	   set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
	   fake_user_in "$l"
	}



}


proc is_channel {w} {
	set x [string trimleft "> "]
	set x [string range $w 0 0]
	if ![string compare "#" $x] {
		return 1
	} else {
		return 0
	}

}

proc channel {c} {

	set c [string trim $c " "]
	if ![string compare "#" $c] {
		set c [get_chan_name [focus] ]
	}
	return $c

}

proc center {t  xoff yoff} {

	set x [expr [winfo screenwidth $t]/2 - [winfo reqwidth $t]/2 \
            - [winfo vrootx [winfo parent $t]]]
    	set y [expr [winfo screenheight $t]/2 - [winfo reqheight $t]/2 \
            - [winfo vrooty [winfo parent $t]]]         
	
	set x [expr $x+$xoff] 
	set y [expr $y+$yoff] 
	wm geom $t +$x+$y  


}

proc max_size { t } {

	set x [winfo screenwidth $t]
	set y [winfo screenheight $t]

	return "$x,$y"
}

proc set_popups {} {

	global rcdir
	global userpopups

	set muser .zipperserver.menu.userlistpopup
	set mnoti .zipperserver.menu.notifypopup
	set mchan .zipperserver.menu.channelpopup      
	set mquery .zipperserver.menu.querypopup      
	
	menu $muser
	menu $mnoti
	menu $mchan
	menu $mquery

	set f [open $rcdir/popuprc r]


	while 1 { 
		set l [gets $f]
		if [eof $f] {
			close $f
			return
		}
		switch -exact -- $l {
			"[USERLIST]"	{set m $muser; set t userlist }
			"[NOTIFY]"	{set m $mnoti; set t notify }
			"[CHANNEL]"	{set m $mchan; set t channel }
			"[QUERY]"	{set m $mquery; set t query }
			"[-]"		{ }
		}
		set ck [string range $l 0 0]
		if [string compare $ck "\[" ] {
			 if ![string compare [lindex [split $l " "] 0]  "-"] {
                        $m add separator
			set userpopups($t) [linsert $userpopups($t) end " "]  
                        $m add  command -label [string trimleft $l "-"] -foreground red
                       	set userpopups($t) [linsert $userpopups($t) end " "]   
			$m add separator
			set userpopups($t) [linsert $userpopups($t) end " "] 
               		 } else {
                	set lab [lrange [split $l " "] 0 0 ]
                	set com [join [lrange [split $l " "] 1 end] " "]
			set mc "do_menu_command \[focus\] \[$m index active\] $t"
			set userpopups($t) [linsert $userpopups($t) end "$com"] 
                	$m add command -label $lab -command $mc 
                	}                        
		}



	}
}

proc select_history {window i} {
	global historyidx
	global history


	set index [get_chan_name $window]
	set l [llength $history($index) ]
	incr historyidx($index) $i
	if [expr $historyidx($index)<0] {
		set historyidx($index) 0
	}
	if [expr $historyidx($index)>$l] {
		set historyidx($index) [expr $l-1 ]
	}
puts $historyidx($index)

	set out [lindex $history($index) $historyidx($index)]
	$window delete 0 end
	$window insert end $out

}

proc roll_off_hist { index } {
	global history
	
	set l [llength $history($index)]
	if $l>25 {
	
	set history($index) [lrange $history($index) 10 end]

	}

}


proc set_styles {} {

global kickst
global joinst
global notfst
global notcst
global actst
global partst
global modest

global joincol
global kickcol
global notfcol
global notccol
global actcol
global partcol
global modecol


set kickst "\003$kickcol"
set joinst "\003$joincol"
set notfst "\003$notfcol"
set notcst "\003$notccol"
set actst  "\003$actcol"
set partst "\003$partcol"   
set modest "\003$modecol"   

}


proc chan_exists {channel} {
	
	set channel [string tolower $channel]	
	if [string match $channel "server"] {return 1}
	set list [.zipperserver.list get 0 end]
	foreach item $list {
		set item [string trim $item "> "]
		if [string compare $item $channel ] {return 1}
	}
	return 0


}
