package provide winman 1.0

####
# winlist format:  channelname:windownumber
proc winman {channel} {
global winlist
global winbase
global chaninfo

	set channel [string tolower $channel]

	if [sNull [array names chaninfo "$channel,name"] ] {
		return -1
	} else {
		return $chaninfo($channel,winnumber)
	}


}


proc winmannew {channel title type s} {
global winlist
global winbase
global chaninfo
	
	set channel [string tolower $channel]
	set refocus [focus]
	set num [winman $channel]

	if $num<0 {
		set winbase [expr $winbase+1]
		set num $winbase
		set winlist [linsert $winlist end "$channel:$winbase" ]
	} 


		set winname ".zipperwin$winbase"
		set index $channel
		set chaninfo($index,name) $winname
		set chaninfo($index,stat) "I"
		set chaninfo($index,history) ""
		set chaninfo($index,historyidx) 0
		set chaninfo($index,winnumber) $num

		switch -exact -- $type {
		priv		{
				set chaninfo($index,type) "priv"
				new_msg_window "win$num" "Private: $title" $s
				}
		pub		{
				set chaninfo($index,type) "chan"
				new_window "win$num" "Channel: $title"
				}
		}


	focus $refocus
}


proc new_server {w name} {

global zipperservericon
global allowsaverc
global mirccolors
global textfg
global textbg
global defaultquit
global actwin
global installpath
global serverfont

set w ".zipper$w"

toplevel $w
wm withdraw $w
if $allowsaverc {
	wm iconname $w "Zipper"
} else {
	wm iconname $w "Zipper Clone"
}


#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font $serverfont

wm title $w $name
wm iconbitmap $w @$installpath/drawing.xbm
set start 0.0
set length 0

set pic [image create photo -file "$installpath/title.gif"]
frame $w.menu -relief raised -bd 2

label $w.menu.pic  -height 20 -image $pic
pack $w.menu.pic -side left
pack $w.menu -side top -fill x

add_system_menus $w 


frame $w.controls
pack $w.controls -side left
text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50 -foreground $mirccolors($textfg) -background $mirccolors($textbg)
scrollbar $w.scroll -command "$w.text yview"
listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 20
scrollbar $w.listscroll -command "$w.list yview"
entry $w.entry -bd 2 -relief sunken -width 30
pack $w.entry -side bottom -expand no -fill x
pack $w.listscroll -side right -fill y
pack $w.list -side right -fill y
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

button $w.controls.connect -text "Connect" -width 10 -command {open_irc_connection}
button $w.controls.disconnect -state disabled -text "Disconnect" -width 10 -command {close_irc_connection}
button $w.controls.server -text "Server" -width 10 -command {modify_servers}
button $w.controls.channels -text "Channels" -width 10 -command {modify_channels}
button $w.controls.notify -text "Notify" -width 10 -command {modify_notify}
button $w.controls.ctcp -text "CTCPs" -width 10 -command {modify_ctcps}
button $w.controls.events -text "Events" -width 10 -command {modify_events}
button $w.controls.users -text "Users" -width 10 -command {modify_users}
button $w.controls.ignore -text "Ignore" -width 10 -command {modify_ignore}
if $allowsaverc {
	button $w.controls.setup -text "Defaults" -width 10 -command { exec zippersetup & }
} else {
	button $w.controls.setup -text "Defaults" -width 10 -state disabled -command { exec zippersetup & }
}
button $w.controls.exit -text "Quit IRC" -width 10 -command {fake_user_in "/quit $defaultquit"}



pack $w.controls.connect -side top
pack $w.controls.disconnect -side  top
pack $w.controls.server $w.controls.channels $w.controls.notify $w.controls.ctcp $w.controls.events $w.controls.users $w.controls.ignore -side top
pack $w.controls.exit -side top
pack $w.controls.setup -side top

bind $w      <Destroy> {kill_window .zipperserver}
bind $w.entry <KeyPress-Up>	{select_history [focus] -1}
bind $w.entry <KeyPress-Down>	{select_history [focus] 1}
bind $w.list  <Double-ButtonPress-1> {goto_window .zipperserver.list }
bind $w.entry <KeyPress-Return> {read_user_in $esvrSock [focus] }
bind $w.entry <Control-KeyPress-b> {[focus] insert end "\002"}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}
bind $w  <FocusIn> {set actwin "server" }
focus $w.entry

update idletasks
center $w -100 -100
wm deiconify $w
focus $w.entry
#set_userlist_popup
set_popups

}



proc new_window {w name} {
global mirccolors
global textfg
global textbg
global defaultquit
global actwin
global installpath
global channelfont

set w ".zipper$w"
toplevel $w
wm withdraw $w
wm iconname $w [lindex [split $name " "] 1]
#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font $channelfont

wm title $w $name
wm iconbitmap $w @zipperwinicon.bmp
set start 0.0
set length 0

frame $w.menu -relief raised -bd 2
pack $w.menu -side top -fill x

set m $w.menu.file.m
menubutton $w.menu.file -text "File" -menu $m
menu $m
$m add command -label "Setup" -command { exec zippersetup & }
$m add separator
$m add command -label "Connect" -command { open_irc_connection}
$m add command -label "Disconnect" -command { close_irc_connection}
$m add separator
$m add command -label "Exit" -command {fake_user_in "/quit $defaultquit" }

pack $w.menu.file -side left

set m $w.menu.edit.m
menubutton $w.menu.edit -text "Edit" -menu $m
menu $m
$m add command -label "Aliases..." -command { fake_user_in "/edit alias" }
$m add command -label "CTCP..." -command { fake_user_in "/edit ctcp" }
$m add command -label "Events..." -command { fake_user_in "/edit events" }
$m add command -label "Ignore..." -command { fake_user_in "/edit ignore" }
$m add command -label "Notify..." -command { fake_user_in "/edit notify" }
$m add command -label "Users..." -command { fake_user_in "/edit users" }
$m add separator
$m add command -label "Add/Del Channel..." -command { modify_channels }
$m add command -label "Add/Del Event..." -command { modify_events }
$m add command -label "Add/Del Server..." -command { modify_servers }
$m add command -label "Add/Del User..." -command { modify_users }

pack $w.menu.edit -side left         





frame $w.labels
text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50 -foreground $mirccolors($textfg) -background $mirccolors($textbg)
scrollbar $w.scroll -command "$w.text yview"
listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 12
scrollbar $w.listscroll -command "$w.list yview"
entry $w.entry -bd 2 -relief sunken -width 30
        label $w.labels.topict -text "Topic"
        label $w.labels.topic -bd 2 -relief sunken -width 50 -justify left
        label $w.labels.modes -bd 2 -relief sunken -width 10
        label $w.labels.modest -text "Modes"

        pack $w.labels -side top -fill x
        pack $w.labels.topict -side left
        pack $w.labels.topic -side left
        pack $w.labels.modes -side right
        pack $w.labels.modest -side right
pack $w.entry -side bottom -expand no -fill both
pack $w.listscroll -side right -fill y
pack $w.list -side right -fill y
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

center $w -50 -50
wm deiconify $w
focus $w.entry

bind $w.entry <KeyPress-Up>	{select_history [focus] -1}
bind $w.entry <KeyPress-Down>	{select_history [focus] 1}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}
bind $w.list  <Double-ButtonPress-1> {goto_window  [focus] }
bind $w.list  <ButtonPress-3> { tk_popup .zipperserver.menu.userlistpopup [winfo pointerx [focus]] [winfo pointery [focus]] }
bind $w.entry <KeyPress-Return> {read_user_in $esvrSock [focus] }
bind $w  <FocusIn> {update_chan_activity 0 [focus] }
bind $w.entry <Destroy> {kill_window $actwin}

}                           



proc new_msg_window {w name s} {
global mirccolors
global textfg
global textbg
global defaultquit
global actwin
global installpath
global queryfont

set w ".zipper$w"
toplevel $w

wm withdraw $w
wm iconname $w [lindex [split $name " "] 1]
wm iconify $w
#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font $queryfont

wm title $w $name
wm iconbitmap $w @zipperwinicon.bmp
set start 0.0
set length 0


frame $w.menu -relief raised -bd 2
pack $w.menu -side top -fill x

set m $w.menu.file.m
menubutton $w.menu.file -text "File" -menu $m
menu $m
$m add command -label "Setup" -command { exec zippersetup & }
$m add separator
$m add command -label "Connect" -command { open_irc_connection}
$m add command -label "Disconnect" -command { close_irc_connection}
$m add separator
$m add command -label "Exit" -command {fake_user_in "/quit $defaultquit" }

pack $w.menu.file -side left

set m $w.menu.edit.m
menubutton $w.menu.edit -text "Edit" -menu $m
menu $m
$m add command -label "Aliases..." -command { fake_user_in "/edit alias" }
$m add command -label "CTCP..." -command { fake_user_in "/edit ctcp" }
$m add command -label "Events..." -command { fake_user_in "/edit events" }
$m add command -label "Ignore..." -command { fake_user_in "/edit ignore" }
$m add command -label "Notify..." -command { fake_user_in "/edit notify" }
$m add command -label "Users..." -command { fake_user_in "/edit users" }
$m add separator
$m add command -label "Add/Del Channel..." -command { modify_channels }
$m add command -label "Add/Del Event..." -command { modify_events }
$m add command -label "Add/Del Server..." -command { modify_servers }
$m add command -label "Add/Del User..." -command { modify_users }

pack $w.menu.edit -side left
                            

frame $w.labels
text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50 -foreground $mirccolors($textfg) -background $mirccolors($textbg)
scrollbar $w.scroll -command "$w.text yview"
#listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 10
#scrollbar $w.listscroll -command "$w.list yview"
entry $w.entry -bd 2 -relief sunken -width 30
pack $w.entry -side bottom -expand no -fill both
#pack $w.listscroll -side right -fill y
#pack $w.list -side right -fill y
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both

center $w -50 -50
#wm iconify $w
#focus $w.entry
if !$s {
	wm deiconify $w
	focus $w.entry
}


bind $w.entry <KeyPress-Up>	{select_history [focus] -1}
bind $w.entry <KeyPress-Down>	{select_history [focus] 1}
bind $w.entry <Control-KeyPress-b> {[focus] insert end "\002"}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}
bind $w.entry      <Destroy> {kill_window [focus]}
bind $w.text  <ButtonPress-3> { tk_popup .zipperserver.menu.querypopup [winfo pointerx [focus]] [winfo pointery [focus]] }
bind $w.entry <KeyPress-Return> {read_user_in $esvrSock [focus] }
bind $w       <FocusIn> {update_chan_activity 0 [focus] }
}                          


proc notify_window {} {

set w ".zippernotify"
toplevel $w
wm iconname $w "Notify"
#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font 8x13

wm title $w "Notify"
set start 0.0
set length 0

listbox $w.list -yscrollcommand "$w.listscroll set" -setgrid 1 -width 10
scrollbar $w.listscroll -command "$w.list yview"
pack $w.list -side left -fill y
pack $w.listscroll -side right -fill y

bind .zippernotify.list  <Double-ButtonPress-1> {goto_window [focus] }
bind $w.list  <ButtonPress-3> { tk_popup .zipperserver.menu.notifypopup [winfo pointerx [focus]] [winfo pointery [focus]] }

}                 

 

proc send_to_window { win text } {
        global response
        global ctag
	global mirccolors
	global textfg
	global textbg

	set refocus [focus]
	set taglist ""
	set tag ".tag$ctag"
	set code ""


	set text [string trimright $text "\n"]
	set text "$text\003$textfg,$textbg"

        set dcccheck [string range $win 0 2]

        if ![is_active $win ] {
		
              	 set_chan_activity 1 $win
       	 }



        if ![string compare $win "server"] {
        set win .zipper$win
        } elseif ![string compare "dcc" $dcccheck] {
                set win .zipper$win

        } else {
                set win [string tolower $win]
                set win ".zipperwin[winman $win]"
        }
        if ![winfo exists $win] {
                set win ".zipperserver"
        }
	$win.text configure -state normal

	set fg $textfg
	set bg $textbg
	switch -glob -- $text "*\[\002\003\007\017\026\037\]*" { 

		while { [regexp "^(\[^\002\003\007\017\026\037\]*)(\[\002\003\007\017\026\037\])(.*)$"  $text match m1 char text] } {   
			$win.text insert end $m1 $taglist
			set tag ".tag$ctag"
			incr ctag
		switch -- $char {
		\002 	{ set code "bold"}
		\003 	{
	                    if [regexp {^([0-9][0-9]?)(,([0-9][0-9]?))?(.*)} $text m fg bl bg text] {
	                        switch -glob -- 0* $fg {set fg [string range $fg 1 end]}
				if [sNull $fg] {
					set fg $textfg
				}
       		                set fg [expr {$fg % 16}]
                        	lappend taglist $tag
                        	switch -- {} $bg {} default {
                            	switch -glob -- 0* $bg {
                                	set bg [string range $bg 1 end]
                            	}
				if [sNull $bg] {
					set fg $textfg
				}
                            	set bg [expr {$bg % 16}]
                        	}
                    	   }
			set code "colr.$fg.$bg" 


			}
		\007    {playsystembell }
		\017 	{lappend taglist $tag; continue}
		\026 	{set code "invr"}
		\037 	{set code "undr"}
		
		}


		conftag $win $taglist


	   	if {[set x [lsearch $taglist ${code}*]] < 0} {
               	 lappend taglist $code$tag
            	} { set taglist [lreplace $taglist $x $x] }   
		}
	}

conftag $win $taglist
$win.text insert end "$text\n" $taglist
$win.text configure -state disabled
$win.text see end
focus $refocus
}

proc conftag {win taglist} {
	global mirccolors
	global textfg
	global textbg

		set fontbold  8x13bold

		foreach entry $taglist {	
		set t [string range $entry 0 3]
		switch -- $t {
		"bold"	{ $win.text tag configure $entry -font $fontbold }
		"undr"	{ $win.text tag configure $entry -underline  }
		"invr"  { $win.text tag configure $entry -foreground $mirccolors($textbg) -background $mirccolors($textfg) }
		
		"colr"  {
				set fg [lindex [split $entry "."] 1]	
				set bg [lindex [split $entry "."] 2]
       	                	$win.text tag configure $entry -foreground $mirccolors($fg)
				if ![string compare $bg ""] {set bg $textbg}
				$win.text tag configure $entry -background $mirccolors($bg)
			}
		}
		}
}
 

proc kill_window w {

        global esvrSock
	global defaultquit
	set w ".[lindex [split $w "."] 1]"
        if ![string compare $w ".zipperserver"] {

                set eventLoop "Done"
		puts stdout "IRC Finished."
                do_quit "$defaultquit" $esvrSock
        } else {
		set channel [get_chan_name $w]
		remove_chan_list $channel
		if [is_channel $channel] {
			send_to_server $esvrSock "PART $channel"
		}
	}

}

proc goto_window w {
        global dccnicklist
        global response
        global nick
        set w [split $w "."]
        set w [lindex $w 1]

        set select [string trimleft [.$w.list get active] "> " ]
        set select [string trimleft $select " >+@"]

        if ![string compare "#" [string index $select 0] ] {
                if [winfo exists .zipperwin[winman $select] ] {
                        focus .zipperwin[winman $select].entry
                        raise .zipperwin[winman $select]
                        wm deiconify .zipperwin[winman $select]
			set currchan $select
                        return
                }
        } elseif ![string compare "DCC" [string range $select 0 2] ] {
                set target [string range $select 4 end]
                get_dcc_sock_from_nick $target
                wm deiconify .zipperdcc$response
                do_query "dcc$response" 0
                focus .zipperdcc$response
		set currchan $select
                return

        } elseif ![sNull $select] { 

		if [winfo exists .zipperwin[winman $select] ] {
                        wm deiconify .zipperwin[winman [string trimleft $select "+@"] ]
                }
                do_query  $select 0
                focus .zipperwin[winman $select].entry
                set_chan_activity 0  $select
		set currchan $select
                return
        }
}

                                   


#proc unknown {name} {

#       puts stdout "Unknown Command Trapped: $name"

#}
proc bgerror {msg} {

#gracefully handle errors ie...do nothing about them yet
#puts stdout "Background error detected: $msg"

        if ![regexp "sock" $msg] {

                puts stdout "Error: $msg"

        }

}                               
proc new_pers_notify {} {

        set w ".zipperpernotify"
        toplevel $w
        wm iconname $w "Customize Notify"
        set font 8x13

        wm title $w "Personal Notify List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 15
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 20

        frame $w.buttons
        button $w.buttons.add -text "Add" -command {notify_add}
        button $w.buttons.remove -text "Del" -command {notify_del}
        button $w.buttons.done -text "Done" -command {destroy .zipperpernotify}
        pack $w.buttons -side bottom


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons.add -side left
        pack $w.buttons.remove -side left
        pack $w.buttons.done -side left

}
                

 
proc new_pers_server {} {
        set w ".zipperperserv"
        toplevel $w
        wm iconname $w "Customize Server List"
        set font 8x13

        wm title $w "Personal Servers List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 25
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 20 
	entry $w.box.port -bd 2 -relief sunken  -width 6 

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {server_add}
        button $w.buttons1.remove -text "Del" -command {server_del}
        button $w.buttons1.join -text "Connect" -command {server_connect}

        button $w.buttons2.done -text "Done" -command {server_done}


        pack $w.box.port -side bottom 
        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.join -side left
        pack $w.buttons2.done -side right


        bind $w.box.list <Double-ButtonPress-1> {server_connect }
}
              

proc new_pers_ignore {} {
	global ignoreindex

        set w ".zipperperig"
        toplevel $w
        wm iconname $w "Customize Ignore"
        set font 8x13

        wm title $w "Personal Ignore List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 25
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 30

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {ignore_add}
        button $w.buttons1.remove -text "Del" -command {ignore_del}
        button $w.buttons1.update -text "Upd" -command {ignore_upd}
        button $w.buttons2.done -text "Done" -command {ignore_done}


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left

	bind $w.box.list <Double-ButtonPress-1>  { load_ignore_edit; set ignoreindex [.zipperperig.box.list index active] }
}                                       


proc new_pers_channel {} {
global mirccolors
global textfg
global textbg

        set w ".zipperperchan"
        toplevel $w
        wm iconname $w "Customize Channels"
        set font 8x13

        wm title $w "Personal Channels List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 40
        scrollbar $w.box.listscroll -command "$w.box.list yview"
        entry $w.box.name -bd 2 -relief sunken  -width 45

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {channel_add}
        button $w.buttons1.remove -text "Del" -command {channel_del}
        button $w.buttons1.join -text "Join" -command {channel_join}

        button $w.buttons2.names -text "Names" -command {channel_names}
        button $w.buttons2.done -text "Done" -command {channel_done}


        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.join -side left
        pack $w.buttons2.names -side left
        pack $w.buttons2.done -side left

        bind $w.box.list <Double-ButtonPress-1> { channel_join}
}                                         

                              
proc new_user_list {} {
	global userindex
        set w ".zipperusers"
        toplevel $w
        wm iconname $w "Customize User list"
        set font 8x13

        wm title $w "Personal User List"

        frame $w.box
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 25
        scrollbar $w.box.listscroll -command "$w.box.list yview"
	entry $w.box.options -relief sunken -width 6
        entry $w.box.name -bd 2 -relief sunken  -width 30
        entry $w.box.level -bd 2 -relief sunken  -width 4
	

        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom

        button $w.buttons1.add -text "Add" -command {user_add}
        button $w.buttons1.remove -text "Del" -command {user_del}
        button $w.buttons1.update -text "Upd" -command {user_upd}
        button $w.buttons2.done -text "Done" -command {user_done}

	pack $w.box.options -side bottom
        pack $w.box.level -side bottom
        pack $w.box.name -side bottom -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left


	bind $w.box.list <Double-ButtonPress-1>  { load_user_edit; set userindex [.zipperusers.box.list index active] }
}                                       

proc new_event_list {} {
	global eventindex
        set w ".zipperevents"
        toplevel $w
        wm iconname $w "Customize Event list"
        set font 8x13

        wm title $w "Personal Event List"

        frame $w.box 
        frame $w.f1
        frame $w.f2
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 90
        scrollbar $w.box.listscroll -command "$w.box.list yview"
	
        entry $w.f1.level -bd 2 -relief sunken  -width 5
        entry $w.f1.type -bd 2 -relief sunken  -width 5
        entry $w.f1.nick -bd 2 -relief sunken  -width 12
        entry $w.f1.channel -bd 2 -relief sunken  -width 15
        entry $w.f1.action -bd 2 -relief sunken  -width 30
        
	label $w.f2.level    -width 5 -text "Level"
        label $w.f2.type    -width 5 -text "Type"
        label $w.f2.nick   -width 12 -text "Nick"
        label $w.f2.channel    -width 15 -text "Channel"
        label $w.f2.action   -width 30 -text "Action"


        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom
	pack $w.f1 -side bottom
	pack $w.f2 -side bottom

        button $w.buttons1.add -text "Add" -command {event_add}
        button $w.buttons1.remove -text "Del" -command {event_del}
	button $w.buttons1.update -text "Upd" -command {event_upd}

        button $w.buttons2.done -text "Done" -command {event_done}

        pack $w.f2.level -side left -fill x
        pack $w.f2.type -side left -fill x
        pack $w.f2.nick -side left -fill x
        pack $w.f2.channel -side left -fill x
        pack $w.f2.action -side left -fill x

        pack $w.f1.level -side left -fill x
        pack $w.f1.type -side left -fill x
        pack $w.f1.nick -side left -fill x
        pack $w.f1.channel -side left -fill x
        pack $w.f1.action -side left -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left


	bind $w.box.list <Double-ButtonPress-1>  { load_event_edit; set eventindex [.zipperevents.box.list index active] }
}



proc set_userlist_popup {} {
global userpopups
global rcdir

set userpopups ""
set m .zipperserver.menu.userlistpopup
set m .zipperserver.menu.notifypopup
set m .zipperserver.menu.channelpopup
menu $m
#menu $m delete 2 end

	 set f [open $rcdir/popuprc r]

        while 1 {
        set l [gets $f]
                if [ eof $f ] {
                        close $f
                        return 1
                }
		
		if ![string compare [lindex [split $l " "] 0]  "-"] {
			$m add separator
			set userpopups [linsert $userpopups end " "]
			$m add  command -label [string trimleft $l "-"] -foreground red 
			set userpopups [linsert $userpopups end " "]
			$m add separator
			set userpopups [linsert $userpopups end " "]


		} else {
		set lab [lrange [split $l " "] 0 0 ]
		set com [join [lrange [split $l " "] 1 end] " "]
		set userpopups [linsert $userpopups end $com]
		$m add command -label $lab -command {do_menu_command [focus] [ .zipperserver.menu.userlistpopup index active] }
		}
        }            

}                 



proc choose_file {file dir operation} {


    #   Type names              Extension(s)    Mac File Type(s)
    #
    #---------------------------------------------------------
    set types {
        {"All files"            *}
        {"Text files"           {.txt .doc}     }
        {"Text files"           {}              TEXT}
        {"Tcl Scripts"          {.tcl}          TEXT}
        {"C Source Files"       {.c .h}         }
        {"All Source Files"     {.tcl .c .h}    }
        {"Image Files"          {.gif}          }
        {"Image Files"          {.jpeg .jpg}    }
        {"Image Files"          ""              {GIFF JPEG}}
    }
    if {$operation == "open"} {
        set file [tk_getOpenFile -initialdir $dir -filetypes $types -parent .zipperserver -title "Select File"]
    } else {
        set file [tk_getSaveFile -initialdir $dir -filetypes $types -parent .zipperserver -title "Save As..." \
            -initialfile $file ]
    }
    return $file

}


proc create_chanlist_window {} {
	set w ".zipperchannellist"
        toplevel $w
        wm iconname $w "Channels List"
        wm title $w "Channels List"
        set font 8x13

	frame $w.channels
	frame $w.buttons

	pack $w.buttons -side bottom
	pack $w.channels -side top

	listbox $w.channels.list -width 40
	button $w.buttons.done -text "Done" -command { destroy .zipperchannellist }
	scrollbar $w.channels.listscroll -command "$w.channels.list yview"
		
	pack $w.channels.list -side left
	pack $w.channels.listscroll -side right -fill y
	pack $w.buttons.done -side bottom

	bind $w.channels.list  <Double-ButtonPress-1> {join_channel_from_list }

}                

proc new_ctcp_list {} {
	global ctcpindex
        set w ".zipperctcps"
        toplevel $w
        wm iconname $w "Customize CTCP list"
        set font 8x13

        wm title $w "Personal CTCP List"

        frame $w.box 
        frame $w.f1
        frame $w.f2
        pack $w.box -side top
        listbox $w.box.list -yscrollcommand "$w.box.listscroll set" -setgrid 1 -width 90
        scrollbar $w.box.listscroll -command "$w.box.list yview"
	
        entry $w.f1.level -bd 2 -relief sunken  -width 5
        entry $w.f1.type -bd 2 -relief sunken  -width 9
        entry $w.f1.nick -bd 2 -relief sunken  -width 12
        entry $w.f1.channel -bd 2 -relief sunken  -width 15
        entry $w.f1.action -bd 2 -relief sunken  -width 30
        
	label $w.f2.level    -width 5 -text "Level"
        label $w.f2.type    -width 9 -text "Type"
        label $w.f2.nick   -width 12 -text "Nick"
        label $w.f2.channel   -width 15 -text "Channel"
        label $w.f2.action   -width 30 -text "Action"


        frame $w.buttons1
        frame $w.buttons2
        pack $w.buttons2 -side bottom
        pack $w.buttons1 -side bottom
	pack $w.f1 -side bottom
	pack $w.f2 -side bottom

        button $w.buttons1.add -text "Add" -command {ctcp_add}
        button $w.buttons1.remove -text "Del" -command {ctcp_del}
	button $w.buttons1.update -text "Upd" -command {ctcp_upd}
        button $w.buttons2.done -text "Done" -command {ctcp_done}

        pack $w.f2.level -side left -fill x
        pack $w.f2.type -side left -fill x
        pack $w.f2.nick -side left -fill x
        pack $w.f2.channel -side left -fill x
        pack $w.f2.action -side left -fill x

        pack $w.f1.level -side left -fill x
        pack $w.f1.type -side left -fill x
        pack $w.f1.nick -side left -fill x
        pack $w.f1.channel -side left -fill x
        pack $w.f1.action -side left -fill x
        pack $w.box.list -side left -fill y
        pack $w.box.listscroll -side left -fill y

        pack $w.buttons1.add -side left
        pack $w.buttons1.remove -side left
        pack $w.buttons1.update -side left
        pack $w.buttons2.done -side left


	bind $w.box.list <Double-ButtonPress-1>  { load_ctcp_edit; set ctcpindex [.zipperctcps.box.list index active] }
}
proc create_banlist_window {chan} {
	set w ".zipperbanlist"
        toplevel $w
	grab $w
        wm iconname $w "Channel Ban List"
        wm title $w "Ban List"
        set font 8x13

	frame $w.bans
	frame $w.buttons

	pack $w.buttons -side bottom
	pack $w.bans -side top
	label $w.bans.channel -width 40 -text $chan
	listbox $w.bans.list -width 40
	button $w.buttons.done -text "Done" -command { destroy .zipperbanlist }
	button $w.buttons.unban -text "Unban" -command { unban_button }
	scrollbar $w.bans.listscroll -command "$w.bans.list yview"
		
	pack $w.bans.channel -side top
	pack $w.bans.list -side left
	pack $w.bans.listscroll -side right -fill y
	pack $w.buttons.unban -side left
	pack $w.buttons.done -side bottom


}                

proc ask_user {text} {
	global response
	set value ""
	set w ".askuser"
        toplevel $w
	grab $w
        wm iconname $w "Question???"
        wm title $w "Question???"

	label $w.label -width 40 -text $text
	entry $w.entry -width 40 -relief sunken

	pack $w.entry -side bottom
	pack $w.label -side top


	bind $w.entry <KeyPress-Return> {set response [.askuser.entry get]; destroy .askuser}

	focus .askuser.entry	
	tkwait window .askuser
	set value $response
	return $value
}


proc add_system_menus {w} {

set m $w.menu.file.m
menubutton $w.menu.file -text "File" -menu $m
menu $m -tearoff no
$m add command -label "Setup" -command { exec zippersetup & }
$m add separator
$m add command -label "Connect" -command { open_irc_connection}
$m add command -label "Disconnect" -command { close_irc_connection}
$m add separator
$m add command -label "Exit" -command {fake_user_in "/quit $defaultquit" }

pack $w.menu.file -side left

set m $w.menu.edit.m
menubutton $w.menu.edit -text "Edit" -menu $m
menu $m -tearoff no
$m add command -label "Aliases..." -command { fake_user_in "/edit alias" }
$m add command -label "CTCP..." -command { fake_user_in "/edit ctcp" }
$m add command -label "Events..." -command { fake_user_in "/edit events" }
$m add command -label "Ignore..." -command { fake_user_in "/edit ignore" }
$m add command -label "Notify..." -command { fake_user_in "/edit notify" }
$m add command -label "Users..." -command { fake_user_in "/edit users" }
$m add separator
$m add command -label "Add/Del Channel..." -command { modify_channels }
$m add command -label "Add/Del CTCP..." -command { modify_ctcps }
$m add command -label "Add/Del Event..." -command { modify_events }
$m add command -label "Add/Del Server..." -command { modify_servers }
$m add command -label "Add/Del User..." -command { modify_users }

pack $w.menu.edit -side left
                                                                     

set m $w.menu.about.m
menubutton $w.menu.about -text "About" -menu $m
menu $m -tearoff no

pack $w.menu.about -side right
$m add command -label "Zipper!" -command { do_about }
$m add separator
$m add command -label "README" -command { exec tkview README & }
$m add command -label "CHANGES" -command { exec tkview CHANGES & }
$m add command -label "FEATURES" -command { exec tkview FEATURES & }
}



proc do_about {} {
set about {
Zipper!
Copyright 1997
Ash Bowers

Thanks for using Zipper!
}      

  tk_dialog .about "tkEditor" $about info 0 OK           


}
