package provide dccchat 1.0

proc init_dcc_connection {tnick dccbaseport} {
	global longip
	global srvcPort 
	global s_sock
	
	set s_sock [socket -server "connect_dcc_connection $tnick" $dccbaseport ]

}
proc connect_dcc_connection {tnick sock addr port } {
	global dccnicklist
	global s_sock
	global response

	fileevent "$sock" readable [list read_dcc_sock "$sock"]
	fconfigure "$sock" -buffering line
	new_dcc_window $sock "DCC:$tnick" "$sock"
	send_to_window "dcc$sock" "Talking to $tnick...\n"
	set dccnicklist [linsert $dccnicklist end "$sock $tnick"]
	get_dcc_nick_from_socket $sock
	insert_chan_list "DCC:$response"
	close $s_sock
}

proc accept_dcc_connection {tnick dccport} {
# open the connection to the DCC server...
	global xip
	global dccnicklist
	global response

	set sock [socket $xip $dccport]
	new_dcc_window $sock "DCC:$tnick    IP: $xip    Port: $dccport" $sock
	send_to_window "dcc$sock"  "Talking to $tnick...\n"
	set dccnicklist [linsert $dccnicklist end "$sock $tnick"]
	get_dcc_nick_from_socket $sock
	insert_chan_list "DCC:$response"
	fileevent $sock readable [list read_dcc_sock "$sock"] 
	fconfigure $sock  -buffering line  

}

proc read_dcc_sock {sock} {

  set l [gets $sock]
  if {[eof $sock]} {
	close $sock
	send_to_window "dcc$sock" "DCC Session Closed\n"
	.zipperdcc$sock.entry configure -state disabled
        set eventLoop "done"
  } else {
    handle_dcc_message  $sock $l
  }
}     

proc read_dcc_user_in {sock}  {
	global nick
	global history
	global historyidx


	set l [.zipperdcc$sock.entry get]
	.zipperdcc$sock.entry delete 0 end 

	set hname [string tolower [get_dcc_nick_from_socket $sock] ]
	set historyidx(dcc:$hname) 30 
 	lappend history(dcc:$hname) $l    
	roll_off_hist dcc:$hname


#default is to send to current dcc window

  if ![string compare "/" [string index $l 0] ] {
        set l [string trimleft $l "/"]
        set_command $sock
  } else {
          send_to_window "dcc$sock" "> $l\n"
	  send_to_dcc_server $sock "$l"
  }    

}


proc get_dcc_nick_from_socket sock {
	global response
	global dccnicklist

	set i [lsearch -regexp $dccnicklist $sock]
	set tnick [lindex $dccnicklist $i]
	set tnick [lindex [split $tnick " "] 1]
		
	set response $tnick
	return $tnick

}
proc get_dcc_sock_from_nick nick {
	global response
	global dccnicklist

	set i [lsearch -regexp $dccnicklist $nick]
	set tsock [lindex $dccnicklist $i]
	set tsock [lindex [split $tsock " "] 0]
	
	set response $tsock
	return $tsock
}

proc remove_dcc_nick_list sock {

	global dccnicklist
	set i [lsearch -regexp $dccnicklist $sock]
	set n1 [lrange $dccnicklist 0 [expr $i-1] ]
	set n2 [lrange $dccnicklist [expr $i+1] end]

	set dccnicklist [list $n1 $n2]

}

proc handle_dcc_message {sock l} {
	global dccnicklist

	set i [lsearch -regexp $dccnicklist $sock]
	set tnick [lindex $dccnicklist $i]
	set tnick [lindex [split $tnick " "] 1]
	if ![string compare "\001" [string index $l 0] ] {
		set l [string trim $l "\001" ]
		set l [string trimleft $l "ACTION" ]
		set l [string trimleft $l " " ]
		send_to_window "dcc$sock" "* $tnick $l\n"
	} else {	
		send_to_window "dcc$sock" "<$tnick> $l\n"
	}

}

proc new_dcc_window {w name sock} {

global response
global textfg
global textbg
global mirccolors
global actwin


set w ".zipperdcc$sock"
toplevel $w
wm iconname $w "$name"
wm iconify $w
#set font  -adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*
set font 8x13

wm title $w $name
wm iconbitmap $w @zipperwinicon.bmp
set start 0.0
set length 0             

text $w.text  -state disabled -font $font -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 -height 20 -width 50  -foreground $mirccolors($textfg) -background $mirccolors($textbg)

scrollbar $w.scroll -command "$w.text yview"
entry $w.entry -bd 2 -relief sunken -width 30
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both
pack $w.entry -expand no -fill both


bind $w.entry <KeyPress-Up>     {select_history [focus] -1 }
bind $w.entry <KeyPress-Down>   {select_history [focus] 1 }   
bind $w.entry <Control-KeyPress-b> {[focus] insert end "\002"}
bind $w.entry <Control-KeyPress-k> {[focus] insert end "\003"}
bind $w.entry <Control-KeyPress-i> {[focus] insert end "\026"}
bind $w.entry <Control-KeyPress-u> {[focus] insert end "\037"}
bind $w.entry <Control-KeyPress-g> {[focus] insert end "\007"}      
bind $w.entry <Destroy> {canceldcc $actwin  }
bind $w.entry <KeyPress-Return> "read_dcc_user_in $sock"
bind $w  <FocusIn> {update_chan_activity 0 [focus] }   
focus $w.entry

}                   



proc canceldcc {w} {

	set sockname [lindex [split [string range $w 10 end] "."] 0]
	closedcc $sockname
}

proc closedcc sock {
	global response

	get_dcc_nick_from_socket $sock
	remove_chan_list "DCC:$response"
	remove_dcc_nick_list $sock
	destroy ".zipperdcc$sock"
	close $sock

}

proc send_to_dcc_server {wsock l} {
  puts $wsock $l           ;# send the data to the server

} 

proc encode_ip {} {
    global longip
    set longip [exec encodeip $longip]
}
proc decode_ip {} {
	global longip
	global xip
		
	set xip [exec decodeip $longip]

}
proc dccchat {type tnick connectport dccport} {

global longip
global xip

if ![string compare "get" $type] {
	decode_ip
	accept_dcc_connection $tnick $connectport
} else {
	decode_ip
	init_dcc_connection $tnick $dccport
}
}
