/* OptionEditor.C */

#include "OptionEditor.h"
// Super Class : None

/*oodB%OptionEditor*** Global Declarations and Stuffs ****/
#include "XtCore.h"
#ifdef NO_HELP
#include "DumbHelp.h"
#else
#include "Help.h"
#endif
#include <TabBook.h>
/*oodE****************************************************/

OptionEditor::OptionEditor()
{
	// Empty
}

OptionEditor::~OptionEditor()
{
	// Empty
}

OptionEditor::OptionEditor(Widget parent,Guide * guide)
{
  _guide = guide;
  _parent = parent;
  _isDisplayed = False;
  createOptionEditor();
}

void OptionEditor::createOptionEditor(void)
{
  Widget children[9];      /* Children to manage */
  Arg al[64];                    /* Arg List */
  register int ac = 0;           /* Arg Count */

  Widget w1;
  Widget w2;
  Widget w3;
  Widget w4;
  Widget w5;
  Widget w6;

  XtSetArg(al[ac], XmNdeleteResponse, XmUNMAP); ac++;
  XtSetArg(al[ac], XmNminWidth, 400); ac++;
  XtSetArg(al[ac], XmNminHeight, 500); ac++;
  _optionEditor = XtCreatePopupShell ( "optionEditor", topLevelShellWidgetClass, _parent, al, ac );
  ac = 0;

  _optionTab = XtVaCreateManagedWidget("Tab", xcgTabBookWidgetClass, 
		_optionEditor, NULL);

  ac = 0;
  w1 = XmCreatePushButton(_optionTab,"General",al,ac);
  XtManageChild(w1);

  ac = 0;
  w2 = XmCreatePushButton(_optionTab,"Compiler",al,ac);
  XtManageChild(w2);

  ac = 0;
  w3 = XmCreatePushButton(_optionTab,"Makefile",al,ac);
  XtManageChild(w3);

  ac = 0;
  w4 = XmCreatePushButton(_optionTab,"Other",al,ac);
  XtManageChild(w4);
  
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  _generalRowColumn = XmCreateRowColumn(_optionTab,"GeneralRC",al,ac);
  XtManageChild(_generalRowColumn);
  
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  _compilerRowColumn = XmCreateRowColumn(_optionTab,"CompilerRC",al,ac);
  XtManageChild(_compilerRowColumn);
  
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  _makefileRowColumn = XmCreateRowColumn(_optionTab,"MakefileRC",al,ac);
  XtManageChild(_makefileRowColumn);
  
  ac = 0;
  XtSetArg(al[ac], XmNorientation,XmVERTICAL ); ac++;
  XtSetArg(al[ac], XmNpacking,XmPACK_COLUMN ); ac++;
  XtSetArg(al[ac], XmNresizeHeight,TRUE ); ac++;
  XtSetArg(al[ac], XmNnumColumns,7); ac++;
  XtSetArg(al[ac], XmNadjustLast,FALSE ); ac++;
  _otherRowColumn = XmCreateRowColumn(_optionTab,"OtherRC",al,ac);
  XtManageChild(_otherRowColumn);
  
  ac = 0;
  _generalToggle_1 = XmCreateToggleButton(_generalRowColumn,
                                        "Standard Code Generation",al,ac);
  XtManageChild(_generalToggle_1);

  ac = 0;
  _generalToggle_2 = XmCreateToggleButton(_generalRowColumn,
                                        "Custom Code Generation",al,ac);
  XtManageChild(_generalToggle_2);

  ac = 0;
  _generalToggle_3 = XmCreateToggleButton(_generalRowColumn,
                                        "Generate Resources",al,ac);
  XtManageChild(_generalToggle_3);

  ac = 0;
  _generalToggle_4 = XmCreateToggleButton(_generalRowColumn,
                                        "Generate Externs",al,ac);
  XtManageChild(_generalToggle_4);


}


void OptionEditor::popup(void)
{
  XtPopup(_optionEditor,XtGrabNone);
  _isDisplayed = True;
}

void OptionEditor::popdown(void)
{
  XtPopdown(_optionEditor);
  _isDisplayed = False;
}

void OptionEditor::help(void)
{
#ifdef NO_HELP
  new DumbHelp("html/main_window.html",_parent);
#else
  new Help("html/main_window.html",_parent);
#endif
}
