/* XMApplicationShell.C */

#include "XMApplicationShell.h"
// Super Class : XMTopLevelShell

/*oodB%XMApplicationShell*** Global Declarations and Stuffs ****/
Pixmap XMApplicationShell::XMApplicationShell_pixmap = XmUNSPECIFIED_PIXMAP; 
Pixmap XMApplicationShell::XMApplicationShellLarge_pixmap = XmUNSPECIFIED_PIXMAP; 
res_rec XMApplicationShell::_applicationShellResources[2] = {
  /* name type value default option get set create modified */
  "argc","int","0","0","NONE",
  True,False,False,False,
  "Number of arguments in XmNargv.",
  "argv","String *","NULL","NULL","NONE",
  True,False,False,False,
  "List of command-line arguments to start the application. This is \
the standard C argv, passed in the call to XtAppInitialize(). It is \
used to set the WM_COMMAND property for this window."
};
/*oodE**********************************************************/

XMApplicationShell::~XMApplicationShell()
{
	// Empty
}

XMApplicationShell::XMApplicationShell(Widget parent,Arg* al,int ac)
{
  if(ac > 0)
    setXtArgs(al,ac);

  setParent(parent);
  createWidget(applicationshell_v);
  _numResources = 2;

  /* IF no pixmaps has been created */
  if(XMApplicationShell_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMApplicationShell_xpm, 
                                 &XMApplicationShell_pixmap, NULL, NULL ) != 0 )
    {
       XMApplicationShell_pixmap = XmUNSPECIFIED_PIXMAP;
      if(debug_set)
        cout << "Failed to create Pixmap for small " << getName() << endl;
    }
    else
    { /*  */ 
      if(debug_set)
        cout << "Created Pixmap for " << getName() << endl;
    } /*  */ 
  } /* create a pixmap */

  /* IF no pixmaps has been created */
  if(XMApplicationShellLarge_pixmap == XmUNSPECIFIED_PIXMAP)
  { /* create a pixmap */ 
    if ( XpmCreatePixmapFromData ( XtDisplay(getWidget()), 
                                 DefaultRootWindow (XtDisplay(getWidget())),
                                 XMApplicationShellLarge_xpm, 
                                 &XMApplicationShellLarge_pixmap, NULL, NULL ) != 0 )
    {
       XMApplicationShellLarge_pixmap = XmUNSPECIFIED_PIXMAP;
      if(debug_set)
        cout << "Failed to create Pixmap for large " << getName() << endl;
    }
    else
    { /*  */ 
      if(debug_set)
        cout << "Created Pixmap for " << getName() << endl;
    } /*  */ 
  } /* create a pixmap */

  /* get resources for this widget */
  storeResources();
}

Pixmap XMApplicationShell::getPixmap(void)
{
  return XMApplicationShell_pixmap;
}

Pixmap XMApplicationShell::getLargePixmap(void)
{
  return XMApplicationShellLarge_pixmap;
}

void XMApplicationShell::popup(void)
{
  XtPopup(getWidget(), XtGrabNone);
}

void XMApplicationShell::popdown(void)
{
  XtPopdown(getWidget());
}

Boolean XMApplicationShell::canbeParent(void)
{
  if(getList()->size() > 0)
    return False;
  else
    return True;
}

void XMApplicationShell::codeChild(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  *outfile << TAB << "/* " << getName() << " */" << endl;
  codeResources(outfile,tab);
  *outfile <<  TAB << "XtSetArg(al[ac], XmNargc, argc); ac++;" << endl;
  *outfile <<  TAB << "XtSetArg(al[ac], XmNargv, argv); ac++;" << endl;
  *outfile << TAB << getVarName() << " = " << endl;
  *outfile << TAB << TAB << "XtAppCreateShell ( "
           << TAB << TAB << "\"" << getWidName() << "\"" << ", " << endl
           << TAB << TAB <<"\"" << getWidName() << "\"" << ", " << endl
           << TAB << TAB <<"applicationShellWidgetClass,display, al, ac );" 
           << endl;
  *outfile << TAB << "ac = 0;" << endl;
}

res_rec * XMApplicationShell::getResources(void)
{
  return _resources;
}

int XMApplicationShell::getNumResources(void)      
{
  return _numResources;
}

void XMApplicationShell::storeResources(void)
{ /*  */ 

  int totalNumResources;

  totalNumResources = _numResources;

  _resources = (res_rec *)malloc(totalNumResources*sizeof(res_rec));
 
  memmove(_resources,_applicationShellResources,_numResources*sizeof(res_rec));

  _numResources = totalNumResources;
} /*  */ 
