/* XtCore.C */

#include "XtCore.h"
// Super Class : None

/*oodB%XtCore*** Global Declarations and Stuffs ****/
int XtCore::_widID = 0;
Boolean XtCore::_usedInclude[];
res_rec XtCore::_coreResources[19] = {
  /* name type value default option get set create modified */
  "accelerators","XtAccelerators","dynamic","dynamic","NONE",
  True,True,True,False,
  "A translation table bound with its actions for a widget. \
A destination widget can be set up to use this accelerator.",
  "ancesterSensitive","Boolean","dynamic","dynamic","True,False",
  True,True,True,False,
  "Tells wether a widget's immediate parent should receive input. \
Default value is TRUE if the widget is a toplevel shell, copied \
from the XmNancestorSensitive resource of its parent if the \
widget is a popup shell, or the bitwise AND of the XmSensitive \
and XmNancesterSensitive resources of the parent for other widgets.",
  "background","Pixel","dynamic","dynamic","NONE",
  True,True,True,False,
  "Widget's background color.",
  "backgroundPixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "Pixmap with which to tile the background, beginning at the \
upper left corner.",
  "borderColor","Pixel","XtDefaultForground","XtDefaultForground","NONE",
  True,True,True,False,
  "Pixel value that defines the color of the border.",
  "borderPixmap","Pixmap","XmUNSPECIFIED_PIXMAP","XmUNSPECIFIED_PIXMAP","NONE",
  True,True,True,False,
  "Pixmap with which to tile the border, beginning at the \
upper left corner of the border.",
  "borderWidth","Dimension","1","1","NONE",
  True,True,True,False,
  "Width (in pixels) of the window's border.",
  "colormap","Colormap","dynamic","dynamic","NONE",
  True,True,True,False,
  "Colormap used in converting to pixel values. Previously created pixel \
values are unaffected. The default value is the screen's default colormap \
for top-level shells or is copied from the parent for other windows.",
  "depth","int","dynamic","dynamic","NONE",
  True,True,True,False,
  "Number of bits allowed for each pixel. The Xt Intrinsics set this \
resource when the widget is created.As with the XmNcolormap resource, \
the default value comes from the screen's default or comes from the \
paren.",
  "destroyCallback","XtCallbackList","NULL","NULL","NONE",
  True,True,True,False,
  "List of callback invoked when the widget is destroed.",
  "height","Dimension","dynamic","dynamic","NONE",
  True,True,True,False,
  "The height of the widget in pixels, excluding the border.",
  "initialResourcesPersistent","Boolean","True","True","True,False",
  True,True,True,False,
  "Tells if the resource should be reference counted. \
If TRUE (default), it is assumed that the widget won't be destroyed \
while the application is running, and thus the widget's resources are \
are not reference counted. Set this resource to FALSE if your \
application might destroy the widget and will need to deallocate \
the resources.",
  "mappedWhenManaged","Boolean","True","True","True,False",
  True,True,True,False,
  "If TRUE (default), the widget becomes visible (is mapped) as soon as \
it is realized and managed. If FALSE, the application performs the mapping \
and unmapping of the widget. If changed to FALSE after the widget is \
realized and managed, the widget is unmmaped.",
  "screen","Screen *","dynamic","dynamic","NONE",
  True,True,True,False,
  "Screen location of the widget. The default value comes either from the \
screen's default or is copied from the parent.",
  "sensitive","Boolean","True","True","True,False",
  True,True,True,False,
  "Tells wether a widget is sensitve to input.",
  "translations","XtTranslations","dynamic","dynamic","NONE",
  True,True,True,False,
  "Point to a tranlation table; must be compiled with \
XtParseTranslationTable().",
  "width","Dimension","dynamic","dynamic","NONE",
  True,True,True,False,
  "Window width (in pixels), excluding the border.",
  "x","Position","0","0","NONE",
  True,True,True,False,
  "The x-coordinate of the widget's upper-left outer corner \
relative to the upper-left inner corner of its's parent.",
  "y","Position","0","0","NONE",
  True,True,True,False,
  "The y-coordinate of the widget's upper-left outer corner \
relative to the upper-left inner corner of its's parent."
};

/*oodE**********************************************/

XtCore::XtCore()
{
  _w = (Widget) NULL;	
  _name = "Undefined";
  _value = "Undefined";
  _varName = "Undefined";
  _widName = "Undefined";
  _widID++;
  _al = NULL;
  _ac = 0;
  _isGlobal = False;
  _pixmap = XmUNSPECIFIED_PIXMAP;
  _parent = NULL;
  _x = 0;
  _y = 0;
  _isVirtual = False;
  _isForm = False;
  _selectedSide = none_selected_v;
  _coreParent = NULL;
  _numResources = 19;
  memmove(_resources,_coreResources,_numResources*sizeof(res_rec));

  _topAttachment = XmATTACH_NONE;
  _leftAttachment = XmATTACH_NONE;
  _rightAttachment = XmATTACH_NONE;
  _bottomAttachment = XmATTACH_NONE;
  _topOffset = 0;
  _leftOffset = 0;
  _rightOffset = 0;
  _bottomOffset = 0;
  _topPosition = 0;
  _leftPosition = 0;
  _rightPosition = 0;
  _bottomPosition = 0;
  _topWidget = NULL; /* XtCore */
  _leftWidget = NULL; /* XtCore */
  _rightWidget = NULL; /* XtCore */
  _bottomWidget = NULL; /* XtCore */
}

XtCore::~XtCore()
{
  XtCore * deleted = NULL;
  int i;

  while((i=_list.size()) != 0)
  { /*  */ 
    deleted = _list[i-1];
    _list.erase(&_list[i-1]);
    delete deleted;
  } /*  */ 

  destroyWidget();
}

char* XtCore::itoa(int x)
{
  static char a[7];
  
  /* need exception here if larger than 99999 */
  sprintf(a,"_%d",x);
  return a;
}

void XtCore::storeResources(void)
{

}

void XtCore::drawAttachments(Widget w)
{
  Arg al[4];
  int ac = 0;
  Position x,y;
  Dimension width,height;
  GC red_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);
  GC blue_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);
  GC green_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);
  XtSetArg(al[ac],XmNx,&x);ac++;
  XtSetArg(al[ac],XmNy,&y);ac++;
  XtSetArg(al[ac],XmNwidth,&width);ac++;
  XtSetArg(al[ac],XmNheight,&height);ac++;
  XtGetValues(_w,al,ac);
  XSetForeground(XtDisplay(w),red_gc,getColor("red"));
  XSetForeground(XtDisplay(w),blue_gc,getColor("blue"));
  XSetForeground(XtDisplay(w),green_gc,getColor("green"));

  cout << "Top = " << (int)_topAttachment << " "
       << "Left = " << (int)_leftAttachment << " "
       << "Right = " << (int)_rightAttachment << " "
       << "Bottom = " << (int)_bottomAttachment << endl;

  /* draw XmATTACH_FORM */
  if(_topAttachment == XmATTACH_FORM)
  { /* draw top attachment */
    XDrawLine(XtDisplay(w),XtWindow(w), 
              blue_gc,
              x+CONSTRAINT_OFFSET+(width/2),y+CONSTRAINT_OFFSET,
              x+CONSTRAINT_OFFSET+(width/2),CONSTRAINT_OFFSET);
  } /* draw top attachment */
  if(_leftAttachment == XmATTACH_FORM)
  { /* draw left attachment */
    XDrawLine(XtDisplay(w),XtWindow(w), 
              blue_gc,
              CONSTRAINT_OFFSET,y+CONSTRAINT_OFFSET+(height/2),
              x+CONSTRAINT_OFFSET,y+CONSTRAINT_OFFSET+(height/2));
  } /* draw left attachment */
  if(_rightAttachment == XmATTACH_FORM)
  { /* draw right attachment */
    XDrawLine(XtDisplay(w),XtWindow(w), 
              blue_gc,
              x+CONSTRAINT_OFFSET+width,
              y+CONSTRAINT_OFFSET+(height/2),
              _coreParent->getWidth()+CONSTRAINT_OFFSET,
              y+CONSTRAINT_OFFSET+(height/2));
  } /* draw right attachment */
  if(_bottomAttachment == XmATTACH_FORM)
  { /* draw bottom attachment */
    XDrawLine(XtDisplay(w),XtWindow(w), 
              blue_gc,
              x+CONSTRAINT_OFFSET+(width/2),
              y+CONSTRAINT_OFFSET+height,
              x+CONSTRAINT_OFFSET+(width/2),
              y+CONSTRAINT_OFFSET+height+15);
  } /* draw bottom attachment */
  
  /* draw XmATTACH_WIDGET */

  XFreeGC(XtDisplay(w),red_gc);
  XFreeGC(XtDisplay(w),blue_gc);
  XFreeGC(XtDisplay(w),green_gc);
}

void XtCore::draw(Widget w)
{
  Arg al[4];
  int ac = 0;
  GC gc  = CreateXorGC(XtDisplay(w), 
              RootWindowOfScreen(XtScreen(w)), 
              XBlackPixelOfScreen(XtScreen(w)),
              XWhitePixelOfScreen(XtScreen(w)));
  GC form_gc = CreateXorGC(XtDisplay(w), 
              RootWindowOfScreen(XtScreen(w)), 
              XBlackPixelOfScreen(XtScreen(w)),
              XWhitePixelOfScreen(XtScreen(w)));
  GC red_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);
  GC blue_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);
  GC green_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);
  GC black_gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);

  Position x,y;
  Dimension width,height;

  XtSetArg(al[ac],XmNx,&x);ac++;
  XtSetArg(al[ac],XmNy,&y);ac++;
  XtSetArg(al[ac],XmNwidth,&width);ac++;
  XtSetArg(al[ac],XmNheight,&height);ac++;
  XtGetValues(_w,al,ac);

  /* if this is a form */
  if(_type == form_v)
  { /* form */

    XSetForeground(XtDisplay(w),red_gc,getColor("red"));
    XSetForeground(XtDisplay(w),blue_gc,getColor("blue"));
    XSetForeground(XtDisplay(w),green_gc,getColor("green"));
    XSetForeground(XtDisplay(w),black_gc,getColor("black"));
    XSetForeground(XtDisplay(w),form_gc,getColor("cyan"));

    /* need to resize the drawing area */
    ac = 0;
    XtSetArg(al[ac],XmNwidth,width+(Dimension)(2*CONSTRAINT_OFFSET));ac++;
    XtSetArg(al[ac],XmNheight,height+(Dimension)(2*CONSTRAINT_OFFSET));ac++;
    XtSetValues(w,al,ac);
    XDrawRectangle(XtDisplay(w),XtWindow(w),black_gc,
                 CONSTRAINT_OFFSET-1,
                 CONSTRAINT_OFFSET-1,
                 width+3,height+3);
  } /* form */
  else
  {
    XSetForeground(XtDisplay(w),red_gc,getColor("red"));
    XSetForeground(XtDisplay(w),blue_gc,getColor("blue"));
    XSetForeground(XtDisplay(w),green_gc,getColor("green"));
    XSetForeground(XtDisplay(w),black_gc,getColor("black"));
    XSetForeground(XtDisplay(w),gc,getColor("blue"));

    XDrawRectangle(XtDisplay(w),XtWindow(w),blue_gc,
                   x+CONSTRAINT_OFFSET,
                   y+CONSTRAINT_OFFSET,
                   width-1,height-1);
    XFillRectangle(XtDisplay(w),XtWindow(w),green_gc,
                   x+CONSTRAINT_OFFSET+1,
                   y+CONSTRAINT_OFFSET+1,
                   width-2,height-2);

  }
  XFreeGC(XtDisplay(w),gc);
  XFreeGC(XtDisplay(w),form_gc);
  XFreeGC(XtDisplay(w),red_gc);
  XFreeGC(XtDisplay(w),blue_gc);
  XFreeGC(XtDisplay(w),green_gc);
  XFreeGC(XtDisplay(w),black_gc);
}

void XtCore::drawSelected(Widget w,Boolean highlight)
{
  Arg al[4];
  int ac = 0;
  GC gc = XCreateGC(XtDisplay(w),RootWindowOfScreen(XtScreen(w)),0,NULL);

  Position x,y;
  Dimension width,height;

  if(highlight)
    XSetForeground(XtDisplay(w),gc,getColor("red"));
  else
    XSetForeground(XtDisplay(w),gc,getColor("green"));

  XSetLineAttributes(XtDisplay(w),gc,
                     5,
                     LineSolid,
                     CapButt,
                     JoinBevel);
  XtSetArg(al[ac],XmNx,&x);ac++;
  XtSetArg(al[ac],XmNy,&y);ac++;
  XtSetArg(al[ac],XmNwidth,&width);ac++;
  XtSetArg(al[ac],XmNheight,&height);ac++;
  XtGetValues(_w,al,ac);

  x = x + CONSTRAINT_OFFSET;
  y = y + CONSTRAINT_OFFSET;

  /* may need to highlight a side */
  switch(_selectedSide)
  { /*  */ 
  case top_selected_v:
    XDrawLine(XtDisplay(w),XtWindow(w), 
                gc,
                x+1,y+3,
                x+width-1,y+3);
    if(debug_set)
      cout << "TOP selected" << endl;
    break;
  case left_selected_v:
    XDrawLine(XtDisplay(w),XtWindow(w), 
                gc,
                x+3,y+1,
                x+3,y+height-1);
    if(debug_set)
      cout << "LEFT selected" << endl;
    break;
  case right_selected_v:
    XDrawLine(XtDisplay(w),XtWindow(w), 
                gc,
                x+width-4,y+1,
                x+width-4,y+height-1);
    if(debug_set)
      cout << "RIGHT selected" << endl;
    break;
  case bottom_selected_v:
    XDrawLine(XtDisplay(w),XtWindow(w), 
                gc,
                x+1,y+height-4,
                x+width-1,y+height-4);
    if(debug_set)
      cout << "BOTTOM selected" << endl;
    break;
  case none_selected_v:
    if(debug_set)
      cout << "NO side selected" << endl;
    break;
  } /*  */ 

  XFreeGC(XtDisplay(w),gc);
}


void XtCore::drawChildren(Widget w)
{
  int i;

  if((int)_list.size() > 0)
    for(i=0;i<(int)_list.size();i++)
      (_list[i])->draw(w);
}

void XtCore::addCallback(XString callback_name,XtCallbackProc callback,XtPointer clientdata)
{
  XtAddCallback(_w,callback_name,callback,clientdata);
}

void XtCore::createWidget(widget_type_enum type)
{

  _type = type;

  switch(type)
  {
    case applicationshell_v:

      /* set the name of the widget */
      _widName = _name = "ApplicationShell";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            topLevelShellWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case toplevelshell_v:

      /* set the name of the widget */
      _widName = _name = "TopLevelShell";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            topLevelShellWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case arrowbutton_v:

      /* set the name of the widget */
      _widName = _name = "ArrowButton";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmArrowButtonWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case arrowbuttongadget_v:

      /* set the name of the widget */
      _widName = _name = "ArrowButtonGadget";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmArrowButtonGadgetClass,
                            _parent,
                            _al,_ac);
      break;
    case bulletinboard_v:

      /* set the name of the widget */
      _widName = _name = "BulletinBoard";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmBulletinBoardWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case cascadebutton_v:

      /* set the name of the widget */
      _widName = _name = "CascadeButton";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmCascadeButtonWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case cascadebuttongadget_v:

      /* set the name of the widget */
      _widName = _name = "CascadeButtonGadget";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmCascadeButtonGadgetClass,
                            _parent,
                            _al,_ac);
      break;
    case command_v:

      /* set the name of the widget */
      _widName = _name = "Command";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmCommandWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case dialogshell_v:

      /* set the name of the widget */
      _widName = _name = "DialogShell";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmDialogShellWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case drawingarea_v:

      /* set the name of the widget */
      _widName = _name = "DrawingArea";
      _varName = _name + itoa(_widID);

      /* create the widget */
       _w = XtCreateWidget((char *) _widName.data(),
                             xmDrawingAreaWidgetClass,
                             _parent,
                             _al,_ac);
      break;
    case drawnbutton_v:

      /* set the name of the widget */
      _widName = _name = "DrawnButton";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmDrawnButtonWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case errordialog_v:

      /* set the name of the widget */
      _widName = _name = "ErrorDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateErrorDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case fileselectionbox_v:

      /* set the name of the widget */
      _widName = _name = "FileSelectionBox";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmFileSelectionBoxWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case form_v:

      /* set the name of the widget */
      _widName = _name = "Form";
      _varName = _name + itoa(_widID);
      _isForm = True;

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmFormWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case formdialog_v:

      /* set the name of the widget */
      _widName = _name = "FormDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateFormDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case frame_v:

      /* set the name of the widget */
      _widName = _name = "Frame";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmFrameWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case informationdialog_v:

      /* set the name of the widget */
      _widName = _name = "InformationDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateInformationDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case label_v:

      /* set the name of the widget */
      _widName = _name = "Label";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmLabelWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case labelgadget_v:

      /* set the name of the widget */
      _widName = _name = "LabelGadget";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmLabelGadgetClass,
                            _parent,
                            _al,_ac);
      break;
    case list_v:

      /* set the name of the widget */
      _widName = _name = "List";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmListWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case mainwindow_v:

      /* set the name of the widget */
      _widName = _name = "MainWindow";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmMainWindowWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case menubar_v:

      /* set the name of the widget */
      _widName = _name = "MenuBar";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateMenuBar(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case messagebox_v:

      /* set the name of the widget */
      _widName = _name = "MessageBox";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmMessageBoxWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case optionmenu_v:

      /* set the name of the widget */
      _widName = _name = "OptionMenu";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateOptionMenu(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case panedwindow_v:

      /* set the name of the widget */
      _widName = _name = "PanedWindow";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmPanedWindowWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case popupmenu_v:

      /* set the name of the widget */
      _widName = _name = "PopupMenu";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreatePopupMenu(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case promptdialog_v:

      /* set the name of the widget */
      _widName = _name = "PromptDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreatePromptDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case pulldownmenu_v:
 
      /* set the name of the widget */
      _widName = _name = "PulldownMenu";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreatePulldownMenu(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case pushbutton_v:

      /* set the name of the widget */
      _widName = _name = "PushButton";
      _varName = _name + itoa(_widID);
      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmPushButtonWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case pushbuttongadget_v:

      /* set the name of the widget */
      _widName = _name = "PushButtonGadget";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmPushButtonGadgetClass,
                            _parent,
                            _al,_ac);
      break;
    case questiondialog_v:

      /* set the name of the widget */
      _widName = _name = "QuestionDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateQuestionDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case radiobox_v:

      /* set the name of the widget */
      _widName = _name = "RadioBox";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateRadioBox(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case rowcolumn_v:

      /* set the name of the widget */
      _widName = _name = "RowColumn";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmRowColumnWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case scale_v:

      /* set the name of the widget */
      _widName = _name = "Scale";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmScaleWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case scrollbar_v:

      /* set the name of the widget */
      _widName = _name = "ScrollBar";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmScrollBarWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case scrolledlist_v:

      /* set the name of the widget */
      _widName = _name = "ScrolledList";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateScrolledList(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case scrolledtext_v:

      /* set the name of the widget */
      _widName = _name = "ScrolledText";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateScrolledText(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case scrolledwindow_v:

      /* set the name of the widget */
      _widName = _name = "ScrolledWindow";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmScrolledWindowWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case selectionbox_v:

       /* set the name of the widget */
      _widName = _name = "SelectionBox";
      _varName = _name + itoa(_widID);

     /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmSelectionBoxWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case selectiondialog_v:

      /* set the name of the widget */
      _widName = _name = "SelectionDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateSelectionDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case separator_v:

      /* set the name of the widget */
      _widName = _name = "Separator";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmSeparatorWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case separatorgadget_v:

      /* set the name of the widget */
      _widName = _name = "SeparatorGadget";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmSeparatorGadgetClass,
                            _parent,
                            _al,_ac);
      break;
    case tabbook_v:

      /* set the name of the widget */
      _widName = _name = "TabBook";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w =  XtCreateManagedWidget(_widName.data(), xcgTabBookWidgetClass, 
		_parent, _al,_ac);
      break;
    case templatedialog_v:

      /* set the name of the widget */
      _widName = _name = "TemplateDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateTemplateDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case text_v:

      /* set the name of the widget */
      _widName = _name = "Text";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmTextWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case textfield_v:

      /* set the name of the widget */
      _widName = _name = "TextField";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmTextFieldWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case togglebutton_v:

      /* set the name of the widget */
      _widName = _name = "ToggleButton";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmToggleButtonWidgetClass,
                            _parent,
                            _al,_ac);
      break;
    case togglebuttongadget_v:

      /* set the name of the widget */
      _widName = _name = "ToggleButtonGadget";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XtCreateWidget((char *) _widName.data(),
                            xmToggleButtonGadgetClass,
                            _parent,
                            _al,_ac);
      break;
    case warningdialog_v:

      /* set the name of the widget */
      _widName = _name = "WarningDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateWarningDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case workingdialog_v:

      /* set the name of the widget */
      _widName = _name = "WorkingDialog";
      _varName = _name + itoa(_widID);

      /* create the widget */
      _w = XmCreateWorkingDialog(_parent,(char *) _widName.data(),_al,_ac);
      break;
    case last_widget_type_v:
      if(debug_set)
        cout << "last_widget_type_v" << endl;
      break;
  }
  _al = NULL;
  _ac = 0;
}

void XtCore::destroyWidget(void)
{
  XtDestroyWidget(_w);
  _w = (Widget) NULL;
}

void XtCore::saveWidget(void)
{
	// Empty
}

void XtCore::print(void)
{
  // Empty
}

XtCallbackList XtCore::getCallbacks(void)
{
  // Empty
}

void XtCore::setCallbacks(XtCallbackList callb)
{
  // Empty
}

Pixmap XtCore::getPixmap(void)
{
  return _pixmap;
}

Pixmap XtCore::getLargePixmap(void)
{
  return _pixmap;
}

void XtCore::setX(int x)
{
  _x = x;
}

void XtCore::setY(int y)
{
  _y = y;
}

void XtCore::setID(int id)
{
  _widID = id;
}

int XtCore::getX(void)
{
  return _x;
}

int XtCore::getY(void)
{
  return _y;
}

int XtCore::getID(void)
{
  return _widID;
}


Widget XtCore::getWidget(void)
{
	return _w;
}

Widget XtCore::getParent(void)
{
	return _parent;
}

void XtCore::setParent(Widget parent)
{
	_parent = parent;
}

Boolean XtCore::isGlobal(void)
{
	return _isGlobal;
}

Boolean XtCore::isForm(void)
{
  return _isForm;
}

void XtCore::setGlobal(Boolean global)
{
	_isGlobal = global;
}

void XtCore::setName(string name)
{
	_name = name;
}

void XtCore::setWidName(string widName)
{
  Arg al[2];
  int ac = 0;
  XmString xmstr;
  _widName = widName;

  switch(_type)
  {
    case cascadebutton_v:
    case cascadebuttongadget_v:
    case label_v:
    case labelgadget_v:
    case pushbutton_v:
    case pushbuttongadget_v:
    case togglebutton_v:
    case togglebuttongadget_v:
      xmstr = XmStringCreate((char *) widName.data(),XmFONTLIST_DEFAULT_TAG);
      XtSetArg(al[ac],XmNlabelString,xmstr);ac++;
      XtSetValues(_w,al,ac);
      XmStringFree (xmstr);
    break;
  }
}

void XtCore::setWidget(Widget w)
{
  _w = w;
}

void XtCore::setValue(string value)
{
	_value = value;
}

void XtCore::setVarName(string varName)
{
	_varName = varName;
}

string XtCore::getName(void)
{
	return _name;
}

string XtCore::getWidName(void)
{
	return _widName;
}

string XtCore::getValue(void)
{
	return _value;
}

string XtCore::getVarName(void)
{
	return _varName;
}

void XtCore::manageChild(void)
{
  XtManageChild(_w);
}

void XtCore::unmanageChild(void)
{
  XtUnmanageChild(_w);
}

void XtCore::setXtArgs(Arg* al,int ac)
{
  _ac = ac;
  _al = al;
}

void XtCore::setXtValues(void)
{
  XtSetValues(_w,_al,_ac);
  _ac = 0;
}

void XtCore::addChild(XtCore* child)
{
  _list.insert(_list.begin(),child);
}

void XtCore::addChildLeft(XtCore* child)
{
	addChild(child);
}

void XtCore::addChildRight(XtCore* child)
{
	_list.insert(_list.end(),child);
}

void XtCore::removeChild(XtCore* child)
{
  int i;
  XtCore * deleted = NULL;

  for(i=0;i<(int)_list.size();i++)
  { /*  */ 
    if(_list[i] == child)
    { /*  */ 
      deleted = _list[i];
      _list.erase(&_list[i]);
      delete deleted;
      break;
    } /*  */ 
  } /*  */ 
}

void XtCore::removeChild(int index)
{
  int i;

  XtCore *deleted = NULL;


  deleted =_list[index];
  _list.erase(&_list[index]);

  delete deleted;
}

void XtCore::copyChild(XtCore* child,XtCore* copy)
{
	// Empty
}

void XtCore::showChildren(void)
{
  int i;

  if((int)_list.size() > 0)
    cout << "List for <" << _varName << "> :" << endl;

  for(i=0;i<(int)_list.size();i++)
  { /*  */ 
    cout << "  " << (_list[i])->getName() << endl;
    (_list[i])->showChildren();
  } /*  */ 
}

void XtCore::saveChildren(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  saveChild(outfile,tab);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->saveChildren(outfile,tab+1);
  } /* for each child */ 

  /* if there are children and this is a from */
  if((_list.size() > 0) && (_type == form_v))
    saveAttachments(outfile,tab+1);
  *outfile << TAB << "}" << endl;
}

void XtCore::saveChild(ofstream *outfile, int tab)
{
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  *outfile << TAB << "Object:" << _type << ":" 
           << _widName << ":" << _varName << endl << TAB << "{" 
           << endl;

  saveResources(outfile,tab+1);
}

void XtCore::saveResources(ofstream * outfile, int tab)
{
  int index = 0;
  int numRes = 0;
  res_rec * list;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  numRes = getNumResources();
  list = getResources();
  cout << "Number of resources = " << getNumResources() << endl;
  *outfile << TAB << "Resources:" << endl << TAB << "{" << endl;
  for(index=0;index<numRes;index++)
  { /*  */ 
    if(list[index].modified)
    { /*  */ 
      *outfile << TAB << list[index].resource_name
               << ":" << list[index].resource_value << endl;
    } /*  */ 
  } /*  */ 
  numRes = getNumCoreResources();
  list = getCoreResources();
  for(index=0;index<numRes;index++)
  { /*  */ 
    if(list[index].modified)
    { /*  */ 
      *outfile << TAB << list[index].resource_name
               << ":" << list[index].resource_value << endl;
    } /*  */ 
  } /*  */ 

  *outfile << TAB << "}" << endl;
}

void XtCore::saveAttachments(ofstream * outfile, int tab)
{
  int index = 0;
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */
  *outfile << TAB << "Attachments:" << endl << TAB << "{" << endl;
  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->saveAttachment(outfile,tab+1);
  } /* for each child */ 
  *outfile << TAB << "}" << endl;
}

void XtCore::saveAttachment(ofstream * outfile, int tab)
{
  int index = 0;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */
  *outfile << TAB << "Attachment:" << endl << TAB << "{" << endl;
  updateAttachments();
  *outfile << TAB << "topAttachment:" 
           << getAttachString(_topAttachment) << endl;
  *outfile << TAB << "leftAttachment:" 
           << getAttachString(_leftAttachment) << endl;
  *outfile << TAB << "rightAttachment:" 
           << getAttachString(_rightAttachment) << endl;
  *outfile << TAB << "bottomAttachment:" 
           << getAttachString(_bottomAttachment) << endl;
  if(_topOffset)
  *outfile << TAB << "topOffset:"
           << _topOffset << endl;
  if(_leftOffset)
  *outfile << TAB << "leftOffset:"
           << _leftOffset << endl;
  if(_rightOffset)
  *outfile << TAB << "rightOffset:"
           << _rightOffset << endl;
  if(_bottomOffset)
  *outfile << TAB << "bottomOffset:"
           << _bottomOffset << endl;
  if(_topPosition)
  *outfile << TAB << "topPosition:"
           << _topPosition << endl;
  if(_leftPosition)
  *outfile << TAB << "leftPosition:"
           << _leftPosition << endl;
  if(_rightPosition)
  *outfile << TAB << "rightPosition:"
           << _rightPosition << endl;
  if(_bottomPosition)
  *outfile << TAB << "bottomPosition:"
           << _bottomPosition << endl;
  if(_topWidget)
  *outfile << TAB << "topWidget:"
           << _topWidget->getVarName() << endl;
  if(_leftWidget)
  *outfile << TAB << "leftWidget:"
           << _leftWidget->getVarName() << endl;
  if(_rightWidget)
  *outfile << TAB << "rightWidget:"
           << _rightWidget->getVarName() << endl;
  if(_bottomWidget)
  *outfile << TAB << "bottomWidget:"
           << _bottomWidget->getVarName() << endl;

  *outfile << TAB << "}" << endl;
}

char * XtCore::getAttachString(unsigned char attach)
{
  static char attach_str[64];
  
  switch(attach)
  { /*  */ 
    case XmATTACH_NONE:
      strcpy(attach_str,"XmATTACH_NONE");
      break;
    case XmATTACH_WIDGET:
      strcpy(attach_str,"XmATTACH_WIDGET");
      break;
    case XmATTACH_OPPOSITE_WIDGET:
      strcpy(attach_str,"XmATTACH_OPPOSITE_WIDGET");
      break;
    case XmATTACH_FORM:
      strcpy(attach_str,"XmATTACH_FORM");
      break;
    case XmATTACH_OPPOSITE_FORM:
      strcpy(attach_str,"XmATTACH_OPPOSITE_FORM");
      break;
    case XmATTACH_POSITION:
      strcpy(attach_str,"XmATTACH_POSITION");
      break;
    case XmATTACH_SELF:
      strcpy(attach_str,"XmATTACH_SELF");
      break;
    default:
      strcpy(attach_str,"");
      break;
  } /*  */
  return attach_str;
}

Boolean XtCore::operator==(XtCore* child)
{
  if((_name == child->getName()) &&
     (_widID == child->getID()))
    return True;
  else
    return False;
}

Boolean XtCore::operator!=(XtCore* child)
{
  if((_name == child->getName()) &&
     (_widID == child->getID()))
    return False;
  else
    return True;
}

widget_type_enum XtCore::getType(void)
{
	return _type;
}

void XtCore::popup(void)
{
	// Empty
}

void XtCore::popdown(void)
{
	// Empty
}

Boolean XtCore::canbeParent(void)
{
  /* By default a widget can be a parent of another widget 
   * unless specifically disallowed in the widget class itself 
   */
  return True;
}

void XtCore::widgetPosition(int x, int y,int & total_x,int & total_y)
{
  XtCore * temp = NULL;
  int i = 0;

  // this carries the total width of the drawing
  total_x = x;

  // no clue what this does :-D
  if((y+SPACE) > total_y)
    total_y = y+SPACE;

  /* find each child */
  for(i=0;i<(int)_list.size();i++)
  { /* next item */ 
    temp = _list[i];
    temp->widgetPosition(x, y+SPACE, total_x, total_y);
    temp->setX((x + total_x) / 2);
    temp->setY(y+SPACE);

    x = total_x + SPACE;
  } /* next item */ 
}

void XtCore::drawWidgets(GC gc, Widget w)
{
  XtCore * temp = NULL;
  XtCore * prev = NULL;
  int i;
  
  XCopyArea(XtDisplay(w), getPixmap(), XtWindow(w),
            gc,0,0,WIDGET_SIZE_X,WIDGET_SIZE_Y,
            getX(), getY());

  if((int)_list.size() > 0)
  { /*  */ 
    temp = _list[0];

    /* draw a dashed line for popupmenu */
    if(temp->getType() == popupmenu_v)
    { /*  */ 
      XSetLineAttributes(XtDisplay(w),gc,0,LineOnOffDash,CapRound,JoinRound);
      XDrawLine(XtDisplay(w), 
              XtWindow(w), 
              gc,
              getX(),
              getY()+WIDGET_SIZE,
              getX(),
              getY()+WIDGET_SIZE+(WIDGET_SPACING/2));
    } /*  */ 
    else
      XDrawLine(XtDisplay(w), 
              XtWindow(w), 
              gc,
              getX()+(WIDGET_SIZE/2),
              getY()+WIDGET_SIZE,
              getX()+(WIDGET_SIZE/2),
              getY()+WIDGET_SIZE+(WIDGET_SPACING/2));

    /* reset to straight line for popupmenu */
    if(temp->getType() == popupmenu_v)
      XSetLineAttributes(XtDisplay(w),gc,0,LineSolid,CapRound,JoinRound);
  } /*  */ 

  /* find each child */
  for(i=0;i<(int)_list.size();i++)
  {
    temp = _list[i];
    
    if(i>=1)
    { /*  */ 
      prev = _list[i-1];
      XDrawLine(XtDisplay(w), XtWindow(w), gc,
                prev->getX()+(WIDGET_SIZE/2),
                prev->getY()-(WIDGET_SPACING/2),
                temp->getX()+(WIDGET_SIZE/2),
                temp->getY()-(WIDGET_SPACING/2));
    } /*  */ 

    temp->drawWidgets(gc,w);

    /* draw a dashed line for popupmenu */
    if(temp->getType() == popupmenu_v)
    { /*  */ 
      XSetLineAttributes(XtDisplay(w),gc,0,LineOnOffDash,CapRound,JoinRound);
      XDrawLine(XtDisplay(w), XtWindow(w), gc,
              temp->getX(),
              temp->getY(),
              temp->getX(),
              temp->getY() - (WIDGET_SPACING/2));
    } /*  */ 
    else
      XDrawLine(XtDisplay(w), XtWindow(w), gc,
              temp->getX() + WIDGET_SIZE/2,
              temp->getY(),
              temp->getX() + (WIDGET_SIZE/2),
              temp->getY() - (WIDGET_SPACING/2));

    /* reset to straight line for popupmenu */
    if(temp->getType() == popupmenu_v)
      XSetLineAttributes(XtDisplay(w),gc,0,LineSolid,CapRound,JoinRound);
  }

}

vector<XtCore *> *XtCore::getList(void)
{
  return &_list;
}

Boolean XtCore::isVirtual(void)
{
  return _isVirtual;
}

void XtCore::setVirtual(Boolean isVirtual)
{
  _isVirtual = isVirtual;
}

void XtCore::setCoreParent(XtCore * parent)
{
  _coreParent = parent;
}

XtCore * XtCore::getCoreParent(void)
{
  return _coreParent;
}

void XtCore::codeGlobalDeclarations(ofstream *outfile)
{
  int i;
  codeGlobalDeclaration(outfile);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->codeGlobalDeclarations(outfile);
  } /* for each child */
}

void XtCore::codeGlobalDeclaration(ofstream *outfile)
{
  if(_isGlobal)
    *outfile << "Widget " << _varName <<  " = (Widget) NULL;" << endl;
}

void XtCore::codeLocalDeclarations(ofstream *outfile)
{
  int i;
  
  codeLocalDeclaration(outfile);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->codeLocalDeclarations(outfile);
  } /* for each child */
}

void XtCore::codeLocalDeclaration(ofstream *outfile)
{
  if(!_isGlobal)
    *outfile << "  Widget " << _varName <<  " = (Widget) NULL;" << endl;
}

void XtCore::codeExterns(ofstream *outfile)
{
  int i;
  codeExtern(outfile);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->codeExterns(outfile);
  } /* for each child */
}

void XtCore::codeExternsCreate(ofstream *outfile)
{
  int i;
  *outfile << " extern Widget create_"
           << getWidName()
           << "(Widget parent);"
           << endl;
}

void XtCore::codeExtern(ofstream *outfile)
{
  if(_isGlobal)
    *outfile << "extern Widget " << _varName << ";" << endl;
}

void XtCore::codeXResources(ofstream *outfile)
{
  int i;
  codeXResource(outfile);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->codeXResources(outfile);
  } /* for each child */ 
}

void XtCore::codeXResource(ofstream *outfile)
{
  *outfile << "! " << _widName << endl;
  if(_generateResource)
    *outfile << "! Resources go here" << endl;
}

void XtCore::codeCreateInterfaces(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  *outfile << "  create" 
           << getCreationFunctionName()
           << "(top);"
           << endl;
}

void XtCore::codeChildren(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  codeChild(outfile,tab);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->codeChildren(outfile,tab);
  } /* for each child */ 

  /* if there are children and this is a from */
  if((_list.size() > 0) && (_type == form_v))
    codeAttachments(outfile,tab);
}

void XtCore::codeChild(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  *outfile << TAB << "/* " << _name << " */" << endl;
  codeResources(outfile,tab);
  *outfile << TAB << "/* " << getVarName() << " */" << endl;
  *outfile << TAB << getVarName() << " = " << endl;
  if(getCoreParent() != NULL)
  { /*  */ 
    *outfile << TAB << TAB<< (getCreateFunctionName(_type)).data() << "(" 
             << (getCoreParent())->getVarName()
             << ", \"" << getWidName() << "\""
             << ", al, ac);" << endl;
  } /*  */ 
  else
  { /*  */ 
    *outfile << TAB << TAB << (getCreateFunctionName(_type)).data() << "(" 
             << "parent"
             << ", \"" << getWidName() << "\""
             << ", al, ac);" << endl;
  } /*  */ 
  *outfile << TAB << "XtManageChild(" << getVarName() << ");" << endl;
  *outfile << TAB << "ac = 0;" << endl;
}

void XtCore::codeAttachments(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */
    (_list[i])->codeAttachment(outfile,tab);
  } /* for each child */
}

void XtCore::codeAttachment(ofstream *outfile, int tab)
{
  int i;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  *outfile << TAB << "/* Attachments for " << _name << " */" << endl;
  if(_topAttachment != XmATTACH_NONE)
  *outfile << TAB << "XtSetArg(al[ac],XmNtopAttachment,"
           << getAttachString(_topAttachment) 
           << ");ac++;" << endl;
  if(_topOffset)
  *outfile << TAB << "XtSetArg(al[ac],XmNtopOffset,"
           << _topOffset <<");ac++;" << endl;
  if(_topPosition)
  *outfile << TAB << "XtSetArg(al[ac],XmNtopPosition,"
           << _topPosition <<");ac++;" << endl;
  if(getTopWidget() != NULL)
  *outfile << TAB << "XtSetArg(al[ac],XmNtopWidget,"
           << getTopWidget()->getVarName() <<");ac++;" << endl;

  if(_bottomAttachment != XmATTACH_NONE)
  *outfile << TAB << "XtSetArg(al[ac],XmNbottomAttachment,"
           << getAttachString(_bottomAttachment) 
           << ");ac++;" << endl;
  if(_bottomOffset)
  *outfile << TAB << "XtSetArg(al[ac],XmNbottomOffset,"
           << _bottomOffset <<");ac++;" << endl;
  if(_bottomPosition)
  *outfile << TAB << "XtSetArg(al[ac],XmNbottomPosition,"
           << _bottomPosition <<");ac++;" << endl;
  if(getBottomWidget() != NULL)
  *outfile << TAB << "XtSetArg(al[ac],XmNbottomWidget,"
           << getBottomWidget()->getVarName() <<");ac++;" << endl;

  if(_leftAttachment != XmATTACH_NONE)
  *outfile << TAB << "XtSetArg(al[ac],XmNleftAttachment,"
           << getAttachString(_leftAttachment) 
           << ");ac++;" << endl;
  if(_leftOffset)
  *outfile << TAB << "XtSetArg(al[ac],XmNleftOffset,"
           << _leftOffset <<");ac++;" << endl;
  if(_leftPosition)
  *outfile << TAB << "XtSetArg(al[ac],XmNleftPosition,"
           << _leftPosition <<");ac++;" << endl;
  if(getLeftWidget() != NULL)
  *outfile << TAB << "XtSetArg(al[ac],XmNleftWidget,"
           << getLeftWidget()->getVarName() <<");ac++;" << endl;

  if(_rightAttachment != XmATTACH_NONE)
  *outfile << TAB << "XtSetArg(al[ac],XmNrightAttachment,"
           << getAttachString(_rightAttachment) 
           << ");ac++;" << endl;
  if(_rightOffset)
  *outfile << TAB << "XtSetArg(al[ac],XmNrightOffset,"
           << _rightOffset <<");ac++;" << endl;
  if(_rightPosition)
  *outfile << TAB << "XtSetArg(al[ac],XmNrightPosition,"
           << _rightPosition <<");ac++;" << endl;
  if(getRightWidget() != NULL)
  *outfile << TAB << "XtSetArg(al[ac],XmNrightWidget,"
           << getRightWidget()->getVarName() <<");ac++;" << endl;

  if((_topAttachment != XmATTACH_NONE) ||
     (_bottomAttachment != XmATTACH_NONE) ||
     (_leftAttachment != XmATTACH_NONE) ||
     (_rightAttachment != XmATTACH_NONE))
  {
    *outfile << TAB << "XtSetValues("
             << getVarName() << ",al,ac);" << endl;
    *outfile << TAB << "ac = 0;" << endl;
  }

}

void XtCore::codeResources(ofstream *outfile, int tab)
{
  int index;
  int numRes = 0;
  res_rec * list;
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */
  numRes = getNumResources();
  list = getResources();
  *outfile << TAB << "/* Resources for " << _varName << " */" << endl;

  for(index=0;index<numRes;index++)
  { /*  */ 
    if(list[index].modified)
    { /*  */
      generateResourceCode(outfile,tab,&list[index]);
      *outfile << TAB << "XtSetArg(al[ac], XmN" << list[index].resource_name
               << "," << list[index].resource_value << ");ac++;" << endl;
    } /*  */ 
  } /*  */ 
  numRes = getNumCoreResources();
  list = getCoreResources();
  for(index=0;index<numRes;index++)
  { /*  */ 
    if(list[index].modified)
    { /*  */ 
      generateResourceCode(outfile,tab,&list[index]);
    } /*  */ 
  } /*  */   
}

void XtCore::generateResourceCode(ofstream *outfile, int tab,res_rec *resource)
{
  int tabindex = 0;
  char TAB[100];

  for(tabindex = 0; tabindex<(tab*2);tabindex++)
  { /*  */ 
    TAB[tabindex] = ' ';
    TAB[tabindex+1] = '\0';
  } /*  */

  if(strcmp(resource->resource_type,"int")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << TAB << "XtSetArg(al[ac], XmN" << resource->resource_name
               << "," << resource->resource_value << ");ac++;" << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"Boolean")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << TAB << "XtSetArg(al[ac], XmN" << resource->resource_name
               << "," << resource->resource_value << ");ac++;" << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"UnsignedChar")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << TAB << "XtSetArg(al[ac], XmN" << resource->resource_name
               << "," << resource->resource_value << ");ac++;" << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"XmString")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"String")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << TAB << "XtSetArg(al[ac], XmN" << resource->resource_name
               << "," << resource->resource_value << ");ac++;" << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"Dimension")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << TAB << "XtSetArg(al[ac], XmN" << resource->resource_name
               << "," << resource->resource_value << ");ac++;" << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"Position")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << TAB << "XtSetArg(al[ac], XmN" << resource->resource_name
               << "," << resource->resource_value << ");ac++;" << endl;
  } /*  */ 
  if(strcmp(resource->resource_type,"Pixel")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
    *outfile << endl;
    *outfile << "  from_value.addr = \"" << resource->resource_value << "\";\n";
    *outfile << "  from_value.size = strlen( from_value.addr ) + 1;\n";
    *outfile << "  to_value.addr = NULL;\n";
    *outfile << "  XtConvertAndStore (" 
             << getCoreParent()->getVarName()
             << ",\n";
    *outfile << "                 XmRString, &from_value, \n";
    *outfile << "                 XmRPixel, &to_value);\n";
    *outfile << "  if ( to_value.addr )\n";
    *outfile << "  {\n";
    *outfile << "    XtSetArg(al[ac],XmN" 
             << resource->resource_name
             << ",*(int *)to_value.addr);ac++;\n";
    *outfile << "  }\n";
  } /*  */ 
  if(strcmp(resource->resource_type,"Pixmap")==0)
  { /*  */ 
    cout << resource->resource_name << " is of type " 
         << resource->resource_type << endl;
  } /*  */ 
}

void XtCore::codeIncludes(ofstream *outfile)
{
  int i;
  codeInclude(outfile);

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->codeIncludes(outfile);
  } /* for each child */ 
}

void XtCore::manageChildren(void)
{
  int i;

  /* go through list in reverse order */
  for(i=(int)_list.size()-1;i>=0;i--)
  { /* for each child */

    /* Only save if the children are real
     * if they are from a convinience routine
     * don't, they will be recreated that way
     */
    if(!(_list[i])->isVirtual())
      (_list[i])->manageChildren();
  } /* for each child */ 

  manageChild();
}

void XtCore::codeInclude(ofstream *outfile)
{
  if(!_usedInclude[_type])
  { /*  */ 
    switch(_type)
    { /*  */
    case applicationshell_v:
        *outfile << "/* ApplicationShell */" << endl;
      break;
    case toplevelshell_v:
        *outfile << "/* TopLevelShellShell */" << endl;
      break;
    case arrowbutton_v:
        *outfile << "#include <Xm/ArrowB.h>" << endl;
      break;
    case arrowbuttongadget_v:
        *outfile << "#include <Xm/ArrowBG.h>" << endl;
      break;
    case bulletinboard_v:
        *outfile << "#include <Xm/BulletinB.h>" << endl;
      break;
    case cascadebutton_v:
        *outfile << "#include <Xm/CascadeB.h>" << endl;
      break;
    case cascadebuttongadget_v:
        *outfile << "#include <Xm/CascadeBG.h>" << endl;
      break;
    case command_v:
        *outfile << "#include <Xm/Command.h>" << endl;
      break;
    case dialogshell_v:
        *outfile << "#include <Xm/DialogS.h>" << endl;
      break;
    case drawingarea_v:
        *outfile << "#include <Xm/DrawingA.h>" << endl;
      break;
    case drawnbutton_v:
        *outfile << "#include <Xm/DrawnB.h>" << endl;
      break;
    case errordialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[messagebox_v])
        { /*  */ 
          _usedInclude[messagebox_v] = True;
          *outfile << "#include <Xm/MessageB.h>" << endl;
        } /*  */ 
      break;
    case fileselectionbox_v:
        *outfile << "#include <Xm/FileSB.h>" << endl;
      break;
    case form_v:
        *outfile << "#include <Xm/Form.h>" << endl;
      break;
    case formdialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[form_v])
        { /*  */ 
          *outfile << "#include <Xm/Form.h>" << endl;
          _usedInclude[form_v] = True;
        } /*  */ 
      break;
    case frame_v:
        *outfile << "#include <Xm/Frame.h>" << endl;
      break;
    case informationdialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[messagebox_v])
        { /*  */ 
          _usedInclude[messagebox_v] = True;
          *outfile << "#include <Xm/MessageB.h>" << endl;
        } /*  */ 
      break;
    case label_v:
        *outfile << "#include <Xm/Label.h>" << endl;
      break;
    case labelgadget_v:
        *outfile << "#include <Xm/LabelG.h>" << endl;
      break;
    case list_v:
        *outfile << "#include <Xm/List.h>" << endl;
      break;
    case mainwindow_v:
        *outfile << "#include <Xm/MainW.h>" << endl;
      break;
    case menushell_v:
        *outfile << "#include <Xm/MenuShell.h>" << endl;
      break;
    case menubar_v:
        if(!_usedInclude[rowcolumn_v])
        { /*  */ 
          *outfile << "#include <Xm/RowColumn.h>" << endl;
          _usedInclude[rowcolumn_v] = True;
        } /*  */ 
      break;
    case messagebox_v:
        *outfile << "#include <Xm/MessageB.h>" << endl;
      break;
    case optionmenu_v:
        if(!_usedInclude[rowcolumn_v])
        { /*  */ 
          *outfile << "#include <Xm/RowColumn.h>" << endl;
          _usedInclude[rowcolumn_v] = True;
        } /*  */ 
      break;
    case panedwindow_v:
        *outfile << "#include <Xm/PanedW.h>" << endl;
      break;
    case popupmenu_v:
        if(!_usedInclude[rowcolumn_v])
        { /*  */ 
          *outfile << "#include <Xm/RowColumn.h>" << endl;
          _usedInclude[rowcolumn_v] = True;
        } /*  */ 
      break;
    case promptdialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
      break;
    case pulldownmenu_v:
        if(!_usedInclude[rowcolumn_v])
        { /*  */ 
          *outfile << "#include <Xm/RowColumn.h>" << endl;
          _usedInclude[rowcolumn_v] = True;
        } /*  */ 
      break;
    case pushbutton_v:
        *outfile << "#include <Xm/PushB.h>" << endl;
      break;
    case pushbuttongadget_v:
        *outfile << "#include <Xm/PushBG.h>" << endl;
      break;
    case questiondialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[messagebox_v])
        { /*  */ 
          _usedInclude[messagebox_v] = True;
          *outfile << "#include <Xm/MessageB.h>" << endl;
        } /*  */ 
      break;
    case radiobox_v:
        if(!_usedInclude[rowcolumn_v])
        { /*  */ 
          *outfile << "#include <Xm/RowColumn.h>" << endl;
          _usedInclude[rowcolumn_v] = True;
        } /*  */ 
      break;
    case rowcolumn_v:
        *outfile << "#include <Xm/RowColumn.h>" << endl;
      break;
    case scale_v:
        *outfile << "#include <Xm/Scale.h>" << endl;
      break;
    case scrollbar_v:
        *outfile << "#include <Xm/ScrollBar.h>" << endl;
      break;
    case scrolledlist_v:
        if(!_usedInclude[scrolledwindow_v])
        { /*  */ 
          *outfile << "#include <Xm/ScrolledW.h>" << endl;
          _usedInclude[scrolledwindow_v] = True;
        } /*  */ 
        if(!_usedInclude[list_v])
        { /*  */ 
          *outfile << "#include <Xm/List.h>" << endl;
          _usedInclude[list_v] = True;
        } /*  */ 
      break;
    case scrolledtext_v:
        if(!_usedInclude[scrolledwindow_v])
        { /*  */ 
          *outfile << "#include <Xm/ScrolledW.h>" << endl;
          _usedInclude[scrolledwindow_v] = True;
        } /*  */ 
        if(!_usedInclude[text_v])
        { /*  */ 
          *outfile << "#include <Xm/Text.h>" << endl;
          _usedInclude[text_v] = True;
        } /*  */ 
      break;
    case scrolledwindow_v:
        *outfile << "#include <Xm/ScrolledW.h>" << endl;
      break;
    case selectionbox_v:
        *outfile << "#include <Xm/SelectioB.h>" << endl;
      break;
    case selectiondialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[selectionbox_v])
        { /*  */ 
          _usedInclude[selectionbox_v] = True;
          *outfile << "#include <Xm/SelectioB.h>" << endl;
        } /*  */ 
      break;
    case separator_v:
        *outfile << "#include <Xm/Separator.h>" << endl;
      break;
    case separatorgadget_v:
        *outfile << "#include <Xm/SeparatoG.h>" << endl;
      break;
    case tabbook_v:
        *outfile << "#include <TabBook.h>" << endl;
      break;
    case templatedialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[messagebox_v])
        { /*  */ 
          _usedInclude[messagebox_v] = True;
          *outfile << "#include <Xm/MessageB.h>" << endl;
        } /*  */ 
      break;
    case text_v:
        *outfile << "#include <Xm/Text.h>" << endl;
      break;
    case textfield_v:
        *outfile << "#include <Xm/TextF.h>" << endl;
      break;
    case togglebutton_v:
        *outfile << "#include <Xm/ToggleB.h>" << endl;
      break;
    case togglebuttongadget_v:
        *outfile << "#include <Xm/ToggleBG.h>" << endl;
      break;
    case warningdialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[messagebox_v])
        { /*  */ 
          _usedInclude[messagebox_v] = True;
          *outfile << "#include <Xm/MessageB.h>" << endl;
        } /*  */ 
      break;
    case workingdialog_v:
        if(!_usedInclude[dialogshell_v])
        { /*  */ 
          *outfile << "#include <Xm/DialogS.h>" << endl;
          _usedInclude[dialogshell_v] = True;
        } /*  */ 
        if(!_usedInclude[messagebox_v])
        { /*  */ 
          _usedInclude[messagebox_v] = True;
          *outfile << "#include <Xm/MessageB.h>" << endl;
        } /*  */ 
      break;
    } /*  */ 
    _usedInclude[_type] = True;
  } /*  */ 
}

string XtCore::getCreateFunctionName(widget_type_enum type)
{
  switch(type)
  { /*  */
    case applicationshell_v:
     _functionName = "XmCreateApplicationShell";
      break;
    case toplevelshell_v:
     _functionName = "XmCreateTopLevelShell";
      break;
    case arrowbutton_v:
      _functionName = "XmCreateArrowButton";
      break;
    case arrowbuttongadget_v:
      _functionName = "XmCreateArrowButtonGadget";
      break;
    case bulletinboard_v:
      _functionName = "XmCreateBulletinBoard";
      break;
    case cascadebutton_v:
      _functionName = "XmCreateCascadeButton";
      break;
    case cascadebuttongadget_v:
      _functionName = "XmCreateCascadeButtonGadget";
      break;
    case command_v:
      _functionName = "XmCreateCommand";
      break;
    case dialogshell_v:
      _functionName = "XmCreateDialogShell";
      break;
    case drawingarea_v:
      _functionName = "XmCreateDrawingArea";
      break;
    case drawnbutton_v:
      _functionName = "XmCreateDrawnButton";
      break;
    case errordialog_v:
      _functionName = "XmCreateErrorDialog";
      break;
    case fileselectionbox_v:
      _functionName = "XmCreateFileSelectionBox";
      break;
    case form_v:
      _functionName = "XmCreateForm";
      break;
    case formdialog_v:
      _functionName = "XmCreateFormDialog";
      break;
    case frame_v:
      _functionName = "XmCreateFrame";
      break;
    case informationdialog_v:
      _functionName = "XmCreateInformationDialog";
      break;
    case label_v:
      _functionName = "XmCreateLabel";
      break;
    case labelgadget_v:
      _functionName = "XmCreateLabelGadget";
      break;
    case list_v:
      _functionName = "XmCreateList";
      break;
    case mainwindow_v:
      _functionName = "XmCreateMainWindow";
      break;
    case menushell_v:
      _functionName = "XmCreateMenuShell";
      break;
    case menubar_v:
      _functionName = "XmCreateMenuBar";
      break;
    case messagebox_v:
      _functionName = "XmCreateMessageBox";
      break;
    case optionmenu_v:
      _functionName = "XmCreateOptionMenu";
      break;
    case panedwindow_v:
      _functionName = "XmCreatePanedWindow";
      break;
    case popupmenu_v:
      _functionName = "XmCreatePopupMenu";
      break;
    case promptdialog_v:
      _functionName = "XmCreatePromptDialog";
      break;
    case pulldownmenu_v:
      _functionName = "XmCreatePulldownMenu";
      break;
    case pushbutton_v:
      _functionName = "XmCreatePushButton";
      break;
    case pushbuttongadget_v:
      _functionName = "XmCreatePushButtonGadget";
      break;
    case questiondialog_v:
      _functionName = "XmCreateQuestionDialog";
      break;
    case radiobox_v:
      _functionName = "XmCreateRadioBox";
      break;
    case rowcolumn_v:
      _functionName = "XmCreateRowColumn";
      break;
    case scale_v:
      _functionName = "XmCreateScale";
      break;
    case scrollbar_v:
      _functionName = "XmCreateScrollBar";
      break;
    case scrolledlist_v:
      _functionName = "XmCreateScrolledList";
      break;
    case scrolledtext_v:
      _functionName = "XmCreateScrolledText";
      break;
    case scrolledwindow_v:
      _functionName = "XmCreateScrolledWindow";
      break;
    case selectionbox_v:
      _functionName = "XmCreateSelectionBox";
      break;
    case selectiondialog_v:
      _functionName = "XmCreateSelectionDialog";
      break;
    case separator_v:
      _functionName = "XmCreateSeparator";
      break;
    case separatorgadget_v:
      _functionName = "XmCreateSeparatorGadget";
      break;
    case tabbook_v:
      _functionName = "XtCreateWidget";
      break;
    case templatedialog_v:
      _functionName = "XmCreateTemplateDialog";
      break;
    case text_v:
      _functionName = "XmCreateText";
      break;
    case textfield_v:
      _functionName = "XmCreateTextField";
      break;
    case togglebutton_v:
      _functionName = "XmCreateToggleButton";
      break;
    case togglebuttongadget_v:
      _functionName = "XmCreateToggleButtonGadget";
      break;
    case warningdialog_v:
      _functionName = "XmCreateWarningDialog";
      break;
    case workingdialog_v:
      _functionName = "XmCreateWorkingDialog";
      break;
  } /*  */ 
  return _functionName;
}

void XtCore::resetInclude(void)
{
  int i;
  for(i=0;i<last_widget_type_v;i++)
    _usedInclude[i] = False;
}

res_rec * XtCore::getResources(void)
{
  return _resources;
}

int XtCore::getNumResources(void)
{
  return 19;
}

res_rec * XtCore::getCoreResources(void)
{
  return _resources;
}

int XtCore::getNumCoreResources(void)
{
  return 19;
}

void XtCore::getLastChildLocation(int &x, int &y)
{
} 

void XtCore::setLastChildLocation(int x, int y)
{
}

void XtCore::setTopWidget(XtCore * w)
{
  _topWidget = w;
}

void XtCore::setLeftWidget(XtCore * w)
{
  _leftWidget = w;
}

void XtCore::setRightWidget(XtCore * w)
{
  _rightWidget = w;
}

void XtCore::setBottomWidget(XtCore * w)
{
  _bottomWidget = w;
}

XtCore * XtCore::getTopWidget(void)
{
  return _topWidget;
}

XtCore * XtCore::getLeftWidget(void)
{
  return _leftWidget;
}

XtCore * XtCore::getRightWidget(void)
{
  return _rightWidget;
}

XtCore * XtCore::getBottomWidget(void)
{
  return _bottomWidget;
}

unsigned long XtCore::getColor(char * colorName)
{
  XrmValue from_value, to_value;
  from_value.addr = colorName;
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  XtConvertAndStore (_w,XmRString, &from_value, XmRPixel , &to_value);
  if ( to_value.addr )
  {
    return( *(unsigned int *)to_value.addr);
  }
  else
    return(0);
}

GC XtCore::CreateXorGC(Display * display, 
               Drawable drawable,
               unsigned long fg,
               unsigned long bg)
{
  XGCValues xgcvalues;
  GC gc;
  
  xgcvalues.foreground = fg ^ bg;
  xgcvalues.background = 0;
  xgcvalues.function = GXxor;
  
  gc = XCreateGC(display,drawable,
                (GCForeground | GCBackground | GCFunction),
                &xgcvalues);
  return(gc);
}

void XtCore::updateResource(res_rec * resource)
{
  res_rec * coreRes;
  int numCoreRes;
  res_rec * widRes;
  int numWidRes;
  Boolean found = False;
  int i;
  // need to find resource and change value
  // values have to be copied since they are locallly allocated

  numWidRes = getNumResources();
  widRes = getResources();
  coreRes = getCoreResources();
  numCoreRes = getNumCoreResources();
  
  cout << "Updating " << resource->resource_name << endl;

  for(i=0;i<numWidRes;i++)
  { /*  */ 
    if(strcmp(widRes[i].resource_name,resource->resource_name)==0)
    { /*  */ 
      strcpy(widRes[i].resource_value,resource->resource_value);
      setResource(&widRes[i]);
      found = True;
      break;
    } /*  */ 
  } /*  */ 
  if(!found)
  { /*  */ 
    for(i=0;i<numCoreRes;i++)
    { /*  */ 
      if(strcmp(coreRes[i].resource_name,resource->resource_name)==0)
      { /*  */ 
        strcpy(coreRes[i].resource_value,resource->resource_value);
        setResource(&coreRes[i]);
        found = True;
        break;
      } /*  */ 
    } /*  */ 
  } /*  */ 
  
}

void XtCore::setResource(res_rec * resource)
{
  Arg al[5];
  int ac = 0;
  XmString xmstr;
  XrmValue from_value, to_value; /* For resource conversion */

  cout << "Updating resource..." << endl;
  cout << "  " << resource->resource_name << " with "
       << resource->resource_value << endl;
  cout << resource->resource_type << endl;
  from_value.addr = resource->resource_value;
  from_value.size = strlen( from_value.addr ) + 1;
  to_value.addr = NULL;
  
  if(strcmp(resource->resource_type,"UnsignedChar")==0)
  {
      XtSetArg(al[ac],resource->resource_name,
               getEnum(resource->resource_name));ac++;
  }
  else
    XtConvertAndStore (_w,
                       XmRString, &from_value, 
                       resource->resource_type , &to_value);
  if ( to_value.addr )
  { /* success */
    if(strcmp(resource->resource_type,"Int")==0)
    { /* int */ 
      XtSetArg(al[ac],resource->resource_name,
               *(int *)to_value.addr);ac++;
    } /* int */ 
    if(strcmp(resource->resource_type,"Boolean")==0)
    { /* Boolean */
      XtSetArg(al[ac],resource->resource_name,
               *(Boolean *)to_value.addr);ac++;
    } /* Boolean */ 
    if(strcmp(resource->resource_type,"Pixel")==0)
    { /* Pixel */ 
      XtSetArg(al[ac],resource->resource_name,
               *(unsigned long *)to_value.addr);ac++;
    } /* Pixel */ 
    if(strcmp(resource->resource_type,"Pixmap")==0)
    { /* Pixmap */ 
    } /* Pixmap */ 
    if(strcmp(resource->resource_type,"Dimension")==0)
    { /* Dimension */ 
      XtSetArg(al[ac],resource->resource_name,
               *(Dimension *)to_value.addr);ac++;
    } /* Dimension */ 
    if(strcmp(resource->resource_type,"Position")==0)
    { /* Position */ 
      XtSetArg(al[ac],resource->resource_name,
               *(Position *)to_value.addr);ac++;
    } /* Position */ 
    if(strcmp(resource->resource_type,"XmFontList")==0)
    { /* XmFontList */ 
      XtSetArg(al[ac],resource->resource_name,
               *(Position *)to_value.addr);ac++;
    } /* XmFontList */ 
    if(strcmp(resource->resource_type,"XmString")==0)
    { /* XmString */ 
      xmstr = XmStringCreate(resource->resource_value,XmFONTLIST_DEFAULT_TAG);
      XtSetArg(al[ac],resource->resource_name,xmstr);ac++;
    } /* XmString */ 
    if(strcmp(resource->resource_type,"XtTranslations")==0)
    { /* XtTranslations */ 
    } /* XtTranslations */ 
    if(strcmp(resource->resource_type,"String")==0)
    { /* String */ 
      XtSetArg(al[ac],resource->resource_name,
               *(char *)to_value.addr);ac++;
    } /* String */ 
    if(strcmp(resource->resource_type,"String *")==0)
    { /* String * */ 
      XtSetArg(al[ac],resource->resource_name,
               *(char **)to_value.addr);ac++;
    } /* String * */ 
    if(strcmp(resource->resource_type,"Window")==0)
    { /* Window */ 
      XtSetArg(al[ac],resource->resource_name,
               *(Window *)to_value.addr);ac++;
    } /* Window */ 
    if(strcmp(resource->resource_type,"Widget")==0)
    { /* Widget */ 
      XtSetArg(al[ac],resource->resource_name,
               *(Widget *)to_value.addr);ac++;
    } /* Widget */ 
    XtSetValues(_w,al,ac);
    if(strcmp(resource->resource_type,"XmString")==0)
      XmStringFree(xmstr);

  } /* success */
}

Boolean XtCore::isAt(int x, int y)
{
  Arg al[6];
  int ac = 0;
  
  XtSetArg(al[ac],XmNx,&_xpos);ac++;
  XtSetArg(al[ac],XmNy,&_ypos);ac++;
  XtSetArg(al[ac],XmNwidth,&_width);ac++;
  XtSetArg(al[ac],XmNheight,&_height);ac++;
  XtGetValues(_w,al,ac);

  if(( x > _xpos) && 
     ( x < (_xpos + _width)) &&
     ( y > _ypos) &&
     ( y < (_ypos + _height)))
  {
    return True;
  }
  return False;
}

Position XtCore::getXpos(void)
{
  return _xpos;
}

Position XtCore::getYpos(void)
{
  return _ypos;
}

Dimension XtCore::getWidth(void)
{
  return _width;
}

Dimension XtCore::getHeight(void)
{
  return _height;
}

void XtCore::moveTo(Position x, Position y)
{
  Arg al[20];
  int ac = 0;
  cout << "XtCore::moveTo " << x << "," << y << endl;
  XtSetArg(al[ac],XmNtopAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNtopOffset,(int)y);ac++;
  XtSetArg(al[ac],XmNleftAttachment,XmATTACH_FORM);ac++;
  XtSetArg(al[ac],XmNleftOffset,(int)x);ac++;
  XtSetArg(al[ac],XmNrightAttachment,XmATTACH_NONE);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,XmATTACH_NONE);ac++;
  XtSetValues(_w,al,ac);
}

void XtCore::resizeTo(Dimension width, Dimension height)
{
  Arg al[4];
  int ac = 0;

  XtSetArg(al[ac],XmNwidth,width);ac++;
  XtSetArg(al[ac],XmNheight,height);ac++;
  XtSetValues(_w,al,ac);
}

string XtCore::getCreationFunctionName(void)
{
  if(_funcName.length()== 0)
    return getVarName();
  else
    return _funcName;
}

void XtCore::setCreationFunctionName(string funcName)
{
  _funcName = funcName;
}

void XtCore::setSelectedSide(side_type_enum side)
{
  _selectedSide = side;
}

side_type_enum XtCore::getSelectedSide(void)
{
  return _selectedSide;
}

void XtCore::findSelectedSide(int x,int y)
{
  _selectedSide = none_selected_v;

  if(debug_set)
  { /* debug */ 
    cout << "top from " << _ypos << " to " 
         << _ypos + _height/2 << endl;
    cout << "left from " << _xpos << " to " 
         << _xpos + _width/5 << endl;
    cout << "right from " << _xpos + _width/5 << " to " 
         << _xpos + _width << endl;
    cout << "bottom from " << _ypos + _height/2 << " to " 
         << _ypos + _height << endl;
  } /* debug */ 

  /* check left side */
  if(x < _xpos + _width/5)
  { /*  */ 
    _selectedSide = left_selected_v;
  } /*  */ 
  /* check right side */
  else if(x > _xpos + _width - _width/5)
  { /*  */ 
    _selectedSide = right_selected_v;
  } /*  */ 
  /* check top */
  else if(y < _ypos + _height/2)
  { /*  */ 
    _selectedSide = top_selected_v;
  } /*  */ 
  else if(y > _ypos + _height - _height/2)
  { /*  */ 
    _selectedSide = bottom_selected_v;
  } /*  */ 
  if(debug_set)
    cout << " XtCore::findSelectedSide = " << _selectedSide << endl;
}

void XtCore::updateCoreResources(void)
{
  Arg al[6];
  int ac = 0;
  
  XtSetArg(al[ac],XmNx,&_xpos);ac++;
  XtSetArg(al[ac],XmNy,&_ypos);ac++;
  XtSetArg(al[ac],XmNwidth,&_width);ac++;
  XtSetArg(al[ac],XmNheight,&_height);ac++;
  XtGetValues(_w,al,ac);
}

void XtCore::updateAttachments(void)
{
  Arg al[17];
  int ac = 0;
  Widget top = (Widget) NULL;
  Widget left = (Widget) NULL;
  Widget right = (Widget) NULL;
  Widget bottom = (Widget) NULL;
  XtCore * found = NULL;

  /* Attachments */
  XtSetArg(al[ac],XmNtopAttachment,&_topAttachment);ac++;
  XtSetArg(al[ac],XmNleftAttachment,&_leftAttachment);ac++;
  XtSetArg(al[ac],XmNbottomAttachment,&_bottomAttachment);ac++;
  XtSetArg(al[ac],XmNrightAttachment,&_rightAttachment);ac++;
  /* Offsets */
  XtSetArg(al[ac],XmNtopOffset,&_topOffset);ac++;
  XtSetArg(al[ac],XmNleftOffset,&_leftOffset);ac++;
  XtSetArg(al[ac],XmNbottomOffset,&_bottomOffset);ac++;
  XtSetArg(al[ac],XmNrightOffset,&_rightOffset);ac++;
  /* Positions */
  XtSetArg(al[ac],XmNtopPosition,&_topPosition);ac++;
  XtSetArg(al[ac],XmNleftPosition,&_leftPosition);ac++;
  XtSetArg(al[ac],XmNbottomPosition,&_bottomPosition);ac++;
  XtSetArg(al[ac],XmNrightPosition,&_rightPosition);ac++;
  /* Widgets */
  XtSetArg(al[ac],XmNtopWidget,&top);ac++;
  XtSetArg(al[ac],XmNleftWidget,&left);ac++;
  XtSetArg(al[ac],XmNbottomWidget,&bottom);ac++;
  XtSetArg(al[ac],XmNrightWidget,&right);ac++;
  
  /* retrieve values */
  XtGetValues(_w,al,ac);
  if(top)
    setTopWidget(findCoreWidget(getCoreParent(),top));
  if(bottom)
    setBottomWidget(findCoreWidget(getCoreParent(),bottom));
  if(left)
    setLeftWidget(findCoreWidget(getCoreParent(),left));
  if(right)
    setRightWidget(findCoreWidget(getCoreParent(),right));
}

void XtCore::setTopAttachment(unsigned char top)
{
  _topAttachment = top;
}

void XtCore::setBottomAttachment(unsigned char bottom)
{
  _bottomAttachment = bottom;
}

void XtCore::setLeftAttachment(unsigned char left)
{
  _leftAttachment = left;
}

void XtCore::setRightAttachment(unsigned char right)
{
  _rightAttachment = right;
}

void XtCore::setTopOffset(int top)
{
  _topOffset = top;
}

void XtCore::setBottomOffset(int bottom)
{
  _bottomOffset = bottom;
}

void XtCore::setLeftOffset(int left)
{
  _leftOffset = left;
}

void XtCore::setRightOffset(int right)
{
  _rightOffset = right;
}

void XtCore::setTopPosition(int top)
{
  _topPosition = top;
}

void XtCore::setBottomPosition(int bottom)
{
  _bottomPosition = bottom;
}

void XtCore::setLeftPosition(int left)
{
  _leftPosition = left;
}

void XtCore::setRightPosition(int right)
{
  _rightPosition = right;
}

XtCore * XtCore::findCoreWidget(XtCore *top, Widget w)
{
  XtCore *found = NULL;
  int i;

  // IF there are children
  if((int)_list.size() > 0)
    for(i=0;(i<(int)_list.size()) && (!found);i++)
      found = findCoreWidget(_list[i],w);
  
  if(w == _w)
    found = this;

  return found;
}

int XtCore::getEnum(char* name)
{
  int return_value = -1;

  if(strcmp(name,"XmPIXMAP")==0)
    return_value = 1;
  if(strcmp(name,"XmSTRING")==0)
    return_value = 2;

  if(strcmp(name,"XmCHANGE_ALL")==0)
    return_value = 0;
  if(strcmp(name,"XmCHANGE_NONE")==0)
    return_value = 1;
  if(strcmp(name,"XmCHANGE_WIDTH")==0)
    return_value = 2;
  if(strcmp(name,"XmCHANGE_HEIGHT")==0)
    return_value = 3;

  if(strcmp(name,"XmPIXELS")==0)
    return_value = 0;
  if(strcmp(name,"Xm100TH_MILLIMETERS")==0)
    return_value = 1;
  if(strcmp(name,"Xm1000TH_INCHES")==0)
    return_value = 2;
  if(strcmp(name,"Xm100TH_POINTS")==0)
    return_value = 3;
  if(strcmp(name,"Xm100TH_FONT_UNITS")==0)
    return_value = 4;

  if(strcmp(name,"XmDESTROY")==0)
    return_value = 0;
  if(strcmp(name,"XmUNMAP")==0)
    return_value = 1;
  if(strcmp(name,"XmDO_NOTHING")==0)
    return_value = 2;

  if(strcmp(name,"XmEXPLICIT")==0)
    return_value = 0;
  if(strcmp(name,"XmPOINTER")==0)
    return_value = 1;

  if(strcmp(name,"XmNONE")==0)
    return_value = 0;
  if(strcmp(name,"XmTAB_GROUP")==0)
    return_value = 1;
  if(strcmp(name,"XmSTICKY_TAB_GROUP")==0)
    return_value = 2;
  if(strcmp(name,"XmEXCLUSIVE_TAB_GROUP")==0)
    return_value = 3;

  if(strcmp(name,"XmDYNAMIC_DEFAULT_TAB_GROUP")==0)
    return_value = 255;

  if(strcmp(name,"XmBELL")==0)
    return_value = 1;

  if(strcmp(name,"XmNO_ORIENTATION")==0)
    return_value = 0;
  if(strcmp(name,"XmVERTICAL")==0)
    return_value = 1;
  if(strcmp(name,"XmHORIZONTAL")==0)
    return_value = 2;

  if(strcmp(name,"XmWORK_AREA")==0)
    return_value = 0;
  if(strcmp(name,"XmMENU_BAR")==0)
    return_value = 1;
  if(strcmp(name,"XmMENU_PULLDOWN")==0)
    return_value = 2;
  if(strcmp(name,"XmMENU_POPUP")==0)
    return_value = 3;
  if(strcmp(name,"XmMENU_OPTION")==0)
    return_value = 4;

  if(strcmp(name,"XmNO_PACKING")==0)
    return_value = 0;
  if(strcmp(name,"XmPACK_TIGHT")==0)
    return_value = 1;
  if(strcmp(name,"XmPACK_COLUMN")==0)
    return_value = 2;
  if(strcmp(name,"XmPACK_NONE")==0)
    return_value = 3;

  if(strcmp(name,"XmALIGNMENT_BASELINE_TOP")==0)
    return_value = 0;
  if(strcmp(name,"XmALIGNMENT_CENTER")==0)
    return_value = 1;
  if(strcmp(name,"XmALIGNMENT_BASELINE_BOTTOM")==0)
    return_value = 2;
  if(strcmp(name,"XmALIGNMENT_CONTENTS_TOP")==0)
    return_value = 3;
  if(strcmp(name,"XmALIGNMENT_CONTENTS_BOTTOM")==0)
    return_value = 4;

  if(strcmp(name,"XmTEAR_OFF_ENABLED")==0)
    return_value = 0;
  if(strcmp(name,"XmTEAR_OFF_DISABLED")==0)
    return_value = 1;

  if(strcmp(name,"XmUNPOST")==0)
    return_value = 0;
  if(strcmp(name,"XmUNPOST_AND_REPLAY")==0)
    return_value = 1;

  if(strcmp(name,"XmLAST_POSITION")==0)
    return_value = -1;
  if(strcmp(name,"XmFIRST_POSITION")==0)
    return_value = 0;

  if(strcmp(name,"XmALIGNMENT_BEGINNING")==0)
    return_value = 0;
  if(strcmp(name,"XmALIGNMENT_CENTER")==0)
    return_value = 1;
  if(strcmp(name,"XmALIGNMENT_END")==0)
    return_value = 2;

  if(strcmp(name,"XmFRAME_GENERIC_CHILD")==0)
    return_value = 0;
  if(strcmp(name,"XmFRAME_WORKAREA_CHILD")==0)
    return_value = 1;
  if(strcmp(name,"XmFRAME_TITLE_CHILD")==0)
    return_value = 2;

  if(strcmp(name,"XmN_OF_MANY")==0)
    return_value = 1;
  if(strcmp(name,"XmONE_OF_MANY")==0)
    return_value = 2;

  if(strcmp(name,"XmATTACH_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmATTACH_FORM")==0)
    return_value = 1;
  if(strcmp(name,"XmATTACH_OPPOSITE_FORM")==0)
    return_value = 2;
  if(strcmp(name,"XmATTACH_WIDGET")==0)
    return_value = 3;
  if(strcmp(name,"XmATTACH_OPPOSITE_WIDGET")==0)
    return_value = 4;
  if(strcmp(name,"XmATTACH_POSITION")==0)
    return_value = 5;
  if(strcmp(name,"XmATTACH_SELF")==0)
    return_value = 6;

  if(strcmp(name,"XmRESIZE_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmRESIZE_GROW")==0)
    return_value = 1;
  if(strcmp(name,"XmRESIZE_ANY")==0)
    return_value = 2;

  if(strcmp(name,"XmCR_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmCR_HELP")==0)
    return_value = 1;
  if(strcmp(name,"XmCR_VALUE_CHANGED")==0)
    return_value = 2;
  if(strcmp(name,"XmCR_INCREMENT")==0)
    return_value = 3;
  if(strcmp(name,"XmCR_DECREMENT")==0)
    return_value = 4;
  if(strcmp(name,"XmCR_PAGE_INCREMENT")==0)
    return_value = 5;
  if(strcmp(name,"XmCR_PAGE_DECREMENT")==0)
    return_value = 6;
  if(strcmp(name,"XmCR_TO_TOP")==0)
    return_value = 7;
  if(strcmp(name,"XmCR_TO_BOTTOM")==0)
    return_value = 8;
  if(strcmp(name,"XmCR_DRAG")==0)
    return_value = 9;
  if(strcmp(name,"XmCR_ACTIVATE")==0)
    return_value = 10;
  if(strcmp(name,"XmCR_ARM")==0)
    return_value = 11;
  if(strcmp(name,"XmCR_DISARM")==0)
    return_value = 12;

  if(strcmp(name,"XmCR_MAP")==0)
    return_value = 16;
  if(strcmp(name,"XmCR_UNMAP")==0)
    return_value = 17;
  if(strcmp(name,"XmCR_FOCUS")==0)
    return_value = 18;
  if(strcmp(name,"XmCR_LOSING_FOCUS")==0)
    return_value = 19;
  if(strcmp(name,"XmCR_MODIFYING_TEXT_VALUE")==0)
    return_value = 20;
  if(strcmp(name,"XmCR_MOVING_INSERT_CURSOR")==0)
    return_value = 21;
  if(strcmp(name,"XmCR_EXECUTE")==0)
    return_value = 22;
  if(strcmp(name,"XmCR_SINGLE_SELECT")==0)
    return_value = 23;
  if(strcmp(name,"XmCR_MULTIPLE_SELECT")==0)
    return_value = 24;
  if(strcmp(name,"XmCR_EXTENDED_SELECT")==0)
    return_value = 25;
  if(strcmp(name,"XmCR_BROWSE_SELECT")==0)
    return_value = 26;
  if(strcmp(name,"XmCR_DEFAULT_ACTION")==0)
    return_value = 27;
  if(strcmp(name,"XmCR_CLIPBOARD_DATA_REQUEST")==0)
    return_value = 28;
  if(strcmp(name,"XmCR_CLIPBOARD_DATA_DELETE")==0)
    return_value = 29;
  if(strcmp(name,"XmCR_CASCADING")==0)
    return_value = 30;
  if(strcmp(name,"XmCR_OK")==0)
    return_value = 31;
  if(strcmp(name,"XmCR_CANCEL")==0)
    return_value = 32;

  if(strcmp(name,"XmCR_APPLY")==0)
    return_value = 34;
  if(strcmp(name,"XmCR_NO_MATCH")==0)
    return_value = 35;
  if(strcmp(name,"XmCR_COMMAND_ENTERED")==0)
    return_value = 36;
  if(strcmp(name,"XmCR_COMMAND_CHANGED")==0)
    return_value = 37;
  if(strcmp(name,"XmCR_EXPOSE")==0)
    return_value = 38;
  if(strcmp(name,"XmCR_RESIZE")==0)
    return_value = 39;
  if(strcmp(name,"XmCR_INPUT")==0)
    return_value = 40;
  if(strcmp(name,"XmCR_GAIN_PRIMARY")==0)
    return_value = 41;
  if(strcmp(name,"XmCR_LOSE_PRIMARY")==0)
    return_value = 42;
  if(strcmp(name,"XmCR_CREATE")==0)
    return_value = 43;
  if(strcmp(name,"XmCR_TEAR_OFF_ACTIVATE")==0)
    return_value = 44;
  if(strcmp(name,"XmCR_TEAR_OFF_DEACTIVATE")==0)
    return_value = 45;
  if(strcmp(name,"XmCR_OBSCURED_TRAVERSAL")==0)
    return_value = 46;
  if(strcmp(name,"XmCR_PROTOCOLS")==0)
    return_value = 47;
  if(strcmp(name,"XmCR_FOCUS_MOVED")==0)
    return_value = 48;

  if(strcmp(name,"XmMULTICLICK_DISCARD")==0)
    return_value = 0;
  if(strcmp(name,"XmMULTICLICK_KEEP")==0)
    return_value = 1;

  if(strcmp(name,"XmSHADOW_IN")==0)
    return_value = 7;
  if(strcmp(name,"XmSHADOW_OUT")==0)
    return_value = 8;

  if(strcmp(name,"XmARROW_UP")==0)
    return_value = 0;
  if(strcmp(name,"XmARROW_DOWN")==0)
    return_value = 1;
  if(strcmp(name,"XmARROW_LEFT")==0)
    return_value = 2;
  if(strcmp(name,"XmARROW_RIGHT")==0)
    return_value = 3;

  if(strcmp(name,"XmNO_LINE")==0)
    return_value = 0;
  if(strcmp(name,"XmSINGLE_LINE")==0)
    return_value = 1;
  if(strcmp(name,"XmDOUBLE_LINE")==0)
    return_value = 2;
  if(strcmp(name,"XmSINGLE_DASHED_LINE")==0)
    return_value = 3;
  if(strcmp(name,"XmDOUBLE_DASHED_LINE")==0)
    return_value = 4;
  if(strcmp(name,"XmSHADOW_ETCHED_IN")==0)
    return_value = 5;
  if(strcmp(name,"XmSHADOW_ETCHED_OUT")==0)
    return_value = 6;
  if(strcmp(name,"XmSHADOW_ETCHED_IN_DASH")==0)
    return_value = 7;
  if(strcmp(name,"XmSHADOW_ETCHED_OUT_DASH")==0)
    return_value = 8;
  if(strcmp(name,"XmINVALID_SEPARATOR_TYPE")==0)
    return_value = 9;

  if(strcmp(name,"XmWINDOW")==0)
    return_value = 0;
  if(strcmp(name,"XmCURSOR")==0)
    return_value = 2;

  if(strcmp(name,"XmMAX_ON_TOP")==0)
    return_value = 0;
  if(strcmp(name,"XmMAX_ON_BOTTOM")==0)
    return_value = 1;
  if(strcmp(name,"XmMAX_ON_LEFT")==0)
    return_value = 2;
  if(strcmp(name,"XmMAX_ON_RIGHT")==0)
    return_value = 3;

  if(strcmp(name,"XmSINGLE_SELECT")==0)
    return_value = 0;
  if(strcmp(name,"XmMULTIPLE_SELECT")==0)
    return_value = 1;
  if(strcmp(name,"XmEXTENDED_SELECT")==0)
    return_value = 2;
  if(strcmp(name,"XmBROWSE_SELECT")==0)
    return_value = 3;

  if(strcmp(name,"XmSTATIC")==0)
    return_value = 0;
  if(strcmp(name,"XmDYNAMIC")==0)
    return_value = 1;

  if(strcmp(name,"XmVARIABLE")==0)
    return_value = 0;
  if(strcmp(name,"XmCONSTANT")==0)
    return_value = 1;
  if(strcmp(name,"XmRESIZE_IF_POSSIBLE")==0)
    return_value = 2;

  if(strcmp(name,"XmAUTOMATIC")==0)
    return_value = 0;
  if(strcmp(name,"XmAPPLICATION_DEFINED")==0)
    return_value = 1;

  if(strcmp(name,"XmAS_NEEDED")==0)
    return_value = 1;

  if(strcmp(name,"XmTOP_LEFT")==0)
    return_value = 3;
  if(strcmp(name,"XmBOTTOM_LEFT")==0)
    return_value = 2;
  if(strcmp(name,"XmTOP_RIGHT")==0)
    return_value = 1;
  if(strcmp(name,"XmBOTTOM_RIGHT")==0)
    return_value = 0;

  if(strcmp(name,"XmCOMMAND_ABOVE_WORKSPACE")==0)
    return_value = 0;
  if(strcmp(name,"XmCOMMAND_BELOW_WORKSPACE")==0)
    return_value = 1;

  if(strcmp(name,"XmMULTI_LINE_EDIT")==0)
    return_value = 0;
  if(strcmp(name,"XmSINGLE_LINE_EDIT")==0)
    return_value = 1;

  if(strcmp(name,"XmTEXT_FORWARD")==0)
    return_value = 0;
  if(strcmp(name,"XmTEXT_BACKWARD")==0)
    return_value = 1;

  if(strcmp(name,"XmSELECT_POSITION")==0)
    return_value = 0;
  if(strcmp(name,"XmSELECT_WHITESPACE")==0)
    return_value = 1;
  if(strcmp(name,"XmSELECT_WORD")==0)
    return_value = 2;
  if(strcmp(name,"XmSELECT_LINE")==0)
    return_value = 3;
  if(strcmp(name,"XmSELECT_ALL")==0)
    return_value = 4;
  if(strcmp(name,"XmSELECT_PARAGRAPH")==0)
    return_value = 5;

  if(strcmp(name,"XmHIGHLIGHT_NORMAL")==0)
    return_value = 0;
  if(strcmp(name,"XmHIGHLIGHT_SELECTED")==0)
    return_value = 1;
  if(strcmp(name,"XmHIGHLIGHT_SECONDARY_SELECTED")==0)
    return_value = 2;

  if(strcmp(name,"XmCOPY_FAILED")==0)
    return_value = 0;
  if(strcmp(name,"XmCOPY_SUCCEEDED")==0)
    return_value = 1;
  if(strcmp(name,"XmCOPY_TRUNCATED")==0)
    return_value = 2;

  if(strcmp(name,"XmDIALOG_NONE")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_APPLY_BUTTON")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_CANCEL_BUTTON")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_DEFAULT_BUTTON")==0)
    return_value = 3;
  if(strcmp(name,"XmDIALOG_OK_BUTTON")==0)
    return_value = 4;
  if(strcmp(name,"XmDIALOG_FILTER_LABEL")==0)
    return_value = 5;
  if(strcmp(name,"XmDIALOG_FILTER_TEXT")==0)
    return_value = 6;
  if(strcmp(name,"XmDIALOG_HELP_BUTTON")==0)
    return_value = 7;
  if(strcmp(name,"XmDIALOG_LIST")==0)
    return_value = 8;
  if(strcmp(name,"XmDIALOG_LIST_LABEL")==0)
    return_value = 9;
  if(strcmp(name,"XmDIALOG_MESSAGE_LABEL")==0)
    return_value = 10;
  if(strcmp(name,"XmDIALOG_SELECTION_LABEL")==0)
    return_value = 11;
  if(strcmp(name,"XmDIALOG_SYMBOL_LABEL")==0)
    return_value = 12;
  if(strcmp(name,"XmDIALOG_TEXT")==0)
    return_value = 13;
  if(strcmp(name,"XmDIALOG_SEPARATOR")==0)
    return_value = 14;
  if(strcmp(name,"XmDIALOG_DIR_LIST")==0)
    return_value = 15;
  if(strcmp(name,"XmDIALOG_DIR_LIST_LABEL")==0)
    return_value = 16;

  if(strcmp(name,"XmDIALOG_HISTORY_LIST")==0)
    return_value = 8;
  if(strcmp(name,"XmDIALOG_PROMPT_LABEL")==0)
    return_value = 11;
  if(strcmp(name,"XmDIALOG_VALUE_TEXT")==0)
    return_value = 13;
  if(strcmp(name,"XmDIALOG_COMMAND_TEXT")==0)
    return_value = 13;
  if(strcmp(name,"XmDIALOG_FILE_LIST")==0)
    return_value = 8;
  if(strcmp(name,"XmDIALOG_FILE_LIST_LABEL")==0)
    return_value = 9;

  if(strcmp(name,"XmDIALOG_MODELESS")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_PRIMARY_APPLICATION_MODAL")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_FULL_APPLICATION_MODAL")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_SYSTEM_MODAL")==0)
    return_value = 3;

  if(strcmp(name,"XmDIALOG_APPLICATION_MODAL")==0)
    return_value = 1;

  if(strcmp(name,"XmPLACE_TOP")==0)
    return_value = 0;
  if(strcmp(name,"XmPLACE_ABOVE_SELECTION")==0)
    return_value = 1;
  if(strcmp(name,"XmPLACE_BELOW_SELECTION")==0)
    return_value = 2;

  if(strcmp(name,"XmDIALOG_WORK_AREA")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_PROMPT")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_SELECTION")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_COMMAND")==0)
    return_value = 3;
  if(strcmp(name,"XmDIALOG_FILE_SELECTION")==0)
    return_value = 4;

  if(strcmp(name,"XmDIALOG_TEMPLATE")==0)
    return_value = 0;
  if(strcmp(name,"XmDIALOG_ERROR")==0)
    return_value = 1;
  if(strcmp(name,"XmDIALOG_INFORMATION")==0)
    return_value = 2;
  if(strcmp(name,"XmDIALOG_MESSAGE")==0)
    return_value = 3;
  if(strcmp(name,"XmDIALOG_QUESTION")==0)
    return_value = 4;
  if(strcmp(name,"XmDIALOG_WARNING")==0)
    return_value = 5;
  if(strcmp(name,"XmDIALOG_WORKING")==0)
    return_value = 6;

  if(strcmp(name,"XmVISIBILITY_UNOBSCURED")==0)
    return_value = 0;
  if(strcmp(name,"XmVISIBILITY_PARTIALLY_OBSCURED")==0)
    return_value = 1;
  if(strcmp(name,"XmVISIBILITY_FULLY_OBSCURED")==0)
    return_value = 2;

  if(strcmp(name,"XmTRAVERSE_CURRENT")==0)
    return_value = 0;
  if(strcmp(name,"XmTRAVERSE_NEXT")==0)
    return_value = 1;
  if(strcmp(name,"XmTRAVERSE_PREV")==0)
    return_value = 2;
  if(strcmp(name,"XmTRAVERSE_HOME")==0)
    return_value = 3;
  if(strcmp(name,"XmTRAVERSE_NEXT_TAB_GROUP")==0)
    return_value = 4;
  if(strcmp(name,"XmTRAVERSE_PREV_TAB_GROUP")==0)
    return_value = 5;
  if(strcmp(name,"XmTRAVERSE_UP")==0)
    return_value = 6;
  if(strcmp(name,"XmTRAVERSE_DOWN")==0)
    return_value = 7;
  if(strcmp(name,"XmTRAVERSE_LEFT")==0)
    return_value = 8;
  if(strcmp(name,"XmTRAVERSE_RIGHT")==0)
    return_value = 9;

  if(strcmp(name,"XmPUSHBUTTON")==0)
    return_value = 1;
  if(strcmp(name,"XmTOGGLEBUTTON")==0)
    return_value = 2;
  if(strcmp(name,"XmRADIOBUTTON")==0)
    return_value = 3;
  if(strcmp(name,"XmCASCADEBUTTON")==0)
    return_value = 4;
  if(strcmp(name,"XmSEPARATOR")==0)
    return_value = 5;
  if(strcmp(name,"XmDOUBLE_SEPARATOR")==0)
    return_value = 6;
  if(strcmp(name,"XmTITLE")==0)
    return_value = 7;
  if(strcmp(name,"XmCHECKBUTTON")==0)
    return_value = 2;

  return (return_value);
}
