
#ifndef __global_h
#	include "global.H"
#endif
#ifndef __board_h
#	include "board.H"
#endif
#ifndef __tile_h
#	include "tile.H"
#endif

#include <stdlib.h>

Board::Board( int width, int height )
{
	dx = width;
	dy = height;
	ntiles = dx * dy;
	if (ntiles%2)	dx++;		// make even dimension
	ntiles = dx * dy;
	ntiles /= 2;

	Tile::init_used_syms(ntiles);
	f = new Field[2*ntiles];
}

Board::~Board() {
	delete f;
}

int Board::check_swap( int op, int np ) {
int x1,y1,x2,y2;
int j;
int help;
int dist;
#ifndef ABS
#	define ABS(x)	(((x)>0)?(x):-(x))
#endif

	help=f[op].tile_id;
	x1=np%dx;
	y1=np/dx;
	for (j=0;j<2*ntiles;j++)
		if (help==f[j].tile_id&&j!=op)		break;
	x2=j%dx;
	y2=j/dx;
	dist=ABS(x1-x2)+ABS(y1-y2);
	if (dist<3)		return 0;

	help=f[np].tile_id;
	x1=op%dx;
	y1=op/dx;
	for (j=0;j<2*ntiles;j++)
		if (help==f[j].tile_id&&j!=np)		break;
	x2=j%dx;
	y2=j/dx;
	dist=ABS(x1-x2)+ABS(y1-y2);
	if (dist<3)		return 0;

	return 1;
}

void Board::reset() {
int		i,j;
Field	help;

	for (i=0;i<2*ntiles;i++)		 f[i].reset(i/2);
	for (i=0;i<2*ntiles;i++) {
		do {
			j = rand()%(2*ntiles);
		} while (!check_swap(i,j));
		help = f[i];
		f[i] = f[j];
		f[j] = help;
	}
	tiles_left=ntiles;
	finished=0;
}

void Board::color_removed( int id ) {
int i;
int back=0;

	for (i=0;i<2*ntiles;i++) {
		if (f[i].lock_col>=id) {
			if (f[i].lock_col==id) {
				f[i].locked=0;
				f[i].found =0;
				f[i].flash =0;
				if (f[i].gone) {
					f[i].gone=0;
					back++;
				}
			}
			f[i].lock_col--;
		}
	}
	tiles_left+=(back/2);
	if (tiles_left)	finished=0;
}

int Board::tile_removed(int /* color_id */) {
	if (--tiles_left)		return 0;
	else {
		finished = current_time;
		return 1;
	}
}

Field *Board::field( int x, int y )
{
	if ((x<0)||(x>=dx)||(y<0)||(y>=dy))		return(0);
	return( &f[x+y*dx] );
}

Field *Board::field( int fid )
{
	return( field( fid%dx, fid/dx ) );
}

