#ifndef __global_h
#	include "global.H"
#endif
#ifndef __color_h
#	include "color.H"
#endif
#ifndef __port_h
#	include "port.H"
#endif

#include <stdio.h>
#include <stdlib.h>

void Color::brighten( XColor *chg, XColor *org, double percent )
{
	if (percent<0) {
		percent = 100+percent;
		chg->red   = (unsigned short)(org->red*percent/100);
		chg->green = (unsigned short)(org->green*percent/100);
		chg->blue  = (unsigned short)(org->blue*percent/100);
	}
	else {
		chg->red   = (unsigned short)((65536-org->red)*percent/100   + org->red);
		chg->green = (unsigned short)((65536-org->green)*percent/100 + org->green);
		chg->blue  = (unsigned short)((65536-org->blue)*percent/100  + org->blue);
	}
}

Color::Color( Port *p_in, int color_id, char *color_name ) :
	p(p_in)
{
unsigned long	plane_mask[2];
XColor	def;
XColor	chg[4];
int i;

	this->color_id = color_id;

//
// query the display for the given rgb-values and
// brighten/darken them to get a 3D-effect.
//
	for (i=0;i<4;i++) {
		char	colnam[40];
		sprintf(colnam,"%s%d",color_name,i+1);
		if (XLookupColor( p->display, DefaultColormapOfScreen(p->screen),
				colnam, &chg[i], &chg[i] ) )			break;
	}
	if (i<4) {
		XLookupColor( p->display, DefaultColormapOfScreen(p->screen), color_name,
				&def, &def );
		brighten(&chg[0],&def, 60.);
		brighten(&chg[1],&def, 20.);
		brighten(&chg[2],&def,-40.);
		brighten(&chg[3],&def,-60.);
	}
	
	if (p->stipple_pmap) {
		XColor layer;
		brighten(&layer,&def,-20.);
	//
	// when there are no planes available, gc_n is created as an tiled
	// overlay with only the main color alloacted.
	//
		pixel=p->alloc_color(&layer);
	
		gc_n = XCreateGC( p->display, RootWindowOfScreen(p->screen), 0L, NULL );
		XSetForeground( p->display, gc_n, pixel );
		XSetStipple( p->display, gc_n, p->stipple_pmap );
		XSetFillStyle( p->display, gc_n, FillStippled );
	}
	else {
	//
	// Unfortuately the program is constructed to use planes 1 & 2 for drawing
	// shadows. These are the *usual* planes returned from XAllocColorCells,
	// when 2 planes are to be allocated. Nevertheless it is not defined that these
	// 2 planes are returned, but it would mean a big rearrangement (own color
	// management) to handle this correctly.
	//
	
		for (int retry=1;retry<=5;retry++) {
			if (!XAllocColorCells( p->display, DefaultColormapOfScreen(p->screen),
				True,			// contiguous
				plane_mask,	// plane-mask
				2,				// number of planes
				&pixel,			// field of pixels
				1				// number of colors
			)) {
				fprintf( stderr, "\n" );
				fprintf( stderr, "*** not enough colors or planes on '%s'\n", DisplayString(p->display) );
				fprintf( stderr, "\n" );
				exit(0);
			}
	
			if ( (plane_mask[0]|plane_mask[1])==0x03 )		break;
			fprintf( stderr, "problem: planes 0x%02lx + 0x%02lx, retrying (%d) ...\n",
						plane_mask[0], plane_mask[1], retry );
		}
	
		if ( (plane_mask[0]|plane_mask[1])!=0x3 ) {
			fprintf( stderr, "WARNING: unexpected results in XAllocColorCells(...)\n" );
			fprintf( stderr, "         planes: 0x%02lx + 0x%02lx\n",
						plane_mask[0], plane_mask[1] );
			fprintf( stderr, "Unfortunately the program won't run correct under these condition, since\n" );
			fprintf( stderr, "the I actually hoped, that XAllocColorCells(...) would always\n" );
			fprintf( stderr, "allocate planes 1 & 2 for my purpose.\n" );
			fprintf( stderr, "You should probably send me a mail, so I know about these problem, but it\n" );
			fprintf( stderr, "would be a major change to solve it ...\n" );
		}

		for (i=0;i<4;i++) {
			chg[i].pixel = pixel+((i&1)?plane_mask[0]:0)+((i&2)?plane_mask[1]:0);
			chg[i].flags = DoRed | DoGreen | DoBlue;
		}


		XStoreColors( p->display, DefaultColormapOfScreen(p->screen), chg, 4 );
	
		gc_n = XCreateGC( p->display, RootWindowOfScreen(p->screen), 0L, NULL );
		XSetPlaneMask( p->display, gc_n, ~(plane_mask[0]|plane_mask[1]) );
		XSetForeground( p->display, gc_n, pixel );
	}
	next=0;
}

Color::~Color() {
	XFreeGC( p->display, gc_n );
	if (next)	delete next;
}

