#ifndef __port_h
#define __port_h

typedef enum {
	Normal,
	Smiley,
	Photo,
#ifdef HUBSYM
	Symbol,
	Cyrillic,
#endif
	DummyMode
} Mode;

#ifndef __color_mapper_h
#	include "color_mapper.H"
#endif

class Port {
	friend class Tile;

public:
	Port( char *disp_name, char *color );
	~Port();

	static void close_all()		{ while(first)	delete first; }

	int empty_queue();					// empty event queue of port
	static int wait_event();			// wait for event on any port

	void add_foreign_color( Port *first, char *color_name );
	void add_color( int id, char *color );
	void sub_color( int id );

	void redraw( int x, int y );							// redraw tile (x,y)
	void redraw_score( int x );							// redraw score of player
	void redraw( int x1, int y1, int x2, int y2 );	// redraw X-region
	void draw_block( int p, int x, int y );			// draw score-block

	static void tile_redraw( int fid );					// redraw tile on index fid
	static void flush_all();

	void selected( int x, int y );	// select tile if possible
	unsigned long deselect( );			// deselect/flash/remove tiles
	int remove();							// remove tile when possible

	unsigned long alloc_color( XColor *col )
				{ return mapper->alloc_color(col); }
	unsigned long alloc_named_color( const char *name )
				{ return mapper->alloc_named_color(name); }

	Display	*display;
	Pixmap	stipple_pmap;				// used for stippled drawing, when no_planes
	Pixmap	rstipple_pmap;				// for reversed stippled drawing
	Screen	*screen;
	Window	window;
	int		double_depth;

	Cursor	normal_cursor, idle_cursor;

	GC			gc_tile;
	unsigned long	light;
	unsigned long	bg;
	unsigned long	fg;
	unsigned long	dark;
	GC			gc_all;
	
	GC			gc_color_n( int id );

	const char *find_font( const char *pattern, int size );

	void resize( int w, int h );		// recalculate sizes (redraw tiles)

	char *color_name;						// color
	int	 my_id;							// id

	int	selections;						// number of selections
	int	points;							// own points
	static int Points( int id );		// Points of port ...
	static void statistic();

	static void activate_any_player();
	void activate_next_player();
	void set_active( int a );
	int		active;						// flag, if playing is allowed

private:
	class Tile	**tile;					// field of normal tiles
	class Tile	*blank;					// closed field
	class Tile	*empty;					// empty field

	class Color	*colors;					// anchor of color list
	class ColorMapper	*mapper;			// mapper to control colormap-usage

	static Port *first;					// anchor of port list
	Port	*next;							// next port in list

	int wbsizex, wbsizey;				// world score block size
	int wborder;                     // world border size
	int WWidth()	{ return wsizex*dwidth+wbsizex*nplayers+3*wborder; }
	int WHeight()	{ return wsizey*dheight+2*wborder; }

	int sizex, sizey;						// tile size
	int bsizex, bsizey;					// size of score-blocks
	int border;								// size of border-frame
	int MWidth()	{ return sizex*dwidth+nplayers*bsizex+3*border; }
	int MHeight()	{ return sizey*dheight+2*border; }
	void MInit(int x) {
		sizex  = x;
		sizey  = x*wsizey /wsizex;
		bsizex = x*wbsizex/wsizex;
		bsizey = x*wbsizey/wsizex;
		border = x*wborder/wsizex;
	}

	int offx, offy;						// window offset for justification
	int width,height;						// size of window (MWidth/MHeight)
	Mode mode;								// tile style

	int		lock_count;					// number of locked tiles 0,1,2
	int		lock[2];						// fid of locked tiles
	unsigned long lock_time;			// lock until ...
	unsigned long flash_time;			// time of next flash

	static struct fd_set	readfds;
	static int				nfds;

	Atom	WmProtocolsPropId, WmDeleteWindowPropId;

	int ncols;								// number of colors in image
	unsigned long	*gif_cols;			// pixel-transformation table

public:
	static int nplayers;					// number of ports
	static int	color_id;				// *current* color id
	static int	dsize;
	static int	dwidth, dheight;		// number of tiles
	static int  wsizex, wsizey;		// world tile size
	static Mode def_mode;				// preselected tile style
	static int	remove_flag;			// flag, if tiles should be removed
	static int	sync_flag;				// synchronous playing mode
	static int	resize_lock;			// flag about sizeability of tiles

	void UpdateTime( const char *time_str );
	static int  def_size;				// preselected tile style
	static class MemImage	*gif;		// original image, when in photo-mode

friend class ScalableFont;
};

#endif
