const byte *subimage;
DATA_TYPE *xdata;
XImage	*ximage;				// the image
int		xwidth,xheight;	// the size of the image

	subimage=p->gif->SubImage(id);

// create buffer for Image-Data
	xdata=new DATA_TYPE[p->sizex*p->sizey];

	if (!xdata) {
		fprintf(stderr,"not enough memory for XImage-data");
		exit(-1);
	}

// create the XImage
	ximage = XCreateImage(display, DefaultVisualOfScreen(p->screen),
				DefaultDepthOfScreen(p->screen), ZPixmap, 0,
				(char*)xdata, p->sizex, p->sizey, DATA_PAD, p->sizex*sizeof(DATA_TYPE));
	xwidth  = ximage->width;
	xheight = ximage->height;

	if (!ximage) {
		fprintf(stderr,"\n*** can't allocate ximage.\n" );
		exit(0);
	}

// copy data from original image and inserting pixel values on the fly
	if (p->gif->PicWidth()==xwidth&&p->gif->PicHeight()==xheight) {
		register DATA_TYPE	*copy = xdata;
		register int	j,i;

		for (i=0; i<p->gif->PicHeight(); i++) {
			register const byte	*org  = subimage + (i*p->gif->Cols()*p->gif->PicWidth());
			for (j=0; j<p->gif->PicWidth(); j++) 
				*copy++ = (DATA_TYPE)p->gif_cols[*org++];
		}
	}
	else {
		for (int y=0;y<xheight;y++) {
			register const byte	*org  = subimage + (y*p->gif->PicHeight()/xheight) * p->gif->PicWidth()*p->gif->Cols();
			register DATA_TYPE *copy = xdata + y * xwidth;
	
			if (xwidth<p->gif->PicWidth()) {
				register int x;
				register int delta = p->gif->PicWidth()/2;
	
				for (x=p->gif->PicWidth();x>0;x--) {
					delta-=xwidth;
					if (delta<0) {
						delta+=p->gif->PicWidth();
						*copy++ = (DATA_TYPE)p->gif_cols[*org];
					}
					org++;
				}
			}
			else {
				register int x;
				register int delta = xwidth/2;
	
				for (x=xwidth;x>0;x--) {
					delta-=p->gif->PicWidth();
					*copy++ = (DATA_TYPE)p->gif_cols[*org];
					if (delta<0) {
						delta+=xwidth;
						org++;
					}
				}
			}
		}
	}

	ximage->data = (char*)xdata;

	XPutImage(display,pixmap,p->gc_all,ximage,0,0,0,0,xwidth,xheight);

	delete xdata;
	ximage->data = 0L;
	XDestroyImage(ximage);
