#ifndef ImageTools_h
#define ImageTools_h
/*
** ImageTools.h
**
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/

#ifdef SH_MEM
#	include <sys/ipc.h>
#	include <sys/shm.h>
#	include <X11/extensions/XShm.h>
#endif

#include <X11/Xew/Basic.h>
#include <X11/Xew/Raster.h>

typedef unsigned char XeSample;

#define XeSample_BITS 8
#define XeSample_RANGE (1<<(XeSample_BITS))
#define XeSample_MAX ((XeSample_RANGE)-1)


typedef void (*XeImageOpF)(
#if NeedFunctionPrototypes
			   XeBasicWidget,	/* widget */
			   unsigned char *,	/* in map parameter */
			   unsigned char *,	/* out val parameter */
			   unsigned char *,	/* out map parameter */
			   XeImageChannel *,	/* dst channel(s) */
			   XeImageChannel *	/* src channel(s) */
#endif
			   );

typedef struct XeImageOp
    {
	XeImageOpF op;	/* Function to execute the operation */
	int in_offset;	/* Offset to the in map area in parameter area */
	int val_offset;	/* Offset to the val area in parameter area */
	int out_offset;	/* Offset to the out map area in parameter area */
	int dst, src;	/* Source and destination channel indexes */
    } XeImageOp;

typedef struct XeImage
    {
	XImage *image;		/* X Image structure */
	unsigned char *map;	/* Color Mapping information */
	XeImageOp *image_op;	/* Image processing instructions */
#if SH_MEM
	unsigned int shared:1;	/* True, if MIT_SHM image allocated */
	XShmSegmentInfo shm;	/* Shared memory segment info */
	Pixmap pixmap;		/* Server side Pixmap (if supported) */
#endif
    } XeImage;


_XFUNCPROTOBEGIN
XeImage *_XeCreateImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 XeRawImage *,		/* Raw image description */
	 int,			/* dither (XeDither) */
	 int,			/* quantize (XeColorQuantize) */
	 int,			/* logical width */
	 int			/* logical height */
#endif
	 );

/*
** _XeMirrorRotation
**	Setup line, inc and start parameters according to the rotation
**	and mirror parameters.
*/
void _XeMirrorRotation
	(
#if NeedFunctionPrototypes
	 int,			/* Rotation angle: 0, 90, 180, 270 */
	 int,			/* Mirror: True/False */
	 XeImageChannel *,	/* Source channel */
	 XeImageChannel *	/* Destination channel */
#endif
	 );
/*
** _XeBuildImage
**	Build the actuall XImage from the raw input image using the
**	control structures.
*/
void _XeBuildImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 XeImage *,		/* Xew Image Control Structure */
	 int n,			/* Number of entries in data */
	 XeImageChannel *	/* Raw Image data channels */
#endif
	 );

void _XePutImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 GC,			/* Graphics context */
	 XeImage *,		/* Image to display */
	 int, int,		/* (src_x, src_y) */
	 int, int,		/* (dst_x, dst_y) */
	 unsigned int,		/* width */
	 unsigned int		/* height */
#endif
	 );

void _XeDestroyImage
	(
#if NeedFunctionPrototypes
	 XeBasicWidget,		/* Widget */
	 XeImage *		/* Display Image descriptor */
#endif
	 );

/*
** _XeCreateRawImage
**	Create empty raw image structure which has room for the
**	specified number of channels.
*/
XeRawImage *_XeCreateRawImage
	(
#if NeedFunctionPrototypes
	 int		/* Number of channel structures */
#endif
	 );

/*
** _XeDestroyRawImage
**	Release all resources allocated to a raw image, including the
**	descriptor structure itself (do not call this for staticly
**	allocated descriptor!)
*/
void _XeDestroyRawImage
	(
#if NeedFunctionPrototypes
	 XeRawImage *		/* Raw Image Descriptor */
#endif
	 );

_XFUNCPROTOEND
#endif


